/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:1,flag:"rc3",revision:Number("$Rev: 6796 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
function dj_load_init(e){
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&!djConfig.delayMozLoadingFix)){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
(function(){
if(typeof dj_usingBootstrap!="undefined"){
return;
}
var _ee=false;
var _ef=false;
var _f0=false;
if((typeof this["load"]=="function")&&((typeof this["Packages"]=="function")||(typeof this["Packages"]=="object"))){
_ee=true;
}else{
if(typeof this["load"]=="function"){
_ef=true;
}else{
if(window.widget){
_f0=true;
}
}
}
var _f1=[];
if((this["djConfig"])&&((djConfig["isDebug"])||(djConfig["debugAtAllCosts"]))){
_f1.push("debug.js");
}
if((this["djConfig"])&&(djConfig["debugAtAllCosts"])&&(!_ee)&&(!_f0)){
_f1.push("browser_debug.js");
}
var _f2=djConfig["baseScriptUri"];
if((this["djConfig"])&&(djConfig["baseLoaderUri"])){
_f2=djConfig["baseLoaderUri"];
}
for(var x=0;x<_f1.length;x++){
var _f4=_f2+"src/"+_f1[x];
if(_ee||_ef){
load(_f4);
}else{
try{
document.write("<scr"+"ipt type='text/javascript' src='"+_f4+"'></scr"+"ipt>");
}
catch(e){
var _f5=document.createElement("script");
_f5.src=_f4;
document.getElementsByTagName("head")[0].appendChild(_f5);
}
}
}
})();
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_f6,_f7){
if(!dojo.lang.isFunction(_f7)){
dojo.raise("dojo.inherits: superclass argument ["+_f7+"] must be a function (subclass: ["+_f6+"']");
}
_f6.prototype=new _f7();
_f6.prototype.constructor=_f6;
_f6.superclass=_f7.prototype;
_f6["super"]=_f7.prototype;
};
dojo.lang._mixin=function(obj,_f9){
var _fa={};
for(var x in _f9){
if((typeof _fa[x]=="undefined")||(_fa[x]!=_f9[x])){
obj[x]=_f9[x];
}
}
if(dojo.render.html.ie&&(typeof (_f9["toString"])=="function")&&(_f9["toString"]!=obj["toString"])&&(_f9["toString"]!=_fa["toString"])){
obj.toString=_f9.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_fd){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_100,_101){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_100.prototype,arguments[i]);
}
return _100;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_104,_105,_106,_107){
if(!dojo.lang.isArrayLike(_104)&&dojo.lang.isArrayLike(_105)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_104;
_104=_105;
_105=temp;
}
var _109=dojo.lang.isString(_104);
if(_109){
_104=_104.split("");
}
if(_107){
var step=-1;
var i=_104.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_104.length;
}
if(_106){
while(i!=end){
if(_104[i]===_105){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_104[i]==_105){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_10d,_10e,_10f){
return dojo.lang.find(_10d,_10e,_10f,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_110,_111){
return dojo.lang.find(_110,_111)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _120=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_120++;
break;
}
}
return _120==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_124){
var _125=dojo.lang.isString(arr);
if(_125){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_124)){
_124=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_124){
var _126=obj;
obj=_124;
_124=_126;
}
}
if(Array.map){
var _127=Array.map(arr,_124,obj);
}else{
var _127=[];
for(var i=0;i<arr.length;++i){
_127.push(_124.call(obj,arr[i]));
}
}
if(_125){
return _127.join("");
}else{
return _127;
}
},reduce:function(arr,_12a,obj,_12c){
var _12d=_12a;
if(arguments.length==1){
dojo.debug("dojo.lang.reduce called with too few arguments!");
return false;
}else{
if(arguments.length==2){
_12c=_12a;
_12d=arr.shift();
}else{
if(arguments.lenght==3){
if(dojo.lang.isFunction(obj)){
_12c=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_12c;
_12c=obj;
obj=tmp;
}
}
}
}
var ob=obj?obj:dj_global;
dojo.lang.map(arr,function(val){
_12d=_12c.call(ob,_12d,val);
});
return _12d;
},forEach:function(_131,_132,_133){
if(dojo.lang.isString(_131)){
_131=_131.split("");
}
if(Array.forEach){
Array.forEach(_131,_132,_133);
}else{
if(!_133){
_133=dj_global;
}
for(var i=0,l=_131.length;i<l;i++){
_132.call(_133,_131[i],i,_131);
}
}
},_everyOrSome:function(_136,arr,_138,_139){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_136?"every":"some"](arr,_138,_139);
}else{
if(!_139){
_139=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _13c=_138.call(_139,arr[i],i,arr);
if(_136&&!_13c){
return false;
}else{
if((!_136)&&(_13c)){
return true;
}
}
}
return Boolean(_136);
}
},every:function(arr,_13e,_13f){
return this._everyOrSome(true,arr,_13e,_13f);
},some:function(arr,_141,_142){
return this._everyOrSome(false,arr,_141,_142);
},filter:function(arr,_144,_145){
var _146=dojo.lang.isString(arr);
if(_146){
arr=arr.split("");
}
var _147;
if(Array.filter){
_147=Array.filter(arr,_144,_145);
}else{
if(!_145){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_145=dj_global;
}
_147=[];
for(var i=0;i<arr.length;i++){
if(_144.call(_145,arr[i],i,arr)){
_147.push(arr[i]);
}
}
}
if(_146){
return _147.join("");
}else{
return _147;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_14c,_14d){
var _14e=[];
for(var i=_14d||0;i<_14c.length;i++){
_14e.push(_14c[i]);
}
return _14e;
}});
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_151){
var _152=window,_153=2;
if(!dojo.lang.isFunction(func)){
_152=func;
func=_151;
_151=arguments[2];
_153++;
}
if(dojo.lang.isString(func)){
func=_152[func];
}
var args=[];
for(var i=_153;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_152,args);
},_151);
};
dojo.lang.clearTimeout=function(_156){
dojo.global().clearTimeout(_156);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_15f,_160,_161){
with(dojo.parseObjPath(_15f,_160,_161)){
return dojo.evalProp(prop,obj,_161);
}
};
dojo.lang.setObjPathValue=function(_162,_163,_164,_165){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_165=true;
}
with(dojo.parseObjPath(_162,_164,_165)){
if(obj&&(_165||(prop in obj))){
obj[prop]=_163;
}
}
};
dojo.provide("dojo.lang.declare");
dojo.lang.declare=function(_166,_167,init,_169){
if((dojo.lang.isFunction(_169))||((!_169)&&(!dojo.lang.isFunction(init)))){
var temp=_169;
_169=init;
init=temp;
}
var _16b=[];
if(dojo.lang.isArray(_167)){
_16b=_167;
_167=_16b.shift();
}
if(!init){
init=dojo.evalObjPath(_166,false);
if((init)&&(!dojo.lang.isFunction(init))){
init=null;
}
}
var ctor=dojo.lang.declare._makeConstructor();
var scp=(_167?_167.prototype:null);
if(scp){
scp.prototyping=true;
ctor.prototype=new _167();
scp.prototyping=false;
}
ctor.superclass=scp;
ctor.mixins=_16b;
for(var i=0,l=_16b.length;i<l;i++){
dojo.lang.extend(ctor,_16b[i].prototype);
}
ctor.prototype.initializer=null;
ctor.prototype.declaredClass=_166;
if(dojo.lang.isArray(_169)){
dojo.lang.extend.apply(dojo.lang,[ctor].concat(_169));
}else{
dojo.lang.extend(ctor,(_169)||{});
}
dojo.lang.extend(ctor,dojo.lang.declare._common);
ctor.prototype.constructor=ctor;
ctor.prototype.initializer=(ctor.prototype.initializer)||(init)||(function(){
});
var _170=dojo.parseObjPath(_166,null,true);
_170.obj[_170.prop]=ctor;
return ctor;
};
dojo.lang.declare._makeConstructor=function(){
return function(){
var self=this._getPropContext();
var s=self.constructor.superclass;
if((s)&&(s.constructor)){
if(s.constructor==arguments.callee){
this._inherited("constructor",arguments);
}else{
this._contextMethod(s,"constructor",arguments);
}
}
var ms=(self.constructor.mixins)||([]);
for(var i=0,m;(m=ms[i]);i++){
(((m.prototype)&&(m.prototype.initializer))||(m)).apply(this,arguments);
}
if((!this.prototyping)&&(self.initializer)){
self.initializer.apply(this,arguments);
}
};
};
dojo.lang.declare._common={_getPropContext:function(){
return (this.___proto||this);
},_contextMethod:function(_176,_177,args){
var _179,_17a=this.___proto;
this.___proto=_176;
try{
_179=_176[_177].apply(this,(args||[]));
}
catch(e){
throw e;
}
finally{
this.___proto=_17a;
}
return _179;
},_inherited:function(prop,args){
var p=this._getPropContext();
do{
if((!p.constructor)||(!p.constructor.superclass)){
return;
}
p=p.constructor.superclass;
}while(!(prop in p));
return (dojo.lang.isFunction(p[prop])?this._contextMethod(p,prop,args):p[prop]);
},inherited:function(prop,args){
dojo.deprecated("'inherited' method is dangerous, do not up-call! 'inherited' is slated for removal in 0.5; name your super class (or use superclass property) instead.","0.5");
this._inherited(prop,args);
}};
dojo.declare=dojo.lang.declare;
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_180,_181){
var fcn=(dojo.lang.isString(_181)?_180[_181]:_181)||function(){
};
return function(){
return fcn.apply(_180,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_183,_184,_185){
var nso=(_184||dojo.lang.anon);
if((_185)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_183){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_183;
return ret;
};
dojo.lang.forward=function(_189){
return function(){
return this[_189].apply(this,arguments);
};
};
dojo.lang.curry=function(_18a,func){
var _18c=[];
_18a=_18a||dj_global;
if(dojo.lang.isString(func)){
func=_18a[func];
}
for(var x=2;x<arguments.length;x++){
_18c.push(arguments[x]);
}
var _18e=(func["__preJoinArity"]||func.length)-_18c.length;
function gather(_18f,_190,_191){
var _192=_191;
var _193=_190.slice(0);
for(var x=0;x<_18f.length;x++){
_193.push(_18f[x]);
}
_191=_191-_18f.length;
if(_191<=0){
var res=func.apply(_18a,_193);
_191=_192;
return res;
}else{
return function(){
return gather(arguments,_193,_191);
};
}
}
return gather([],_18c,_18e);
};
dojo.lang.curryArguments=function(_196,func,args,_199){
var _19a=[];
var x=_199||0;
for(x=_199;x<args.length;x++){
_19a.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_196,func].concat(_19a));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1a0,_1a1){
if(!farr.length){
if(typeof _1a1=="function"){
_1a1();
}
return;
}
if((typeof _1a0=="undefined")&&(typeof cb=="number")){
_1a0=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1a0){
_1a0=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1a0,_1a1);
},_1a0);
};
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_1a3){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _1a6=dl.nameAnonFunc(args[2],ao.adviceObj,_1a3);
ao.adviceFunc=_1a6;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _1a6=dl.nameAnonFunc(args[0],ao.srcObj,_1a3);
ao.srcFunc=_1a6;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _1a6=dl.nameAnonFunc(args[1],dj_global,_1a3);
ao.srcFunc=_1a6;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _1a6=dl.nameAnonFunc(args[3],dj_global,_1a3);
ao.adviceObj=dj_global;
ao.adviceFunc=_1a6;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _1a6=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_1a3);
ao.aroundFunc=_1a6;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _1a8={};
for(var x in ao){
_1a8[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_1a8.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_1a8));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _1b0;
if((arguments.length==1)&&(typeof a1=="object")){
_1b0=a1;
}else{
_1b0={srcObj:a1,srcFunc:a2};
}
_1b0.adviceFunc=function(){
var _1b1=[];
for(var x=0;x<arguments.length;x++){
_1b1.push(arguments[x]);
}
dojo.debug("("+_1b0.srcObj+")."+_1b0.srcFunc,":",_1b1.join(", "));
};
this.kwConnect(_1b0);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this._kwConnectImpl=function(_1b8,_1b9){
var fn=(_1b9)?"disconnect":"connect";
if(typeof _1b8["srcFunc"]=="function"){
_1b8.srcObj=_1b8["srcObj"]||dj_global;
var _1bb=dojo.lang.nameAnonFunc(_1b8.srcFunc,_1b8.srcObj,true);
_1b8.srcFunc=_1bb;
}
if(typeof _1b8["adviceFunc"]=="function"){
_1b8.adviceObj=_1b8["adviceObj"]||dj_global;
var _1bb=dojo.lang.nameAnonFunc(_1b8.adviceFunc,_1b8.adviceObj,true);
_1b8.adviceFunc=_1bb;
}
_1b8.srcObj=_1b8["srcObj"]||dj_global;
_1b8.adviceObj=_1b8["adviceObj"]||_1b8["targetObj"]||dj_global;
_1b8.adviceFunc=_1b8["adviceFunc"]||_1b8["targetFunc"];
return dojo.event[fn](_1b8);
};
this.kwConnect=function(_1bc){
return this._kwConnectImpl(_1bc,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_1bf){
return this._kwConnectImpl(_1bf,true);
};
};
dojo.event.MethodInvocation=function(_1c0,obj,args){
this.jp_=_1c0;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_1c8){
this.object=obj||dj_global;
this.methodname=_1c8;
this.methodfunc=this.object[_1c8];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_1ca){
if(!obj){
obj=dj_global;
}
if(!obj[_1ca]){
obj[_1ca]=function(){
};
if(!obj[_1ca]){
dojo.raise("Cannot set do-nothing method on that object "+_1ca);
}
}else{
if((!dojo.lang.isFunction(obj[_1ca]))&&(!dojo.lang.isAlien(obj[_1ca]))){
return null;
}
}
var _1cb=_1ca+"$joinpoint";
var _1cc=_1ca+"$joinpoint$method";
var _1cd=obj[_1cb];
if(!_1cd){
var _1ce=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_1ce=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_1cb,_1cc,_1ca]);
}
}
var _1cf=obj[_1ca].length;
obj[_1cc]=obj[_1ca];
_1cd=obj[_1cb]=new dojo.event.MethodJoinPoint(obj,_1cc);
obj[_1ca]=function(){
var args=[];
if((_1ce)&&(!arguments.length)){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(_1ce)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _1cd.run.apply(_1cd,args);
};
obj[_1ca].__preJoinArity=_1cf;
}
return _1cd;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _1d5=[];
for(var x=0;x<args.length;x++){
_1d5[x]=args[x];
}
var _1d7=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _1d9=marr[0]||dj_global;
var _1da=marr[1];
if(!_1d9[_1da]){
dojo.raise("function \""+_1da+"\" does not exist on \""+_1d9+"\"");
}
var _1db=marr[2]||dj_global;
var _1dc=marr[3];
var msg=marr[6];
var _1de;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _1d9[_1da].apply(_1d9,to.args);
}};
to.args=_1d5;
var _1e0=parseInt(marr[4]);
var _1e1=((!isNaN(_1e0))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _1e4=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_1d7(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_1dc){
_1db[_1dc].call(_1db,to);
}else{
if((_1e1)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_1d9[_1da].call(_1d9,to);
}else{
_1d9[_1da].apply(_1d9,args);
}
},_1e0);
}else{
if(msg){
_1d9[_1da].call(_1d9,to);
}else{
_1d9[_1da].apply(_1d9,args);
}
}
}
};
var _1e7=function(){
if(this.squelch){
try{
return _1d7.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _1d7.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_1e7);
}
var _1e8;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_1e8=mi.proceed();
}else{
if(this.methodfunc){
_1e8=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_1e7);
}
return (this.methodfunc)?_1e8:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"]);
},addAdvice:function(_1ed,_1ee,_1ef,_1f0,_1f1,_1f2,once,_1f4,rate,_1f6){
var arr=this.getArr(_1f1);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_1ed,_1ee,_1ef,_1f0,_1f4,rate,_1f6];
if(once){
if(this.hasAdvice(_1ed,_1ee,_1f1,arr)>=0){
return;
}
}
if(_1f2=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_1f9,_1fa,_1fb,arr){
if(!arr){
arr=this.getArr(_1fb);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _1fa=="object")?(new String(_1fa)).toString():_1fa;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_1f9)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_201,_202,_203,once){
var arr=this.getArr(_203);
var ind=this.hasAdvice(_201,_202,_203,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_201,_202,_203,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_207){
if(!this.topics[_207]){
this.topics[_207]=new this.TopicImpl(_207);
}
return this.topics[_207];
};
this.registerPublisher=function(_208,obj,_20a){
var _208=this.getTopic(_208);
_208.registerPublisher(obj,_20a);
};
this.subscribe=function(_20b,obj,_20d){
var _20b=this.getTopic(_20b);
_20b.subscribe(obj,_20d);
};
this.unsubscribe=function(_20e,obj,_210){
var _20e=this.getTopic(_20e);
_20e.unsubscribe(obj,_210);
};
this.destroy=function(_211){
this.getTopic(_211).destroy();
delete this.topics[_211];
};
this.publishApply=function(_212,args){
var _212=this.getTopic(_212);
_212.sendMessage.apply(_212,args);
};
this.publish=function(_214,_215){
var _214=this.getTopic(_214);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_214.sendMessage.apply(_214,args);
};
};
dojo.event.topic.TopicImpl=function(_218){
this.topicName=_218;
this.subscribe=function(_219,_21a){
var tf=_21a||_219;
var to=(!_21a)?dj_global:_219;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_21d,_21e){
var tf=(!_21e)?_21d:_21e;
var to=(!_21e)?null:_21d;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_221){
this._getJoinPoint().squelch=_221;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_222,_223){
dojo.event.connect(_222,_223,this,"sendMessage");
};
this.sendMessage=function(_224){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_227){
var na;
var tna;
if(_227){
tna=_227.all||_227.getElementsByTagName("*");
na=[_227];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _22b={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _230=0;
this.normalizedEventName=function(_231){
switch(_231){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _231;
break;
default:
return _231.toLowerCase();
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_235){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_235.length;x++){
node.__clobberAttrs__.push(_235[x]);
}
};
this.removeListener=function(node,_238,fp,_23a){
if(!_23a){
var _23a=false;
}
_238=dojo.event.browser.normalizedEventName(_238);
if((_238=="onkey")||(_238=="key")){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_23a);
}
_238="onkeypress";
}
if(_238.substr(0,2)=="on"){
_238=_238.substr(2);
}
if(node.removeEventListener){
node.removeEventListener(_238,fp,_23a);
}
};
this.addListener=function(node,_23c,fp,_23e,_23f){
if(!node){
return;
}
if(!_23e){
var _23e=false;
}
_23c=dojo.event.browser.normalizedEventName(_23c);
if((_23c=="onkey")||(_23c=="key")){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_23e,_23f);
}
_23c="onkeypress";
}
if(_23c.substr(0,2)!="on"){
_23c="on"+_23c;
}
if(!_23f){
var _240=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_23e){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_240=fp;
}
if(node.addEventListener){
node.addEventListener(_23c.substr(2),_240,_23e);
return _240;
}else{
if(typeof node[_23c]=="function"){
var _243=node[_23c];
node[_23c]=function(e){
_243(e);
return _240(e);
};
}else{
node[_23c]=_240;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_23c]);
}
return _240;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_246,_247){
if(typeof _246!="function"){
dojo.raise("listener not a function: "+_246);
}
dojo.event.browser.currentEvent.currentTarget=_247;
return _246.call(_247,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_24a){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _24c=evt.keyCode;
if(_24c>=65&&_24c<=90&&evt.shiftKey==false){
_24c+=32;
}
if(_24c>=1&&_24c<=26&&evt.ctrlKey){
_24c+=96;
}
evt.key=String.fromCharCode(_24c);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _24c=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_24c+=32;
}
evt.key=String.fromCharCode(_24c);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_24a?_24a:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _24e=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_24e.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_24e.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.provide("dojo.event.*");
dojo.provide("dojo.event");
dojo.deprecated("dojo.event","replaced by dojo.event.*","0.5");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_256,_257){
var out="";
for(var i=0;i<_256;i++){
out+=str;
if(_257&&i<_256-1){
out+=_257;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_265,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _265.replace(/\%\{(\w+)\}/g,function(_268,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _26b=str.split(" ");
for(var i=0;i<_26b.length;i++){
_26b[i]=_26b[i].charAt(0).toUpperCase()+_26b[i].substring(1);
}
return _26b.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _270=escape(str);
var _271,re=/%u([0-9A-F]{4})/i;
while((_271=_270.match(re))){
var num=Number("0x"+_271[1]);
var _274=escape("&#"+num+";");
ret+=_270.substring(0,_271.index)+_274;
_270=_270.substring(_271.index+_271[0].length);
}
ret+=_270.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_279){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_279){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_282){
if(_282){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_286,_287){
if(_287){
str=str.toLowerCase();
_286=_286.toLowerCase();
}
return str.indexOf(_286)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_28d){
if(_28d=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_28d=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_28f){
var _290=[];
for(var i=0,_292=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_28f){
_290.push(str.substring(_292,i));
_292=i+1;
}
}
_290.push(str.substr(_292));
return _290;
};
dojo.provide("dojo.string");
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_294,_295,_296){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_294){
this.mimetype=_294;
}
if(_295){
this.transport=_295;
}
if(arguments.length>=4){
this.changeUrl=_296;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_299,_29a){
},error:function(type,_29c,_29d,_29e){
},timeout:function(type,_2a0,_2a1,_2a2){
},handle:function(type,data,_2a5,_2a6){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_2a7){
if(_2a7["url"]){
_2a7.url=_2a7.url.toString();
}
if(_2a7["formNode"]){
_2a7.formNode=dojo.byId(_2a7.formNode);
}
if(!_2a7["method"]&&_2a7["formNode"]&&_2a7["formNode"].method){
_2a7.method=_2a7["formNode"].method;
}
if(!_2a7["handle"]&&_2a7["handler"]){
_2a7.handle=_2a7.handler;
}
if(!_2a7["load"]&&_2a7["loaded"]){
_2a7.load=_2a7.loaded;
}
if(!_2a7["changeUrl"]&&_2a7["changeURL"]){
_2a7.changeUrl=_2a7.changeURL;
}
_2a7.encoding=dojo.lang.firstValued(_2a7["encoding"],djConfig["bindEncoding"],"");
_2a7.sendTransport=dojo.lang.firstValued(_2a7["sendTransport"],djConfig["ioSendTransport"],false);
var _2a8=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_2a7[fn]&&_2a8(_2a7[fn])){
continue;
}
if(_2a7["handle"]&&_2a8(_2a7["handle"])){
_2a7[fn]=_2a7.handle;
}
}
dojo.lang.mixin(this,_2a7);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_2af){
if(!(_2af instanceof dojo.io.Request)){
try{
_2af=new dojo.io.Request(_2af);
}
catch(e){
dojo.debug(e);
}
}
var _2b0="";
if(_2af["transport"]){
_2b0=_2af["transport"];
if(!this[_2b0]){
dojo.io.sendBindError(_2af,"No dojo.io.bind() transport with name '"+_2af["transport"]+"'.");
return _2af;
}
if(!this[_2b0].canHandle(_2af)){
dojo.io.sendBindError(_2af,"dojo.io.bind() transport with name '"+_2af["transport"]+"' cannot handle this type of request.");
return _2af;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_2af))){
_2b0=tmp;
break;
}
}
if(_2b0==""){
dojo.io.sendBindError(_2af,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _2af;
}
}
this[_2b0].bind(_2af);
_2af.bindSuccess=true;
return _2af;
};
dojo.io.sendBindError=function(_2b3,_2b4){
if((typeof _2b3.error=="function"||typeof _2b3.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _2b5=new dojo.io.Error(_2b4);
setTimeout(function(){
_2b3[(typeof _2b3.error=="function")?"error":"handle"]("error",_2b5,null,_2b3);
},50);
}else{
dojo.raise(_2b4);
}
};
dojo.io.queueBind=function(_2b6){
if(!(_2b6 instanceof dojo.io.Request)){
try{
_2b6=new dojo.io.Request(_2b6);
}
catch(e){
dojo.debug(e);
}
}
var _2b7=_2b6.load;
_2b6.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_2b7.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _2b9=_2b6.error;
_2b6.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_2b9.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_2b6);
dojo.io._dispatchNextQueueBind();
return _2b6;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_2bc,last){
var enc=/utf/i.test(_2bc||"")?encodeURIComponent:dojo.string.encodeAscii;
var _2bf=[];
var _2c0=new Object();
for(var name in map){
var _2c2=function(elt){
var val=enc(name)+"="+enc(elt);
_2bf[(last==name)?"push":"unshift"](val);
};
if(!_2c0[name]){
var _2c5=map[name];
if(dojo.lang.isArray(_2c5)){
dojo.lang.forEach(_2c5,_2c2);
}else{
_2c2(_2c5);
}
}
}
return _2bf.join("&");
};
dojo.io.setIFrameSrc=function(_2c6,src,_2c8){
try{
var r=dojo.render.html;
if(!_2c8){
if(r.safari){
_2c6.location=src;
}else{
frames[_2c6.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_2c6.contentWindow.document;
}else{
if(r.safari){
idoc=_2c6.document;
}else{
idoc=_2c6.contentWindow;
}
}
if(!idoc){
_2c6.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _2cc=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_2cc.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_2ce,_2cf){
var node=_2ce.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_2cf&&node&&node.tagName&&node.tagName.toLowerCase()!=_2cf.toLowerCase()){
node=dojo.dom.nextElement(node,_2cf);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_2d1,_2d2){
var node=_2d1.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_2d2&&node&&node.tagName&&node.tagName.toLowerCase()!=_2d2.toLowerCase()){
node=dojo.dom.prevElement(node,_2d2);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_2d5){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_2d5&&_2d5.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_2d5);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_2d7){
if(!node){
return null;
}
if(_2d7){
_2d7=_2d7.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_2d7&&_2d7.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_2d7);
}
return node;
};
dojo.dom.moveChildren=function(_2d8,_2d9,trim){
var _2db=0;
if(trim){
while(_2d8.hasChildNodes()&&_2d8.firstChild.nodeType==dojo.dom.TEXT_NODE){
_2d8.removeChild(_2d8.firstChild);
}
while(_2d8.hasChildNodes()&&_2d8.lastChild.nodeType==dojo.dom.TEXT_NODE){
_2d8.removeChild(_2d8.lastChild);
}
}
while(_2d8.hasChildNodes()){
_2d9.appendChild(_2d8.firstChild);
_2db++;
}
return _2db;
};
dojo.dom.copyChildren=function(_2dc,_2dd,trim){
var _2df=_2dc.cloneNode(true);
return this.moveChildren(_2df,_2dd,trim);
};
dojo.dom.replaceChildren=function(node,_2e1){
var _2e2=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_2e2.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_2e1);
for(var i=0;i<_2e2.length;i++){
dojo.dom.destroyNode(_2e2[i]);
}
};
dojo.dom.removeChildren=function(node){
var _2e5=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _2e5;
};
dojo.dom.replaceNode=function(node,_2e7){
return node.parentNode.replaceChild(_2e7,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_2eb,_2ec){
var _2ed=[];
var _2ee=(_2eb&&(_2eb instanceof Function||typeof _2eb=="function"));
while(node){
if(!_2ee||_2eb(node)){
_2ed.push(node);
}
if(_2ec&&_2ed.length>0){
return _2ed[0];
}
node=node.parentNode;
}
if(_2ec){
return null;
}
return _2ed;
};
dojo.dom.getAncestorsByTag=function(node,tag,_2f1){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_2f1);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_2f6,_2f7){
if(_2f7&&node){
node=node.parentNode;
}
while(node){
if(node==_2f6){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _2fa=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _2fb=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_2fb.length;i++){
try{
doc=new ActiveXObject(_2fb[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_2fa.implementation)&&(_2fa.implementation.createDocument)){
doc=_2fa.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_2fe){
if(!_2fe){
_2fe="text/xml";
}
if(!dj_undef("DOMParser")){
var _2ff=new DOMParser();
return _2ff.parseFromString(str,_2fe);
}else{
if(!dj_undef("ActiveXObject")){
var _300=dojo.dom.createDocument();
if(_300){
_300.async=false;
_300.loadXML(str);
return _300;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _301=dojo.doc();
if(_301.createElement){
var tmp=_301.createElement("xml");
tmp.innerHTML=str;
if(_301.implementation&&_301.implementation.createDocument){
var _303=_301.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_303.importNode(tmp.childNodes.item(i),true);
}
return _303;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_306){
if(_306.firstChild){
_306.insertBefore(node,_306.firstChild);
}else{
_306.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_309){
if((_309!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _30a=ref.parentNode;
_30a.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_30d){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_30d!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_30d);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_311){
if((!node)||(!ref)||(!_311)){
return false;
}
switch(_311.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_313,_314){
var _315=_313.childNodes;
if(!_315.length||_315.length==_314){
_313.appendChild(node);
return true;
}
if(_314==0){
return dojo.dom.prependChild(node,_313);
}
return dojo.dom.insertAfter(node,_315[_314-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _318=dojo.doc();
dojo.dom.replaceChildren(node,_318.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _319="";
if(node==null){
return _319;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_319+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_319+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _319;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_31f,_320,_321){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_31f,_320,_321);
}else{
var _322=elem.ownerDocument;
var _323=_322.createNode(2,_320,_31f);
_323.nodeValue=_321;
elem.setAttributeNode(_323);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _328=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_32a){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_328.apply(this,[_32a]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _32b=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_32d){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_32b){
_32b.apply(this,[_32d]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_330){
if(!dojo.render.html.opera){
var _331=this._getUrlQuery(_330.href);
if(_331==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_331==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_331==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _332=this.historyStack.pop();
if(!_332){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_332);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _339=url.split("?");
if(_339.length<2){
return null;
}else{
return _339[1];
}
},_loadIframeHistory:function(){
var url=dojo.hostenv.getBaseScriptUri()+"iframe_history.html?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _33c=false;
var _33d=node.getElementsByTagName("input");
dojo.lang.forEach(_33d,function(_33e){
if(_33c){
return;
}
if(_33e.getAttribute("type")=="file"){
_33c=true;
}
});
return _33c;
};
dojo.io.formHasFile=function(_33f){
return dojo.io.checkChildrenForFile(_33f);
};
dojo.io.updateNode=function(node,_341){
node=dojo.byId(node);
var args=_341;
if(dojo.lang.isString(_341)){
args={url:_341};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_348,_349,_34a){
if((!_348)||(!_348.tagName)||(!_348.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_34a){
_34a=dojo.io.formFilter;
}
var enc=/utf/i.test(_349||"")?encodeURIComponent:dojo.string.encodeAscii;
var _34c=[];
for(var i=0;i<_348.elements.length;i++){
var elm=_348.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_34a(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_34c.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_34c.push(name+"="+enc(elm.value));
}
}else{
_34c.push(name+"="+enc(elm.value));
}
}
}
var _352=_348.getElementsByTagName("input");
for(var i=0;i<_352.length;i++){
var _353=_352[i];
if(_353.type.toLowerCase()=="image"&&_353.form==_348&&_34a(_353)){
var name=enc(_353.name);
_34c.push(name+"="+enc(_353.value));
_34c.push(name+".x=0");
_34c.push(name+".y=0");
}
}
return _34c.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _359=form.getElementsByTagName("input");
for(var i=0;i<_359.length;i++){
var _35a=_359[i];
if(_35a.type.toLowerCase()=="image"&&_35a.form==form){
this.connect(_35a,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _361=false;
if(node.disabled||!node.name){
_361=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_361=node==this.clickedButton;
}else{
_361=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _361;
},connect:function(_362,_363,_364){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_362,_363,this,_364);
}else{
var fcn=dojo.lang.hitch(this,_364);
_362[_363]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _367=this;
var _368={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_36a,_36b){
return url+"|"+_36a+"|"+_36b.toLowerCase();
}
function addToCache(url,_36d,_36e,http){
_368[getCacheKey(url,_36d,_36e)]=http;
}
function getFromCache(url,_371,_372){
return _368[getCacheKey(url,_371,_372)];
}
this.clearCache=function(){
_368={};
};
function doLoad(_373,http,url,_376,_377){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_373.method.toLowerCase()=="head"){
var _379=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _379;
};
var _37a=_379.split(/[\r\n]+/g);
for(var i=0;i<_37a.length;i++){
var pair=_37a[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_373.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_373.mimetype=="text/json"||_373.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_373.mimetype=="application/xml")||(_373.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_377){
addToCache(url,_376,_373.method,http);
}
_373[(typeof _373.load=="function")?"load":"handle"]("load",ret,http,_373);
}else{
var _37d=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_373[(typeof _373.error=="function")?"error":"handle"]("error",_37d,http,_373);
}
}
function setHeaders(http,_37f){
if(_37f["headers"]){
for(var _380 in _37f["headers"]){
if(_380.toLowerCase()=="content-type"&&!_37f["contentType"]){
_37f["contentType"]=_37f["headers"][_380];
}else{
http.setRequestHeader(_380,_37f["headers"][_380]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_367._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _384=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_384,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _385=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_386){
return _385&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_386["mimetype"].toLowerCase()||""))&&!(_386["formNode"]&&dojo.io.formHasFile(_386["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_387){
if(!_387["url"]){
if(!_387["formNode"]&&(_387["backButton"]||_387["back"]||_387["changeUrl"]||_387["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_387);
return true;
}
}
var url=_387.url;
var _389="";
if(_387["formNode"]){
var ta=_387.formNode.getAttribute("action");
if((ta)&&(!_387["url"])){
url=ta;
}
var tp=_387.formNode.getAttribute("method");
if((tp)&&(!_387["method"])){
_387.method=tp;
}
_389+=dojo.io.encodeForm(_387.formNode,_387.encoding,_387["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_387["file"]){
_387.method="post";
}
if(!_387["method"]){
_387.method="get";
}
if(_387.method.toLowerCase()=="get"){
_387.multipart=false;
}else{
if(_387["file"]){
_387.multipart=true;
}else{
if(!_387["multipart"]){
_387.multipart=false;
}
}
}
if(_387["backButton"]||_387["back"]||_387["changeUrl"]){
dojo.undo.browser.addToHistory(_387);
}
var _38c=_387["content"]||{};
if(_387.sendTransport){
_38c["dojo.transport"]="xmlhttp";
}
do{
if(_387.postContent){
_389=_387.postContent;
break;
}
if(_38c){
_389+=dojo.io.argsFromMap(_38c,_387.encoding);
}
if(_387.method.toLowerCase()=="get"||!_387.multipart){
break;
}
var t=[];
if(_389.length){
var q=_389.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_387.file){
if(dojo.lang.isArray(_387.file)){
for(var i=0;i<_387.file.length;++i){
var o=_387.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_387.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_389=t.join("\r\n");
}
}while(false);
var _392=_387["sync"]?false:true;
var _393=_387["preventCache"]||(this.preventCache==true&&_387["preventCache"]!=false);
var _394=_387["useCache"]==true||(this.useCache==true&&_387["useCache"]!=false);
if(!_393&&_394){
var _395=getFromCache(url,_389,_387.method);
if(_395){
doLoad(_387,_395,url,_389,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_387);
var _397=false;
if(_392){
var _398=this.inFlight.push({"req":_387,"http":http,"url":url,"query":_389,"useCache":_394,"startTime":_387.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_367._blockAsync=true;
}
if(_387.method.toLowerCase()=="post"){
if(!_387.user){
http.open("POST",url,_392);
}else{
http.open("POST",url,_392,_387.user,_387.password);
}
setHeaders(http,_387);
http.setRequestHeader("Content-Type",_387.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_387.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_389);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_387,{status:404},url,_389,_394);
}
}else{
var _399=url;
if(_389!=""){
_399+=(_399.indexOf("?")>-1?"&":"?")+_389;
}
if(_393){
_399+=(dojo.string.endsWithAny(_399,"?","&")?"":(_399.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_387.user){
http.open(_387.method.toUpperCase(),_399,_392);
}else{
http.open(_387.method.toUpperCase(),_399,_392,_387.user,_387.password);
}
setHeaders(http,_387);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_387,{status:404},url,_389,_394);
}
}
if(!_392){
doLoad(_387,http,url,_389,_394);
_367._blockAsync=false;
}
_387.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_39b,days,path,_39e,_39f){
var _3a0=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_3a0=d.toGMTString();
}
_39b=escape(_39b);
document.cookie=name+"="+_39b+";"+(_3a0!=-1?" expires="+_3a0+";":"")+(path?"path="+path:"")+(_39e?"; domain="+_39e:"")+(_39f?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _3a4=document.cookie.substring(idx+name.length+1);
var end=_3a4.indexOf(";");
if(end==-1){
end=_3a4.length;
}
_3a4=_3a4.substring(0,end);
_3a4=unescape(_3a4);
return _3a4;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_3ab,_3ac,_3ad){
if(arguments.length==5){
_3ad=_3ab;
_3ab=null;
_3ac=null;
}
var _3ae=[],_3af,_3b0="";
if(!_3ad){
_3af=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_3af){
_3af={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _3af[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_3af[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _3af){
_3ae.push(escape(prop)+"="+escape(_3af[prop]));
}
_3b0=_3ae.join("&");
}
dojo.io.cookie.setCookie(name,_3b0,days,path,_3ab,_3ac);
};
dojo.io.cookie.getObjectCookie=function(name){
var _3b3=null,_3b4=dojo.io.cookie.getCookie(name);
if(_3b4){
_3b3={};
var _3b5=_3b4.split("&");
for(var i=0;i<_3b5.length;i++){
var pair=_3b5[i].split("=");
var _3b8=pair[1];
if(isNaN(_3b8)){
_3b8=unescape(pair[1]);
}
_3b3[unescape(pair[0])]=_3b8;
}
}
return _3b3;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _3b9=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_3b9=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.provide("dojo.io.*");
dojo.provide("dojo.io");
dojo.deprecated("dojo.io","replaced by dojo.io.*","0.5");
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_3ba){
this.pairs=[];
this.returnWrappers=_3ba||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_3bc,wrap,_3be,_3bf){
var type=(_3bf)?"unshift":"push";
this.pairs[type]([name,_3bc,wrap,_3be]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.json");
dojo.json={jsonRegistry:new dojo.AdapterRegistry(),register:function(name,_3c7,wrap,_3c9){
dojo.json.jsonRegistry.register(name,_3c7,wrap,_3c9);
},evalJson:function(json){
try{
return eval("("+json+")");
}
catch(e){
dojo.debug(e);
return json;
}
},serialize:function(o){
var _3cc=typeof (o);
if(_3cc=="undefined"){
return "undefined";
}else{
if((_3cc=="number")||(_3cc=="boolean")){
return o+"";
}else{
if(o===null){
return "null";
}
}
}
if(_3cc=="string"){
return dojo.string.escapeString(o);
}
var me=arguments.callee;
var _3ce;
if(typeof (o.__json__)=="function"){
_3ce=o.__json__();
if(o!==_3ce){
return me(_3ce);
}
}
if(typeof (o.json)=="function"){
_3ce=o.json();
if(o!==_3ce){
return me(_3ce);
}
}
if(_3cc!="function"&&typeof (o.length)=="number"){
var res=[];
for(var i=0;i<o.length;i++){
var val=me(o[i]);
if(typeof (val)!="string"){
val="undefined";
}
res.push(val);
}
return "["+res.join(",")+"]";
}
try{
window.o=o;
_3ce=dojo.json.jsonRegistry.match(o);
return me(_3ce);
}
catch(e){
}
if(_3cc=="function"){
return null;
}
res=[];
for(var k in o){
var _3d3;
if(typeof (k)=="number"){
_3d3="\""+k+"\"";
}else{
if(typeof (k)=="string"){
_3d3=dojo.string.escapeString(k);
}else{
continue;
}
}
val=me(o[k]);
if(typeof (val)!="string"){
continue;
}
res.push(_3d3+":"+val);
}
return "{"+res.join(",")+"}";
}};
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _3d6=dojo.global();
var _3d7=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_3d7.documentElement.clientWidth;
h=_3d6.innerHeight;
}else{
if(!dojo.render.html.opera&&_3d6.innerWidth){
w=_3d6.innerWidth;
h=_3d6.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_3d7,"documentElement.clientWidth")){
var w2=_3d7.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_3d7.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _3db=dojo.global();
var _3dc=dojo.doc();
var top=_3db.pageYOffset||_3dc.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_3db.pageXOffset||_3dc.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _3e1=dojo.doc();
var _3e2=dojo.byId(node);
type=type.toLowerCase();
while((_3e2)&&(_3e2.nodeName.toLowerCase()!=type)){
if(_3e2==(_3e1["body"]||_3e1["documentElement"])){
return null;
}
_3e2=_3e2.parentNode;
}
return _3e2;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _3ea={x:0,y:0};
if(e.pageX||e.pageY){
_3ea.x=e.pageX;
_3ea.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_3ea.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_3ea.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _3ea;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _3ef=dojo.doc().createElement("script");
_3ef.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_3ef);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_3f2,_3f3,args,_3f5,_3f6){
dojo.deprecated("dojo.html."+_3f2,"replaced by dojo.html."+_3f3+"("+(_3f5?"node, {"+_3f5+": "+_3f5+"}":"")+")"+(_3f6?"."+_3f6:""),"0.5");
var _3f7=[];
if(_3f5){
var _3f8={};
_3f8[_3f5]=args[1];
_3f7.push(args[0]);
_3f7.push(_3f8);
}else{
_3f7=args;
}
var ret=dojo.html[_3f3].apply(dojo.html,args);
if(_3f6){
return ret[_3f6];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_3fb,uri){
var loc=dojo.hostenv.getModuleSymbols(_3fb).join("/");
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri()+loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _400=new dojo.uri.Uri(arguments[i].toString());
var _401=new dojo.uri.Uri(uri.toString());
if((_400.path=="")&&(_400.scheme==null)&&(_400.authority==null)&&(_400.query==null)){
if(_400.fragment!=null){
_401.fragment=_400.fragment;
}
_400=_401;
}else{
if(_400.scheme==null){
_400.scheme=_401.scheme;
if(_400.authority==null){
_400.authority=_401.authority;
if(_400.path.charAt(0)!="/"){
var path=_401.path.substring(0,_401.path.lastIndexOf("/")+1)+_400.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_400.path=segs.join("/");
}
}
}
}
uri="";
if(_400.scheme!=null){
uri+=_400.scheme+":";
}
if(_400.authority!=null){
uri+="//"+_400.authority;
}
uri+=_400.path;
if(_400.query!=null){
uri+="?"+_400.query;
}
if(_400.fragment!=null){
uri+="#"+_400.fragment;
}
}
this.uri=uri.toString();
var _405="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_405));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_405="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_405));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_40c){
return (new RegExp("(^|\\s+)"+_40c+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_40e){
_40e+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_40e);
};
dojo.html.addClass=function(node,_410){
if(dojo.html.hasClass(node,_410)){
return false;
}
_410=(dojo.html.getClass(node)+" "+_410).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_410);
};
dojo.html.setClass=function(node,_412){
node=dojo.byId(node);
var cs=new String(_412);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_412);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_415,_416){
try{
if(!_416){
var _417=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_415+"(\\s+|$)"),"$1$2");
}else{
var _417=dojo.html.getClass(node).replace(_415,"");
}
dojo.html.setClass(node,_417);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_419,_41a){
dojo.html.removeClass(node,_41a);
dojo.html.addClass(node,_419);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_41b,_41c,_41d,_41e,_41f){
_41f=false;
var _420=dojo.doc();
_41c=dojo.byId(_41c)||_420;
var _421=_41b.split(/\s+/g);
var _422=[];
if(_41e!=1&&_41e!=2){
_41e=0;
}
var _423=new RegExp("(\\s|^)(("+_421.join(")|(")+"))(\\s|$)");
var _424=_421.join(" ").length;
var _425=[];
if(!_41f&&_420.evaluate){
var _426=".//"+(_41d||"*")+"[contains(";
if(_41e!=dojo.html.classMatchType.ContainsAny){
_426+="concat(' ',@class,' '), ' "+_421.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_41e==2){
_426+=" and string-length(@class)="+_424+"]";
}else{
_426+="]";
}
}else{
_426+="concat(' ',@class,' '), ' "+_421.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _427=_420.evaluate(_426,_41c,null,XPathResult.ANY_TYPE,null);
var _428=_427.iterateNext();
while(_428){
try{
_425.push(_428);
_428=_427.iterateNext();
}
catch(e){
break;
}
}
return _425;
}else{
if(!_41d){
_41d="*";
}
_425=_41c.getElementsByTagName(_41d);
var node,i=0;
outer:
while(node=_425[i++]){
var _42b=dojo.html.getClasses(node);
if(_42b.length==0){
continue outer;
}
var _42c=0;
for(var j=0;j<_42b.length;j++){
if(_423.test(_42b[j])){
if(_41e==dojo.html.classMatchType.ContainsAny){
_422.push(node);
continue outer;
}else{
_42c++;
}
}else{
if(_41e==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_42c==_421.length){
if((_41e==dojo.html.classMatchType.IsOnly)&&(_42c==_42b.length)){
_422.push(node);
}else{
if(_41e==dojo.html.classMatchType.ContainsAll){
_422.push(node);
}
}
}
}
return _422;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_42e){
var arr=_42e.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_432){
return _432.replace(/([A-Z])/g,"-$1").toLowerCase();
};
dojo.html.getComputedStyle=function(node,_434,_435){
node=dojo.byId(node);
var _434=dojo.html.toSelectorCase(_434);
var _436=dojo.html.toCamelCase(_434);
if(!node||!node.style){
return _435;
}else{
if(document.defaultView&&dojo.html.isDescendantOf(node,node.ownerDocument)){
try{
var cs=document.defaultView.getComputedStyle(node,"");
if(cs){
return cs.getPropertyValue(_434);
}
}
catch(e){
if(node.style.getPropertyValue){
return node.style.getPropertyValue(_434);
}else{
return _435;
}
}
}else{
if(node.currentStyle){
return node.currentStyle[_436];
}
}
}
if(node.style.getPropertyValue){
return node.style.getPropertyValue(_434);
}else{
return _435;
}
};
dojo.html.getStyleProperty=function(node,_439){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_439)]:undefined);
};
dojo.html.getStyle=function(node,_43b){
var _43c=dojo.html.getStyleProperty(node,_43b);
return (_43c?_43c:dojo.html.getComputedStyle(node,_43b));
};
dojo.html.setStyle=function(node,_43e,_43f){
node=dojo.byId(node);
if(node&&node.style){
var _440=dojo.html.toCamelCase(_43e);
node.style[_440]=_43f;
}
};
dojo.html.setStyleText=function(_441,text){
try{
_441.style.cssText=text;
}
catch(e){
_441.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_443,_444){
if(!_444.style.cssText){
_443.setAttribute("style",_444.getAttribute("style"));
}else{
_443.style.cssText=_444.style.cssText;
}
dojo.html.addClass(_443,dojo.html.getClass(_444));
};
dojo.html.getUnitValue=function(node,_446,_447){
var s=dojo.html.getComputedStyle(node,_446);
if((!s)||((s=="auto")&&(_447))){
return {value:0,units:"px"};
}
var _449=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_449){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_449[1]),units:_449[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
dojo.html.getPixelValue=function(node,_44b,_44c){
var _44d=dojo.html.getUnitValue(node,_44b,_44c);
if(isNaN(_44d.value)){
return 0;
}
if((_44d.value)&&(_44d.units!="px")){
return NaN;
}
return _44d.value;
};
dojo.html.setPositivePixelValue=function(node,_44f,_450){
if(isNaN(_450)){
return false;
}
node.style[_44f]=Math.max(0,_450)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_451,_452,_453){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_453=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_453=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_451+" { "+_452+" }";
return dojo.html.styleSheet.insertRule(rule,_453);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_451,_452,_453);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_455){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_455){
_455=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_455);
}
}else{
if(document.styleSheets[0]){
if(!_455){
_455=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_455);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_458,_459){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _45a=dojo.hostenv.getText(URI,false,_459);
if(_45a===null){
return;
}
_45a=dojo.html.fixPathsInCssText(_45a,URI);
if(_458){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_45a)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _45f=doc.getElementsByTagName("style");
for(var i=0;i<_45f.length;i++){
if(_45f[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _460=dojo.html.insertCssText(_45a,doc);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_45a,"nodeRef":_460});
if(_460&&djConfig.isDebug){
_460.setAttribute("dbgHref",URI);
}
return _460;
};
dojo.html.insertCssText=function(_461,doc,URI){
if(!_461){
return;
}
if(!doc){
doc=document;
}
if(URI){
_461=dojo.html.fixPathsInCssText(_461,URI);
}
var _464=doc.createElement("style");
_464.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_464);
}
if(_464.styleSheet){
var _466=function(){
try{
_464.styleSheet.cssText=_461;
}
catch(e){
dojo.debug(e);
}
};
if(_464.styleSheet.disabled){
setTimeout(_466,10);
}else{
_466();
}
}else{
var _467=doc.createTextNode(_461);
_464.appendChild(_467);
}
return _464;
};
dojo.html.fixPathsInCssText=function(_468,URI){
if(!_468||!URI){
return;
}
var _46a,str="",url="",_46d="[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
var _46e=new RegExp("url\\(\\s*("+_46d+")\\s*\\)");
var _46f=/(file|https?|ftps?):\/\//;
regexTrim=new RegExp("^[\\s]*(['\"]?)("+_46d+")\\1[\\s]*?$");
if(dojo.render.html.ie55||dojo.render.html.ie60){
var _470=new RegExp("AlphaImageLoader\\((.*)src=['\"]("+_46d+")['\"]");
while(_46a=_470.exec(_468)){
url=_46a[2].replace(regexTrim,"$2");
if(!_46f.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_468.substring(0,_46a.index)+"AlphaImageLoader("+_46a[1]+"src='"+url+"'";
_468=_468.substr(_46a.index+_46a[0].length);
}
_468=str+_468;
str="";
}
while(_46a=_46e.exec(_468)){
url=_46a[1].replace(regexTrim,"$2");
if(!_46f.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_468.substring(0,_46a.index)+"url("+url+")";
_468=_468.substr(_46a.index+_46a[0].length);
}
return str+_468;
};
dojo.html.setActiveStyleSheet=function(_471){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_471){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _47d={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _47d){
if(_47d[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.provide("dojo.html.*");
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_480,_481){
node=dojo.byId(node);
_481(node,!_480(node));
return _480(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_486){
dojo.html[(_486?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_48c){
dojo.html.setStyle(node,"display",((_48c instanceof String||typeof _48c=="string")?_48c:(_48c?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_490){
dojo.html.setStyle(node,"visibility",((_490 instanceof String||typeof _490=="string")?_490:(_490?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_494,_495){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_495){
if(_494>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_494=0.999999;
}
}else{
if(_494<0){
_494=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_494*100+")";
}
}
node.style.filter="Alpha(Opacity="+_494*100+")";
}else{
if(h.moz){
node.style.opacity=_494;
node.style.MozOpacity=_494;
}else{
if(h.safari){
node.style.opacity=_494;
node.style.KhtmlOpacity=_494;
}else{
node.style.opacity=_494;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _4a1=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_4a1+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _4a1;
};
dojo.html.setStyleAttributes=function(node,_4a4){
node=dojo.byId(node);
var _4a5=_4a4.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_4a5.length;i++){
var _4a7=_4a5[i].split(":");
var name=_4a7[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _4a9=_4a7[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_4a9);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_4a9});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_4a9});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_4a9});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_4a9});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_4a9;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_4ab,_4ac){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_4ac){
_4ac=bs.CONTENT_BOX;
}
var _4af=2;
var _4b0;
switch(_4ac){
case bs.MARGIN_BOX:
_4b0=3;
break;
case bs.BORDER_BOX:
_4b0=2;
break;
case bs.PADDING_BOX:
default:
_4b0=1;
break;
case bs.CONTENT_BOX:
_4b0=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_4af=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _4b4;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_4b4=db;
}else{
_4b4=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _4b6=node;
do{
var n=_4b6["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_4b6["offsetTop"];
ret.y+=isNaN(m)?0:m;
_4b6=_4b6.offsetParent;
}while((_4b6!=_4b4)&&(_4b6!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_4ab){
var _4b9=dojo.html.getScroll();
ret.y+=_4b9.top;
ret.x+=_4b9.left;
}
var _4ba=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_4af>_4b0){
for(var i=_4b0;i<_4af;++i){
ret.y+=_4ba[i](node,"top");
ret.x+=_4ba[i](node,"left");
}
}else{
if(_4af<_4b0){
for(var i=_4b0;i>_4af;--i){
ret.y-=_4ba[i-1](node,"top");
ret.x-=_4ba[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_4be,_4bf){
var _4c0=0;
for(var x=0;x<_4be.length;x++){
_4c0+=dojo.html.getPixelValue(node,_4be[x],_4bf);
}
return _4c0;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _4cd=dojo.html.getBorder(node);
return {width:pad.width+_4cd.width,height:pad.height+_4cd.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if(((h.ie)||(h.opera))&&node.nodeName!="IMG"){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _4d2=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_4d2){
_4d2=dojo.html.getStyle(node,"box-sizing");
}
return (_4d2?_4d2:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _4d7=dojo.html.getBorder(node);
return {width:box.width-_4d7.width,height:box.height-_4d7.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _4d9=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_4d9.width,height:node.offsetHeight-_4d9.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _4dc=0;
var _4dd=0;
var isbb=dojo.html.isBorderBox(node);
var _4df=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_4dc=args.width+_4df.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_4dc);
}
if(typeof args.height!="undefined"){
_4dd=args.height+_4df.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_4dd);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _4e2=dojo.html.getBorderBox(node);
var _4e3=dojo.html.getMargin(node);
return {width:_4e2.width+_4e3.width,height:_4e2.height+_4e3.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _4e6=0;
var _4e7=0;
var isbb=dojo.html.isBorderBox(node);
var _4e9=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _4ea=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_4e6=args.width-_4e9.width;
_4e6-=_4ea.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_4e6);
}
if(typeof args.height!="undefined"){
_4e7=args.height-_4e9.height;
_4e7-=_4ea.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_4e7);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_4ef,_4f0,_4f1){
if(_4ef instanceof Array||typeof _4ef=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_4ef.length<4){
_4ef.push(0);
}
while(_4ef.length>4){
_4ef.pop();
}
var ret={left:_4ef[0],top:_4ef[1],width:_4ef[2],height:_4ef[3]};
}else{
if(!_4ef.nodeType&&!(_4ef instanceof String||typeof _4ef=="string")&&("width" in _4ef||"height" in _4ef||"left" in _4ef||"x" in _4ef||"top" in _4ef||"y" in _4ef)){
var ret={left:_4ef.left||_4ef.x||0,top:_4ef.top||_4ef.y||0,width:_4ef.width||0,height:_4ef.height||0};
}else{
var node=dojo.byId(_4ef);
var pos=dojo.html.abs(node,_4f0,_4f1);
var _4f5=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_4f5.width,height:_4f5.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_4f7){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_4fa){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_4fc){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_4fe){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_500){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_502){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_50c){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_50e){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.html.util");
dojo.html.getElementWindow=function(_50f){
return dojo.html.getDocumentWindow(_50f.ownerDocument);
};
dojo.html.getDocumentWindow=function(doc){
if(dojo.render.html.safari&&!doc._parentWindow){
var fix=function(win){
win.document._parentWindow=win;
for(var i=0;i<win.frames.length;i++){
fix(win.frames[i]);
}
};
fix(window.top);
}
if(dojo.render.html.ie&&window!==document.parentWindow&&!doc._parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc._parentWindow||doc.parentWindow||doc.defaultView;
};
dojo.html.gravity=function(node,e){
node=dojo.byId(node);
var _517=dojo.html.getCursorPosition(e);
with(dojo.html){
var _518=getAbsolutePosition(node,true);
var bb=getBorderBox(node);
var _51a=_518.x+(bb.width/2);
var _51b=_518.y+(bb.height/2);
}
with(dojo.html.gravity){
return ((_517.x<_51a?WEST:EAST)|(_517.y<_51b?NORTH:SOUTH));
}
};
dojo.html.gravity.NORTH=1;
dojo.html.gravity.SOUTH=1<<1;
dojo.html.gravity.EAST=1<<2;
dojo.html.gravity.WEST=1<<3;
dojo.html.overElement=function(_51c,e){
_51c=dojo.byId(_51c);
var _51e=dojo.html.getCursorPosition(e);
var bb=dojo.html.getBorderBox(_51c);
var _520=dojo.html.getAbsolutePosition(_51c,true,dojo.html.boxSizing.BORDER_BOX);
var top=_520.y;
var _522=top+bb.height;
var left=_520.x;
var _524=left+bb.width;
return (_51e.x>=left&&_51e.x<=_524&&_51e.y>=top&&_51e.y<=_522);
};
dojo.html.renderedTextContent=function(node){
node=dojo.byId(node);
var _526="";
if(node==null){
return _526;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
var _528="unknown";
try{
_528=dojo.html.getStyle(node.childNodes[i],"display");
}
catch(E){
}
switch(_528){
case "block":
case "list-item":
case "run-in":
case "table":
case "table-row-group":
case "table-header-group":
case "table-footer-group":
case "table-row":
case "table-column-group":
case "table-column":
case "table-cell":
case "table-caption":
_526+="\n";
_526+=dojo.html.renderedTextContent(node.childNodes[i]);
_526+="\n";
break;
case "none":
break;
default:
if(node.childNodes[i].tagName&&node.childNodes[i].tagName.toLowerCase()=="br"){
_526+="\n";
}else{
_526+=dojo.html.renderedTextContent(node.childNodes[i]);
}
break;
}
break;
case 3:
case 2:
case 4:
var text=node.childNodes[i].nodeValue;
var _52a="unknown";
try{
_52a=dojo.html.getStyle(node,"text-transform");
}
catch(E){
}
switch(_52a){
case "capitalize":
var _52b=text.split(" ");
for(var i=0;i<_52b.length;i++){
_52b[i]=_52b[i].charAt(0).toUpperCase()+_52b[i].substring(1);
}
text=_52b.join(" ");
break;
case "uppercase":
text=text.toUpperCase();
break;
case "lowercase":
text=text.toLowerCase();
break;
default:
break;
}
switch(_52a){
case "nowrap":
break;
case "pre-wrap":
break;
case "pre-line":
break;
case "pre":
break;
default:
text=text.replace(/\s+/," ");
if(/\s$/.test(_526)){
text.replace(/^\s/,"");
}
break;
}
_526+=text;
break;
default:
break;
}
}
return _526;
};
dojo.html.createNodesFromText=function(txt,trim){
if(trim){
txt=txt.replace(/^\s+|\s+$/g,"");
}
var tn=dojo.doc().createElement("div");
tn.style.visibility="hidden";
dojo.body().appendChild(tn);
var _52f="none";
if((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody><tr>"+txt+"</tr></tbody></table>";
_52f="cell";
}else{
if((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody>"+txt+"</tbody></table>";
_52f="row";
}else{
if((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table>"+txt+"</table>";
_52f="section";
}
}
}
tn.innerHTML=txt;
if(tn["normalize"]){
tn.normalize();
}
var _530=null;
switch(_52f){
case "cell":
_530=tn.getElementsByTagName("tr")[0];
break;
case "row":
_530=tn.getElementsByTagName("tbody")[0];
break;
case "section":
_530=tn.getElementsByTagName("table")[0];
break;
default:
_530=tn;
break;
}
var _531=[];
for(var x=0;x<_530.childNodes.length;x++){
_531.push(_530.childNodes[x].cloneNode(true));
}
tn.style.display="none";
dojo.html.destroyNode(tn);
return _531;
};
dojo.html.placeOnScreen=function(node,_534,_535,_536,_537,_538,_539){
if(_534 instanceof Array||typeof _534=="array"){
_539=_538;
_538=_537;
_537=_536;
_536=_535;
_535=_534[1];
_534=_534[0];
}
if(_538 instanceof String||typeof _538=="string"){
_538=_538.split(",");
}
if(!isNaN(_536)){
_536=[Number(_536),Number(_536)];
}else{
if(!(_536 instanceof Array||typeof _536=="array")){
_536=[0,0];
}
}
var _53a=dojo.html.getScroll().offset;
var view=dojo.html.getViewport();
node=dojo.byId(node);
var _53c=node.style.display;
node.style.display="";
var bb=dojo.html.getBorderBox(node);
var w=bb.width;
var h=bb.height;
node.style.display=_53c;
if(!(_538 instanceof Array||typeof _538=="array")){
_538=["TL"];
}
var _540,_541,_542=Infinity,_543;
for(var _544=0;_544<_538.length;++_544){
var _545=_538[_544];
var _546=true;
var tryX=_534-(_545.charAt(1)=="L"?0:w)+_536[0]*(_545.charAt(1)=="L"?1:-1);
var tryY=_535-(_545.charAt(0)=="T"?0:h)+_536[1]*(_545.charAt(0)=="T"?1:-1);
if(_537){
tryX-=_53a.x;
tryY-=_53a.y;
}
if(tryX<0){
tryX=0;
_546=false;
}
if(tryY<0){
tryY=0;
_546=false;
}
var x=tryX+w;
if(x>view.width){
x=view.width-w;
_546=false;
}else{
x=tryX;
}
x=Math.max(_536[0],x)+_53a.x;
var y=tryY+h;
if(y>view.height){
y=view.height-h;
_546=false;
}else{
y=tryY;
}
y=Math.max(_536[1],y)+_53a.y;
if(_546){
_540=x;
_541=y;
_542=0;
_543=_545;
break;
}else{
var dist=Math.pow(x-tryX-_53a.x,2)+Math.pow(y-tryY-_53a.y,2);
if(_542>dist){
_542=dist;
_540=x;
_541=y;
_543=_545;
}
}
}
if(!_539){
node.style.left=_540+"px";
node.style.top=_541+"px";
}
return {left:_540,top:_541,x:_540,y:_541,dist:_542,corner:_543};
};
dojo.html.placeOnScreenPoint=function(node,_54d,_54e,_54f,_550){
dojo.deprecated("dojo.html.placeOnScreenPoint","use dojo.html.placeOnScreen() instead","0.5");
return dojo.html.placeOnScreen(node,_54d,_54e,_54f,_550,["TL","TR","BL","BR"]);
};
dojo.html.placeOnScreenAroundElement=function(node,_552,_553,_554,_555,_556){
var best,_558=Infinity;
_552=dojo.byId(_552);
var _559=_552.style.display;
_552.style.display="";
var mb=dojo.html.getElementBox(_552,_554);
var _55b=mb.width;
var _55c=mb.height;
var _55d=dojo.html.getAbsolutePosition(_552,true,_554);
_552.style.display=_559;
for(var _55e in _555){
var pos,_560,_561;
var _562=_555[_55e];
_560=_55d.x+(_55e.charAt(1)=="L"?0:_55b);
_561=_55d.y+(_55e.charAt(0)=="T"?0:_55c);
pos=dojo.html.placeOnScreen(node,_560,_561,_553,true,_562,true);
if(pos.dist==0){
best=pos;
break;
}else{
if(_558>pos.dist){
_558=pos.dist;
best=pos;
}
}
}
if(!_556){
node.style.left=best.left+"px";
node.style.top=best.top+"px";
}
return best;
};
dojo.html.scrollIntoView=function(node){
if(!node){
return;
}
if(dojo.render.html.ie){
if(dojo.html.getBorderBox(node.parentNode).height<=node.parentNode.scrollHeight){
node.scrollIntoView(false);
}
}else{
if(dojo.render.html.mozilla){
node.scrollIntoView(false);
}else{
var _564=node.parentNode;
var _565=_564.scrollTop+dojo.html.getBorderBox(_564).height;
var _566=node.offsetTop+dojo.html.getMarginBox(node).height;
if(_565<_566){
_564.scrollTop+=(_566-_565);
}else{
if(_564.scrollTop>node.offsetTop){
_564.scrollTop-=(_564.scrollTop-node.offsetTop);
}
}
}
}
};

