-- 2008 Erich Heinemann
-- Bonn



create table proj_call_log
( localnumber  varchar2(200)
, remotenumber varchar2(200)
, log_date     date
, proj_user    varchar2(255)
);



CREATE TABLE I18 (
  ID                               NUMBER    (22, 0)      ,
  LANGUAGE                         VARCHAR2  (12)         ,
  GUI_TEXT                         VARCHAR2  (1200)       ,
  GUI_MEMO                         VARCHAR2  (1200)       ,
  LAST_MOD_DATE                    DATE                   ,
  LAST_MOD_USER                    VARCHAR2  (600)       
  )
;

CREATE UNIQUE INDEX C_I18_1
  ON I18
     (ID,
      LANGUAGE)
;

CREATE TABLE PROJ_AASTRA_REGISTER (
  IP                               VARCHAR2  (15)         ,
  SIP_USER                         VARCHAR2  (255)        ,
  PROJ_USER                        VARCHAR2  (255)        ,
  LETZTE_AKTIVITAET                DATE                   ,
  HEADER_IP                        VARCHAR2  (255)       
  )
;

CREATE TABLE PROJ_FIRMA (
  ID                               NUMBER    (10, 0)      NOT NULL ,
  FIRMENNAME                       VARCHAR2  (1200)       ,
  ZUSATZ                           VARCHAR2  (1200)       ,
  STRASSE1                         VARCHAR2  (1200)       ,
  STRASSE2                         VARCHAR2  (1200)       ,
  STRASSE3                         VARCHAR2  (1200)       ,
  PLZ                              VARCHAR2  (18)         ,
  STADT                            VARCHAR2  (600)        ,
  LAND                             CHAR      (33)         ,
  BEMERKUNG                        VARCHAR2  (1200)       ,
  WEBPAGE                          VARCHAR2  (600)        ,
  TEL                              VARCHAR2  (60)         ,
  LETZTE_BEARBEITUNG               DATE                   ,
  BEARBEITUNG_DURCH                VARCHAR2  (765)        ,
  EMAIL                            VARCHAR2  (765)       
  )
;
CREATE UNIQUE INDEX C_PROJ_FIRMA_1
  ON PROJ_FIRMA
     (ID)
;

CREATE TABLE PROJ_KONTAKT (
  ID                               NUMBER    (10, 0)      NOT NULL ,
  FK_FIRMA                         NUMBER    (10, 0)      ,
  ANREDE                           VARCHAR2  (600)        ,
  VORNAME                          VARCHAR2  (600)        ,
  NACHNAME                         VARCHAR2  (600)        ,
  ZUSATZ                           VARCHAR2  (600)        ,
  EMAIL                            VARCHAR2  (600)        ,
  TEL1                             VARCHAR2  (60)         ,
  TEL2                             VARCHAR2  (60)         ,
  TEL3                             VARCHAR2  (60)         ,
  TEL4                             VARCHAR2  (60)         ,
  TEL5                             VARCHAR2  (60)         ,
  STRASSE                          VARCHAR2  (1200)       ,
  STRASSE2                         VARCHAR2  (1200)       ,
  STRASSE3                         VARCHAR2  (1200)       ,
  PLZ                              VARCHAR2  (18)         ,
  STADT                            VARCHAR2  (600)        ,
  LAND                             CHAR      (33)         ,
  LETZTE_BEARBEITUNG               DATE                   ,
  BEARBEITUNG_DURCH                VARCHAR2  (765)        ,
  BEMERKUNG                        VARCHAR2  (1200)       ,
  VANITY                           VARCHAR2  (240)        ,
  SIP_USER                         VARCHAR2  (255)       
  )
;
CREATE UNIQUE INDEX C_PROJ_KONTAKT_1
  ON PROJ_KONTAKT
     (ID)
;
CREATE INDEX C_PROJ_KONTAKT_2
  ON PROJ_KONTAKT
     (FK_FIRMA)
;

CREATE TABLE PROJ_PROJEKT (
  ID                               NUMBER    (10, 0)      NOT NULL ,
  FK_BAUHERR                       NUMBER    (10, 0)      ,
  FK_PROJEKT_STATUS                NUMBER    (10, 0)      ,
  STARTDATUM                       DATE                   NOT NULL ,
  PROJEKT_NAME                     VARCHAR2  (1200)       NOT NULL ,
  AKTUELLER_STATUS                 VARCHAR2  (765)        ,
  PROJEKT_ID                       VARCHAR2  (60)         ,
  LETZTE_BEARBEITUNG               DATE                   ,
  BEARBEITUNG_DURCH                VARCHAR2  (765)       
  )
;
CREATE UNIQUE INDEX C_PROJ_PROJEKT_1
  ON PROJ_PROJEKT
     (ID)
;

CREATE TABLE PROJ_PROJEKT_AKTUELLES_LOG (
  ID                               NUMBER    (10, 0)      ,
  LETZTE_BEARBEITUNG               DATE                   ,
  BEARBEITUNG_DURCH                VARCHAR2  (765)        ,
  AKTUELLER_STATUS                 VARCHAR2  (765)        ,
  FK_PROJEKT_STATUS                NUMBER    (10, 0)     
  )
;

CREATE TABLE PROJ_PROJEKTFRAGE (
  ID                               NUMBER    (10, 0)      NOT NULL ,
  FK_PROJEKT_ID                    NUMBER    (10, 0)      NOT NULL ,
  FK_PROJEKT_PHASE                 NUMBER    (10, 0)      ,
  SUBJECT                          VARCHAR2  (1200)       NOT NULL ,
  SUBJECT_RX                       VARCHAR2  (4000)       ,
  SUBJECT_TX                       VARCHAR2  (4000)       ,
  ACTION_DATE                      DATE                   ,
  EXTERNAL_REFERENCE               VARCHAR2  (4000)       ,
  LETZTE_BEARBEITUNG               DATE                   ,
  BEARBEITUNG_DURCH                VARCHAR2  (120)        ,
  ZUGEWIESEN_AN                    VARCHAR2  (240)        ,
  STATUS                           NUMBER    (2, 0)      
  )
;
CREATE INDEX C_PROJ_PROJEKTFRAGE_1
  ON PROJ_PROJEKTFRAGE
     (FK_PROJEKT_ID)
;

CREATE TABLE PROJ_PROJEKTPHASE (
  ID                               NUMBER    (10, 0)      NOT NULL ,
  STARTDATUM                       DATE                   ,
  ENDDATUM                         DATE                   ,
  PHASEN_NAME                      VARCHAR2  (300)        NOT NULL ,
  PROJEKT_ABSCHNITT                VARCHAR2  (300)        ,
  AKTUELLER_STATUS                 VARCHAR2  (300)        ,
  FK_PROJEKT_ID                    NUMBER    (10, 0)      NOT NULL ,
  LETZTE_BEARBEITUNG               DATE                   ,
  BEARBEITUNG_DURCH                VARCHAR2  (765)        ,
  BESCHREIBUNG                     VARCHAR2  (4000)       ,
  FARBE                            VARCHAR2  (21)         ,
  PLANKOSTEN                       NUMBER    (10, 2)      ,
  FK_FIRMA                         NUMBER    (10, 0)     
  )
;
CREATE INDEX C_PROJ_PROJEKTPHASE_1
  ON PROJ_PROJEKTPHASE
     (FK_PROJEKT_ID)
;
CREATE INDEX C_PROJ_PROJEKTPHASE_2
  ON PROJ_PROJEKTPHASE
     (STARTDATUM,
      ENDDATUM)
;

CREATE TABLE XDB_WERTE (
  ID                               NUMBER    (10, 0)      NOT NULL ,
  WB_ID                            NUMBER    (6, 0)       NOT NULL ,
  KURZTEXT                         VARCHAR2  (30)         NOT NULL ,
  LANGTEXT                         VARCHAR2  (300)        NOT NULL ,
  BEMERKUNG                        VARCHAR2  (1500)       ,
  SEARCH_ONLY                      NUMBER    (1, 0)      
  )
;
CREATE INDEX WERT_FK_WB_I
  ON XDB_WERTE
     (WB_ID)
;
CREATE INDEX WERT_KURZTEXT_I
  ON XDB_WERTE
     (KURZTEXT)
;

CREATE TABLE XDB_WERTEBEREICHE (
  ID                               NUMBER    (6, 0)       NOT NULL ,
  NAME                             VARCHAR2  (90)         NOT NULL ,
  BEMERKUNG                        VARCHAR2  (300)       
  )
;

CREATE TABLE XDB_ZUG_MENUROLES_MODE (
  MENUROLES_ID                     NUMBER    (12, 0)      NOT NULL ,
  MODULE_ID                        NUMBER    (12, 0)      NOT NULL ,
  MODUS                            NUMBER    (1, 0)       NOT NULL ,
  MEMO                             VARCHAR2  (765)        NOT NULL ,
  ID                               NUMBER    (10, 0)      NOT NULL
  )
;

CREATE TABLE XDB_ZUG_MODULE (
  ID                               NUMBER    (10, 0)      NOT NULL ,
  NAME                             VARCHAR2  (300)        ,
  USAGE                            VARCHAR2  (210)        ,
  TYP                              VARCHAR2  (30)        
  )
;

CREATE TABLE XDB_ZUG_ROLES (
  ID                               NUMBER    (10, 0)      NOT NULL ,
  ROLENAME                         VARCHAR2  (90)         NOT NULL ,
  DB_ROLE                          VARCHAR2  (90)         ,
  MEMO                             VARCHAR2  (765)       
  )
;

CREATE TABLE XDB_ZUG_USER (
  ID                               NUMBER    (10, 0)      NOT NULL ,
  LOGIN                            VARCHAR2  (90)         NOT NULL ,
  USER_NAME                        VARCHAR2  (240)        NOT NULL ,
  MEMO                             VARCHAR2  (765)        ,
  EMAIL                            VARCHAR2  (765)       
  )
;

CREATE TABLE XDB_ZUG_ZUO_USER_MENU (
  USER_ID                          NUMBER    (12, 0)      NOT NULL ,
  MENUROLE_ID                      NUMBER    (12, 0)      NOT NULL ,
  ID                               NUMBER    (10, 0)     
  )
;

