--
--  OraTool Pro  - (c) by Softwaredevelopment Jens Fudickar
--          TGS Telonic - 0000000004 (1)
--
--  Generator    : Create Object
--  Objecttype   : FUNCTION
--  Generated at : 30.07.2008
--  Generated by : PROJADM
--

CREATE OR REPLACE FUNCTION aastra$addsoftkey
        (
         p_index  in varchar2   default null
       , p_label  in varchar2   default null
       , p_uri    in varchar2   default null
       , p_icon   in varchar2   default null
       )
       return varchar2 as

 v_xml varchar2(800);

  begin

                v_xml := '<SoftKey index="'||p_index||'"';
                if(p_icon!=NULL) then
                   v_xml := v_xml||' icon="'||p_icon||'"';
                end if;
                v_xml := v_xml||'>';
                v_xml := v_xml||'<Label>'||p_label||'</Label>';
                v_xml := v_xml||'<URI>'||p_uri||'</URI>';
                v_xml := v_xml||'</SoftKey>';
                return(v_xml);

  exception when others then return
   null;
 end;
/

CREATE OR REPLACE FUNCTION aastra_format_dialtel (p_tel in varchar2 default null)
return varchar2
   -- 30.07.2008 E.Heinemann

as

 v_tel        varchar2(255) := substr(p_tel,1,20);
 v_prefix     xdb_Werte.langtext%type := dbfun$get_Werte('globalconfig','tel_pref');  -- Amtsholung
 v_replace    xdb_Werte.langtext%type := dbfun$get_Werte('globalconfig','tel_0_repl'); -- fhrende Null aus der Datenbank wird ersetzt gegen...


begin

-- Die Telefonnummer wird durchformatiert
  if substr(p_tel,1,1) = '0'
  and substr(p_tel,1,2) != '00'
  then
  -- inlndische Telefonnummer
   v_tel := v_replace || substr  (p_tel,2); -- die fhrende Null wird durch etwas anderes ersetzt
 end if;


 if v_prefix is not null then
  v_tel := v_prefix||v_tel ;
 end if;

-- v_tel := DBFUN$FORMAT_TEL(v_tel); -- Grobe korrektur aller Angaben!

 v_tel := replace(v_tel,' ','');
 v_tel := replace(v_tel,'+','');
 v_tel := replace(v_tel,'-','');
 v_tel := replace(v_tel,'(','');
 v_tel := replace(v_tel,')','');

 return v_tel;


end;
/

CREATE OR REPLACE FUNCTION dbfun$aastra_dial ( p_id in Number default null, p_tel_number in varchar2)
return varchar2 as

 v_tel       varchar2(30) := substr(p_tel_number,1,20) ;

 -- 26.07.2008      E.Heinemann
 -- Diese Funktion baut aus der Telefonnummer und ggf. anderen Angaben eine passende URL fr die Prozedur aastra_dial um


begin
 if trim(p_tel_number) is not null then


  return '<a href="aastra_dial?p_tel='||v_tel||'" target="_dial">'
    || '<img src="/i/projekt/default/img/telefon.png" title="'||p_tel_number||' anrufen" border="no"></a>';
  else
   return
    null;
  end if;
end;
/

CREATE OR REPLACE FUNCTION dbfun$aastra_no_access

return varchar2
as

-- Diese Funktion leifert aktuell eine fest eingestellte Fehlerseite an den Anwender zurck

v_ret varchar2(1000);

begin

 v_ret := '<AastraIPPhoneTextScreen>';
 v_ret := v_ret || '<Title>Kein Zugriff</Title>';
 v_ret := v_ret || '<Text>Sie haben keine Berechtigung zum Zugriff auf diese Dienste</Text>';
 v_ret := v_ret || '</AastraIPPhoneTextScreen>';

 return v_ret;

end;
/

CREATE OR REPLACE FUNCTION DBFUN$DATE_TO_NUM (ETIME in DATE)
RETURN
  NUMBER
IS

--[VERS:2008-07-22]
-- Der Versuch, die UNIX-Time zu einem TAG zu erhalten
-- muss hier im Kontext nicht genau sein!!

  OUT_DATE  NUMBER;
  TEMP_DATE DATE;
BEGIN

  OUT_DATE := (etime - TO_DATE('01-01-1970','DD-MM-YYYY')) * 86400;
  OUT_DATE := trunc(OUT_DATE); -- Sicherung ab 08.09.2004 !!
  RETURN OUT_DATE;
END DBFUN$DATE_TO_NUM;
/

CREATE OR REPLACE FUNCTION dbfun$days_between
      ( p_date1      in date  -- erster Tag      (von)
      , p_date2      in date  -- letzter Tag     (bis)
      )

return number
    as
--[VERS:2008-07-12]
 -- Diese Funktion liefert die Anzahl von Tagen zwischen den beiden Daten
 -- Es wird intern mit der Unix-Time gearbeitet, daher die FUnktion dat_to_num vorher kompilieren   !

 -- lokale Variablen
  v_ret   Number(22);
  v_summ  Number(12,3);

begin
   v_ret := ( dbfun$date_to_num(trunc(p_date2)+1) - dbfun$date_to_num(trunc(p_date1)) ) / 86400  ;
 return v_ret;
end;
/

CREATE OR REPLACE FUNCTION dbfun$default_gui
return varchar2
as
BEGIN
-- spter ber User-Preferences
return 'default';
end;
/

CREATE OR REPLACE FUNCTION dbfun$default_lang
return varchar2
as

 -- sollte spter mal ber USER-Paraemter  in xdb_zug_user hinterlegt werden knnen!
 -- vorerst mal fix

begin
return 'de';
end;
/

CREATE OR REPLACE FUNCTION dbfun$format_http_header (v_in in Varchar2)
return varchar2
--[VERS:2007-09-05]

-- 2007-09-05 Optimierung  - not null -
-- 2004-07-12 Ersterstellung

is
 v_ret   varchar2(2000);
 v_asc   number(3);
 v_aschb varchar2(3);
 v_asclb varchar2(3);
 v_hb    number(3);
 v_lb    number(3);

begin
 if v_in is not null then
  for a in 1..length(v_in) loop
  v_asc := ascii(substr(v_in,a,1));
  if not ((v_asc between 48 and 57)
        or (v_asc between 65 and 90)
        or (v_asc between 97 and 122)
        or (v_asc in (45,95))
         )  then

     v_hb := trunc(v_asc/16);
     if v_hb > 9 then
      v_aschb := chr(v_hb + 55);
     else
      v_aschb := lpad(v_hb,1,'0');
     end if;

     v_lb := mod(v_asc,16);
     if v_lb > 9 then
      v_asclb := chr(v_lb + 55);
     else
      v_asclb := lpad(v_lb,1,'0');
     end if;
     v_ret := v_ret ||'%'|| v_aschb ||  v_asclb;

    else -- kein Sonderzeichen
     v_ret := v_ret || chr(v_asc);
    end if;

  end loop;
 end if;

  return v_ret;

end;
/

CREATE OR REPLACE FUNCTION dbfun$format_tel (p_number in Varchar2)
return varchar2
as
 --[VERS:2008-07-23]
 -- Diese Funktion formatiert die Rufnummer so, dass sie fr gleich formatiert sind!

 v_ret2 Varchar2(4000):= substr(p_number,1,4000);


  begin
--   v_ret2 := '0'||v_ret2;

  -- v_ret2 := replace(v_ret2,'/','');   -- bleibt erhalten

   v_ret2 := replace(v_ret2,'-',' ');
   v_ret2 := replace(v_ret2,'_',' ');
   v_ret2 := replace(v_ret2,'.',' ');
   v_ret2 := replace(v_ret2,'\',' ');
   v_ret2 := replace(v_ret2,':',' ');
   v_ret2 := replace(v_ret2,';',' ');
   v_ret2 := replace(v_ret2,',',' ');
   v_ret2 := replace(v_ret2,'#',' ');
   v_ret2 := replace(v_ret2,'(',' ');
   v_ret2 := replace(v_ret2,')',' ');
   v_ret2 := replace(v_ret2,'{',' ');
   v_ret2 := replace(v_ret2,'}',' ');
   v_ret2 := replace(v_ret2,'  ',' ');
   v_ret2 := replace(v_ret2,'+49','0');
   return v_ret2;

end;
/

CREATE OR REPLACE FUNCTION dbfun$get_akt_benutzer_id
 return number
 is
   --[VERS:2008-07-05]
  -- Diese Funktion sucht zum User die passende proj_kontakt.id raus...
  -- Email-Adresse in Userberechtigung und in den Kontakten muss gleich sein!
  v_ret number(10);

 BEGIN
  begin
   select min(c.id) into v_ret
    from xdb_zug_user z
       , proj_kontakt c
     where user             = upper(z.login)
       and upper (z.email)  = upper(c.email);
   exception when others
    then
     v_ret := null;
    end;
   return v_ret;

 END;
/

CREATE OR REPLACE FUNCTION dbfun$get_firmen_kontakt (p_id in Number ) -- proj_firma.id
 return varchar2

 is

-- kleine Funktion um die Bezeichnung einer Firma zu erhalten
-- diese Funktion kann an die jeweiligen Bedrfnisse angepat werden
-- um im Kontext jeweils die beste und gebruchichste Bezeichnung darzustellen


cursor c1 (l_id in Number)
 is
 select tel||' '||email ret
  from proj_firma
 where id = p_id;

v_return varchar2(400);

begin
 for ca1 in c1 (p_id)
  loop
   v_return := substr(ca1.ret ,1,400) ;
 end loop;
  return v_return;
end;
/

CREATE OR REPLACE FUNCTION dbfun$get_firmen_name (p_id in Number ) -- proj_firma.id
 return varchar2

 is

-- kleine Funktion um die Bezeichnung einer Firma zu erhalten
-- diese Funktion kann an die jeweiligen Bedrfnisse angepat werden
-- um im Kontext jeweils die beste und gebruchichste Bezeichnung darzustellen
-- 27.07.2008 E.Heinemann

cursor c1 (l_id in Number)
 is
 select firmenname||' '||zusatz||' ('||stadt||')' ret
  from proj_firma
 where id = p_id;

v_return varchar2(400);

begin
 for ca1 in c1 (p_id)
  loop
   v_return := substr(ca1.ret ,1,400) ;
 end loop;
  return v_return;
end;
/

CREATE OR REPLACE FUNCTION dbfun$get_kontakt_email (p_Kontakt_id in Number default 1)
return varchar2
as
 -- 24.07.2008 Diese Funktion liefert die E-Mail-Adresse zu einem Kontakt
 v_ret Varchar2(400);

cursor c1 (l_kontakt_id in Number) is
  select co2.email
  from proj_kontakt co2
   where id = l_kontakt_id;

begin
 for ca1 in c1 (p_kontakt_id) loop
  v_ret := ca1.email;
 end loop;
 return nvl(v_ret,user);
end;
/

CREATE OR REPLACE FUNCTION dbfun$get_kontakt_name (p_kontakt_id in Number default 1)
return varchar2
as
 -- 24.07.2008 Diese Funktion liefert die den Namen zu einem Kontakt
 -- kann an die eigenen Anforderungen angepat werden!
 -- Auf dem Bau kennen sich viele nur beim Vornamen, daher hier vollstndig!

 v_ret Varchar2(800);

cursor c1 (l_kontakt_id in Number) is
  select decode(vorname,vorname,vorname||' '||nachname,nachname) voller_name
  from proj_kontakt co2
   where id = l_kontakt_id;

begin
 for ca1 in c1 (p_kontakt_id) loop
  v_ret := ca1.voller_name;
 end loop;
 return nvl(v_ret,user);
end;
/

CREATE OR REPLACE FUNCTION dbfun$get_kontakt_tel (p_kontakt_id in Number default 1
                                                , p_format in varchar2  default null)
return varchar2
as

 -- diese Funktion reiht die Telefonnummern eines Kontakts der Reihe nach auf.
 v_ret Varchar2(4000);

cursor c1 (l_kontakt_id in Number) is
  select
        co2.tel1
     ,  co2.tel2
     ,  co2.tel3
     ,  co2.tel4
     ,  co2.tel5

  from proj_kontakt co2
   where id = l_kontakt_id;

  function lfun (l_num in Varchar2)
  return varchar2
  as
    v_ret2 varchar2(700) := l_num;

  begin
   v_ret2 := '0'||v_ret2;
   v_ret2 := replace(v_ret2,'/','');
   v_ret2 := replace(v_ret2,' ','');
   v_ret2 := replace(v_ret2,'-','');
   v_ret2 := replace(v_ret2,'.','');
   v_ret2 := replace(v_ret2,'\','');
   v_ret2 := replace(v_ret2,':','');
   v_ret2 := replace(v_ret2,'+49','0'); -- User-Prefix
  -- v_ret2 := replace(v_ret2,'002291',''); -- User-Firmen-Prefix
   return v_ret2;
  end;

begin
 for ca1 in c1 (p_kontakt_id) loop

-- Wenn der User mit seinem Aastra eingelogt ist, werden entsprechende Links angeboten
-- muss noch ausprogrammiert werden!!
 if user != 'xxxxXDBADM' then
  if ca1.tel1 is not null then
   v_ret := v_ret||p_format||' <a href="aastra_dial?p_tel='||lfun(ca1.tel1)||'" target="_dial">(tel:'||ca1.tel1||')</a>';
  end if;
  if ca1.tel2 is not null then
   v_ret := v_ret||p_format||' <a href="aastra_dial?p_tel='||lfun(ca1.tel2)||'" target="_dial">(mob-tel:'||ca1.tel2||')</a>';
  end if;
  if ca1.tel3 is not null then
   v_ret := v_ret||p_format||' <a href="aastra_dial?p_tel='||lfun(ca1.tel3)||'" target="_dial">(fax:'||ca1.tel3||')</a>';
  end if;
  if ca1.tel4 is not null then
   v_ret := v_ret||p_format||' <a href="aastra_dial?p_tel='||lfun(ca1.tel4)||'" target="_dial">(dect:'||ca1.tel4||')</a>';
  end if;
  if ca1.tel5 is not null then
   v_ret := v_ret||p_format||' <a href="aastra_dial?p_tel='||lfun(ca1.tel5)||'" target="_dial">(sonst:'||ca1.tel5||')</a>';
  end if;
 else

  if ca1.tel1 is not null then
   v_ret := v_ret||p_format||' (tel:'||ca1.tel1||')';
  end if;
  if ca1.tel2 is not null then
   v_ret := v_ret||p_format||' (mob-tel:'||ca1.tel2||')';
  end if;
  if ca1.tel3 is not null then
   v_ret := v_ret||p_format||' (fax:'||ca1.tel3||')';
  end if;
  if ca1.tel4 is not null then
   v_ret := v_ret||p_format||' (dect:'||ca1.tel4||')';
  end if;
  if ca1.tel5 is not null then
   v_ret := v_ret||p_format||' (sonst:'||ca1.tel5||')';
  end if;

 end if;
 end loop;

 if v_ret is not null then
  v_ret := '<span style="font-size:10px;">'||v_ret||'</span>';

 end if;

 return v_ret;

 exception when others then
  return null;
end;
/

CREATE OR REPLACE FUNCTION dbfun$get_phone_ip( p_user in varchar2) -- Login muss bergeben werden
return varchar2 is    -- Rckgabe ist die IP des Telefons

  -- Diese Funktion sucht in der Tabelle proj_aastra_register
  -- nach der IP-Adresse des registrierten SIP-USERs
  -- um dann z.B. per XML-Call irgendetwas auf dem telefon anzuzeigen
  -- Version 27.07.2008
  -- E.Heinemann

  v_ret    varchar2(200);
  v_user   xdb_zug_user.login%type := substr(p_user,1,30);


  cursor c1 (l_user in varchar2) is
    select ip from proj_aastra_register
 where upper(proj_user) = p_user -- bergabeparameter
   and proj_user is not null
   and sip_user  is not null -- nicht konfigurierte Telefone
   and ip is not null
 order by letzte_aktivitaet desc;

begin

 if v_user is not null then
  for ca1 in c1 (v_user) loop
    v_ret := ca1.ip;
  end loop;
 end if;
  return v_ret; -- wenn nix gefunden wird, wird NULL zurck gegeben

end;
/

CREATE OR REPLACE FUNCTION dbfun$get_phone_user( p_ip in varchar2 )-- IP muss bergeben werden
return varchar2 is    -- Rckgabe zur IP des Telefons ist der richtige DB-User-Login

  -- Diese Funktion sucht in der Tabelle proj_aastra_register
  -- nach der IP-Adresse des registrierten SIP-USERs
  -- Diese Funktion wird zur Authentifizierung bzw. Berechtigungsprfung in Aasta-XML-Prozeduren verwendet
  -- Version 30.07.2008
  -- E.Heinemann

  v_ret    varchar2(200);
  v_ip     varchar2(200) := substr(p_ip,1,200);


  cursor c1 (l_ip in varchar2) is
    select proj_user from proj_aastra_register
 where upper(ip) = l_ip -- bergabeparameter
   and proj_user is not null
   and sip_user  is not null -- nicht konfigurierte Telefone
   and ip is not null
 order by letzte_aktivitaet desc;

begin

 if v_ip is not null then
  for ca1 in c1 (v_ip) loop
    v_ret := ca1.proj_user;
  end loop;
 end if;
  return upper(v_ret); -- wenn nix gefunden wird, wird NULL zurck gegeben

end;
/

CREATE OR REPLACE FUNCTION dbfun$get_projekt_name (p_id in Number ) -- Proj_projekt.id
 return varchar2

 is

-- kleine Funktion um die Bezeichnung eines Projektes zu erhalten
-- diese Funktion kann an die jeweiligen Bedrfnisse angepat werden
-- um im Kontext jeweils die beste und gebruchichste Bezeichnung darzustellen
-- 20.07.2008 E.Heinemann

cursor c1 (l_id in Number)
 is
 select projekt_name ret
   from proj_projekt
  where id = p_id;

v_return varchar2(400);

begin
 for ca1 in c1 (p_id)
  loop
   v_return := substr(ca1.ret ,1,400) ;
 end loop;
  return v_return;
end;
/

CREATE OR REPLACE FUNCTION dbfun$get_werte (v_wbname in varchar2, v_kurztext in varchar2)
 return varchar2

--[VERS:2008-07-12]

as
 -- Diese Funktion liefert den Langtext aus der Tabelle xdb_werte zu
 -- einem bestimmten Wertebereich zurck.
 -- Falls kein Wert gefunden wurde, wird der ursprngliche
 -- Wert zurckgeliefert.


 vwbname     xdb_werte.langtext%type := v_wbname;
 vkurztext   xdb_werte.kurztext%type := v_kurztext;
 varresult   varchar2(100);

 cursor c1 (vwbname in varchar2, vkurztext in varchar2) is
  select min(langtext) langtext from xdb_werte w
  , xdb_wertebereiche wb
  where w.wb_id   = wb.id
   and upper(wb.name)    = vwbname
   and w.kurztext = vkurztext;

BEGIN
 for ca1 in c1 (upper(vwbname), vkurztext)
  loop
   varresult := nvl(ca1.langtext,vkurztext);
  end loop;
 return varresult;
END;
/

CREATE OR REPLACE FUNCTION dbfun$get_werte_langtext (p_wbname in varchar2, p_langtext in varchar2)
 return varchar2

--[VERS:2008-07-12]

as
 -- Diese Funktion liefert den Langtext aus der Tabelle xdb_werte zu
 -- einem bestimmten Wertebereich zurck.
 -- Falls kein Wert gefunden wurde, wird der ursprngliche
 -- Wert zurckgeliefert.


 v_wbname      xdb_werte.langtext%type := p_wbname;
 v_langtext    xdb_werte.langtext%type := p_langtext;
 v_result      xdb_werte.bemerkung%type;

 cursor c1 (vwbname in varchar2, l_langtext in varchar2) is
  select min(w.bemerkung) bemerkung from xdb_werte w
  , xdb_wertebereiche wb
  where w.wb_id   = wb.id
   and upper(wb.name)    = vwbname
   and w.langtext = l_langtext;

BEGIN
 for ca1 in c1 (upper(v_wbname), v_langtext)
  loop
   v_result := nvl(ca1.bemerkung,v_langtext);
  end loop;
 return v_result;
END;
/

CREATE OR REPLACE FUNCTION dbfun$get_werte_memo (v_wbname in varchar2, v_kurztext in varchar2)
 return varchar2

--[VERS:2004-07-12]

as
 -- Diese Funktion liefert die Bemerkung aus der Tabelle xdb_werte zu
 -- einem bestimmten Wertebereich zurck.
 -- Falls kein Wert gefunden wurde, wird der ursprngliche
 -- Wert zurckgeliefert.
 -- E.Heinemann 2.05.2004

 vwbname     xdb_werte.langtext%type := v_wbname;
 vkurztext   xdb_werte.kurztext%type := v_kurztext;
 varresult   varchar2(100);

 cursor c1 (vwbname in varchar2, vkurztext in varchar2) is
  select min(w.bemerkung) langtext
    from xdb_werte w
     , xdb_wertebereiche wb
  where w.wb_id   = wb.id
   and wb.name    = vwbname
   and w.kurztext = vkurztext;

BEGIN
 for ca1 in c1 (vwbname, vkurztext)
  loop
   varresult := nvl(ca1.langtext,vkurztext);
  end loop;
 return varresult;
END;
/

CREATE OR REPLACE FUNCTION dbfun$html_button
                                           (  p_new_loc in varchar2
                                            , p_label   in varchar2 default null
                                            , p_value   in Varchar2 default null
                                            , p_style   in varchar2 default null
                                            , p_tooltip in varchar2 default null
                                            )
     return varchar2

     as
--[VERS:2007-05-30]
-- Historie:
-- 30.05.2007 Ersterstellung

 v_ret varchar2(4000);

begin
v_ret := '<button type="button" ';

if p_value is not null then
 v_ret := v_ret ||' value="'||p_value||'" ';
end if;

if p_Style is not null then
 v_ret := v_ret ||' style="'||p_Style||'" ';
end if;

v_ret := v_ret ||' onClick="self.document.location.href='''||p_new_loc||'''" ';
v_ret := v_ret ||' title="'||p_tooltip||'" onmouseover="parent.window.status='''||p_tooltip||'''; return true">';

if p_label is not null then
 v_ret := v_ret || p_label;
end if;
 v_ret := v_ret ||'</button>';

 return v_ret;

--   return '<input type="button" '||p_style||' value="'||p_value||'" onclick="javascript: location.href ='''|| p_new_loc||''';">';
--   htp.p (dbfun$html_button('ci_list_of_values_details?p_id='||nvl(v_fk_lov,p_fk_lov), dbfun$i18(defaultlang,'Back to the LOV') ));
end;
/

CREATE OR REPLACE FUNCTION dbfun$i18 ( p_language   in varchar2
                                     , p_searchtext in Varchar2
                          )
              return varchar2 as

-- In der Tabelle i18 werden Sprachbausteine, Wrter, ganze Stze in der jeweiligen Sprache abgelegt.
-- Mit dem Namen der Applikation wird jeweils ein Masterdatensatz je Baustein abgelegt.
-- Im Falle des Projektes "PROJEKT" werden die Datenstze jeweils mit dem Prefix "proj" abgelegt.
-- Fr Deutsch dann mit "de", Italy "i" etc...
-- 20.07.2008 E.Heinemann

 cursor c0 (l_searchtext in Varchar2) is
 select min(id) r_id from i18
   where l_searchtext = gui_text;

 cursor c1 (l_id in Number, l_language in Varchar2) is
 select gui_text from i18
  where id = l_id
    and language = l_language;


 v_return i18.gui_text%type;
 v_id     i18.id%type;
 kund     varchar2(2) :=  chr(38);


BEGIN
  if dbfun$to_number(p_searchtext) is not null
   then
    v_id := dbfun$to_number(p_searchtext);
  end if;
  for ca0 in c0 (p_searchtext) loop
     v_id := ca0.r_id ;
  end loop;


  if v_id is not null then
   for ca1 in c1 (v_id, p_language) loop
     v_return := ca1.gui_text;
   end loop;
  end if;

  if dbfun$get_werte('globalconfig','i18') = 'edit' and v_return is not null then
    return nvl(v_return,'['||p_searchtext)||' <a class="abc" href="i18_details?p_id='||v_id||'">i18</a>]';
  else
    return nvl(v_return, '['||p_searchtext||' <a class="abc" href="i18_details?p_gui_text='||p_searchtext||kund||'p_do_insert=insert">i18</a>]');
  end if;

exception when others
 then
 return p_searchtext;
End;
/

CREATE OR REPLACE FUNCTION dbfun$mod_color( p_old_color in varchar2, mod_value in Number)
return varchar2 -- Farbe #FF00FF
-- ZUr Modulation der CSS-Farben

as
 r_color number(10);
 g_color PLS_INTEGER;
 b_color number(10);

 function lpos ( l_number in Number)
  return number

  as

  begin
   if l_number > 255 then
     return 255;
   end if;

   if l_number >= 0 then
      return l_number;
   else
    return 0;
   end if;
 end;

BEGIN

 r_color := lpos(hex_to_dec(substr(p_old_color,2,2))+mod_value);
 g_color := lpos(hex_to_dec(substr(p_old_color,4,2))+mod_value);
 b_color := lpos(hex_to_dec(substr(p_old_color,6,2))+mod_value);

 return '#'||dec_to_hex(r_color,2)||''||dec_to_hex(g_color,2)||''||dec_to_hex(b_color,2);

end;
/

CREATE OR REPLACE FUNCTION dbfun$projekt_status_img
          (p_projekt_status in Number)
        -- diese Funktion liefert den vollstndigen IMG-Tag fr einen STATUS
        -- 27.07.2008

return varchar2
is

 v_toolbar  varchar2(4000);
 v_image    varchar2(255);
begin

 v_image := dbfun$get_werte ('projekt_status_img', p_projekt_status);

 if v_image = '-99' or v_image=to_char(p_projekt_status) then
  v_image := 'alert_red.gif';
 end if;

 v_toolbar := v_toolbar || '      <img src="/i/proj/default/img/'||v_image ||'" '
 ||' alt="'||dbfun$get_werte('projekt_status',p_projekt_status)  ||'" '
 ||' title="'||dbfun$get_werte('projekt_status',p_projekt_status) ||'" '
 ||' Border="NO" >';


 return v_toolbar;

end;
/

CREATE OR REPLACE FUNCTION dbfun$projtoolbar ( p_modul in varchar2
   , p_modus in varchar2
   , p_user  in varchar2
    )
return varchar2
is
  --[VERS:2008-08-07]

   -- Menubuilder: http://www.cs.ucla.edu/~heng/JSCookMenu/MenuBuilder.html
   -- Historie:
   -- 2008-07-08 E.Heinemann Initiales Men fpr die Projekt-DB

   v_toolbar         Varchar2(32000);
   v_modus           Number(1);
   v_module_name     Varchar2(30) := 'PROJ_PROJEKT_LIST'; --- Auf dieses Modul muss der Anwender zugreifen drfen!
   v_error_mod1      Varchar2(80);
   v_error_mod2      Varchar2(80);
   v_mod_ret         Number(2);

   v_where           Varchar2(4000);
   v_user_id         Number(10);
   v_modus_projekt   Number(10):= dbpck$main.fun$chk_module_allowed('PROJ_PROJEKT_DETAILS') ;
--   v_modus_todo      Number(10):= dbpck$main.fun$chk_module_allowed('PROJ_TODOS') ;
--   v_modus_termine   Number(10):= dbpck$main.fun$chk_module_allowed('PROJ_TERMINE');
   v_modus_kontakte  Number(10):= dbpck$main.fun$chk_module_allowed('PROJ_KONTAKT_DETAILS');
   v_modus_admin     Number(10):= dbpck$main.fun$chk_module_allowed('PROJ_WERTE_DETAILS');

   v_modus_kunde     Number(10):= dbpck$main.fun$chk_module_allowed('PSEUDO_KUNDE'); -- Pseudorechte fr spteren Zugriff direkt durch Kunden


   kund              Varchar2(2) := chr(38);  -- Steuerzeichen in PLSQL - Kaufmanns-Und


begin

   v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

   v_toolbar := v_toolbar ||'<table><tr><td><div id="projektMenuID" zorder="1"></div>' ||chr(10)
    || ' <script type="text/javascript"><!-- ' ||chr(10)
    || 'var projektMenu =  '||chr(10)
    || '['||chr(10) ;


 -- Projekt -----------------------------------------------------------
 -- Projekt -----------------------------------------------------------
   -- CIs
   if 1=1 then --v_modus_av > 0 or v_modus_av_artikelnrliste > 0 then
    v_toolbar := v_toolbar
     ||' [null,''Projekte'',null,null,null,   '||chr(10) ;

    v_toolbar := v_toolbar
     || '   [''<IMG SRC=/i/projekt/default/img/search-16x16.gif>'',''Projekt-Suche'',''proj_suche?p_kontext=proj'',null,null],'||chr(10)
     || '   _cmSplit,'||chr(10)
     || '   [''<IMG SRC=/i/projekt/default/img/liste.png>'',''Projektliste'',''PROJ_PROJEKT_LIST'',null,null],'   ||chr(10)
     ;


    v_toolbar := v_toolbar
     || '  [''<IMG SRC=/i/projekt/default/img/add_new_abc.png>'',''Neues Projekt dokumentieren'',''proj_projekt_details'',null,null], '  ||chr(10)
     ;

    v_toolbar := v_toolbar
    || ' ], '||chr(10) ;
   end if;



 /*
   v_toolbar := v_toolbar --||'<a href="xdb_tst_faq_list"    ><img src="/tst/buttons/faq.gif"   title="FAQ"   alt="FAQ" Border="NO"></a>';
  ||'  [null,''Fragen und Antworten'',null,null,null,  ' ||chr(10)
  ||'   [''<IMG SRC=/i/projekt/menu/help-16x16.gif>'',''Suche in Fragen'',''xdb_tst_faq_list'',null,null], ' ||chr(10)
  ||'   [''<IMG SRC=/i/projekt/menu/new.png>'',''neue FAQ erstellen'',''xdb_tst_faq_details'',null,null],  ' ||chr(10)
  ||'  ],  ' ||chr(10) ;
 */
 -- Kontakte  ---------------------------------------------
 -- Kontakte  ---------------------------------------------
  if v_modus_kontakte > 0 then

    v_toolbar := v_toolbar --'<a href="xdb_company_list"    ><img src="/tst/buttons/contacts.gif" title="Contacts"    alt="Contacts" Border="NO"></a>';
    ||'   [null,''Kontaktdaten'',null,null,null,  ' ||chr(10)
    ||'     [''<IMG SRC=/i/projekt/menu/search.png>'',''Suche'',''proj_suche'',null,null], '||chr(10)
    || '     _cmSplit,'||chr(10)
    ||'     [''<IMG SRC=/i/projekt/menu/adress.png>'',''Kunden und Firmen'',''proj_firmen_list'',null,null], ' ||chr(10) ;
    if v_modus_kontakte > 1 then
      v_toolbar := v_toolbar
        ||'      [''<IMG SRC=/i/projekt/menu/new.png>'',''neue Firma erfassen'',''proj_firma_details'',null,null], '   ||chr(10);
      v_toolbar := v_toolbar
        ||'      [''<IMG SRC=/i/projekt/menu/new.png>'',''neuen Kontakt erfassen'',''proj_kontakt_details'',null,null], '   ||chr(10);
    end if;
    v_toolbar := v_toolbar
        ||' ], ' ||chr(10) ;
  end if;

 -- Termine ----------------------------------------------
 -- Termine ----------------------------------------------
 /*
   v_toolbar := v_toolbar
  ||'   [null,''Termine'',null,null,null, '    ||chr(10)
  ||'     [''<IMG SRC=/i/projekt/menu/cal.gif>'',''Diese Woche'',''xdb_sch_group_day'',null,null],  ' ||chr(10)
  ||'     [null,''alle nchste Woche'',''xdb_sch_group_day'
    ||kund||'ts='||to_char(sysdate+7,'YYYYMMDD')||''',null,null],  ' ||chr(10)
  || '    _cmSplit,'||chr(10) --||'   [null,''-----------------------------'',null,null,null],'||chr(10)
  ||'     [null,''4 Wochen'',''xdb_sch_group_day4'',null,null],  ' ||chr(10)
  ||'    ], ' ||chr(10);
 */

  -- Extras
  -- Extras
  v_toolbar := v_toolbar
  ||'  [null,''Extras'',null,null,null, '||chr(10);
  v_toolbar := v_toolbar
  ||'    [''<IMG SRC=/i/projekt/menu/exit.png>'',''Abmelden'',''xdb_logoutadm'',null,null], '||chr(10)
  ||'    _cmSplit,'||chr(10) --||'    [null,''-----------------------------'',null,null,null],  '||chr(10)
  ||'    [''<IMG SRC=/i/projekt/menu/key-16x16.gif>'',''Passwort ndern'',''xdb_pw_change'',null,null], '   ||chr(10)
  ||'    [''<IMG SRC=/i/projekt/menu/settings.png>'',''Einstellungen'',''xdb_tst_user_prevs_details'',null,null], '  ||chr(10)
  ||'    _cmSplit,'||chr(10); --||'    [null,''-----------------------------'',null,null,null],   '||chr(10);

 if v_modus_admin=3 then
  v_toolbar := v_toolbar
   ||'     [''<IMG SRC=/i/projekt/menu/preferences-16x16.gif>'',''Userverwaltung'',''proj_zug_user_admin'',null,null],   '||chr(10)
   ||'     [''<IMG SRC=/i/projekt/menu/preferences-16x16.gif>'',''Wertelisten'',''proj_wertebereiche_list'',null,null], ' ||chr(10)
   ||'     [''<IMG SRC=/i/projekt/menu/preferences-16x16.gif>'',''i18'',''proj_projekt_i18_details'',null,null], ' ||chr(10)
   ;
  end if;
  v_toolbar := v_toolbar
  ||'   ], '  ||chr(10);

  v_toolbar := v_toolbar
  ||'  [null,''Hilfe'',''proj_help?p_module='||upper(p_modul)||''',''_new'',null]'||chr(10);


   -- ENDE
   -- ENDE
    v_toolbar := v_toolbar
  ||'   ]; ' ||chr(10)
  ||'  --></script> ' ||chr(10) ;

    v_toolbar := v_toolbar
  ||'   <script type="text/javascript"><!-- '  ||chr(10)
  ||'  cmDraw (''projektMenuID'', projektMenu, ''hbr'', cmThemeOffice2003, ''ThemeOffice2003'');  '  ||chr(10)
  ||'--></script>  '||chr(10) ;

  v_toolbar := v_toolbar
  ||'<td><img src="/i/projekt/default/img/custom/menu_logo.png"></td>' -- ggf. als Hintergrundlogo
  ||'</tr></table>';
 return v_toolbar;

end;
/

CREATE OR REPLACE FUNCTION dbfun$projtoolbar2js
return varchar2
is

--[VERS:2008-07-08]
   -- 12/2004 Ersterstellung

   -- Funktion:
   -- ber diese Funktion werden die bentigten Javascript-Libs fr das JSCook-Meneingebunden
   -- Historie:
   -- 08.07.2008 Ersterstellung

   v_toolbar                 Varchar2(4000);
   -- Original ist von: http://www.cs.ucla.edu/~heng/JSCookMenu/
begin


   v_toolbar := v_toolbar
        ||' <script type="text/javascript" src="/i/projekt/menu/functions.js"></SCRIPT>' ||chr(10)
        ||' <script type="text/javascript" src="/i/projekt/menu/JSCookMenu.js"></script>' ||chr(10)
        ||' <link rel="stylesheet" href="/i/projekt/menu/ThemeOffice2003/theme.css" TYPE="text/css">' ||chr(10)
        ||' <script type="text/javascript" src="/i/projekt/menu/ThemeOffice2003/theme.js"></script>' ||chr(10);
  return v_toolbar;
end;
/

CREATE OR REPLACE FUNCTION dbfun$selected_opt
( val1 in varchar2, val2 in varchar2)

-- einfache Funktion zur Untersttzung von SELECTION-TAGS (HTML)
-- macht ein Compare von 2 Strings
   return varchar2 -- selected
   as
  begin
 if val1 = val2 then
  return 'selected';
 else
  if (val1 is NULL and val2 = '')
   or (val1 ='' and val2 is NULL)
    then
    return 'selected';
  end if;
  return NULL;
 end if;
 exception
  when others then
   return ('Error inside the Module-Function: SQL-Error '||sqlerrm ||' / '|| sqlcode);
--   return null;
  end;
/

CREATE OR REPLACE FUNCTION dbfun$string2Vanity (p_in_string in varchar2 default null)
return varchar2
is


 v_return varchar2(80);
 v_in_string varchar2(255) := upper(substr(p_in_string,1,255));

 function lfun$ascii2num (l_in in varchar2)
  return varchar2

 is
 l_ret    varchar2(1);
 l_ascii  number(4) := ascii (upper(l_in));

 begin


  if l_ascii between 65 and 67  then
     l_ret := '2';
  end if;
  if l_ascii between 68 and 70  then
     l_ret := '3';
  end if;
  if l_ascii between 71 and 73  then
     l_ret := '4';
  end if;
  if l_ascii between 74 and 76  then
     l_ret := '5';
  end if;
  if l_ascii between 77 and 79  then
     l_ret := '6';
  end if;
  if l_ascii between 80 and 84  then
     l_ret := '7';
  end if;
  if l_ascii between 85 and 87  then
     l_ret := '8';
  end if;
  if l_ascii between 88 and 91  then
     l_ret := '9';
  end if;
  if l_ascii between 32 and 32  then
     l_ret := '0';
  end if;

  return l_ret;
 end lfun$ascii2num;


begin
 v_in_string :=  replace(v_in_string,'','A');
 v_in_string := replace(v_in_string,'','O');
 v_in_string := replace(v_in_string,'','U');
 v_in_string := replace(v_in_string,'?','S');


  for ca1 in 1 .. length (v_in_string)
   loop
    v_return := v_return || lfun$ascii2num(substr( v_in_string,ca1,1)) ;
  end loop;

  return v_return ;

end;
/

CREATE OR REPLACE FUNCTION dbfun$text_to_aastrahtml(my_html in Varchar2)
   return varchar2
   is
 -- Konvertiert Text in gueltiges Aastra-HTML
 -- 29.07.2008

      temp_html Varchar2(32000);
      kund      Varchar2(2) := chr(38);

   begin
     temp_html := replace(my_html,chr(10),' ');
     temp_html := replace(temp_html,chr(13),' ');
   --  temp_html := replace(temp_html,kund,kund||'amp;');
     temp_html := replace(temp_html,'','oe');
     temp_html := replace(temp_html,'','Oe');
     temp_html := replace(temp_html,'','ae');
     temp_html := replace(temp_html,'','o');
     temp_html := replace(temp_html,'','o');
     temp_html := replace(temp_html,'','a');
     temp_html := replace(temp_html,'','a');
     temp_html := replace(temp_html,'','u');
     temp_html := replace(temp_html,'','u');
     temp_html := replace(temp_html,'','e');
     temp_html := replace(temp_html,'','e');

     temp_html := replace(temp_html,'','O');
     temp_html := replace(temp_html,'','O');
     temp_html := replace(temp_html,'','A');
     temp_html := replace(temp_html,'','A');
     temp_html := replace(temp_html,'','U');
     temp_html := replace(temp_html,'','U');
     temp_html := replace(temp_html,'','E');
     temp_html := replace(temp_html,'','E');


     temp_html := replace(temp_html,'','Ae');
     temp_html := replace(temp_html,'','Ae');
     temp_html := replace(temp_html,'','ue');
     temp_html := replace(temp_html,'','Ue');
     temp_html := replace(temp_html,'"',' ');
     temp_html := replace(temp_html,'','ss');
     return temp_html;
end;
/

CREATE OR REPLACE FUNCTION dbfun$text_to_html(my_html in Varchar2)
   return varchar2
   is
 -- Konvertiert Text in gueltiges HTML
 -- http://de.selfhtml.org/html/referenz/zeichen.htm
 -- 29.06.2006

      temp_html Varchar2(32000);
      kund      Varchar2(2) := chr(38);

   begin
     temp_html := replace(my_html,chr(10),'<br>');
   --  temp_html := replace(temp_html,chr(12),'<br>');
     temp_html := replace(temp_html,chr(13),'<br>');
     temp_html := replace(temp_html,kund,kund||'amp;');
     temp_html := replace(temp_html,'',kund||'ouml;');
     temp_html := replace(temp_html,'',kund||'Ouml;');
     temp_html := replace(temp_html,'',kund||'auml;');
     temp_html := replace(temp_html,'',kund||'Auml;');
     temp_html := replace(temp_html,'',kund||'uuml;');
     temp_html := replace(temp_html,'',kund||'Uuml;');
     temp_html := replace(temp_html,'"',kund||'quot;');
     temp_html := replace(temp_html,'','ss');
     temp_html := replace(temp_html,'<br><br>','<br>');
     temp_html := replace(temp_html,'<br><br>','<br>');
     return temp_html;
end;
/

CREATE OR REPLACE FUNCTION DBFUN$TO_NUMBER(
  N  CHAR )
RETURN NUMBER IS

--[VERS:2008-07-12]

BEGIN
    RETURN TO_NUMBER(N);
  EXCEPTION
    WHEN OTHERS THEN RETURN NULL;
END DBFUN$TO_NUMBER;
/

CREATE OR REPLACE FUNCTION dbfun$url_to_googlemaps (  s_street in varchar2 default 'Albin-Kbis-Str.'
                                                    , s_city   in Varchar2 default 'Kln'
                                                    , d_street in varchar2 default null
                                                    , d_city   in varchar2 default null
                                                   )
          return varchar2 as

--[VERS:2008-07-23]
-- Diese Funktion erstellt eine URL zu Google-Maps mit den angegebenen postalischen Adressen
-- Nur Nutzen, wenn Sie die Lizenzbestimmungen, die ggf. seitens Google bestehen, einhalten
-- .. ich bin Privat-Nutzer.... :-)

 v_url varchar2(800);

 v_s_street varchar2(400)   := substr (s_street, 1,400);
 v_s_city   varchar2(400)   := substr (s_city, 1,400);
 v_d_street varchar2(400)   := substr (d_street, 1,400);
 v_d_city   varchar2(400)   := substr (d_city, 1,400);

 kund       varchar2(2) := chr(38);

function lfun$conf (l_string in varchar2 default null)
 return varchar2 as

 l_ret varchar2(400) := substr(l_string,1,400);

 begin
  l_ret := trim(l_ret);
  l_ret := replace(l_ret,'  ',' ');
  l_ret := replace(l_ret,'-',' ');
  l_ret := replace(l_ret,'  ',' ');
  l_ret := replace(l_ret,' ','+');
  l_ret := lower(l_ret);
  l_ret := replace(l_ret,'','%C3%9F');
  l_ret := replace(l_ret,'','%C3%B6');
  l_ret := replace(l_ret,'','%C3%A4');
  l_ret := replace(l_ret,'','%C3%BC');

  return l_ret;
end;

BEGIN

 v_url := '<a class="ablue" href="http://maps.google.de/maps?f=d'||kund||'hl=de'||kund||'saddr=';
 v_url := v_url || lfun$conf (v_s_street) ||',+' ;
 v_url := v_url || lfun$conf (v_s_city) ||',+Deutschland'||kund;
 v_url := v_url || 'daddr=';
 v_url := v_url || lfun$conf (v_d_street) ||',+';
 v_url := v_url || lfun$conf (v_d_city) ||kund||'ie=UTF8" target="_blank">';

 return v_url;

END;
/

CREATE OR REPLACE FUNCTION dbfun$url_to_michelin  (   s_street   in varchar2 default 'Am Kielshof 19'
                                                    , s_city     in Varchar2 default 'Kln'
                                                    , s_zipcode  in Varchar2 default ''
                                                    , d_street   in varchar2 default null
                                                    , d_city     in varchar2 default null
                                                    , d_zipcode  in varchar2 default null
                                                   )
          return varchar2 as

--[VERS:2007-01-27]
-- Diese Funktion erstellt eine URL zu Michelin Routenplaner mit den angegebenen postalischen Adressen

 v_url varchar2(1200);

 v_s_street    varchar2(400)   := substr (s_street , 1,400);
 v_s_city      varchar2(400)   := substr (s_city   , 1,400);
 v_s_zipcode   varchar2(400)   := substr (s_zipcode, 1,400);
 v_d_street    varchar2(400)   := substr (d_street , 1,400);
 v_d_city      varchar2(400)   := substr (d_city   , 1,400);
 v_d_zipcode   varchar2(400)   := substr (d_zipcode, 1,400);
 kund          varchar2(2)     := chr(38);

function lfun$conf (l_string in varchar2 default null)
 return varchar2 as

 l_ret varchar2(400) := substr(l_string,1,400);

 begin
  l_ret := trim(l_ret);
  l_ret := replace(l_ret,'  ',' ');
  l_ret := replace(l_ret,'-',' ');
  l_ret := replace(l_ret,'  ',' ');
  l_ret := replace(l_ret,' ','+');
  l_ret := lower(l_ret);
  l_ret := replace(l_ret,'','%DF');
  l_ret := replace(l_ret,'','%B6');
  l_ret := replace(l_ret,'','%F6');
  l_ret := replace(l_ret,'','%E4');
  l_ret := replace(l_ret,'','%FC');

  return l_ret;
end;

BEGIN

 v_url := '<a class="ablue" href="http://www.viamichelin.com/viamichelin/deu/dyn/controller/ItiWGPerformPage?reinit=1'
 || kund ||'strStartCityCountry=240'
 || kund ||'strStartAddress='|| lfun$conf (v_s_street)
 || kund ||'strStartCP='||v_s_zipcode
 || kund ||'strStartCity='|| lfun$conf (v_s_city) ;

 v_url := v_url || kund || 'strDestCityCountry=240'
 || kund ||'strDestAddress='|| lfun$conf (v_d_street)
 || kund ||'strDestCP='|| v_d_zipcode
 || kund ||'strDestCity='|| lfun$conf (v_d_city)
 || kund ||'image2.x=34'||kund||'image2.y=12'
 ||'" target="_blank">';

 return v_url;

END;
/

CREATE OR REPLACE FUNCTION dec_to_hex (i_decimal in integer, i_length in integer)
return varchar2 is

        v_result       varchar2(12);
        v_hex_digit    varchar2(1);
        v_quotient     integer;
        v_remainder    integer;

begin

        if (i_decimal < 10) then
               v_result := to_char(i_decimal);
        elsif (i_decimal < 16) then
               v_result := chr(65+(i_decimal-10));   -- or 55 + idec
        else
               v_remainder := mod(i_decimal,16);
               v_quotient  := round((i_decimal - v_remainder) /16);
               v_result :=
                       dec_to_hex(v_quotient,1) ||
                       dec_to_hex(v_remainder,1);
        end if;
        return lpad(v_result,i_length,'0');

end;
/

CREATE OR REPLACE FUNCTION hex_to_dec ( pc$hex IN VARCHAR2 )
RETURN PLS_INTEGER
IS
  hexch  VARCHAR2(40) := UPPER( pc$hex) ;
  len PLS_INTEGER := LENGTH( hexch) ;
  res PLS_INTEGER := 0 ;
  pos PLS_INTEGER := 0 ;
  val PLS_INTEGER ;
  car VARCHAR2(1) ;
BEGIN

  FOR i IN REVERSE 1..len LOOP

    car := SUBSTR( hexch, i , 1 ) ;

 IF ASCII(car) > 57 THEN
       val := ASCII(car) - 55 ;
    ELSE
       val := ASCII(car) - 48 ;
    END IF ;

    res := res + (val * ( POWER(16,pos) ) ) ;

 pos := pos + 1 ;

  END LOOP ;

  RETURN( res ) ;

END;
/

CREATE OR REPLACE FUNCTION nbsp
return varchar2 as
-- Version 1.0 29.07.2008

begin
 return chr(38)||'nbsp;';
end;
/

