CREATE OR REPLACE PROCEDURE aastra_suche_tel    ( p_num in Varchar2 default '%228%8866%' --null
                                                )

as


-- Ergebnisliste fr Aastra-Telefone
-- E.Heinemann, Bonn

-- 29.07.2008 Ersterstellung
-- 11.08.2008 Patch

 v_num                    Varchar2(200) := trim(replace(substr(p_num,1,200),'*','%'));


 v_modus                  Number(1);
 v_module_name            Varchar2(30)  := 'AASTRA_SUCHE_TEL';

 -- Die Remote-IP wird bentigt, um das Telefon einem User zuordnen zu knnen.
 v_remote_ip              Varchar2(255) := owa_util.get_cgi_env('REMOTE_ADDR');


 -- Liste der Ansprechpartner
 cursor c1 (cnumber in Varchar2) is
 select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       , co.id
       , co.tel1 tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(tel1,'/',''),' ') like '%'||cnumber
     and  co.tel1    is not null
     and  co.fk_firma = c.id (+)

  union all
  -- 2
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       ,  co.id
       ,  co.tel2 tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(co.tel2,'/',''),' ') like '%'||cnumber
       and co.tel2 is not null
       and  co.fk_firma = c.id (+)
  --3
  union all
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       , co.id
         , co.tel3  tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(co.tel3 ,'/',''),' ') like '%'||cnumber
       and co.tel3 is not null
       and  co.fk_firma = c.id (+)
 --4
  union all
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       ,  co.id
   ,  co.tel4  tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(co.tel4 ,'/',''),' ') like '%'||cnumber
       and co.tel4 is not null
       and co.fk_firma = c.id (+)
 --5
  union all
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
   ,  co.id
   ,  co.tel5  tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
     ,  proj_firma c
    where replace(replace(co.tel5 ,'/',''),' ') like '%'||cnumber
       and co.tel5 is not null
       and  co.fk_firma = c.id (+)
 ;

 -- Liste der laufenden Projekte, wo diese Person als Bauherr eingetragen ist
 cursor c2 (l_contact in Number)
  is
 select
   p.id
 , p.projekt_id
 , p.projekt_name
 , decode(vorname, vorname,vorname||' '||nachname, nachname) bauherr
 , aktueller_status
 , fk_projekt_status
 , startdatum
 , p.letzte_bearbeitung
  from proj_projekt p
     , proj_kontakt k
   where fk_projekt_status  != 4 -- abgeschlossene werden nicht aufgelistet... - suctomizing!   ;
    and k.id = l_contact
    and ( -- entweder ist es der Bauherr
         ( fk_bauherr = l_contact and fk_bauherr is not null)
    --  or
    --     ( -- oder ein Mitarbeiter eines Subunternehmers
    --      1=0
    --      )
         );

   -- am 11.08.2008 als Patch eingefgt, E.Heinemann
   v_counter    Number(10) :=0;
   v_proj_user  proj_aastra_register.proj_user%type;

begin

  -- Modus bedingt ermitteln , Optimierung kommt spter rein!.....
  v_proj_user := dbfun$get_phone_user(v_remote_ip);
  v_modus := 0; --dbpck$main.fun$chk_module_allowed( v_module_name , dbfun$get_phone_user( v_remote_ip  ) );

  -- !! Neue Tabelle proj_call_log !!
  if v_remote_ip is not null and   v_proj_user is not null
   then
   insert into proj_call_log
    (remotenumber, log_date, proj_user)
    values
     (p_num, sysdate, dbfun$get_phone_user(v_remote_ip) );
   commit;
  v_modus := 1; -- nur User kommen an die Daten!
 end if;

 if v_modus > 0 then
  if v_num like ('00%') then
   v_num := substr(v_num,3);
  end if;

  -- Lnderkennung rauslschen
  if v_num like ('49%') then
   v_num := substr(v_num,3);
  end if;
  if v_num like ('+49%') then
   v_num := substr(v_num,4);
  end if;


  -- Wenn die Nummer keine fhrende Null und auch krzer als 5 Stellen ist, dann handelt es sich um eine Nebenstellennummer
  -- die an der gleichen Nebenstelle hngt
  if v_num not like ('0%') and length(v_num) <= 5  then
   v_num := dbfun$get_werte('globalconfig','tel_pbx') || v_num  ;
  end if;

  htp.p('<AastraIPPhoneTextMenu destroyOnExit="yes" cancelAction="aastra_1" wrapList="yes">');
  htp.p('<Title> Suchergebnis zu '|| v_num ||'</Title>');

  -- vorher lief der Loop noch ber p_num, ... war falsch, es muss v_num lauten!!
  for ca1 in c1 ( v_num )  loop
   v_counter := v_counter +1 ; -- Kontrolle, da bei 0 die XML-Page nicht angezeigt wird!
   htp.p('<MenuItem>');
   htp.p('<Prompt>'||dbfun$text_to_aastrahtml(ca1.full_name)||'</Prompt> ');
   htp.p('<Selection>'||ca1.id||'</Selection>');
   htp.p('</MenuItem> ');
   if v_counter > 29 then
    exit;
   end if;
  end loop;

 -- wenn nix gefunden wurde, nochmal suchen
 if v_counter = 0 then
  v_num := '%'||substr(v_num,3)||'%';  -- Vorwahl oder Landeswahl abschneiden!
  for ca1 in c1 ( v_num )  loop
   v_counter := v_counter +1 ; -- Kontrolle, da bei 0 die XML-Page nicht angezeigt wird!
   htp.p('<MenuItem>');
   htp.p('<Prompt>'||dbfun$text_to_aastrahtml(ca1.full_name)||'</Prompt> ');
   htp.p('<Selection>'||ca1.id||'</Selection>');
   htp.p('</MenuItem> ');
   if v_counter > 29 then
    exit;
   end if;
  end loop;
 end if;

 -- wenn nix gefunden wurde, mindestens einen Eintrag anzeigen
 if v_counter = 0 then
   htp.p('<MenuItem>');
   htp.p('<Prompt> - - keine Treffer - - </Prompt> ');
   htp.p('<Selection>0</Selection>');
   htp.p('</MenuItem> ');
 end if;

 if v_counter > 0 then
  htp.p('<SoftKey index = "1">');
  htp.p('<Label>Dial</Label>');
  htp.p('<URI>http://'||dbfun$get_werte('globalconfig','serv_ip')||'/pls/aastra/aastra_dial_menu</URI>');
  htp.p('</SoftKey>');

  htp.p('<SoftKey index = "2">');
  htp.p('<Label>Details</Label>');
  htp.p('<URI>http://'||dbfun$get_werte('globalconfig','serv_ip')||'/pls/aastra/aastra_kontakt_details</URI>');
  htp.p('</SoftKey>');

  htp.p('<SoftKey index = "3">');
  htp.p('<Label>Projekte</Label>');
  htp.p('<URI>http://'||dbfun$get_werte('globalconfig','serv_ip')||'/pls/aastra/aastra_kontakt_projekte</URI>');
  htp.p('</SoftKey>');
 end if;

   htp.p(aastra$addsoftkey ('6','Exit', 'SoftKey:Exit'));
  htp.p('</AastraIPPhoneTextMenu>');

 else -- v-modus =0


  htp.p (dbfun$aastra_no_access);
 end if;

exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
end;
/

