CREATE OR REPLACE PROCEDURE aastra_projekt_aktuelles (Selection in varchar2 default null
                                                           , p_id      in number   default null
                                                            ) -- bergabeparaemter ist die ID des Projektes!!
as

 -- 11.08.2008 Diese Maske liefert eine einfache Liste der letzten Projekteintrge (Aktuelles)
 --            fehlte leider im Paket


 v_id                     proj_projekt.id%type := nvl(to_number(selection),p_id);


 v_modus                  Number(1);
 v_module_name            Varchar2(30)  := 'AASTRA_PROJEKT_AKTUELLES';

 -- Die Remote-IP wird bentigt, um das Telefon einem User zuordnen zu knnen.
 v_remote_ip              Varchar2(255) := owa_util.get_cgi_env('REMOTE_ADDR');
 kund                     varchar2(2) := chr(38);
  -- Formatierung

 v_counter                Number(10);

   cursor c1 (l_fk_projekt_id in Number)
   is
   select to_char(letzte_bearbeitung , 'Dy DD.MM.YY') letzte_Bearbeitung
   , bearbeitung_durch
   , aktueller_Status
   , dbfun$get_werte     ('projekt_status',fk_projekt_status) projekt_status
  from proj_projekt_aktuelles_log
   where id   =  l_fk_projekt_id
   order by letzte_bearbeitung desc;


begin

  -- Modus ermitteln , .. kommt spter rein!.....
  v_modus := 3; --dbpck$main.fun$chk_module_allowed( v_module_name , dbfun$get_phone_user( v_remote_ip  ) );

 if v_modus > 0 then

  htp.p('<AastraIPPhoneFormattedTextScreen '
      || ' destroyOnExit = "yes" '
    ||'>');
  htp.p(' <Line Align="left">Aktuelles zum Projekt</Line>');
  htp.p('<Scroll Height="3">');

  for ca1 in c1 ( v_id )  loop
   htp.p('<Line Align="left">'||ca1.aktueller_Status||'</Line>');
   htp.p('<Line Align="left">'||ca1.letzte_Bearbeitung||'</Line>');
   htp.p('<Line Align="left">'||ca1.Bearbeitung_durch||'</Line>');
   htp.p('<Line Align="left">--------------------------</Line>');
   v_counter := v_counter +1;
   -- nicht mehr als 4 Eintrge anzeigen
   if v_counter > 4 then
    exit;
   end if;
  end loop;

  htp.p('</Scroll>');
-- mehr gibt es hier vorerst nicht...

  htp.p('<SoftKey index = "2">');
  htp.p('<Label>Phasen</Label>');
  htp.p('<URI>http://'||dbfun$get_werte('globalconfig','serv_ip')||'/pls/aastra/aastra_projektphasen_list?selection='||v_id||'</URI>');
  htp.p('</SoftKey>');

  htp.p('<SoftKey index = "3">');
  htp.p('<Label>Fragen</Label>');
  htp.p('<URI>http://'||dbfun$get_werte('globalconfig','serv_ip')||'/pls/aastra/aastra_projekt_fragen_list?selection='||v_id||'</URI>');
  htp.p('</SoftKey>');

  htp.p('<SoftKey index = "4">');
  htp.p('<Label>Aktuelles</Label>');
  htp.p('<URI>http://'||dbfun$get_werte('globalconfig','serv_ip')||'/pls/aastra/aastra_projekt_aktuelles?selection='||v_id||'</URI>');
  htp.p('</SoftKey>');

  htp.p(aastra$addsoftkey ('6','Exit', 'SoftKey:Exit'));

  htp.p('</AastraIPPhoneFormattedTextScreen>');

 else -- v-modus =0


  htp.p (dbfun$aastra_no_access);
 end if;

exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
end;
/

