CREATE OR REPLACE PROCEDURE proj_help
(
     p_id               in  Number    default NULL
   , p_fk_faq_category  in  Number    default NULL
   , p_faq_keywords     in  Varchar2  default NULL
   , p_faq_bounds       in  Varchar2  default NULL

   , p_faq_title        in  Varchar2  default NULL
   , p_last_mod_date    in  Date      default NULL
   , p_last_mod_user    in  Varchar2  default NULL
  ,  p_do_update        in  Varchar2  default ''
  ,  p_do_delete        in  Varchar2  default ''
  ,  p_do_insert        in  Varchar2  default ''
  ,  p_fun              in  Varchar2  default null -- bei "EDIT" gehts ab in den Editiermodus
   , x                  in  Number    default null -- dummy
   , y                  in  Number    default null -- dummy
   , p_module           in  varchar2   default null
  ) as

--[VERS:2008-10-28]

-- Historie:
-- 2008-10-28 Ersterstellung

-- lokale Variablen:
   v_id                 xdb_tst_faq.id%type;
   v_fk_faq_category    xdb_tst_faq.fk_faq_category%type;
   v_faq_category       Varchar2(400);
   v_faq_keywords       xdb_tst_faq.faq_keywords%type;
   v_faq                xdb_tst_faq.faq%type;     -- 4000 Zeichen !
   v_faq1               xdb_tst_faq.faq1%type;    -- 4000 Zeichen !
   v_faq2               xdb_tst_faq.faq2%type;    -- 4000 Zeichen !
   v_faq3               xdb_tst_faq.faq3%type;    -- 4000 Zeichen !
   v_faq_title          xdb_tst_faq.faq_title%type;

   v_faq_bounds         varchar2(16000);

   v_last_mod_date      xdb_tst_faq.last_mod_date%type;
   v_last_mod_user      xdb_tst_faq.last_mod_user%type;
--   v_width              Number(10) := p_width;

   v_modus              number(1);
   v_module_name        Varchar2(30) := 'PROJ_HELP';
   v_error_mod1         Varchar2(80);
   v_error_mod2         Varchar2(80);
   v_mod_ret            Number(2);

   kund                 varchar2(2) := chr(38);

   defaultgui         Varchar2(400) := dbfun$default_gui;
   defaultlang        Varchar2(400) := dbfun$default_lang;

   v_dateformat       Varchar2(40) := 'DD.MM.YYYY HH24:MI';


   v_modus_success      Number(10) :=0; -- dbpck$main.fun$chk_module_allowed('XDB_TST_SUCCESS_DETAILS')  > 1

    -- Fr Files:
  cursor c1 (l_id in number) is
  select
    f.name
  , f.mime_type
  , f.last_updated
  , f.doc_size
  , f.description
  , f.author
  , f.external_blob
    from xdb_tst_files  f
    , xdb_faq_files  z
    where ( (f.name = z.filename and  z.fk_faq = l_id and l_id is not null)
           or (l_id is null)
          )
    order by f.last_updated desc;

 -- FAQ-category
 cursor c5 is
 select * from
 (   select  to_number (w.kurztext) id
    , langtext
     from xdb_werte w, xdb_wertebereiche wb
    where w.wb_id = wb.id
      and upper(wb.name) = 'FAQ_CATEGORY'
      union all
    select -99 id, ' ' langtext from dual
  ) x order by langtext;


 -- Local-Function
 function selected_opt ( val1 in varchar2, value in varchar2)
   return varchar2 -- selected
   as
    begin
     if val1 = value then
      return 'selected';
     else
      if (val1 is NULL and value = '')
       or (val1 ='' and value is NULL)
       then
         return 'selected';
     end if;
    return NULL;
     end if;
end;

 function lfun$web_format(my_html in Varchar2)
   return varchar2
   is
      temp_html varchar2(32000);
   begin
     temp_html := replace(my_html,chr(10),'<br>');
     return temp_html;
   end;

begin
 BEGIN
 -- Modus ermitteln
 v_mod_ret := dbpck$main.fun$chk_module_allowed(
               v_module_name,
               v_modus,
               v_error_mod2,
               v_error_mod2);

  if v_modus > 0 then

  if p_id is null and p_module is not null then
   begin
    select max(id) into v_id
     from xdb_tst_faq
      where instr(faq_keywords,trim(p_module))>0;
   --   htp.p('<H1>FAQ-ID:'||v_id||'</H1>');
   --   htp.p('<H1>P_MODULE:'||p_module||'</H1>');
     exception when others then
      Null;
      htp.p('<H1> Nothing found </H1>');
     end;
  end if;

   -- Delete
 if p_id is not null
   and p_do_delete is not NULL
   and p_do_delete = 'delete'
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen
        v_fk_faq_category := p_fk_faq_category;
     delete xdb_tst_faq
      where id = v_id;
    commit;
  end if; -- delete

 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
 if  ( (p_id is not null)
        or  (p_do_insert is not null and p_id is null)
        or  (p_do_update is not null )
     )
 --    and p_fun is null
  then
 -- Datensatz einfgen bzw. bernehmen
   v_id                   :=  p_id ;
   v_fk_faq_category      :=  p_fk_faq_category ;
   v_faq_keywords         :=  p_faq_keywords ;
   v_faq                  :=  substr(p_faq_bounds,     1,4000) ;
   v_faq1                 :=  substr(p_faq_bounds,  4001,4000) ;
   v_faq2                 :=  substr(p_faq_bounds,  8001,4000) ;
   v_faq3                 :=  substr(p_faq_bounds, 12001,4000) ;
   v_faq_title            :=  p_faq_title ;
   v_last_mod_date        :=  nvl(p_last_mod_date,sysdate) ;
   v_last_mod_user        :=  nvl(p_last_mod_user,user) ;
 end if;

 if p_do_insert = 'insert'
  and v_modus > 1 -- min 2!
 then

 --SEQUENCE !!!!!!
 select seq_tst_faq.nextval into v_id from dual;

 insert into xdb_tst_faq
 (
             id
        ,    fk_faq_category
        ,    faq_keywords
        ,    faq
        ,    faq1
        ,    faq2
        ,    faq3
        ,    faq_title
        ,    last_mod_date
        ,    last_mod_user
          ) values (
             v_id
        ,    v_fk_faq_category
        ,    upper(v_faq_keywords)
        ,    substr(p_faq_bounds,     1,4000)
        ,    substr(p_faq_bounds,  4001,4000)
        ,    substr(p_faq_bounds,  8001,4000)
        ,    substr(p_faq_bounds, 12001,4000)
        ,    v_faq_title
        ,    v_last_mod_date
        ,    v_last_mod_user
        );
  commit;
  end if; -- Insert ??

  -- UPDATE
  if p_do_update is not null
   and p_id is not null
   and v_modus > 1
    then
     v_id := p_id;
     update xdb_tst_faq
      set
        fk_faq_category     =  v_fk_faq_category
      , faq_keywords       =  upper(v_faq_keywords)
      , faq                =  v_faq
      , faq1               =  v_faq1
      , faq2               =  v_faq2
      , faq3               =  v_faq3
      , faq_title          =  v_faq_title
      , last_mod_date      =  v_last_mod_date
      , last_mod_user      =  v_last_mod_user
      where id   = v_id;
     commit;
    end if; -- Update ??

    if   ( p_do_insert is NULL)
     and ( p_do_delete is NULL)
     and   (p_id is not null or v_id is not null)
  then
    v_id               := nvl(v_id,p_id);
   select
      fk_faq_category
    , faq_keywords
    , faq
    , faq1
    , faq2
    , faq3
    , faq_title
    , last_mod_date
    , last_mod_user
    , dbfun$get_werte('TICKET_CATEGORY',fk_faq_category) faq_category
  into
      v_fk_faq_category
    , v_faq_keywords
    , v_faq
    , v_faq1
    , v_faq2
    , v_faq3
    , v_faq_title
    , v_last_mod_date
    , v_last_mod_user
    , v_faq_category
    from xdb_tst_faq
 where id = v_id
   ;
 end if;



  v_faq_bounds := substr(v_faq||v_faq1||v_faq2||v_faq3,1,16000);

  htp.p('<html>');
  htp.p('<head>');

  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p('<meta http-equiv="expires" content="0">');

  htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||defaultgui||'/css/default.css'' type=''text/css''>');
  htp.p(dbfun$projtoolbar2js);

  htp.p('<title>Projekte | Hilfe</title>');
  htp.p('</head>');

  htp.p('<body>');


 if p_fun = 'EDIT' or v_id is null then
  htp.p (dbfun$projtoolbar(upper(v_module_name)
                               , v_modus
                               , null --dbpck$main.fun$get_akt_benutzer
                               )
          );


    htp.p ('<div class="maintitle"> Hilfe und Knowledge-Editor </div>');
    htp.p (' <form  action="'||lower(v_module_name)||'" id="editors_here" method="post">');
    htp.p ('<!-- Alte Werte -->');
    htp.p ('<input type="hidden"  name="p_id" value="'||v_id||'"/>');

    if p_do_delete = 'delete' and p_do_delete is not null then
      htp.p ('<h2> Die FAQ <i>'||p_faq_title||'</i> wurde gelscht</h2>');
    else -- nicht gelscht
     htp.p ('  <p> Titel: <br>');
     htp.p ('      <input name="p_faq_title" type="text" size="100" maxlength="400" value="'
       || v_faq_title||'">');
     htp.p ('  <p> Kategorie:<br>');
     htp.p ('      <select name="p_fk_faq_category" size="1" maxlength="22" width="50" style="width:250px">');
     for ca5 in c5 loop
         htp.p ('     <option value="'||ca5.id||'" '||selected_opt(v_fk_faq_category ,ca5.id)||'> '||ca5.langtext);
     end loop;
     htp.p ('    </select>');
     htp.p ('  <p> Keywords:<br> <textarea name="p_faq_keywords" id="p_faq_keywords" cols="100" rows="4" style="width:98%;">');
     htp.p( v_faq_keywords );
     htp.p ('  </textarea>');


     htp.p ('  <p> Knowledge:<br><textarea id="p_faq_bounds" name="p_faq_bounds" style="width:98%;height:320px;">');
     htp.p ( nvl(trim(v_faq_bounds), 'hier die Erklrung oder News rein!') );
     htp.p ('</textarea>');

     if v_id is not Null then
       if v_modus > 1 then
         htp.p ('  <input type="submit" name ="p_do_update" value="update"/>');
        end if;
        if v_modus > 2 or v_modus_success > 2 then
         htp.p ('  <input type="submit" name ="p_do_delete" value="delete"/>');
       end if;
     end if;
     if v_id is NULL
       and v_modus > 1 then
       htp.p ('  <input type="submit" name ="p_do_insert" value="insert">');
     end if;

  end if; -- delete


 else

  -- Hier nur Anzeige !!!
  -- Alte Werte
     htp.p ('<div class="maintitle"> ');
     htp.p ( v_faq_title||'</div>');

     htp.p (lfun$web_format(v_faq) );

      if v_id is not Null then
       if v_modus > 1 then
          htp.p ('<br><hr><br>' );
           htp.p (' <form  action="'||lower(v_module_name)||'" method="post">');
           htp.p ('<!-- Alte Werte -->');
           htp.p ('<input type="hidden"  name="p_id" value="'||v_id||'"/>');
           htp.p ('<input type="submit" name ="p_fun" value="EDIT"/>');
           htp.p ('</form>');
        end if;
       end if;



   end if; -- p_fun

  else -- v-modus =0
  htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;

 htp.p('</BODY>');
 htp.p('</HTML>');
 end;
EXCEPTION
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/

