--  Generated at : 30.07.2008
--  Generated by : Erich Heinemann
--


----------------------------------------------------------------
-- PROCEDURE AASTRA_1
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE aastra_1
as

 -- Das ist die LANDPAge fr die Aastra-Telefone
 -- Es existiert keine vergleichbare Website fr den normalen Browser
 -- Im Aastra-Telefon sind die Action-URIs entsprechend der Dokumentation
 -- anzupassen.



begin
  htp.p('<AastraIPPhoneTextScreen>');
  htp.p(' <Title>Push test</Title>');
  htp.p('  <Text>This is a test for pushing a screen to a phone.');
  htp.p('   It is a way to demonstrate that we can push XML objects to an Aastra Phone.');
  htp.p(' </Text>');
  htp.p('</AastraIPPhoneTextScreen>');


end;
/


----------------------------------------------------------------
-- PROCEDURE AASTRA_DIAL
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE aastra_dial (p_tel in varchar2 default null)
as

 v_tel        varchar2(255) := substr(p_tel,1,20);
 v_prefix     xdb_Werte.langtext%type := dbfun$get_Werte('globalconfig','tel_pref');  -- Amtsholung
 v_replace    xdb_Werte.langtext%type := dbfun$get_Werte('globalconfig','tel_0_repl'); -- fhrende Null aus der Datenbank wird ersetzt gegen...

 v_ip         proj_aastra_register.ip%type;

begin

 v_ip := dbfun$get_phone_ip(user);

 -- Wenn kein Telefon gefunden wird, ist die ganze Funktion sinnlos...
 if v_ip is not null then

 -- auf der Webseite muss noch etwas ausgegeben werden
  if substr(p_tel,1,1) = '0'
  and substr(p_tel,1,2) != '00'
  then
  -- inlndische Telefonnummer
   v_tel := v_replace || substr  (p_tel,2); -- die fhrende Null wird durch etwas anderes ersetzt
 end if;


 if v_prefix is not null then
  v_tel := v_prefix||v_tel ;
 end if;

-- v_tel := DBFUN$FORMAT_TEL(v_tel); -- Grobe korrektur aller Angaben!

 v_tel := replace(v_tel,' ','');
 v_tel := replace(v_tel,'+','');
 v_tel := replace(v_tel,'-','');



  htp.p('Es wird eine Telefonnummer '||v_tel||' gewhlt');
  htp.p('<br>Achten Sie auf Ihr Telefon!');

   aastra_util.push2phone (
           p_server   => dbfun$get_werte('globalconfig',' serv_ip') --IP des Servers
         , p_phone    => v_ip
         , p_data     => 'xml='
  ||'<AastraIPPhoneExecute Beep="no">'
  ||'<ExecuteItem URI="Dial:'||v_tel||'" triggerDestroyOnExit="yes" interruptCall="no" />'
  ||'</AastraIPPhoneExecute>'
        );

  else
   htp.p('<html><body>');
   htp.p('<h1> Zu Ihrem Projekt-Account ('||user||') wurde kein regstriertes Telefon gefunden!! </h1>');
   htp.p('<ol>');
   htp.p('  <li> Ihre Emailadresse muss bei Ihrem Account und in Ihren Kontaktdaten eingetragen sein');
   htp.p('  <li> Die SIP-Adresse muss korrekt bei den Kontaktdaten eingetragen sein');
   htp.p('  <li> Das Telefon muss sich beim Projekt-Server angemeledet haben (ACTION-URI)');
   htp.p('</ol>');
   htp.p('</body><html>');


  end if;
end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON AASTRA_DIAL                    TO PROJ_RO;

GRANT EXECUTE      ON AASTRA_DIAL                    TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE AASTRA_DSL_NAT_IP
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE aastra_dsl_nat_ip
as

-- Das Telefon braucht beim Betrieb ber NAT-Netzwerke die ffentliche IP-Adresse
-- diese kann man ggf. ber einen WWW-Service ermitteln.
-- .. gf. kann man die ABsende-Adresse auch auf Grund einer IP-Range
-- in die Procedure Aastra_Register verpacken

-- DSL1-Logik - wenn die PROJ-Applikation im WEB steht und das Telefon einen DSL-Uplink zu einem VoIP-Provider nutzt:
--  Wenn die Remote-IP-Adresse aus dem HTTP-Header "Agent" nicht bereinstimmt, schickt das Telefon eine
--  falsche IP mit. Dann knnte man ihm die richtige NAT-IP direkt zurck geben

-- DSL2-Logik - wenn die PROJ-Applikation im gleichen LAN luft wie das Telefon, aber der VOIP-Server im WEB (VoIP-Provider)
-- kann man nur ber einen WEB-Dienst wie bei www.heise.de die temporre ffentliche IP-ADresse fr das (ein) Telefon ermitteln
-- und bei ihm setzten.


 v_data     varchar2 (2000);
 v_ip       proj_aastra_register.ip%type;
 v_nat_ip   proj_aastra_register.ip%type;

begin
 v_ip := dbfun$get_phone_ip(user);
 dbms_output.put_line ('IP:'||v_ip);
 -- Wenn kein Telefon gefunden wird, ist die ganze Funktion sinnlos...
 if v_ip is not null then

  --hier muss nun ihrer Funktion zur Ermittlung der NAT-IP rein...
  -- v_nat_ip := ???;

   aastra_util.push2phone (
            p_server   => dbfun$get_werte('globalconfig',' serv_ip') --IP des Servers
          , p_phone    => v_ip
          , p_data     => 'xml='
   ||'<AastraIPPhoneConfiguration Beep="no" triggerDestroyOnExit="yes">'
   ||'<ConfigurationItem>'
   ||'<Parameter>sip nat ip</Parameter>'
   ||'<Value>'||v_nat_ip||'</Value>' --'||v_nat_ip||'
   ||'</ConfigurationItem>'
   --||'<!Additional ConfigurationItems may be added -->
   ||'</AastraIPPhoneConfiguration>'
        );
 end if;
end;
/


----------------------------------------------------------------
-- PROCEDURE AASTRA_REGISTER
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE aastra_register ( p_sipuser in varchar2 default null )
as
 -- ber diese Procedure bekommen wir den Zusammenhang zwischen SIP-User und dem WEB-User und seinen Berechtigungen im PROJ-Tool

  v_sip_user      varchar2(255) := substr( p_sipuser,1,255);
  v_remote_ip     varchar2(255) := owa_util.get_cgi_env('REMOTE_ADDR');
  v_agent         varchar2(800) := owa_util.get_cgi_env('HTTP_USER_AGENT');
  v_user          xdb_zug_user.login%type;
  v_error         varchar2(200);

begin

 -- Prfen, ob der SIP-User oder das Telefon schonmal registriert war, ist aufwendig
 -- einfacher ist es, alste Eintrge zu lschen und nur neue einzufgen... :-)))) hehehe
   begin
    delete  proj_aastra_register
     where ip = v_remote_ip or sip_user = v_sip_user;
   exception when others then
    null;
   end;

  begin
  select min(login) into v_user
   from xdb_zug_user u
      , proj_kontakt k
  where
    k.email = u.email
    and k.email is not null
    and u.email is not null;
   exception when others then
    v_error := 'Kein Eintrag in Kontakten gefunden!';
   end;

    insert into  proj_aastra_register
    ( ip                 --              varchar2  (15)   ,
    , sip_user           --              varchar2  (255)  ,
    , proj_user          --              varchar2  (255)  ,
    , letzte_aktivitaet  ---              date
    , header_ip
    )
    values
    (v_remote_ip
    , v_sip_user
    , v_user     -- hier muss der User gefunden werden
    , sysdate
    , substr(owa_util.get_cgi_env('HTTP_USER_AGENT'),1,255)
    );

-- htp.p('<Title>User Agent</Title>');
  if v_error is null then
   htp.p('<AastraIPPhoneFormattedTextScreen LockIn="yes"  destroyOnExit="yes" Timeout = "2">');
   htp.p('<Line> SIP-User:'|| v_sip_user   ||'</Line>');
--   htp.p('<Line> IP:'            || v_remote_ip  ||'</Line>');
   htp.p('<Line> Projekt-User:'   || v_user      ||'</Line>');
 else
   htp.p('<AastraIPPhoneFormattedTextScreen LockIn="yes"  destroyOnExit="yes" Timeout = "45">');
   htp.p('<Line> SIP-User:'|| v_sip_user   ||'</Line>');
   htp.p('<Scroll Height="2"><Line> '      || v_error  ||'</Line></Scroll>');
 end if;

 htp.p('</AastraIPPhoneFormattedTextScreen>');

end;
/


----------------------------------------------------------------
-- PROCEDURE AASTRA_RESET
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE aastra_reset
as


 v_ip         proj_aastra_register.ip%type;

begin

 v_ip := dbfun$get_phone_ip(user);

 -- Wenn kein Telefon gefunden wird, ist die ganze Funktion sinnlos...
 if v_ip is not null then




  htp.p('Ihr Telefon wird gebootet');
  htp.p('<br>Achten Sie auf Ihr Telefon!');

   aastra_util.push2phone (
           p_server   => dbfun$get_werte('globalconfig','serv_ip')
         , p_phone    => v_ip
         , p_data     => 'xml='
  ||'<AastraIPPhoneExecute Beep ="no">'
  ||'<ExecuteItem URI=Command: Reset/>'
  ||'</AastraIPPhoneExecute>'
        );
  end if;
end;
/


----------------------------------------------------------------
-- PROCEDURE AASTRA_SUCHE_TEL
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE aastra_suche_tel    ( p_num in Varchar2 default null
                                                )

as


-- So muss die Ergebnisliste fr ein Aastra aussehen

 v_num Varchar2(200) := substr(p_num,1,200);


 v_modus                  Number(1);
 v_module_name            Varchar2(30)  := 'PROJ_SUCHE_TEL';

  -- Formatierung

 v_counter                Number(10);

 -- Liste der Ansprechpartner
 cursor c1 (cnumber in Varchar2) is
 select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       , co.id
       , co.tel1 tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(tel1,'/',''),' ') like '%'||cnumber
     and  co.tel1    is not null
     and  co.fk_firma = c.id (+)

  union all
  -- 2
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       ,  co.id
       ,  co.tel2 tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(co.tel2,'/',''),' ') like '%'||cnumber
       and co.tel2 is not null
       and  co.fk_firma = c.id (+)
  --3
  union all
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       , co.id
         , co.tel3  tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(co.tel3 ,'/',''),' ') like '%'||cnumber
       and co.tel3 is not null
       and  co.fk_firma = c.id (+)
 --4
  union all
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       ,  co.id
   ,  co.tel4  tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(co.tel4 ,'/',''),' ') like '%'||cnumber
       and co.tel4 is not null
       and co.fk_firma = c.id (+)
 --5
  union all
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
   ,  co.id
   ,  co.tel5  tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
     ,  proj_firma c
    where replace(replace(co.tel5 ,'/',''),' ') like '%'||cnumber
       and co.tel5 is not null
       and  co.fk_firma = c.id (+)
 ;

 -- Liste der laufenden Projekte, wo diese Person als Bauherr eingetragen ist
 cursor c2 (l_contact in Number)
  is
 select
   p.id
 , p.projekt_id
 , p.projekt_name
 , decode(vorname, vorname,vorname||' '||nachname, nachname) bauherr
 , aktueller_status
 , fk_projekt_status
 , startdatum
 , p.letzte_bearbeitung
  from proj_projekt p
     , proj_kontakt k
   where fk_projekt_status  != 4 -- abgeschlossene werden nicht aufgelistet... - suctomizing!   ;
    and k.id = l_contact
    and ( -- entweder ist es der Bauherr
         ( fk_bauherr = l_contact and fk_bauherr is not null)
    --  or
    --     ( -- oder ein Mitarbeiter eines Subunternehmers
    --      1=0
    --      )
         );


begin

  -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

 if v_modus > 0 then


  if v_num like ('00%') then
   v_num := substr(v_num,2);
  end if;

  -- Wenn die Nummer keine fhrende Null und auch krzer als 5 Stellen ist, dann handelt es sich um eine Nebenstellennummer
  -- die an der gleichen Nebenstelle hngt
  if v_num not like ('0%') and length(v_num) <= 5  then
   v_num := dbfun$get_werte('globalconfig','tel_pbx') || v_num  ;
  end if;

  htp.p('<AastraIPPhoneTextMenu destroyOnExit = "yes">');
  htp.p('<Title>Dial and Select</Title>');
 for ca1 in c1 ( p_num )  loop
  htp.p('<MenuItem>');
  htp.p('<Prompt>'||ca1.full_name||'</Prompt> ');
  htp.p('<URI>101</URI>');
  htp.p('<Selection>101</Selection>');
  htp.p('</MenuItem> ');
 /*
   htp.p(' <MenuItem>');
   htp.p('  <Prompt>');
   htp.p('    TEST'); --||ca1.full_name);
    if ca1.stadt is not null then htp.p('('||ca1.stadt||')');  end if;
   htp.p('    </Prompt>');
   htp.p('  <URI>'||ca1.id||'</URI>');
   htp.p('  <Selection>'||ca1.id||'</Selection>');
 --  htp.p('  <Selection>'||ca1.tel||'</Selection>');
   htp.p('  </MenuItem>');
*/
  end loop;


htp.p('<SoftKey index = "1">');
htp.p('<Label>Dial</Label>');
htp.p('<URI>SoftKey:Dial</URI>');
htp.p('</SoftKey>');

htp.p('<SoftKey index = "2">');
htp.p('<Label>Select</Label>');
htp.p('<URI>http://192.168.160.101/pls/freeaccess/xml_offhook</URI>');
htp.p('</SoftKey>');

htp.p('</AastraIPPhoneTextMenu>');

 else -- v-modus =0


  htp.p (dbfun$aastra_no_access);
 end if;

exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
end;
/


----------------------------------------------------------------
-- PROCEDURE AJAX_SUCH_KONTAKT
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE ajax_such_kontakt (p_search in Varchar2 default null)
as


--[VERS:2007-01-27]
-- Diese Funktion liefert die OPtionliste fr die DOJO-Combobox im
-- JSON-Stil zurck
-- E.Heinemann

-- 27.01.2007 Anpassung an Umlaute
-- 05.01.2007 Ersterstellung

cursor c1 (l_search in varchar2) is
select decode(k.vorname, nvl(k.vorname, '-'), k.nachname||', '
 ||k.vorname,k.nachname)||' ('||substr(nvl(f.firmenname,k.stadt),1,40) ||')' main_name
 , k.id
 from proj_kontakt k
   ,  proj_firma f
  where
   upper(nachname) like   (l_search||'%')
  and k.fk_firma = f.id(+)
   order by nachname;

 v_search varchar2(200) := trim(substr(p_search,1,200));

begin
htp.p('[');
if length(v_search)> 2 then
 v_search := replace(v_search,chr(195),'');
 v_search := replace(v_search,chr(164),'');
 v_search := replace(v_search,chr(182),'');
 v_search := replace(v_search,chr(188),'');
 v_search := replace(v_search,chr(132),'');
 v_search := replace(v_search,chr(155),'');
 v_search := replace(v_search,chr(156),'');
 v_search := replace(v_search,chr(159),'');

 for ca1 in c1  (upper(replace(v_search,'*','%'))) loop
  if trim(ca1.main_name) is not null then
   htp.p('    [ "'||ca1.main_name||'","'||ca1.id||'"],');
  end if;
 end loop;
--  htp.p('    [ "'||v_search||'-'||ascii(substr(v_search,1,1))||'","'||ascii(p_search)||'"]');
  htp.p('    [ "",""]');

end if;
htp.p('] ');
end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON AJAX_SUCH_KONTAKT              TO PROJ_RO;

GRANT EXECUTE      ON AJAX_SUCH_KONTAKT              TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE HTP_TEST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE htp_test
as

 begin
 htp.p('<HTML><BODY>');
 htp.p('<H1>JA, die EPG - Konfiguration funktioniert</H1>');
 htp.p('<PRE>');
 htp.p('User -------------------');
 htp.p('AUTHORIZATION:        '||owa_util.get_cgi_env('AUTHORIZATION'));
 htp.p('REMOTE_ADDR:          '||owa_util.get_cgi_env('REMOTE_ADDR'));
 htp.p('REMOTE_USER:          '||owa_util.get_cgi_env('REMOTE_USER'));
 htp.p('HTTP_ACCEPT:          '||owa_util.get_cgi_env('HTTP_ACCEPT'));
 htp.p('HTTP_ACCEPT_ENCODING: '||owa_util.get_cgi_env('HTTP_ACCEPT_ENCODING'));
 htp.p('HTTP_ACCEPT_CHARSET:  '||owa_util.get_cgi_env('HTTP_ACCEPT_CHARSET'));
 htp.p('HTTP_ACCEPT_LANGUAGE: '||owa_util.get_cgi_env('HTTP_ACCEPT_LANGUAGE'));
 htp.p('HTTP_COOKIE:          '||owa_util.get_cgi_env('HTTP_COOKIE'));
 htp.p('HTTP_USER_AGENT:      '||owa_util.get_cgi_env('HTTP_USER_AGENT')||chr(10));

 htp.p('CGI---------------------');
 htp.p('REQUEST_METHOD:       '||owa_util.get_cgi_env('REQUEST_METHOD'));
 htp.p('REQUEST_PROTOCOL:     '||owa_util.get_cgi_env('REQUEST_PROTOCOL'));
 htp.p('SCRIPT_NAME:          '||owa_util.get_cgi_env('SCRIPT_NAME'));
 htp.p('SCRIPT_PREFIX:        '||owa_util.get_cgi_env('SCRIPT_PREFIX')||chr(10));

 htp.p('SERVER -----------------');
 htp.p('HTTP_HOST:            '||owa_util.get_cgi_env('HTTP_HOST'));
 htp.p('HTTP_REFERER:         '||owa_util.get_cgi_env('HTTP_REFERER'));
 htp.p('SERVER_NAME:          '||owa_util.get_cgi_env('SERVER_NAME'));
 htp.p('SERVER_PORT:          '||owa_util.get_cgi_env('SERVER_PORT'));
 htp.p('SERVER_PROTOCOL:      '||owa_util.get_cgi_env('SERVER_PROTOCOL'));

 htp.p('</PRE></BODY></HTML>');
end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON HTP_TEST                       TO AASTRAPHONES;

GRANT EXECUTE      ON HTP_TEST                       TO PROJ_RO;

GRANT EXECUTE      ON HTP_TEST                       TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PO_FIRMA_MA_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE po_firma_ma_list (   p_fk_firma_id    in Number    default null
                                               , p_such           in varchar2  default null
                                               , p_format         in varchar2  default null
                                               , p_is_portlet     in Varchar2  default 'ja'
                                               )
as

--[VERS:2007-02-07]
-- Fr Liste der Kontakte

 -- Ansprechpartner aus allgemeiner Suchmaske  suchen
 cursor c1 (c_fk_firma in number, c_such in varchar2) is
   select
      c.id
    , decode(vorname,vorname, vorname||' '||nachname,nachname ) kontakt_name
    , nvl(nvl(c.email,tel1),tel2) contact
    , c.email
    , nvl(c.tel1,c.tel2) telephone
    , substr(x.firmenname,1,80)||' '||x.zusatz||'('||x.stadt||')' firma
    , x.id firma_id
    , c.bemerkung
   from proj_kontakt c
      , proj_firma   x
     where (
             (fk_firma = c_fk_firma and  c_fk_firma is not null  )
             or
             (
              ( upper(vorname) like c_such or upper(nachname) like c_such )
              and c_fk_firma is null and c_such is not null
              )
            )
      and c.fk_firma = x.id(+)
           --    telephone_private
           --    telephone_additional
           --    mobile_additional
    order by nachname;



  -- Zugriffsverwaltung
  v_modus           Number(1);
  v_module_name     Varchar2(20) := 'PO_FIRMA_MA_LIST';

  -- Formatierung
  v_firmenname      Varchar2(400); -- da wird der name der Firma reingebaut

  -- Suchfunktion
  v_counter         Number(10)    := 0; -- anch 100 Datenstzen wird abgebrochen !!

  v_user_id         Number(10);

  kund              Varchar2(2)  := chr(38);
  nbsp              Varchar2(10) := kund||'nbsp;';
  v_dummy           Number(10)   :=0;
  v_such            varchar2(31) := upper(substr(replace(p_such,'*','%'),1,30)||'%'); -- Suchprameter wird optimiert

  v_link            Varchar2(500);

  --fr Files:
 -- v_blob_content     xdb_tst_files.blob_content%TYPE;
 -- v_filename       Varchar2(255);
 -- myblob           Blob;
 -- v_mime_type      xdb_tst_files.mime_type%TYPE;
  --v_bfile            UTL_FILE.file_type;
  l_text             VARCHAR2(32767);

BEGIN
 v_modus := dbpck$main.fun$chk_module_allowed(v_module_name);

   if p_fk_firma_id is not null then
    null;
    begin
     select  ' der Firma '||firmenname||' '||'('||stadt||')' into v_firmenname
         from proj_firma
         where id = p_fk_firma_id;
     exception when others then null;
    end;
   end if;


 if v_modus > 0 then

 if p_format is not null and p_format in ('word','excel','powerpoint') then
   owa_util.mime_header('application/vnd.ms-'||p_format,FALSE);

   if p_format = 'word' then
     htp.p('Content-disposition: attachment;filename=Kontakte_'||p_fk_firma_id||'.doc');
   end if;

   if p_format = 'xls' then
     htp.p('Content-disposition: attachment;filename=Kontakte_'||p_fk_firma_id||'.xls');
   end if;

   owa_util.http_header_close;
 end if;

  -- HTTP-Session ffen
   htp.p ('<HTML>');
   htp.p ('<head>');
   htp.p ('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p ('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  -- HTML-Include fr das Men
 if p_format is null and p_is_portlet != 'ja' then
   htp.p(dbfun$projtoolbar2js);
 end if;

   if p_format is null then
     htp.p (' <link rel="stylesheet" href="/i/projekt/default/css/default.css" type="text/css">');
-- XLS und DOC werden ohne CSS ausgeliefert, ... geht ander, ist aber zu komplziert fr die Installation
-- und unterschiedich je nach Datenbank..
  end if;
/*   else
     null;
     -- read the CSS-File
    begin
   -- v_bfile := BFILENAME('XDBFUTIL', 'default.css');
  --  htp.p('<style type="text/css">');
   -- v_bfile := UTL_FILE.fopen('XDBFUTIL', 'default.css', 'r', 32767);

    -- Read and output first line.
   -- UTL_FILE.get_line(v_bfile, l_text, 32767);
   -- htp.p( l_text );

    -- Read through the file until we reach the last line.
    BEGIN
     LOOP
       UTL_FILE.get_line(v_bfile, l_text, 32767);
       htp.p (l_text);
     END LOOP;
    EXCEPTION
     WHEN NO_DATA_FOUND THEN
       NULL;
    END;
    -- Close the file.
   UTL_FILE.fclose(v_bfile);

   exception when others then
    htp.p('Error on WPG_DOCLOAD');
    htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);

   end;
    htp.p('</style>');
   end if;
  */


   htp.p ('<title>Projekt | Kontakt-Liste</title>');

   htp.p ('</head>');
   htp.p ('<BODY>');

 if p_format is null and p_is_portlet != 'ja' then
   htp.p (dbfun$projtoolbar(upper(v_module_name)
                                , v_modus
                                , null --dbpck$main.fun$get_akt_benutzer
                                )
           );
    if p_fk_firma_id is not null then
        htp.p ('<div class="maintitle"> Kontakt-Liste zu'  ||v_firmenname||'</div>');
    else
        htp.p ('<div class="maintitle"> Ergebnisliste-Liste zu '  ||p_such||'</div>');
    end if;
 end if;





  htp.p(v_such);

  if p_fk_firma_id is not null and p_format is null then
   htp.p ('<div style="text-align:right;">');
   htp.p (' <a  href="po_firma_ma_list?p_fk_firma_id='||p_fk_firma_id||kund||'p_format=excel" target="_new"> [XLS-Export] </a>');
   htp.p (' |<a href="po_firma_ma_list?p_fk_firma_id='||p_fk_firma_id||kund||'p_format=word" target="_new"> [DOC-Export] </a>');
   htp.p('</div>');
 end if;


    if p_fk_firma_id is not null then
     if v_modus > 1  and p_format is null then
/*
     htp.p(dbfun$html_button('Neuen Mitarbeiter erfassen','proj_kontakt_details?p_fk_firma_id='
        ||p_fk_firma_id,230));
*/
     htp.p ('<div style="text-align:right;"><a href="proj_kontakt_details?p_fk_firma='
        ||p_fk_firma_id||'" target="_new"><img src="/i/projekt/default/img/add_new_abc.png" border="no"/>[Neuen Ansprechpartner zu '||v_firmenname
        ||' erfassen]</a>');
     end if;
    end if;



   htp.p('<table class="listtable" style="width:98%;background-color:#FFFFFF;">');

   htp.p('    <TD width="80"  class="tdh"> Name </TD>');
   htp.p('     <td width="120" class="tdh">');
   htp.p(' Telefon </TD>');



   htp.p('    <TD width="120" class="tdh"> Email </TD>');
--   htp.p('    <TD width="80"  class="tdh"> Firma /Abteilung </TD>');
   if p_format is null then
     htp.p('    <TD width="20"  class="tdh" colspan="3">'||nbsp ||'</TD>');
   end if;
   htp.p('<tr>');
  v_counter :=1;


  for ca1 in c1(p_fk_firma_id, v_such)  loop
   v_dummy := v_counter;
   v_link  := '<a href="proj_kontakt_details?p_id=' ||ca1.ID||'" target="_top">';

  if v_counter < 500 then
   htp.p('  <tr class="tdlist'||mod(v_dummy,2)||'">');


   if ca1.firma_id = 1 then   -- erste Firma ist immer die eigene Firma (intern) , externe dann != 1 !!
    htp.p(' <td class="tdlist'||mod(v_dummy,2)||'" style="background-image: url(./i/projekt/default/img/tool/bg_gn.gif);"> ');
   else
    htp.p(' <td class="tdlist'||mod(v_dummy,2)||'" > ');
    null;
   end if;

   htp.p(v_link||ca1.kontakt_name
      ||'</a>'
      ||'</td>');

   htp.p('    <td class="tdlist'||mod(v_dummy,2)||'">');
   htp.p( ca1.bemerkung);
   htp.p('</td>');



   htp.p('    <td class="tdlist'||mod(v_dummy,2)||'">');

   htp.p(dbfun$get_kontakt_tel (ca1.id) );
  -- if p_format is null then
  --    htp.p ( dbfun$get_contact_tel (ca1.id));
  -- else
  --    htp.p ('call:'|| dbfun$get_callto_tel (ca1.id));
  -- end if;

   htp.p('     </td>');



   htp.p('     <td  class="tdlist'||mod(v_dummy,2)||'">'
      ||'<a href="mailto:'
      ||ca1.email||'" title="Sende Email" alt="Email an">'
      ||ca1.email --contact
      ||'</a>');
   htp.p('     </td>');

--   htp.p('     <td  class="tdlist'||mod(v_dummy,2)||'">');
--       if  ca1.firma_id is not null then
--          htp.p(' <a href="proj_firma_details?p_id='||ca1.firma_id||'">'
--           ||ca1.firma
--           ||'</a>');
--     end if;
--   htp.p('     </td>');
  if p_format is null then
    htp.p('     <td colspan="2" class="tdlist'||mod(v_dummy,2)||'"><A href="proj_kontakt_details?p_id='
       ||ca1.ID||'"><img src="/i/projekt/default/img//details.png" BORDER="NO" title="Edit Details" Alt="Details" target="_top"></A>');
     htp.p('     </td>');
    end if; -- p_format
   htp.p('   </tr>');

   end if; -- v_counter < 100
   end loop;

  htp.p('  </table>');

  if v_counter > 99 then
   htp.p('     <br><H1>Zu viele Daten !!, die Liste wurde abgeschnitten !</h1>');
  end if;


 else -- v-modus =0
    htp.p (' <html><body><H1> no Accesss with Your Account ! </H1><BR>');
 end if;


 htp.p('</BODY>' );
 htp.p('</HTML>' );
end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PO_FIRMA_MA_LIST               TO PROJ_RO;

GRANT EXECUTE      ON PO_FIRMA_MA_LIST               TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PO_PROJEKT_AKTUELLES
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE po_projekt_aktuelles

 (  p_fk_projekt_id                in Number    default null -- Filter auf das Projekt, .. ohne geht es nicht
  )

as
--[VERS:2008-07-24]

-- Ziel:
-- Generiert Liste des Projekt_Logs
-- Autor: Erich Heinemann

  cursor c1 (l_fk_projekt_id in Number)
   is
   select letzte_bearbeitung
   , bearbeitung_durch
   , aktueller_Status
   , dbfun$get_werte     ('projekt_status',fk_projekt_status) projekt_status
  from proj_projekt_aktuelles_log
   where id   =  l_fk_projekt_id
   order by letzte_bearbeitung desc;

  -- Zugriffsverwaltung
  v_modus            Number(1);
  v_module_name      Varchar2(30) := 'PO_PROJEKTPHASEN_LIST';

  -- Formatierung
  kund               varchar2(2)  := chr(38);

  v_dummy            Number(10)     :=1;

  v_td_string        Varchar2(2000);

  defaultgui         Varchar2(400) := dbfun$default_gui;
  defaultlang        Varchar2(400) := dbfun$default_lang;
  dateformat         Varchar2(40)  := ('DD.MM.YYYY'); -- hier nur Tagesdatum


BEGIN


  v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

  if v_modus > 0 then

   -- HTTP-Session ffen
    htp.p('<HTML>');
    htp.p('<head>');
    htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
    htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');


    htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||dbfun$default_gui||'/css/default.css'' type=''text/css''>');

    htp.p('</head>');
    htp.p('<BODY>');

    -- die 2 anchfolgenden DIVS werden versteckt um die Styles fr das Highlighting beim Hover-Effekt zu steuern
    htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">x</div>');
    htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">x</div>');


    -- Header-Zeile aufbauen
    htp.p(' <table class="listtable" style="width:98%;position:absolute;top:4px;">');

    htp.p('  <tr>');

    htp.p('  <td class="tdh" style="border-bottom-width:1px;width:25%;">');
    htp.p('      letzte Bearbeitung');
    htp.p('  </td>');

    htp.p('  <td width="150" class="tdh"  style="border-bottom-width:1px;;width:25%;" >');
    htp.p('     durch');
    htp.p('  </td>');

    htp.p('  <td width="120" class="tdh" style="border-bottom-width:1px;;width:40%;" >');
    htp.p('     Neues "Aktuelles"');
    htp.p('  </td>');

    htp.p('  <td width="60" class="tdh"  style="border-bottom-width:1px;;width:10%;">');
    htp.p('     neuer Status</form>');
    htp.p('  </td>');

    htp.p('</tr>');

    v_dummy := 1;

  for ca1 in c1 (p_fk_projekt_id)
   loop

   -- Der Style wird in der Liste zwischen den Datenstzen und dem Status des Projektes jeweils umgeschaltet
   -- Daher wird der Link vorher definiert und der Rohbau einer Tabellenzelle (<TD>) vorab je Zeile definiert



   if v_dummy < 1000 then
     v_dummy :=  v_dummy +1;

     v_td_string :=  '    <td onmouseover="tr'||v_dummy||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'
       ||v_dummy||'.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;" '
                 ||' >';

     htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" id="tr'||v_dummy||'" style="text-valign: center;">');

     -- letzte Bearbeitung
     htp.p ( v_td_string ||to_char(ca1.letzte_Bearbeitung,dateformat) ||'</td>');

     -- durch
     htp.p ( v_td_string ||ca1.bearbeitung_durch ||'</td>');

     -- Spalte fr Aktuelles
     htp.p ( v_td_string ||ca1.aktueller_Status  ||'</td>');

     -- Spalte fr Status (Auswahlliste)
     htp.p ( v_td_string ||ca1.projekt_Status||'</td>');

     htp.p('   </tr>');
    end if; -- 1000?
   end loop;
   htp.p('   </table>');

 else -- v-modus =0
    htp.p ('  <html><body><h1> no Accesss with Your Account ! </h1><br>');
 end if;


 htp.p('  </body>' );
 htp.p(' </html>' );

-- exception when others
-- then
--    htp.p ('SQL-Error '||sqlerrm ||' / '|| sqlcode );
end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PO_PROJEKT_AKTUELLES           TO PROJ_RO;

GRANT EXECUTE      ON PO_PROJEKT_AKTUELLES           TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PO_PROJEKT_FRAGEN_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE po_projekt_fragen_list
(
     p_id                   in Number    default NULL   -- ID des Projektes
   , p_report               in varchar2  default 'n' -- Druckansicht
   , p_do_update            in varchar2  default ''
   , p_do_delete            in Varchar2  default ''
   , p_do_insert            in Varchar2  default ''
) as

--[VERS:2008-07-20]
  -- Funktion:
  -- Nur die Liste der Fragen fr einen TAB (iframe) in PROJ_PROJEKT_DETAILS
  -- Historie:

-- lokale Variablen:
   v_id                     proj_projektfrage.id%type;
   v_letzte_bearbeitung     proj_projektfrage.letzte_bearbeitung%type;
   v_dummy                  Number(10); -- interner Zhler

   v_modus                  Number(1);
   v_module_name            Varchar2(30)  := 'PO_PROJEKT_FRAGEN_LIST';  --Pseudoabfrage!

  -- Formatierung
   kund                     Varchar2(1)   := chr(38);
   nbsp                     Varchar2(5)   := chr(38)||'nbsp';
   v_field_width            Number(10);
   defaultgui               Varchar2(400) := dbfun$default_gui;
   defaultlang              Varchar2(4)   := dbfun$default_lang;


  -- vordefinierte Farben, sofern die Frage in den letzten Tagen bearbeitet wurde
   v_today_td               Varchar2(50)  := '#6595FF';
   v_today_td4              Varchar2(50)  := '#A0C0FF';
   v_today_td7              Varchar2(50)  := '#D0E0FF';
   v_timed_format           Varchar2(50);

  v_link            Varchar2(400);
  v_td_string       Varchar2(2000);

 -- Projekt-Fragen
 cursor c10 (c_id in number) is
  select
      f.id
    , f.subject
    , substr(f.subject_tx,1,80) tx
    , substr(f.subject_rx,1,80) rx
    , f.action_date
    , f.status
   from proj_projektfrage f
         where fk_projekt_id =  c_id  -- bergabeparameter
     order by action_date desc; -- zuletzt gestellte Fragen on top




 BEGIN

 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed(v_module_name);

 if v_modus > 0 then

  v_id := p_id;

  htp.p('<html>');
  htp.p(' <head>');
  htp.p('  <META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  -- deutscher zeichensatz <meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
  htp.p('  <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

  htp.p('  <link rel="stylesheet" href="/i/projekt/'||dbfun$default_gui||'/css/default.css" type="text/css">');
  htp.p('  </link>');

  htp.p(' </head>');
  htp.p('<body style="padding-left:8px;padding-top:0px;text-align: center;">');

  -- Liste der Fragen-Aktionen:
  if v_id is not null then

   htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">x</div>');
   htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">x</div>');

   htp.p('<div id="tdlistactionDate7_0" class="tdlist1" style="visibility:hidden;top:0px;height:0px;background-color:'||v_today_td7||';">x</div>');
   htp.p('<div id="tdlistactionDate4_0" class="tdlist1" style="visibility:hidden;top:0px;height:0px;background-color:'||v_today_td4||';">x</div>');
   htp.p('<div id="tdlistactionDate1_0" class="tdlist1" style="visibility:hidden;top:0px;height:0px;background-color:'||v_today_td||';">x</div>');

   htp.p('<div id="tdlistactionDate7_1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;background-color:'||dbfun$mod_color( v_today_td7 ,10)||';">x</div>');
   htp.p('<div id="tdlistactionDate4_1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;background-color:'||dbfun$mod_color( v_today_td4 ,10)||';">x</div>');
   htp.p('<div id="tdlistactionDate1_1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;background-color:'||dbfun$mod_color( v_today_td ,10)||';">x</div>');

  -- htp.p('<div id="tablelist" style="position:absolute;top:5px;text-align:center;">');

--    htp.p('  <table class="formtable" style="width:98%;">');
--    htp.p('  <tr>');
--    htp.p('    <td width="25%" class="tdh" align="left"  style="width:25%;" valign="top">'
--     ||dbfun$i18(defaultlang,'Liste')||'</td>');
--    htp.p('    <td width="25%" class="tdh" align="right" style="width:25%;" valign="top">');




    htp.p('<div id="buttons"  style="position:absolute;top:0px;visibility:visible;Z-INDEX: 1;">');
      if v_modus > 2 then
       --  htp.p ('<a href="proj_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id||'" target="_blank"> Neue Phase einfgen </a>');
        htp.p(dbfun$html_button ('po_projektfrage_details?p_fk_projekt_id='||p_id,'<img src="/i/projekt/default/img/add_new_abc.png">'||dbfun$i18(defaultlang,'Neue Frage einfgen')));
      end if;

        htp.p(dbfun$html_button (v_module_name||'?p_id='||p_id||kund||'p_report=j','Druckansicht'));
        htp.p(dbfun$html_button (v_module_name||'?p_id='||p_id,'<img src="/i/projekt/default/img/reload.png">Neu Laden'));

     htp.p('</div>');


--    if v_modus > 1 and p_do_delete is null then
--      htp.p('  <input type="button" value="Neue Frage in Liste aufnehmen" '
--       ||'onClick="document.location.href=''po_ticket_action_details?p_fk_ticket='||v_id||'''"/>');
--    end if;
--    htp.p('  </tr>');
--    htp.p(' </table>');

    htp.p(' <table class="listtable" style="width:98%;position:absolute;top:36px;">');

    htp.p('  <tr>');
    htp.p('     <td class="tdh" style="width:20%;">Datum</td>');
    htp.p('     <td class="tdh">Betreff</td>');
    htp.p('     <td class="tdh" style="width:25%;"> Frage </td>');
    htp.p('     <td class="tdh" style="width:25%;"> Antwort </td>');
    htp.p('     <td class="tdh" colspan="2" style="width:15%;"> Status </td>');
    htp.p('  </tr>');

    v_dummy := 0;

   for ca10 in c10(v_id) loop
     v_dummy := v_dummy +1;
   --  htp.p ('  <tr>');
     v_timed_format:='';
     if trunc (ca10.action_date) > trunc(sysdate)-7 then
        v_timed_format := v_today_td7;
        v_td_string :=  '    <td onmouseover="tr'||v_dummy
         ||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy
         ||'.style.backgroundColor=tdlistactionDate'||7||'_'||mod(v_dummy,2)
         ||'.style.backgroundColor;" '
                 ||' >';
     end if;
     if trunc (ca10.action_date) > trunc(sysdate)-4 then
        v_timed_format := v_today_td4;
        v_td_string :=  '    <td onmouseover="tr'||v_dummy
         ||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy
         ||'.style.backgroundColor=tdlistactionDate'||4||'_'||mod(v_dummy,2)
         ||'.style.backgroundColor;" '
                 ||' >';
     end if;
    if trunc (ca10.action_date) = trunc(sysdate) then
        v_timed_format := v_today_td;
        v_td_string :=  '    <td onmouseover="tr'||v_dummy
         ||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy
         ||'.style.backgroundColor=tdlistactionDate'||1||'_'||mod(v_dummy,2)
         ||'.style.backgroundColor;" '
                 ||' >';
    end if;

    if instr(v_timed_format,'#',1) > 0 then
      htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" style="background-color:'
         ||dbfun$mod_color( v_timed_format ,mod(v_dummy,2)*10)
         ||';" id="tr'||v_dummy||'">');
    else
       v_td_string :=  '    <td onmouseover="tr'||v_dummy
         ||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy||'.style.backgroundColor=tdlist'
         ||mod(v_dummy,2)||'.style.backgroundColor;" '
                 ||' >';
      htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" id="tr'||v_dummy||'">');-- class="tdlist'||mod(v_dummy,2)||'" onmouseover="this.style.backgroundColor=''#FFFF00'';" onmouseout="this.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;">');
    end if;


        v_link := '<a href="po_projektfrage_details?p_id='||ca10.id||'">';

    htp.p (v_td_string||v_link||to_char(ca10.action_date,'DD.MM.YY Hh24:MI')||'</a></td>');

      htp.p (v_td_string||v_link
               ||'<img src="/i/projekt/'||dbfun$default_gui||'/img/dashboard.gif" Alt="Frage" Border="No">');
      htp.p (ca10.subject||'</a></td>');
      htp.p (v_td_string||v_link  ||nvl(ca10.rx,nbsp)||'</a></td>');
      htp.p (v_td_string
              ||v_link  ||nvl(ca10.tx,nbsp)||'</a></td>');
      htp.p( v_td_string
              ||v_link
              ||'<img src="/i/projekt/'||dbfun$default_gui||'/img/details.png" border="no"></a></td>');

       htp.p ('</tr>');
   end loop;

   htp.p ('</table>');
   htp.p ('</div>');
  end if;

 else -- v-modus =0

  htp.p (' <HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;


 htp.p(' </body>');
 htp.p('</html>');
exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PO_PROJEKT_FRAGEN_LIST         TO PROJ_RO;

GRANT EXECUTE      ON PO_PROJEKT_FRAGEN_LIST         TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PO_PROJEKTBETEILIGUNG_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE po_projektbeteiligung_list

 (  p_fk_firma_id                in Number    default null -- Filter auf die Firma
  , p_order1                     in Varchar2  default null
  , p_order2                     in Varchar2  default null
  , p_debug                      in Varchar2  default null
  , p_netzplan                   in varchar2  default null -- Switch, so dass die Liste grafisch ausgegeben wird
  , p_report                     in varchar2  default null
  , x                            in Number    default null -- Dummy
  , y                            in Number    default null -- Dummy
  )

as
--[VERS:2008-07-24]

-- Ziel:
-- Generiert Liste der Projektphasen

-- noch offen:
-- - kritische Projektphasen hervorheben  (Status, oder aus dem Rahmen gelaufen)
-- - grafische Darstellung als Netzplan (Interaktiv ber DHTML ...)
-- - Links zu den Ansprechpartnern


-- Autor: Erich Heinemann
-- Kln

 -- Suche aller passenden Projekte
 -- dynamisches SQL
  sql_string1       Varchar2(4000);
  TYPE r_cur_t1     IS REF Cursor;
  r_cur1            r_cur_t1;

  v_po Boolean := true; -- ist nur als Portlet verfgbar

 -- DBMS_SQL
  cursor c1
   is
  select
    id
  , phasen_name
  , projekt_abschnitt
  , startdatum
  , enddatum
  , aktueller_status
  , letzte_bearbeitung
  , bearbeitung_durch
  , nvl(farbe,'#f0f0a0') farbe
  , fk_projekt_id
  , dbfun$get_projekt_name (fk_projekt_id) projekt
  from proj_projektphase
   where fk_projekt_id = 1 --l_fk_projekt_id
   order by nvl(startdatum,letzte_bearbeitung)
  ;
  -- dynamic-SQL

  ca1                c1%rowtype;

/* -- Vorladen der verschiedenen Farben fr die HTML-DIVs
 cursor c2 is
 select w.kurztext, w.langtext
   from xdb_werte  w
      , xdb_wertebereiche wb
  where wb.id   =  w.wb_id
    and wb.name =  'projekt_status_farbe'
  ;
*/

  -- Zugriffsverwaltung
  v_modus            Number(1);
  v_module_name      Varchar2(30) := 'PO_PROJEKTBETEILIGUNG_LIST';

  -- Formatierung
  kund               varchar2(2)  := chr(38);
--  v_severity_str     Varchar2(255);

  -- spezifische Parameter zur Darstellung als Netzplan
  v_min_datum        Date;     -- kleinstes Datum aus den Projektphasen
  v_max_datum        Date;     -- maximales Datum aus den Projektphasen
  v_faktor           Number(10); -- Faktor, um den Netzplan optimal darzustellen (1024 Pixel maximal = 1000 Tage...)
  v_start            Number(10); -- Anzahl von Pixeln vom ersten Termin um eine Phase als Netzplan anzuzeigen
  v_days             Number(10); -- Anzahl von Pixeln um eine Phase als Netzplan anzuzeigen
  v_erster_monat     Date;
  v_monat            Date;
  v_netzplan         Varchar2(20) := nvl(p_netzplan,'j');  -- Bei Bedarf ndern !!!   j/n
  v_popup            Varchar2(4000); -- Text fr Popup-Meldungen

  v_top              Number(10) :=0;   -- Platzhalter, um die Objekte richtig zu positionieren
  v_height           Number(10) := 60; -- bei der Ausgabe als Report
                                        -- mssen alle mglichen Zeilen ausgegeben werden, so dass es
                                        -- je Phase n*v_height  sein knnen!!! (Zeilen=n)

  -- Fr die Suchfunktionen
  v_such_projekt_id  Varchar2(255); -- :=  '%'||substr(p_such_projekt_nr,1,20)||'%';
  v_dummy            Number(10)     :=1;

  v_order_form       Varchar2(4000);
  v_order1           Varchar2(200);
  v_order2           Varchar2(200);
  v_link             Varchar2(400);
  v_td_string        Varchar2(2000);



  v_error            Varchar2(800);
  defaultgui         Varchar2(400) := dbfun$default_gui;
  defaultlang        Varchar2(400) := dbfun$default_lang;
  dateformat         Varchar2(40)  := ('DD.MM.YYYY'); -- hier nur Tagesdatum


BEGIN

 begin


  v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

  if p_report != null and p_netzplan='j' then
   v_height := 5 * v_height; --- mehr Daten je Phase!
  end if;

  if v_modus > 0 then

   begin
   select min (startdatum), max (nvl(enddatum,startdatum)) into v_min_datum, v_max_datum
    from proj_projektphase
     where fk_projekt_id is not null
       and fk_firma = p_fk_firma_id
       and ( nvl(startdatum,sysdate-200) between sysdate-30 and sysdate+130
             or nvl(enddatum,sysdate-200)   between sysdate-30 and sysdate+130
           )

       ;

     v_faktor := dbfun$days_between (v_min_datum, v_max_datum);

     if v_faktor > 500 then  -- Projekt erstreckt sich ber 1.5 Jahre
      v_faktor:= 1;
     elsif v_faktor > 300 then -- Projekt erstreckt sich ber 1 Jahr
      v_faktor :=2;
     elsif v_faktor > 200 then  -- Projekt erstreckt sich ber 3/4 Jahr
      v_faktor :=3;
     elsif v_faktor > 100 then  -- Projekt erstreckt sich ber 3 Monate
      v_faktor :=4;
     elsif v_faktor <=100 then
      v_faktor :=8;
     end if;

   exception when others then
      v_faktor :=1;
      v_min_datum := sysdate;
      v_max_datum := sysdate+60;

    -- noch keine Startdatums vorhanden
   end;


   v_order_form := '<form  action="'||lower(v_module_name)||'" method="post" style="white-space:nowrap">';

   if p_fk_firma_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_fk_firma_id" value="'||p_fk_firma_id||'"/>';
   end if;



/*
   if p_kontakt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_kontakt_id" value="'||p_kontakt_id||'"/>';
   end if;


   if p_such_projekt_name is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_projekt" value="'||p_such_projekt_name||'"/>';
   end if;

   if p_such_projekt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_projekt_id" value="'||p_such_projekt_id||'"/>';
   end if;

    if p_such_status is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_status" value="'||p_such_status||'"/>';
   end if;
*/

 -- Alte Sortierung nach hinten schieben !!
 -- Dieser Parameter hilft, dass die vorletzte Sortierung nicht ganz verloren geht.
 -- Erst die dritte Auswahl einer Sortierreihenfolge lscht die vorletzte!
   if p_order1 is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_order2" value="'||p_order1||'"/>';
   end if;

-- Suche auch nach abgeschlossenen Bauprojekten
/*   if p_nur_offen <> 1 then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_only_open" value="0"/>';
   end if;
*/

  sql_string1 := 'select * from( '||chr(10)
 ||' select   id          '||chr(10)
 ||' , phasen_name       '||chr(10)
 ||' , projekt_abschnitt  '||chr(10)
 ||' , startdatum         '||chr(10)
 ||' , enddatum           '||chr(10)
 ||' , aktueller_status   '||chr(10)
 ||' , letzte_bearbeitung '||chr(10)
 ||' , bearbeitung_durch  '||chr(10)
 ||' , nvl(farbe,''#f0f0a0'') farbe   '||chr(10)
 ||' , fk_projekt_id                  '||chr(10)
 ||' , dbfun$get_projekt_name (fk_projekt_id) projekt '||chr(10)
 ||' from proj_projektphase '||chr(10) ;

 sql_string1 := sql_string1
   || ' where fk_firma is not null and fk_firma = '||p_fk_firma_id ||' '||chr(10);


/* if p_kontakt_id is not null then
   sql_string1 := sql_string1 ||' and ' || p_kontakt_id||'  = p.fk_bauherr ';
 end if;
*/
 -- ??? muss erweitert werden, da in einem Projekt und Phasen zustzliche Personen involviert werden knnen

/*
 if p_such_projekt_id is not null then
   sql_string1 := sql_string1 ||' and (p.projekt_id like ''%'||p_such_projekt_id ||'%''';
   sql_string1 := sql_string1 ||' or p.id||'''' like ''%'||p_such_projekt_id ||'%'')';
  else
   if p_nur_offen = 1  then  -- Wenn nicht abgeschlossene (4) Projekte gesucht werden!
     sql_string1 := sql_string1 ||' and p.fk_projekt_status not in (4)'||chr(10);
   end if;
 end if;

  if p_such_status is not null then
   sql_string1 := sql_string1 ||' and upper(dbfun$get_werte(''projekt_status'',p.fk_projekt_status)) like ''%'||upper(p_such_status)||'%'' ';
  end if;

  if p_such_bauherr is not null then
   sql_string1 := sql_string1 ||' and (upper(nachname) like ''%'||upper(p_such_bauherr)||'%'' or  ';
   sql_string1 := sql_string1 ||'      upper(stadt) like ''%'||upper(p_such_bauherr)||'%'' )  ';

  end if;


  if p_such_projekt_id is not null then
   sql_string1 := sql_string1 ||' and ( p.projekt_id      like ''%'||p_such_projekt_id ||'%'' ';
   sql_string1 := sql_string1 ||'   or  upper(nachname) like ''%'||upper(p_such_projekt_id )||'%'' ) ';
  end if;

  -- Suchfeld fr das Status-Bemerkungsfeld
  if p_such_status_info is not null then
   sql_string1 := sql_string1 ||' and upper(p.aktueller_status) like ''%'||upper(p_such_status_info)||'%'' ';
  end if;

  if p_such_projekt_name is not null then
   sql_string1 := sql_string1 ||' and ( upper(p.projekt_name) like ''%'||upper(p_such_projekt_name) ||'%'')' ||chr(10);
  end if;

 -- hier noch ein Block, womit eine Volltextsuche ber alle Felder gestartet wird
  if p_such_projekt is not null then
   sql_string1 := sql_string1 ||' and ( upper(p.projekt_name) like ''%'||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(p.aktueller_status) like ''%'  ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(k.plz) like ''%'        ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(k.stadt) like ''%'      ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'     )' ||chr(10);
 end if;

*/

 -- Ende des Subselect einfgen
 sql_string1 := sql_string1 ||') x ';
-- .. sicher, so ein dynamisches SQL bietet nicht die beste Performance, ist aber irgendwie im Sourcecode nachvollziehbar.
-- Besser wre es, dieses Statement ber Bind-Variablen zu bauen. ... beim nchsten mal. :-)


 -- ORDER-BY einfgen
  if p_order1 is not null then
   sql_string1 := sql_string1 ||' order by '||dbfun$get_werte('PROJEKTPHASEN_LIST_ORDER',p_order1);
   if p_order2 is not null then
     sql_string1 := sql_string1 ||' , '||dbfun$get_werte('PROJEKTPHASEN_LIST_ORDER',p_order2);
   end if;
  else -- Sortierung nach Startdatum letzter nderung desc
     sql_string1 := sql_string1 ||'    order by nvl(startdatum,letzte_bearbeitung)';
  end if;

   -- HTTP-Session ffen
    htp.p('<HTML>');
    htp.p('<head>');
    htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
    htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

   -- Include fr HTML-Header
    If v_po = false then
      htp.p(dbfun$projtoolbar2js);
    end if;

   -- Include fr POPUP-JS
    htp.p(' <script type="text/javascript" src="/i/projekt/js/popup.js"></script>');

   if v_netzplan='j' then
   -- Include fr die freie Library von Walter Zorn
    htp.p ('<script type="text/javascript"  src="/i/projekt/js/wz_jsgraphics.js"></script>');
 /*
    htp.p ('<script type="text/javascript">');
    htp.p ('function getObj(name)');
    htp.p ('{');
    htp.p ('  if (document.getElementById)');
    htp.p ('  {');
    htp.p ('    this.obj = document.getElementById(name);');
    htp.p ('    this.style = document.getElementById(name).style;');
    htp.p ('    this.width = document.getElementById(name).width;');
    htp.p ('    this.height = document.getElementById(name).height;');
    htp.p ('    this.zIndex = document.getElementById(name).zIndex;');
    htp.p ('  }');
    htp.p ('  else if (document.all)');
    htp.p ('  {');
    htp.p ('    this.obj = document.all[name];');
    htp.p ('    this.style = document.all[name].style;');
    htp.p ('    this.width = document.all[name].width;');
    htp.p ('    this.height = document.all[name].height;');
    htp.p ('    this.zIndex = document.all[name].zIndex;');
    htp.p ('  }');
    htp.p ('  else if (document.layers)');
    htp.p ('  {');
    htp.p ('    this.obj = document.layers[name];');
    htp.p ('    this.style = document.layers[name];');
    htp.p ('    this.width = document.layers[width];');
    htp.p ('    this.height = document.layers[height];');
    htp.p ('    this.zIndex = document.layers[zIndex];');
    htp.p ('  }');
    htp.p ('}');
    htp.p ('</script>');
    */

  end if;


    htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||dbfun$default_gui||'/css/default.css'' type=''text/css''>');
    htp.p('<title>Projekte | Projektbeteiligung </title>');
    htp.p('</head>');
    htp.p('<BODY>');

    If v_po = false then
     htp.p (dbfun$projtoolbar(upper(v_module_name)
                                   , v_modus
                                   , null --dbpck$main.fun$get_akt_benutzer
                                )
           );

     end if;

     -- Hidden DIV fr Popups
     htp.p ('  <DIV id="popup" class="popuptable" style="POSITION: absolute; VISIBILITY: hidden; Z-INDEX: 1"></DIV>');

 --   if p_such_projekt_id is null and  p_such_projekt is null then
    --  htp.p('<div class="maintitle">Projektphasen zum Projekt '||'<i>'
     -- || dbfun$get_projekt_name(p_fk_projekt_id)
      --||'<a href="proj_projekt_details?p_id='||p_fk_projekt_id||'" border="NO">'
     -- ||'<img src="../../projekt/'||dbfun$default_gui||'/img/tool/details.png" ALT="Details" BORDER=NO></a>'
     -- ||'</i>');

      htp.p('<div id="buttons"  style="POSITION: absolute; VISIBILITY: visible; Z-INDEX: 1;">');
    --  if v_modus > 2 then
    --  --  htp.p ('<a href="proj_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id||'" target="_blank"> Neue Phase einfgen </a>');
    --    htp.p(dbfun$html_button ('po_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id,'<img src="/i/projekt/default/img/add_new_abc.png">'||dbfun$i18(defaultlang,'Neue Phase einfgen')));
    --  end if;

      if v_netzplan  = 'n' then
        htp.p(dbfun$html_button (v_module_name||'?p_fk_firma_id='||p_fk_firma_id||kund||'p_netzplan=j','<img src="/i/projekt/default/img/liste_netz.png">Als Netzplan'));
        htp.p(dbfun$html_button (v_module_name||'?p_fk_firma_id='||p_fk_firma_id||kund||'p_netzplan=n','<img src="/i/projekt/default/img/reload.png">Neu Laden'));
      else
    --    htp.p('<a href="'||v_module_name||'?p_fk_projekt_id='||p_fk_projekt_id||kund||'p_netzplan=n">Als Liste</a>');
        htp.p(dbfun$html_button (v_module_name||'?p_fk_firma_id='||p_fk_firma_id||kund||'p_netzplan=n','<img src="/i/projekt/default/img/liste_bunt.png">Als Liste'));
        htp.p(dbfun$html_button (v_module_name||'?p_fk_firma_id='||p_fk_firma_id||kund||'p_netzplan=j','<img src="/i/projekt/default/img/reload.png">Neu Laden'));
      end if;



      htp.p('</div>');


     -- DIV fr die Linien im Netzplan
     htp.p ('<div id="myCanvas" style="position:absolute;top:0px;left:0px;width:98%;height:98%;clear:both;"></div>');

     htp.p ('<script type="text/javascript"> ');
     htp.p ('<!--');
     htp.p ('var jg = new jsGraphics("myCanvas");');
     htp.p ('//-->');
     htp.p ('</script>');


 -- die 2 anchfolgenden DIVS werden versteckt um die Styles fr das Highlighting beim Hover-Effekt zu steuern
   htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">x</div>');
   htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">x</div>');

  htp.p(' <table class="listtable" style="width:98%;position:absolute;top:36px;">');

    -- Header-Zeile aufbauen

   if v_netzplan ='n' then
    htp.p('  <tr>');

    htp.p('  <td class="tdh" style="border-bottom-width:1px;width:20%;">');
    htp.p('      '||v_order_form ||'<input type="hidden"  name="p_order1" value="1"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Phase" title="Sortierung nach Phase" Border="NO">');
    htp.p('      Name</form>');
    htp.p('  </td>');

    htp.p('  <td class="tdh" style="border-bottom-width:1px;width:20%;">');
    htp.p('      '||v_order_form ||'<input type="hidden"  name="p_order1" value="1"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Phase" title="Sortierung nach Phase" Border="NO">');
    htp.p('      Phase</form>');
    htp.p('  </td>');


    htp.p('  <td class="tdh"  style="border-bottom-width:1px;width:20%;" >');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="2"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sortierung nach Projektabschnitt" title="Sortierung nach Projektabschnitt" Border="NO">');
    htp.p('     Projektabschnitt</form>');
    htp.p('  </td>');

    htp.p('  <td class="tdh" style="border-bottom-width:1px;width:10%;" >');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="3"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sortierung nach Startdatum" title="Sortierung nach Startdatum" Border="NO">');
    htp.p('     Startdatum</form>');
    htp.p('  </td>');

    htp.p('  <td  class="tdh"  style="border-bottom-width:1px;width:10%;">');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="4"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sorierung nach Enddatum" title="Sorierung nach Enddatum" Border="NO">');
    htp.p('     Enddatum</form>');
    htp.p('  </td>');

    htp.p('  <td class="tdh"  style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="5"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Status" title="Sortierung nach Status" Border="NO">');
    htp.p('      Status</form>');
    htp.p('    </td>');

    htp.p('  <td class="tdh" colspan="2" style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="6"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Bearbeitung" title="Sortierung nach Bearbeitung" Border="NO">');
    htp.p('      Bearbeitung</form>');
    htp.p('    </td>');


    htp.p('</tr>');
  end if;


  /*
   htp.p('<tr>');
   -- Filter-Zeile fr neue Suche einfgen!!
   -- Suchfelder zusammenbauen

   htp.p(' <form  action="'||lower(v_module_name)||'" method="get" style="white-space:nowrap">');
   htp.p('   <TD class="tdheader">');
   htp.p(     ' <input name="p_such_status" type="text" size=5 maxlength=400 value="'
     || p_such_status ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_bauherr" type="text" size=16 maxlength=400 value="'
     || p_such_bauherr ||'">Bauherr</td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_id" type="text" size=16 maxlength=20 value="'
     || p_such_projekt_id ||'">Projekt-ID</td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_startdatum" type="text" size=19 maxlength=10 value="'
     || p_such_startdatum  ||'">startdatum</td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_letzte_Bearbeitung" type="text" size=10 maxlength=10 value="'
     || p_such_letzte_Bearbeitung ||'"></td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_name" type="text" size=38 maxlength=400 value="'
     || p_such_projekt_name ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_status_info" type="text" size=18 maxlength=400 value="'
     || p_such_status_info ||'"></td>');

   htp.p('    <td class="tdheader" >'
         ||'<input type="image" src="../../projekt/'||dbfun$default_gui||'/img/tool/such.png" ');
   htp.p('     alt="Suchen" title="Suchen" Border="NO">');
   htp.p('   </td>');

   htp.p('   </form>');
   htp.p('   </tr>');

   -------------------------------------

   if  p_such_projekt_id is not null then
      v_such_projekt_id :=  '%'||substr(p_such_projekt_id,1,20)||'%';
   end if;
  */


  v_dummy := 1;

  -- Monate oder Tage einblenden
  if v_min_datum is not null and v_netzplan='j' then
   v_erster_monat := add_months(last_day(v_min_datum)+1,-1); -- erster Tag im ersten Monat!!
   v_monat        := v_erster_monat; -- := add_months(last_day(v_min_datum)+1,-1); -- erster Tag im ersten Monat!!
     htp.p('   <tr>');
     htp.p('    <td colspan="7">');
     htp.p('    <div id="aussen" class="tdv" style="position:relative;top:0px;width:100%;height:20px;visibility:visible;">');
     while  v_monat < v_max_datum
      loop
       v_start := DBFUN$DAYS_BETWEEN ( v_erster_monat, v_monat );
       v_days  := DBFUN$DAYS_BETWEEN  ( v_monat ,last_day(v_monat)) -2;
       htp.p('    <div class="td" style="position:absolute;top:0px;left:'||(v_start*v_faktor)
        ||'px;width:'||(v_days*v_faktor)||'px;">');
       htp.p('      |'||to_char(v_monat,'Mon/YY') );
       htp.p('    </div>');
        if v_faktor = 1 then
          v_monat := add_months( v_monat ,2) ;
        elsif v_faktor > 1 then
          v_monat := add_months( v_monat ,1) ;
        --end if;

       end if;

       end loop;
       htp.p('    </div>');
      htp.p('    </td>');
      htp.p('   </tr>');
  end if;


  -- SQL-Statement ausfhren
  open r_cur1 for sql_string1;
  loop
  fetch r_cur1 into ca1;
   exit when r_cur1%notfound;

   -- Der Style wird in der Liste zwischen den Datenstzen und dem Status des Projektes jeweils umgeschaltet
   -- Daher wird der Link vorher definiert und der Rohbau einer Tabellenzelle (<TD>) vorab je Zeile definiert

   if substr(v_module_name,1,3) != 'PO_' then
     v_link :=   '<a href="proj_projekt_details?p_id='||ca1.fk_projekt_id||'" target="_top">';
   else
     v_link :=   '<a href="proj_projekt_details?p_id='||ca1.fk_projekt_id||'" target="_top">';
   end if;

   v_dummy :=  v_dummy +1;

   if v_dummy < 3050 then
    if v_netzplan = 'n' then

       v_td_string :=  '    <td onmouseover="tr'||v_dummy||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'
       ||v_dummy||'.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;" '
                 ||' >';
    htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" id="tr'||v_dummy||'" style="text-valign: center;">');
  --  end if;

   -- Spalte fr den Status
 --  htp.p ( v_td_string
 --     ||v_link||dbfun$projekt_status_img(ca1.fk_projekt_status)||'</a></td>');

   -- Spalte fr Phasen_Name
   if ca1.phasen_name != 'PHASE' then
       htp.p ( v_td_string ||'<b>' || v_link||ca1.projekt       ||'</b></a>'||'</td>');
       htp.p ( v_td_string ||'<b>' || v_link||ca1.phasen_name   ||'</b></a>'||'</td>');
   else
       -- Beteiligte Personen aufzhlen und als Phasen-Name anzeigen z.B. "Tiefbau Mller GmbH"
       htp.p ( v_td_string ||'<i>' || v_link||ca1.projekt       ||'</i></a>'||'</td>');
       htp.p ( v_td_string ||'<i>' || v_link||ca1.phasen_name   ||'</i></a>'||'</td>');
   end if;

   -- Spalte fr Phasen_Name
   htp.p ( v_td_string ||v_link||ca1.Projekt_Abschnitt   ||'</a>'||'</td>');


   -- Spalte fr Startdatum
   htp.p( v_td_string ||v_link||'<b>'||to_char(ca1.startdatum,dateformat)||'</b>'
     ||'</a></td>');

   -- Spalte fr das Enddatum
   htp.p (v_td_string ||v_link   ||to_char(ca1.enddatum,dateformat)||'<br>'
     ||'</a></td>');

   -- Spalte "Aktueller_Status"
   htp.p (v_td_string
     ||v_link
     ||ca1.aktueller_Status
     ||'</a></td>');


   -- Spalte "Letzte Bearbeitung"
   htp.p (v_td_string
     ||v_link
     ||to_char(ca1.letzte_bearbeitung,'DD.MM.YYYY Hh24:MI') ||' / '|| ca1.bearbeitung_durch
     ||'</a></td>');


   htp.p( v_td_string
   ||v_link
   ||'<img src="/i/projekt/'||dbfun$default_gui||'/img/details.png" BORDER=NO></A></TD>');
   htp.p('   </tr>');
 end if;
 --  Ende der Listendarstellung,
 -- ab hier wirds interessanter!

 -- Netzplan grafisch darstellen
 if  ca1.startdatum is not null and v_netzplan = 'j' then
     v_top   := v_top +18;
     v_start := DBFUN$DAYS_BETWEEN ( v_erster_monat, nvl(ca1.startdatum,ca1.letzte_Bearbeitung) );
     v_days  := DBFUN$DAYS_BETWEEN  ( nvl(ca1.startdatum,ca1.letzte_Bearbeitung) , nvl(ca1.enddatum, ca1.startdatum)) +1;
     htp.p('   <tr>');
     htp.p('    <td colspan="7">');
    -- IE-Workaround, erstmal das Hintergrund-DIV malen  class="tdv"
--     htp.p('    <div id="iediv'|| ca1.id ||'"  style="position:relative;left:'||(v_start*v_faktor)
     htp.p('    <div id="iediv'|| ca1.id ||'"  style="position:relative;left:'||(v_start*v_faktor)
     ||'px;width:'|| ((v_days*v_faktor)) ||'px;height:'||v_height||'px;' -- keine Ahnung, warum 5 abgezogen werden mssen??
     ||'background-color:'||ca1.farbe||'; layer-background-color:'||ca1.farbe||'; visibility: visible;">'
     );

     htp.p ('<script type="text/javascript"> ');
     htp.p ('<!--');
     -- In der Farbe der Phase (Leistung)
     htp.p ('  jg.setColor("'||ca1.farbe||'");'); -- rot
 --    htp.p ('  var od   = new getObj(''iediv'|| ca1.id||''');');
     htp.p ('  var y_offset = 64 ;'); -- die 64 habe ich einfach ausprobiert!!
     htp.p ('  var y        = '||v_top||' + y_offset ;'); -- den Offset habe ich einfach ausprobiert!!
--     htp.p ('  var y    = parseInt(od.offsetHeight) + y_offset ;'); -- den Offset habe ich einfach ausprobiert!!
--     htp.p ('      y    = parseInt(od.style.top) + y_offset ;'); -- den Offset habe ich einfach ausprobiert!!

--     htp.p ('  alert(y + " TEST");');--    = parseInt(od.offsetHeight) + y_offset ;'); -- den Offset habe ich einfach ausprobiert!!
     htp.p ('  jg.drawLine('||(v_start*v_faktor)||', y , '||(v_start*v_faktor)||', y_offset );'); -- Koordinaten auf Zeichenflche bezogen
--     htp.p ('  jg.setColor("'||ca1.farbe||'");'); -- rot
     htp.p ('  jg.drawLine('||((v_start+v_days)*v_faktor)||', y, '||((v_start+v_days)*v_faktor)||', y_offset);'); -- Koordinaten auf Zeichenflche bezogen
--     htp.p ('jg.setColor("#0000ff");'); -- blau
--     htp.p ('jg.fillRect(110, 120, 30, 60);');
     htp.p ('  jg.paint();');
     htp.p ('//-->');
     htp.p ('</script>');

     --  Nun das DIV mit der Beschriftung einbinden
     -- Fr reine Firefox-Umgebungen kann man hier ein DIV weg lassen
     htp.p('    <div id="mozdiv'||ca1.id||'" class="tdx" style="position:absolute;left:0px;top:0px;height:'||v_height||'px;"');

    -------------------------------------------
       htp.p ('    onMouseOut=''hidePopup()''    ');
      v_popup := '<table class="popuptable">';
      v_popup := v_popup || '<td class=\"popup_header\" colspan="2">'||ca1.phasen_name||'</td></tr>';
     --  Startdatum
      v_popup := v_popup || '<td class=\"popup_label\">Start:</td><td class=\"popup_val\">'
       ||to_char(ca1.startdatum,'Dy '||dateformat)||'</td></tr>';
     --  Enddatum
     v_popup := v_popup || '<td class=\"popup_label\">Enddatum:</td><td class=\"popup_val\">'
       ||to_char(ca1.enddatum,'Dy '||dateformat)||'</td></tr>';
     -- Spalte "Aktueller_Status"
     if ca1.aktueller_Status is not null then
      v_popup := v_popup || '<td class=\"popup_label\">Aktuell:</td><td class=\"popup_val\">'
       ||ca1.aktueller_Status||'</td></tr>';
     end if;


    -- Bereinigung der Daten, so dass alle Sonderzeichen rausfallen
    v_popup := replace(replace(v_popup,'(',''),')','');
    v_popup := replace(replace(v_popup,'"',''),'''','');
    htp.p ('    onMouseOver=''showPopup("'||v_popup||'",event)''    ></a>');
    -------------------------------------------

     -- Phasen_Name
     htp.p ( v_link||'<span style="white-space:nowrap; "> '||ca1.projekt||'('||ca1.phasen_name||')</span>');
     htp.p ( v_link||'<span style="white-space:nowrap; "> Start:'||to_char(ca1.startdatum,'Dy '||dateformat)||')</span>');
     if ca1.enddatum is not null then
      htp.p ( v_link||'<span style="white-space:nowrap; "> Ende:'||to_char(ca1.enddatum,'Dy '||dateformat)||')</span>');
     end if;

     htp.p('</a>');
  /* -- GUI ist beim IE nicht praktikabel

     if v_faktor > 2 then
      --  Startdatum
      htp.p(' '||to_char(ca1.startdatum,dateformat)||' ');
     end if;

     if v_faktor > 3 then
      --  Enddatum
      htp.p (to_char(ca1.enddatum,dateformat));
     end if;

      -- Spalte "Aktueller_Status"
     if ca1.aktueller_Status is not null and v_faktor > 1 then
       htp.p (' ('||ca1.aktueller_Status||')');
     end if;
  */
     htp.p('      </div>');
     htp.p('     </div>');
 --    htp.p('    </td>');
--     htp.p('   </tr>');
 end if;



   else -- v_dummy <150
    htp.p('   <tr>');
    htp.p('     <td colspan="9"> Zu viele Datenstze!!! Abgeschnitten ab Nr.'||v_dummy||'! </td>');
    htp.p('   </tr>');
   end if; -- v_dummy <150

   end loop;
    CLOSE r_cur1;

   htp.p('   </table>');

 else -- v-modus =0
    htp.p ('  <html><body><h1> no Accesss with Your Account ! </h1><br>');
 end if;


 htp.p('  </body>' );
 htp.p(' </html>' );

end;
 exception when others
 then

    htp.p('<div style="position:absolute; top:100px;">');
    htp.p ('SQL-Error '||sqlerrm ||' / '|| sqlcode );

  --  if v_modus != null and v_modus > 2 then
      htp.p ('<br>'||chr(10)||sql_string1);
      htp.p ('</div>');
  --  end if;

end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PO_PROJEKTBETEILIGUNG_LIST     TO PROJ_RO;

GRANT EXECUTE      ON PO_PROJEKTBETEILIGUNG_LIST     TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PO_PROJEKTFRAGE_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE po_projektfrage_details
(
     p_id                   in Number    default NULL
   , p_fk_projekt_id        in Number    default NULL
   , p_subject              in Varchar2  default NULL  --  400
   , p_subject_rx           in Varchar2  default NULL  -- 2000
   , p_subject_tx           in Varchar2  default NULL  -- 2000
   , p_action_date          in varchar2  default NULL
   , p_external_reference   in Varchar2  default NULL   -- 2000
   , p_zugewiesen_an        in Varchar2  default NULL   -- 80 -- Bearbeiter!
   , p_Status               in Varchar2  default NULL   -- Number, aus Werteliste (warte auf Kunde, in Bearbeitung, unbearbeitert, abgeschlossen, warte auf Subunternehmer)
   , p_do_update            in varchar2  default ''
   , p_do_delete            in Varchar2  default ''
   , p_do_insert            in Varchar2  default ''

   , x                      in Number    default null -- dummy
   , y                      in Number    default null -- dummy
) as

  --[VERS:2008-07-21]


-- lokale Variablen:
   v_id                     proj_projektfrage.id%type;
   v_fk_projekt_id          proj_projektfrage.fk_projekt_id%type := p_fk_projekt_id;
   v_subject                proj_projektfrage.subject%type;
   v_subject_rx             proj_projektfrage.subject_rx%type;
   v_subject_tx             proj_projektfrage.subject_tx%type;
   v_action_date            proj_projektfrage.action_date%type;
--   p_action_date            proj_projektfrage.action_date%type;
   v_zugewiesen_an          proj_projektfrage.zugewiesen_an%type;
   v_external_reference     proj_projektfrage.external_reference%type;
   v_letzte_bearbeitung     proj_projektfrage.letzte_bearbeitung%type;
   v_bearbeitung_durch      proj_projektfrage.bearbeitung_durch%type;
   v_status                 proj_projektfrage.status%type;

   v_modus                  Number(1);
   v_module_name            Varchar2(30) := 'PO_PROJEKTFRAGE_DETAILS';

   v_error                  Varchar2(800);
   defaultgui               Varchar2(400) := dbfun$default_gui;
   defaultlang              Varchar2(400) := dbfun$default_lang;
   dateformat               Varchar2(40)  := ('DD.MM.YYYY'); -- hier nur Tagesdatum
   kund                     Varchar2(1):= chr(38);

   v_time1                  Number(10);  -- start
   v_time2                  Number(10);  -- vor Update oder Insert
   v_time3                  Number(10);  -- nach Update oder Insert
   v_time4                  Number(10);  -- nach Re-Fetch
   v_time5                  Number(10);  -- nach Re-Fetch


 -- Datumsfunktion
   v_new_date               date;

 -- Nchste Ticket-Action
 -- Vorherige Frage, nachfolgende Frage, so dass man durchsteppen kann!
    v_id_prev               proj_projektfrage.id%type;
    v_id_next               proj_projektfrage.id%type;


 BEGIN

  -- Modus ermitteln
  v_modus := dbpck$main.fun$chk_module_allowed( v_module_name);

  if v_modus > 0 then
   -- Delete
   if p_id is not null
     and p_do_delete is not NULL
     and p_do_delete = 'delete'
     and v_modus > 2
      then
        v_id := p_id;
         --- Hier noch einen Parameter zuweisen, damit der Rcksprung funktioniert!
         v_fk_projekt_id := p_fk_projekt_id;
         delete proj_projektfrage
          where id = v_id;
         commit;
    end if; -- delete


   -- Allgemein
   -- wenn Update oder Insert durchgefhrt werden soll dann:
   -- Daten aus bergabeparaemtern bernehmen
  if (p_id is not null)
   or  (p_do_insert is not null and p_id is null)
   or  (p_do_update is not null)
    then
     -- Datensatz einfgen bzw. bernehmen
     v_time2             := dbms_utility.GET_TIME;
     v_id                :=  p_id ;
     v_fk_projekt_id     :=  p_fk_projekt_id ;
     v_subject           :=  nvl(substr(p_subject,1,400), nvl(substr(p_external_reference,1,400),substr(nvl(p_subject,'?'),1,400)));
     v_subject_rx        :=  substr(p_subject_rx,1,2000) ;
     v_subject_tx        :=  substr(p_subject_tx,1,2000) ;
     v_external_reference:=  substr(p_external_reference,1,2000) ;
     v_zugewiesen_an     :=  substr(p_zugewiesen_an,1,80) ;
    begin
     v_status            :=  to_number(p_status);
    exception when others then
     v_status:= 1; -- Initial
    end;

   end if;


 if p_do_insert is not null
  and v_modus > 1
   then

  --SEQUENCE !!!!!!
   select seq_projektfrage.nextval into v_id from dual;
   insert into proj_projektfrage
   (
        id
   ,    fk_projekt_id
   ,    subject
   ,    subject_rx
   ,    subject_tx
   ,    action_date
   ,    external_reference
   ,    letzte_bearbeitung
   ,    bearbeitung_durch
   ,    zugewiesen_an
   ,    status
   ) values (
        v_id
   ,    v_fk_projekt_id
   ,    nvl(v_subject, nvl(substr(v_external_reference,1,160),nvl(v_subject,'?')))   -- Anforderung von Dirk Bttcher
   ,    v_subject_rx
   ,    v_subject_tx
   ,    sysdate
   ,    v_external_reference
   ,    sysdate
   ,    user
   ,    v_zugewiesen_an
   ,    v_status
   );

   commit;
 end if; -- Insert ??


-- UPDATE
  if p_do_update is not null
   and p_id is not null
   and v_modus > 1
    then
     v_id := p_id;
    -- nur fr Notizen
     update proj_projektfrage
      set
        fk_projekt_id             =  v_fk_projekt_id
      , subject                  =
          nvl(substr(v_subject,1,200), nvl(substr(v_external_reference,1,160),nvl(v_subject,'?')))
     , subject_rx               =  v_subject_rx
     , subject_tx               =  v_subject_tx
     , external_reference       =  v_external_reference
     , letzte_bearbeitung       = sysdate
     , bearbeitung_durch        = user
     , zugewiesen_an            = v_zugewiesen_an
     , status                   = v_status
  where id   = v_id
     ;
   commit;
 end if; -- Update ??

  -- sonst nur entsprechend der ID den Datensatz ziehen
  if     (p_do_insert is NULL)
     and (p_do_delete is NULL)
     and  p_id is not null
  then
    v_id               := p_id;
   select
     fk_projekt_id
    , subject
    , subject_rx
    , subject_tx
    , action_date
    , external_reference
    , letzte_bearbeitung
    , bearbeitung_durch
    , zugewiesen_an
    , status
  into
      v_fk_projekt_id
    , v_subject
    , v_subject_rx
    , v_subject_tx
    , v_action_date
    , v_external_reference
    , v_letzte_bearbeitung
    , v_bearbeitung_durch
    , v_zugewiesen_an
    , v_status
    from proj_projektfrage
    where id = v_id;
 end if;


 if   v_fk_projekt_id   is not null
  and v_action_date is not null then
   -- prev-proj_Frage selektieren
   begin
    select max(id) into v_id_prev
     from proj_projektfrage a
     , (select max(action_date) action_date
        from proj_projektfrage
        where fk_projekt_id   = v_fk_projekt_id
          and action_date     <  v_action_date
          and id              <> v_id ) X
        where fk_projekt_id   = v_fk_projekt_id
          and x.action_date   = a.action_date
          and a.id            <> v_id ;

   exception when others
    then v_id_prev := null;
   end;


   -- next-projektfrage selektieren
   begin
    select min(id) into v_id_next
     from proj_projektfrage a
     , (select min(action_date) action_date
        from proj_projektfrage
        where fk_projekt_id     = v_fk_projekt_id
          and action_date       >  v_action_date
          and id                <> v_id ) X
        where fk_projekt_id     = v_fk_projekt_id
          and x.action_date     = a.action_date
          and a.id              <> v_id ;

   exception when others
    then v_id_next := null;
   end;
  end if; -- Prev / Next-Button


  htp.p('<HTML>');
  htp.p('<head>');

-- if v_id is not null
--  then
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p('<meta http-equiv="expires" content="0">');
  -- Include in den HTML-Header
  htp.p(dbfun$projtoolbar2js);

  htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||dbfun$default_gui||'/css/default.css'' type=''text/css''>');
  htp.p('<title></title>');
  htp.p('</head>');
  htp.p('<body>');
  htp.p('<div class="maintitle">Frage zum Projekt</div>');

  -- prev-Button einfgen
  if v_id_prev is not null then
   htp.p('<a href="'|| lower(v_module_name)||'?'
   ||'p_id='||v_id_prev||'"><img src="/i/projekt/'||dbfun$default_gui||'/img/prev.png" border="NO" title="vorherige Frage"></a>');
  end if;
  -- Zurckbutton zur Liste einfgen zur
  if v_fk_projekt_id is not null then
   htp.p('<a href="'||'po_projekt_fragen_list?'
      ||'p_id='||v_fk_projekt_id||'"><img src="/i/projekt/'||dbfun$default_gui||'/img/top.png" border="NO" '
      ||' title="zurck zur Liste der Fragen"></a>');
  end if;

  -- next-Button einfgen
  if v_id_next is not null then
   htp.p('<a href="'|| lower(v_module_name)||'?p_id='||v_id_next
      ||'"><img src="/i/projekt/'||dbfun$default_gui||'/img/next.png" border="NO" title="nchste Frage"></a>');
  end if;


  htp.p('<table class="formtable" width="99%">');
-- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method="post">');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type=hidden  name="p_id" value="'||v_id||'"/>');

  if p_do_delete = 'delete' and p_do_delete is not null then
    htp.p ('<tr><td  class="tdv" colspan="2"><b> is deleted </b></td></tr>');
   else -- nicht gelscht
    htp.p ('   <input name="p_fk_projekt_id" type="hidden" size="40" maxlength="22" value="'
     || v_fk_projekt_id||'"></td></tr>');
    htp.p ('<tr><td>');

   if v_id is not Null then
     htp.p('<span class="abc">Generiert: '||to_char(v_action_date,'DD.MM.YYYY HH24:MI') ||'  letzte nderung am: '|| to_char(v_letzte_bearbeitung,'DD.MM.YYYY HH24:MI')
     ||' / '||v_bearbeitung_durch||'');
     htp.p ('</span></td>');

     htp.p('<td align=right>');
     htp.p ('Status: <input name ="p_status" type="text" size=40 maxlength=10 value="'||v_status||'"/>');

     if v_modus > 1 then
       htp.p ('  <input type="submit" name ="p_do_update" value="'||dbfun$i18(defaultlang,'update')||'"/>');
     end if;
     if v_modus > 2 then
       htp.p ('  <input type="submit" name ="p_do_delete" value="'||dbfun$i18(defaultlang,'delete')||'"/>');
     end if;
   end if;

   if v_id is NULL
    and v_modus > 1 then
       htp.p ('  <input type="submit" name ="p_do_insert" value="'||dbfun$i18(defaultlang,'insert')||'">');
   end if;
   htp.p (' </td></tr>');

   htp.p (' <tr>');
   htp.p ('   <td colspan="2" class="tdh" align=left>Betreff</td>');
   htp.p (' </tr>');
   htp.p (' <tr>');
   htp.p ('   <td colspan="2" class="tdl" align=left>');
   htp.p ('      <textarea name="p_subject" cols="100" rows="2"  style="width:98%;">'
                || v_subject||'</textarea></td>');
   htp.p(' </tr>');
   htp.p (' <tr>');
   htp.p ('    <td colspan="2" class="tdh" align=left>Frage</td>');
   htp.p (' </tr>');
   htp.p (' <tr>');
   htp.p ('    <td colspan="2" class="tdl" align=left>');
   htp.p ('    <textarea name="p_subject_rx"  cols="100" rows="8" style="width:98%;">'
                  || v_subject_rx||'</textarea></td>');
   htp.p(' </tr>');

   htp.p (' <tr>');
   htp.p ('   <td colspan="2" class="tdh" align=left>Antwort</td>');
   htp.p (' </tr>');

   htp.p (' <tr>');
   htp.p ('   <td colspan="2" class="tdl" align=left>');
   htp.p ('     <textarea name="p_subject_tx"  cols="100" rows="8" style="width:98%;">'
               || v_subject_tx||'</textarea></td>');
   htp.p (' </tr>');


   htp.p (' <tr>');
   htp.p ('   <td colspan="2" class="tdh" align="left" valign="top">Interne Notiz</td>');
   htp.p (' </tr>');

   htp.p (' <tr>');
   htp.p ('   <td colspan="2" class="tdl" align="left" valign="top">');
   htp.p ('     <textarea name="p_external_reference"  cols="100" rows="5" style="width:98%;">'
      || v_external_reference||'</textarea></td>');
   htp.p (' </tr>');
  end if; -- do_delete
  htp.p ('  </form>');
  htp.p('</TABLE>');
 else -- v-modus =0
  htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;
 htp.p('</BODY>');
 htp.p('</HTML>');

 EXCEPTION
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);

END;
/


----------------------------------------------------------------
-- PROCEDURE PO_PROJEKTPHASE_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE PO_PROJEKTPHASE_DETAILS
(
     p_id                 in Number   default NULL
  ,  p_startdatum         in Varchar2 default NULL
  ,  p_enddatum           in Varchar2 default NULL
  ,  p_phasen_name        in Varchar2 default 'Phase'
  ,  p_projekt_abschnitt  in Varchar2 default NULL
  ,  p_aktueller_status   in Varchar2 default NULL
  ,  p_farbe              in Varchar2 default NULL
  ,  p_fk_firma           in Number   default NULL

  ,  p_fk_projekt_id      in Number   default NULL -- muss immer durch eine Aufrufende Maske mitgeschickt werden !!!!
--  ,  p_letzte_bearbeitung in Date     default NULL
--  ,  p_bearbeitung_durch  in Varchar2 default NULL
  ,  p_beschreibung       in Varchar2 default NULL
  ,  p_plankosten         in Varchar2 default NULL

  ,  p_do_update          in varchar2 default ''
  ,  p_do_delete          in Varchar2 default ''
  ,  p_do_insert          in Varchar2 default ''
  ,  p_do_copy            in Varchar2 default ''

) as

-- lokale Variablen:
   v_id                   proj_projektphase.id%type;
   v_startdatum           proj_projektphase.startdatum%type;
   v_enddatum             proj_projektphase.enddatum%type;
   v_phasen_name          proj_projektphase.phasen_name%type;
   v_projekt_abschnitt    proj_projektphase.projekt_abschnitt%type;
   v_aktueller_status     proj_projektphase.aktueller_status%type;
   v_fk_projekt_id        proj_projektphase.fk_projekt_id%type;
   v_letzte_bearbeitung   proj_projektphase.letzte_bearbeitung%type;
   v_bearbeitung_durch    proj_projektphase.bearbeitung_durch%type;
   v_beschreibung         proj_projektphase.beschreibung%type;
   v_farbe                proj_projektphase.farbe%type;
   v_plankosten           proj_projektphase.plankosten%type;
   v_fk_firma             proj_projektphase.fk_firma%type;

   v_po                   Boolean := TRUE; -- ist nur als Portlet verfgbar
   v_modus                Number(1);
   v_module_name          Varchar2(30) := 'PO_PROJEKTPHASE_DETAILS';

   v_error                Varchar2(800);
   defaultgui             Varchar2(400) := dbfun$default_gui;
   defaultlang            Varchar2(400) := dbfun$default_lang;
   dateformat             Varchar2(40)  := ('DD.MM.YYYY'); -- hier nur Tagesdatum


   cursor c2 is
    select kurztext  farbe
         , langtext
    from xdb_Werte w
    , xdb_wertebereiche wb
    where wb_id = wb.id
    and lower(wb.name) = 'phasenfarben';


   cursor c3 (l_firma_id in Number) is
    select firmenname||' '||zusatz||'('||Stadt||')' firma
       , id
       from proj_firma
       where ( l_firma_id = id or l_firma_id is null )
   order by firmenname;

 BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );
 htp.p (v_modus||'MODUS') ;

  if v_modus > 0 then
   -- Delete
 if p_id is not null
   and p_do_delete is not NULL
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen um ihn spter nochmal anzuzeigen
        v_phasen_name := v_phasen_name;
     delete PROJ_PROJEKTPHASE
   where id = v_id;
    commit;
  end if; -- delete

 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
 if (p_id is not null)
  or  (p_do_insert is not null and p_id is null)
  or  (p_do_update  is not null and p_id is not null)
  or  p_do_copy     is not null -- Datensatz verdoppeln, uim Daten zu bernehmen
   then
  -- Datensatz einfgen bzw. bernehmen
    v_id                  :=  p_id ;
    begin
     v_startdatum          :=  to_date(p_startdatum,dateformat ) ;
    exception when others then
     v_error := 'Falsches Datumsformat fr Startdatum';
    end;

    begin
     v_enddatum            :=  to_date(p_enddatum,dateformat ) ;
    exception when others then
     v_error := 'Falsches Datumsformat fr Startdatum';
    end;

    v_phasen_name         :=  nvl(trim(p_phasen_name),'PHASE') ;
    v_projekt_abschnitt   :=  p_projekt_abschnitt ;
    v_aktueller_status    :=  p_aktueller_status ;
    v_fk_projekt_id       :=  p_fk_projekt_id ;
    v_letzte_bearbeitung  :=  sysdate; --p_letzte_bearbeitung ;
    v_bearbeitung_durch   :=  user; --p_bearbeitung_durch ;
    v_beschreibung        :=  p_beschreibung ;
    v_farbe               :=  substr(p_farbe,1,7) ;
    v_fk_firma            :=  p_fk_firma ;
    begin
     v_plankosten          :=  to_number(replace(replace(p_plankosten,' ',''), ',','.'),'9999999.99') ;
    exception when others
     -- alte Plankosten selektieren und einfgen
     then
     null; -- workaround
    end;


 end if;


if (p_do_insert is not null
    or p_do_copy is not null)
    and v_modus > 1 -- mindestens muss Modus = 2 sein um etwas speichern zu drfen
    then

  --SEQUENCE !!!!!!
  select seq_projektphase.nextval into v_id from dual;
  -- Datensatz einfgen
  insert into proj_projektphase
   (          id
        ,     startdatum
        ,     enddatum
        ,     phasen_name
        ,     projekt_abschnitt
        ,     aktueller_status
        ,     fk_projekt_id
        ,     letzte_bearbeitung
        ,     bearbeitung_durch
        ,     beschreibung
        ,     farbe
        ,     plankosten
        ,     fk_firma
          ) values (
              v_id
        ,     v_startdatum
        ,     v_enddatum
        ,     v_phasen_name
        ,     v_projekt_abschnitt
        ,     v_aktueller_status
        ,     v_fk_projekt_id
        ,     v_letzte_bearbeitung
        ,     v_bearbeitung_durch
        ,     v_beschreibung
        ,     v_farbe
        ,     v_plankosten
        ,     v_fk_firma
        );
  commit;
  end if; -- Insert ??

-- UPDATE
  if p_do_update is not null
   and p_id is not null
   and v_modus > 1
    then
     v_id := p_id;
      update proj_projektphase
       set
       startdatum          =  v_startdatum
     , enddatum            =  v_enddatum
     , phasen_name         =  v_phasen_name
     , projekt_abschnitt   =  v_projekt_abschnitt
     , aktueller_status    =  v_aktueller_status
     , fk_projekt_id       =  v_fk_projekt_id
     , letzte_bearbeitung  =  v_letzte_bearbeitung
     , bearbeitung_durch   =  v_bearbeitung_durch
     , beschreibung        =  v_beschreibung
     , farbe               =  v_farbe
     , plankosten          =  v_plankosten
     , fk_firma            =  v_fk_firma
    where id   = v_id;
    commit;
 end if; -- Update ??

  if     ( p_do_insert is NULL )
     and ( p_do_delete is NULL )
     and  p_id is not NULL
  then
    v_id   := p_id;
    select
     startdatum
   , enddatum
   , phasen_name
   , projekt_abschnitt
   , aktueller_status
   , fk_projekt_id
   , letzte_bearbeitung
   , bearbeitung_durch
   , beschreibung
   , farbe
   , plankosten
   , fk_firma
   into
     v_startdatum
   , v_enddatum
   , v_phasen_name
   , v_projekt_abschnitt
   , v_aktueller_status
   , v_fk_projekt_id
   , v_letzte_bearbeitung
   , v_bearbeitung_durch
   , v_beschreibung
   , v_farbe
   , v_plankosten
   , v_fk_firma
   from proj_projektphase
    where id = v_id;
 end if;

 -- der nachfolgende Parameter muss immer gesetzt werden, egal was vorher gelaufen sit!!
 if p_fk_projekt_id is not null and v_fk_projekt_id is null then
     v_fk_projekt_id       :=  p_fk_projekt_id ;
 end if;

  htp.p('<html>');
  htp.p(' <head>');
  htp.p('  <META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('  <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p('   <link rel=''stylesheet'' href=''/i/projekt/'||defaultgui||'/css/default.css'' type=''text/css''>');
  -- Toolbar einbinden
  if v_po = false then
     htp.p(dbfun$projtoolbar2js);
  end if;

  -- Calender einbinden
  htp.p('  <link rel="stylesheet" href="/i/projekt/calender/calendar.css" type="text/css">');
  htp.p('  <script type="text/javascript" src="/i/projekt/js/calender/calendar1.js"></script>');


  htp.p('  <title>PROJEKT | Projektphasen </title>');
  htp.p('</head>');

  htp.p('<body topmargin=5 leftmargin=5 marginwidth=5 marginheight=5>');

  if v_po = false then
    htp.p (dbfun$projtoolbar(upper(v_module_name)
                               , v_modus
                               , null --dbpck$main.fun$get_akt_benutzer
                             )
            );
  end if;

  htp.p('<div class="maintitle"> '||dbfun$i18(defaultlang,'PROJ_PROJEKTPHASE zum Projekt')||'<i>'
  || dbfun$get_projekt_name(p_fk_projekt_id)||'</i></div>');

      if v_modus > 2 then
      --  htp.p ('<a href="proj_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id||'" target="_blank"> Neue Phase einfgen </a>');
        htp.p(dbfun$html_button ('po_projektphasen_list?p_fk_projekt_id='||nvl(v_fk_projekt_id,p_fk_projekt_id)
        ,'<img src="/i/projekt/menu/arrow-up-16x16.gif">'||dbfun$i18(defaultlang,'Zurck zur Liste')));
      end if;

  htp.p('<table class="formtable" style="width:98%;">');
  -- Alte Werte
  htp.p (' <form name="form1" action="'||lower(v_module_name)||'" method="post">');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type="hidden"  name="p_id" value="'||v_id||'"/>');
  -- Neue Werte --
  htp.p ('<tr><td class="tdlr"> '||dbfun$i18(defaultlang,'ID')||'</td>');
  htp.p ('      <td  class="tdv"> '||p_id
          ||'</td></tr>');

 if  p_do_delete is not null then
  htp.p ('<tr><td  class="tdv" colspan = "2"><b>'||dbfun$i18(defaultlang,'wurde_gelscht')||' </b></td></tr>');
 else -- nicht gelscht
   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Startdatum')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('        <input name="p_startdatum" type="text" size=40 maxlength=10 value="'
     || to_char(v_startdatum,dateformat)||'">');

   htp.p('<a href="javascript:cals.popup();">'
    ||'<img src="/i/projekt/js/calender/img/cal.gif" width="16" height="16" border="0" alt="Datum auswhlen"></a>');


   htp.p('</td></tr>');



    htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Enddatum')||'</td>');
    htp.p ('      <td  class="tdv"> ');
    htp.p ('        <input name="p_enddatum" type="text" size=40 maxlength=10 value="'
     || to_char( v_enddatum,dateformat)||'">');
   htp.p('<a href="javascript:cale.popup();">'
    ||'<img src="/i/projekt/js/calender/img/cal.gif" width="16" height="16" border="0" alt="Datum auswhlen"></a>');


   htp.p('</td></tr>');

/*
   htp.p ('          <script type="text/javascript"> ');
   htp.p ('          <!-- // create calendar object(s) just after form tag closed ');
   htp.p ('                var calls = new calendar1(document.forms[''form1''].elements[''p_startdatum'']); ');
   htp.p ('                calls.year_scroll = true; ');
   htp.p ('                calls.time_comp = true;  ');

   htp.p ('                var calle = new calendar1(document.forms[''form1''].elements[''p_enddatum'']); ');
   htp.p ('                calle.year_scroll = true; ');
   htp.p ('                calle.time_comp = true;  ');

   htp.p ('             //-->');
   htp.p ('           </script>');
  */




   htp.p (' <tr><td  class="tdlr" style="background-color:'||v_farbe||'; layer-background-color:'||v_farbe||';">'||dbfun$i18(defaultlang,'Phasen_Name')||'</td>');
   htp.p ('     <td  class="tdv" style="background-color:'||v_farbe||'; layer-background-color:'||v_farbe||';"> ');
   htp.p ('       <input name="p_phasen_name" type="text" size=40 maxlength=100 value="'
     || v_phasen_name||'">');


    htp.p ('   <input name="p_farbe" type="hidden" size=7 maxlength=7 value="'
     || v_farbe||'">');

    -- Palette als innere Tabelle aufbauen
    if v_modus > 1 then
     htp.p('<table><tr>');
     for ca2 in c2 loop
       if ca2.farbe != v_farbe then
        htp.p('<td class="abc" style="background-color:'||ca2.farbe||'; layer-background-color:'||ca2.farbe||'; visibility: visible;" onclick="document.form1.p_farbe.value=('''||ca2.farbe||';'')">'||ca2.langtext||'</td>');
       else
        htp.p('<td class="abc" style="background-color:'||ca2.farbe||'; layer-background-color:'||ca2.farbe||'; visibility: visible;" onclick="document.form1.p_farbe.value=('''||ca2.farbe||';'')"><b>'||ca2.langtext||'</b></td>');
       end if;
     end loop;
     htp.p('</tr></table>');
     htp.p(' </td></tr>');
    end if;


   htp.p('</td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Projekt_Abschnitt')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('       <input name="p_projekt_abschnitt" type="text" size=40 maxlength=100 value="'
     || v_projekt_abschnitt||'" style="width:270px;"></td></tr>');
   if nvl(v_fk_Firma, p_fk_Firma) is null then
     htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Ausfhrende Firma')||'</td>');
    else
     htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Ausfhrende Firma')
              ||'<a href="proj_firma_details?p_id='||nvl(v_fk_Firma, p_fk_Firma)||'" target="_top"><img src="/i/projekt/default/img/details.png" title="Firma-Details" alt="Firma-Details"border="no"> </td>');
   end if;

   htp.p ('<td  class="tdv"> <select name="p_fk_Firma" size=1 maxlength=80 width=40 style="width:270px;">');
   if v_fk_firma is null then
     htp.p (' <option value="" selected > - ');
   end if;

   for ca3 in c3 (v_fk_Firma) loop
    htp.p (' <option value="'||ca3.id||'" '||dbfun$selected_opt(ca3.id,v_fk_Firma)||'>'||ca3.firma);
   end loop;
    htp.p (' <option value="" '||dbfun$selected_opt(null,v_fk_Firma)||'> - Eintrag lschen');

    htp.p ('</select>');
    htp.p ('</td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Aktueller_Status')||'</td>');
   htp.p ('     <td  class="tdv"> ');
   htp.p ('      <input name="p_aktueller_status" type="text" size=40 maxlength=100 value="'
     || v_aktueller_status||'" style="width:270px;"></td></tr>');

--   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Fk_Projekt_Id')||'</td>');
--   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_fk_projekt_id" type="hidden" value="' || v_fk_projekt_id||'">'); --</td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Letzte_Bearbeitung')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ( to_char( v_letzte_bearbeitung,dateformat||' HH24:MI') ||' / ');
   htp.p ( v_bearbeitung_durch||'</td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Plankosten')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_plankosten" type="text" size=40 maxlength=2000 value="'
     || to_char(v_plankosten, '9999999.99')||'" style="width:270px;"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Beschreibung')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_beschreibung" type="text" size=40 maxlength=2000 value="'
     || v_beschreibung||'" style="width:270px;"></td></tr>');

--   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Farbe')||'</td>');
--   htp.p ('      <td  class="tdv"> ');


    htp.p ('<tr><td colspan=2>');
   if v_id is not Null then
      if v_modus > 1 then
        htp.p ('  <input type="submit" name ="p_do_update" value="'||dbfun$i18(defaultlang,'update')||'"/>');
      end if;

      if v_modus > 1 then
        htp.p ('  <input type="submit" name ="p_do_copy" value="'||dbfun$i18(defaultlang,'duplizieren')||'"/>');
      end if;

      if v_modus > 2 then
        htp.p ('  <input type="submit" name ="p_do_delete" value=" '||dbfun$i18(defaultlang,'delete')||'"/>');
      end if;
    end if;
   if v_id is NULL
      and v_modus > 1 then
        htp.p ('  <input type="submit" name ="p_do_insert" value=" '||dbfun$i18(defaultlang,'insert')||'"/>');
   end if;
   htp.p (' </td></tr>');
  end if; -- do_delete
  htp.p (' </table>');
  htp.p ('<script language="JavaScript">');
  htp.p ('          <!-- // create calendar object(s) just after form tag closed  ');
  htp.p ('                     var cals = new calendar1(document.forms[''form1''].elements[''p_startdatum'']);');
  htp.p ('                     cals.year_scroll = true; ');
  --htp.p ('                     cals.time_comp = true; ');
  htp.p ('                     var cale = new calendar1(document.forms[''form1''].elements[''p_enddatum'']); ');
  htp.p ('                     cale.year_scroll = true;');
  --htp.p ('                     cale.time_comp = true;');
  htp.p ('             //--> ');
  htp.p ('           </script> ');
  htp.p (' </form>');

  else -- v-modus =0 -> keine Berechtigung
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;

 htp.p('</body>');
 htp.p('</html>');
EXCEPTION
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PO_PROJEKTPHASE_DETAILS        TO PROJ_RO;

GRANT EXECUTE      ON PO_PROJEKTPHASE_DETAILS        TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PO_PROJEKTPHASEN_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE po_projektphasen_list -- p_fk_projekt_id

 (  p_fk_projekt_id                in Number    default null -- Filter auf die Firma
--  , p_such_projekt               in Varchar2  default null -- Lst eine Volltextsuche nach Projekten aus
--  , p_kontakt_id                 in Number    default null -- Filter auf diesen Kontakt
--  , p_such_projekt_id            in varchar2  default null -- fr Suche ber die Projektnummer
--  , p_such_projekt_name          in Varchar2  default null -- Filter auf dieses Projekt
--  , p_such_bauherr               in Varchar2  default null
--  , p_such_startdatum            in Varchar2  default null
--  , p_such_letzte_Bearbeitung    in Varchar2  default null
  , p_order1                     in Varchar2  default null
  , p_order2                     in Varchar2  default null
  , p_debug                      in Varchar2  default null
  , p_netzplan                   in varchar2  default null -- Switch, so dass die Liste grafisch ausgegeben wird
  , p_report                     in varchar2  default null
  -- neu
--  , p_such_status                in varchar2  default null
--  , p_such_status_info           in varchar2  default null
  , x                            in Number    default null -- Dummy
  , y                            in Number    default null -- Dummy
--  , p_nur_offen                  in Number    default 1

  )

as
--[VERS:2008-07-13]

-- Ziel:
-- Generiert Liste der Projektphasen

-- noch offen:
-- - kritische Projektphasen hervorheben  (Status, oder aus dem Rahmen gelaufen)
-- - grafische Darstellung als Netzplan (Interaktiv ber DHTML ...)
-- - Links zu den Ansprechpartnern


-- Autor: Erich Heinemann
-- Kln

 -- Suche aller passenden Projekte
 -- dynamisches SQL
  sql_string1       Varchar2(4000);
  TYPE r_cur_t1     IS REF Cursor;
  r_cur1            r_cur_t1;

  v_po Boolean := true; -- ist nur als Portlet verfgbar

 -- DBMS_SQL
  cursor c1
   is
  select
    id
  , phasen_name
  , projekt_abschnitt
  , startdatum
  , enddatum
  , aktueller_status
  , letzte_bearbeitung
  , bearbeitung_durch
  , nvl(farbe,'#f0f0a0') farbe
  , fk_firma
  from proj_projektphase
--   where fk_projekt_id = l_fk_projekt_id
   order by nvl(startdatum,letzte_bearbeitung)
  ;
  -- dynamic-SQL

  ca1                c1%rowtype;

/* -- Vorladen der verschiedenen Farben fr die HTML-DIVs
 cursor c2 is
 select w.kurztext, w.langtext
   from xdb_werte  w
      , xdb_wertebereiche wb
  where wb.id   =  w.wb_id
    and wb.name =  'projekt_status_farbe'
  ;
*/

  -- Zugriffsverwaltung
  v_modus            Number(1);
  v_module_name      Varchar2(30) := 'PO_PROJEKTPHASEN_LIST';

  -- Formatierung
  kund               varchar2(2)  := chr(38);
--  v_severity_str     Varchar2(255);

  -- spezifische Parameter zur Darstellung als Netzplan
  v_min_datum        Date;     -- kleinstes Datum aus den Projektphasen
  v_max_datum        Date;     -- maximales Datum aus den Projektphasen
  v_faktor           Number(10); -- Faktor, um den Netzplan optimal darzustellen (1024 Pixel maximal = 1000 Tage...)
  v_start            Number(10); -- Anzahl von Pixeln vom ersten Termin um eine Phase als Netzplan anzuzeigen
  v_days             Number(10); -- Anzahl von Pixeln um eine Phase als Netzplan anzuzeigen
  v_erster_monat     Date;
  v_monat            Date;
  v_netzplan         Varchar2(20) := nvl(p_netzplan,'j');  -- Bei Bedarf ndern !!!   j/n
  v_popup            Varchar2(4000); -- Text fr Popup-Meldungen

  v_top              Number(10) :=0;   -- Platzhalter, um die Objekte richtig zu positionieren
  v_height           Number(10) := 20; -- bei der Ausgabe als Report
                                        -- mssen alle mglichen Zeilen ausgegeben werden, so dass es
                                        -- je Phase n*v_height  sein knnen!!! (Zeilen=n)

  -- Fr die Suchfunktionen
  v_such_projekt_id  Varchar2(255); -- :=  '%'||substr(p_such_projekt_nr,1,20)||'%';
  v_dummy            Number(10)     :=1;

  v_order_form       Varchar2(4000);
  v_order1           Varchar2(200);
  v_order2           Varchar2(200);
  v_link             Varchar2(400);
  v_td_string        Varchar2(2000);



  v_error            Varchar2(800);
  defaultgui         Varchar2(400) := dbfun$default_gui;
  defaultlang        Varchar2(400) := dbfun$default_lang;
  dateformat         Varchar2(40)  := ('DD.MM.YYYY'); -- hier nur Tagesdatum


BEGIN

 begin


  v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

  if p_report != null and p_netzplan='j' then
   v_height := 5 * v_height; --- mehr Daten je Phase!
  end if;

  if v_modus > 0 then

   begin
   select min (startdatum), max (nvl(enddatum,startdatum)) into v_min_datum, v_max_datum
    from proj_projektphase
     where fk_projekt_id = p_fk_projekt_id;

     v_faktor := dbfun$days_between (v_min_datum, v_max_datum);

     if v_faktor > 500 then  -- Projekt erstreckt sich ber 1.5 Jahre
      v_faktor:= 1;
     elsif v_faktor > 300 then -- Projekt erstreckt sich ber 1 Jahr
      v_faktor :=2;
     elsif v_faktor > 200 then  -- Projekt erstreckt sich ber 3/4 Jahr
      v_faktor :=3;
     elsif v_faktor > 100 then  -- Projekt erstreckt sich ber 3 Monate
      v_faktor :=4;
     elsif v_faktor <=100 then
      v_faktor :=8;
     end if;

   exception when others then
    null;
    -- noch keine Startdatums vorhanden
   end;


   v_order_form := '<form  action="'||lower(v_module_name)||'" method="post" style="white-space:nowrap">';

   if p_fk_projekt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_fk_projekt_id" value="'||p_fk_projekt_id||'"/>';
   end if;



/*
   if p_kontakt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_kontakt_id" value="'||p_kontakt_id||'"/>';
   end if;


   if p_such_projekt_name is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_projekt" value="'||p_such_projekt_name||'"/>';
   end if;

   if p_such_projekt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_projekt_id" value="'||p_such_projekt_id||'"/>';
   end if;

    if p_such_status is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_status" value="'||p_such_status||'"/>';
   end if;
*/

 -- Alte Sortierung nach hinten schieben !!
 -- Dieser Parameter hilft, dass die vorletzte Sortierung nicht ganz verloren geht.
 -- Erst die dritte Auswahl einer Sortierreihenfolge lscht die vorletzte!
   if p_order1 is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_order2" value="'||p_order1||'"/>';
   end if;

-- Suche auch nach abgeschlossenen Bauprojekten
/*   if p_nur_offen <> 1 then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_only_open" value="0"/>';
   end if;
*/

  sql_string1 := 'select * from( '||chr(10)
 ||' select   id          '||chr(10)
 ||' ,  phasen_name       '||chr(10)
 ||' , projekt_abschnitt  '||chr(10)
 ||' , startdatum         '||chr(10)
 ||' , enddatum           '||chr(10)
 ||' , aktueller_status   '||chr(10)
 ||' , letzte_bearbeitung '||chr(10)
 ||' , bearbeitung_durch  '||chr(10)
 ||' , nvl(farbe,''#f0f0a0'') farbe   '||chr(10)
 ||' , fk_firma '||chr(10)
 ||' from proj_projektphase '||chr(10) ;

 sql_string1 := sql_string1
   || ' where fk_projekt_id = '||p_fk_projekt_id ||' '||chr(10);


/* if p_kontakt_id is not null then
   sql_string1 := sql_string1 ||' and ' || p_kontakt_id||'  = p.fk_bauherr ';
 end if;
*/
 -- ??? muss erweitert werden, da in einem Projekt und Phasen zustzliche Personen involviert werden knnen

/*
 if p_such_projekt_id is not null then
   sql_string1 := sql_string1 ||' and (p.projekt_id like ''%'||p_such_projekt_id ||'%''';
   sql_string1 := sql_string1 ||' or p.id||'''' like ''%'||p_such_projekt_id ||'%'')';
  else
   if p_nur_offen = 1  then  -- Wenn nicht abgeschlossene (4) Projekte gesucht werden!
     sql_string1 := sql_string1 ||' and p.fk_projekt_status not in (4)'||chr(10);
   end if;
 end if;

  if p_such_status is not null then
   sql_string1 := sql_string1 ||' and upper(dbfun$get_werte(''projekt_status'',p.fk_projekt_status)) like ''%'||upper(p_such_status)||'%'' ';
  end if;

  if p_such_bauherr is not null then
   sql_string1 := sql_string1 ||' and (upper(nachname) like ''%'||upper(p_such_bauherr)||'%'' or  ';
   sql_string1 := sql_string1 ||'      upper(stadt) like ''%'||upper(p_such_bauherr)||'%'' )  ';

  end if;


  if p_such_projekt_id is not null then
   sql_string1 := sql_string1 ||' and ( p.projekt_id      like ''%'||p_such_projekt_id ||'%'' ';
   sql_string1 := sql_string1 ||'   or  upper(nachname) like ''%'||upper(p_such_projekt_id )||'%'' ) ';
  end if;

  -- Suchfeld fr das Status-Bemerkungsfeld
  if p_such_status_info is not null then
   sql_string1 := sql_string1 ||' and upper(p.aktueller_status) like ''%'||upper(p_such_status_info)||'%'' ';
  end if;

  if p_such_projekt_name is not null then
   sql_string1 := sql_string1 ||' and ( upper(p.projekt_name) like ''%'||upper(p_such_projekt_name) ||'%'')' ||chr(10);
  end if;

 -- hier noch ein Block, womit eine Volltextsuche ber alle Felder gestartet wird
  if p_such_projekt is not null then
   sql_string1 := sql_string1 ||' and ( upper(p.projekt_name) like ''%'||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(p.aktueller_status) like ''%'  ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(k.plz) like ''%'        ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(k.stadt) like ''%'      ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'     )' ||chr(10);
 end if;

*/

 -- Ende des Subselect einfgen
 sql_string1 := sql_string1 ||') x ';
-- .. sicher, so ein dynamisches SQL bietet nicht die beste Performance, ist aber irgendwie im Sourcecode nachvollziehbar.
-- Besser wre es, dieses Statement ber Bind-Variablen zu bauen. ... beim nchsten mal. :-)


 -- ORDER-BY einfgen
  if p_order1 is not null then
   sql_string1 := sql_string1 ||' order by '||dbfun$get_werte('PROJEKTPHASEN_LIST_ORDER',p_order1);
   if p_order2 is not null then
     sql_string1 := sql_string1 ||' , '||dbfun$get_werte('PROJEKTPHASEN_LIST_ORDER',p_order2);
   end if;
  else -- Sortierung nach Startdatum letzter nderung desc
     sql_string1 := sql_string1 ||'    order by nvl(startdatum,letzte_bearbeitung)';
  end if;

   -- HTTP-Session ffen
    htp.p('<HTML>');
    htp.p('<head>');
    htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
    htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

   -- Include fr HTML-Header
    If v_po = false then
      htp.p(dbfun$projtoolbar2js);
    end if;

   -- Include fr POPUP-JS
    htp.p(' <script type="text/javascript" src="/i/projekt/js/popup.js"></script>');

   if v_netzplan='j' then
   -- Include fr die freie Library von Walter Zorn
    htp.p ('<script type="text/javascript"  src="/i/projekt/js/wz_jsgraphics.js"></script>');
 /*
    htp.p ('<script type="text/javascript">');
    htp.p ('function getObj(name)');
    htp.p ('{');
    htp.p ('  if (document.getElementById)');
    htp.p ('  {');
    htp.p ('    this.obj = document.getElementById(name);');
    htp.p ('    this.style = document.getElementById(name).style;');
    htp.p ('    this.width = document.getElementById(name).width;');
    htp.p ('    this.height = document.getElementById(name).height;');
    htp.p ('    this.zIndex = document.getElementById(name).zIndex;');
    htp.p ('  }');
    htp.p ('  else if (document.all)');
    htp.p ('  {');
    htp.p ('    this.obj = document.all[name];');
    htp.p ('    this.style = document.all[name].style;');
    htp.p ('    this.width = document.all[name].width;');
    htp.p ('    this.height = document.all[name].height;');
    htp.p ('    this.zIndex = document.all[name].zIndex;');
    htp.p ('  }');
    htp.p ('  else if (document.layers)');
    htp.p ('  {');
    htp.p ('    this.obj = document.layers[name];');
    htp.p ('    this.style = document.layers[name];');
    htp.p ('    this.width = document.layers[width];');
    htp.p ('    this.height = document.layers[height];');
    htp.p ('    this.zIndex = document.layers[zIndex];');
    htp.p ('  }');
    htp.p ('}');
    htp.p ('</script>');
    */

  end if;


    htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||dbfun$default_gui||'/css/default.css'' type=''text/css''>');
    htp.p('<title>Projekte | Projektphasen</title>');
    htp.p('</head>');
    htp.p('<BODY>');

    If v_po = false then
     htp.p (dbfun$projtoolbar(upper(v_module_name)
                                   , v_modus
                                   , null --dbpck$main.fun$get_akt_benutzer
                                )
           );

     end if;

     -- Hidden DIV fr Popups
     htp.p ('  <DIV id="popup" class="popuptable" style="POSITION: absolute; VISIBILITY: hidden; Z-INDEX: 1"></DIV>');

 --   if p_such_projekt_id is null and  p_such_projekt is null then
    --  htp.p('<div class="maintitle">Projektphasen zum Projekt '||'<i>'
     -- || dbfun$get_projekt_name(p_fk_projekt_id)
      --||'<a href="proj_projekt_details?p_id='||p_fk_projekt_id||'" border="NO">'
     -- ||'<img src="../../projekt/'||dbfun$default_gui||'/img/tool/details.png" ALT="Details" BORDER=NO></a>'
     -- ||'</i>');

      htp.p('<div id="buttons"  style="POSITION: absolute; VISIBILITY: visible; Z-INDEX: 1;">');
      if v_modus > 2 then
      --  htp.p ('<a href="proj_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id||'" target="_blank"> Neue Phase einfgen </a>');
        htp.p(dbfun$html_button ('po_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id,'<img src="/i/projekt/default/img/add_new_abc.png">'||dbfun$i18(defaultlang,'Neue Phase einfgen')));
      end if;

      if v_netzplan  = 'n' then
        htp.p(dbfun$html_button (v_module_name||'?p_fk_projekt_id='||p_fk_projekt_id||kund||'p_netzplan=j','<img src="/i/projekt/default/img/liste_netz.png">Als Netzplan'));
        htp.p(dbfun$html_button (v_module_name||'?p_fk_projekt_id='||p_fk_projekt_id||kund||'p_netzplan=n','<img src="/i/projekt/default/img/reload.png">Neu Laden'));
      else
    --    htp.p('<a href="'||v_module_name||'?p_fk_projekt_id='||p_fk_projekt_id||kund||'p_netzplan=n">Als Liste</a>');
        htp.p(dbfun$html_button (v_module_name||'?p_fk_projekt_id='||p_fk_projekt_id||kund||'p_netzplan=n','<img src="/i/projekt/default/img/liste_bunt.png">Als Liste'));
        htp.p(dbfun$html_button (v_module_name||'?p_fk_projekt_id='||p_fk_projekt_id||kund||'p_netzplan=j','<img src="/i/projekt/default/img/reload.png">Neu Laden'));
      end if;



      htp.p('</div>');


     -- DIV fr die Linien im Netzplan
     htp.p ('<div id="myCanvas" style="position:absolute;top:0px;left:0px;width:98%;height:98%;clear:both;"></div>');

     htp.p ('<script type="text/javascript"> ');
     htp.p ('<!--');
     htp.p ('var jg = new jsGraphics("myCanvas");');
     htp.p ('//-->');
     htp.p ('</script>');


 --   else
 --     htp.p('<div class="maintitle"> Projektphasen, <i>Filter, Projekte entsprechend '
 --         ||nvl(p_such_projekt_id,p_such_projekt)||'</i></div>');
 --   end if;

 -- die 2 anchfolgenden DIVS werden versteckt um die Styles fr das Highlighting beim Hover-Effekt zu steuern
   htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">x</div>');
   htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">x</div>');

/*
 -- DIVs fr die unterschiedlichen Severities
 -- Die Farben fr die Severities werden in einer WErteliste ausgelesen und dann verstekct vorgehalten
  for ca2 in c2 loop
   htp.p('<div id="tdlistSeverities'||ca2.kurztext||'_0" style="visibility:hidden;top:0px;height:0px;background-color:'
   ||ca2.langtext||';">x</div>');
   htp.p('<div id="tdlistSeverities'||ca2.kurztext||'_1" style="visibility:hidden;top:0px;height:0px;background-color:'
   ||dbfun$mod_color(ca2.langtext,15)||';">x</div>');
  end loop;
*/


  htp.p(' <table class="listtable" style="width:98%;position:absolute;top:36px;">');

    -- Header-Zeile aufbauen

  if v_netzplan ='n' then

    htp.p('  <tr>');

    htp.p('  <td width="30" class="tdh" style="border-bottom-width:1px;">');
    htp.p('      '||v_order_form ||'<input type="hidden"  name="p_order1" value="1"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Phase" title="Sortierung nach Phase" Border="NO">');
    htp.p('      Name</form>');
    htp.p('  </td>');

    htp.p('  <td width="150" class="tdh"  style="border-bottom-width:1px;" >');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="2"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sortierung nach Projektabschnitt" title="Sortierung nach Projektabschnitt" Border="NO">');
    htp.p('     Projektabschnitt</form>');
    htp.p('  </td>');

    htp.p('  <td width="120" class="tdh" style="border-bottom-width:1px;" >');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="3"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sortierung nach Startdatum" title="Sortierung nach Startdatum" Border="NO">');
    htp.p('     Startdatum</form>');
    htp.p('  </td>');

    htp.p('  <td width="60" class="tdh"  style="border-bottom-width:1px;">');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="4"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sorierung nach Enddatum" title="Sorierung nach Enddatum" Border="NO">');
    htp.p('     Enddatum</form>');
    htp.p('  </td>');

    htp.p('  <td width="60" class="tdh"  style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="5"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Status" title="Sortierung nach Status" Border="NO">');
    htp.p('      Status</form>');
    htp.p('    </td>');

    htp.p('  <td width="60" class="tdh" colspan="2" style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="6"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Bearbeitung" title="Sortierung nach Bearbeitung" Border="NO">');
    htp.p('      Bearbeitung</form>');
    htp.p('    </td>');


    htp.p('</tr>');
  end if;


  /*
   htp.p('<tr>');
   -- Filter-Zeile fr neue Suche einfgen!!
   -- Suchfelder zusammenbauen

   htp.p(' <form  action="'||lower(v_module_name)||'" method="get" style="white-space:nowrap">');
   htp.p('   <TD class="tdheader">');
   htp.p(     ' <input name="p_such_status" type="text" size=5 maxlength=400 value="'
     || p_such_status ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_bauherr" type="text" size=16 maxlength=400 value="'
     || p_such_bauherr ||'">Bauherr</td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_id" type="text" size=16 maxlength=20 value="'
     || p_such_projekt_id ||'">Projekt-ID</td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_startdatum" type="text" size=19 maxlength=10 value="'
     || p_such_startdatum  ||'">startdatum</td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_letzte_Bearbeitung" type="text" size=10 maxlength=10 value="'
     || p_such_letzte_Bearbeitung ||'"></td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_name" type="text" size=38 maxlength=400 value="'
     || p_such_projekt_name ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_status_info" type="text" size=18 maxlength=400 value="'
     || p_such_status_info ||'"></td>');

   htp.p('    <td class="tdheader" >'
         ||'<input type="image" src="../../projekt/'||dbfun$default_gui||'/img/tool/such.png" ');
   htp.p('     alt="Suchen" title="Suchen" Border="NO">');
   htp.p('   </td>');

   htp.p('   </form>');
   htp.p('   </tr>');

   -------------------------------------

   if  p_such_projekt_id is not null then
      v_such_projekt_id :=  '%'||substr(p_such_projekt_id,1,20)||'%';
   end if;
  */


  v_dummy := 1;

  -- Monate oder Tage einblenden
  if v_min_datum is not null and v_netzplan='j' then
   v_erster_monat := add_months(last_day(v_min_datum)+1,-1); -- erster Tag im ersten Monat!!
   v_monat        := v_erster_monat; -- := add_months(last_day(v_min_datum)+1,-1); -- erster Tag im ersten Monat!!
     htp.p('   <tr>');
     htp.p('    <td colspan="7" style="height:'||v_height||'px;">');
     htp.p('    <div id="aussen" class="tdv" style="position:relative;top:0px;width:100%;height:'||v_height
      ||'px;visibility:visible;">');
     while  v_monat < v_max_datum
      loop
       v_start := DBFUN$DAYS_BETWEEN ( v_erster_monat, v_monat );
       v_days  := DBFUN$DAYS_BETWEEN  ( v_monat ,last_day(v_monat)) -2;
       htp.p('    <div class="td" style="position:absolute;top:0px;left:'||(v_start*v_faktor)
        ||'px;width:'||(v_days*v_faktor)||'px;">');
       htp.p('      |'||to_char(v_monat,'Mon/YY') );
       htp.p('    </div>');
        if v_faktor = 1 then
          v_monat := add_months( v_monat ,2) ;
        elsif v_faktor > 1 then
          v_monat := add_months( v_monat ,1) ;
        --end if;

       end if;

       end loop;
       htp.p('    </div>');
      htp.p('    </td>');
      htp.p('   </tr>');
  end if;


  -- SQL-Statement ausfhren
  open r_cur1 for sql_string1;
  loop
  fetch r_cur1 into ca1;
   exit when r_cur1%notfound;

   -- Der Style wird in der Liste zwischen den Datenstzen und dem Status des Projektes jeweils umgeschaltet
   -- Daher wird der Link vorher definiert und der Rohbau einer Tabellenzelle (<TD>) vorab je Zeile definiert

   if substr(v_module_name,1,3) != 'PO_' then
     v_link :=   '<a href="proj_projektphase_details?p_id='||ca1.id||'">';
   else
     v_link :=   '<a href="po_projektphase_details?p_id='||ca1.id||'">';
   end if;

   v_dummy :=  v_dummy +1;

   if v_dummy < 3050 then
    if v_netzplan = 'n' then

--   if instr(ca1.status_farbe,'#',1) > 0 then
 --       v_td_string :=  '    <td style="text-valign: middle;" onmouseover="tr'||v_dummy
 --       ||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy||'.style.backgroundColor=tdlistSeverities'
 --       ||ca1.projekt_status||'_'||mod(v_dummy,2)||'.style.backgroundColor;" '
  --      ||' >';
  --    htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" style="text-valign: bottom;background-color: '
  --    ||dbfun$mod_color(ca1.status_farbe,mod(v_dummy,2)*15)||';" id="tr'||v_dummy||'">');-- class="tdlist'||mod(v_dummy,2)||'" onmouseover="this.style.backgroundColor=''#FFFF00'';" onmouseout="this.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;">');
  --  else
       v_td_string :=  '    <td onmouseover="tr'||v_dummy||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'
       ||v_dummy||'.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;" '
                 ||' >';
    htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" id="tr'||v_dummy||'" style="text-valign: center;">');
  --  end if;

   -- Spalte fr den Status
 --  htp.p ( v_td_string
 --     ||v_link||dbfun$projekt_status_img(ca1.fk_projekt_status)||'</a></td>');

   -- Spalte fr Phasen_Name
   if ca1.phasen_name != 'PHASE' then
       htp.p ( v_td_string ||'<b>' || v_link||ca1.phasen_name   ||'</b></a>'||'</td>');
   else
       -- Beteiligte Personen aufzhlen und als Phasen-Name anzeigen z.B. "Tiefbau Mller GmbH"
       htp.p ( v_td_string ||'<i>' || v_link||ca1.phasen_name   ||'</i></a>'||'</td>');
   end if;

   -- Spalte fr Phasen_Name
   htp.p ( v_td_string ||v_link||ca1.Projekt_Abschnitt   ||'</a>');

   if ca1.fk_firma is not null then
     -- Firmenname einfgen
       htp.p('<br>'||DBFUN$GET_FIRMEN_NAME(ca1.fk_firma) );
     -- zentrale Telefonnummer einblenden
       htp.p('<br>'||DBFUN$GET_FIRMEN_kontakt(ca1.fk_firma) );

   end if;


   htp.p('</td>');


   -- Spalte fr Startdatum
   htp.p( v_td_string ||v_link||'<b>'||to_char(ca1.startdatum,dateformat)||'</b>'
     ||'</a></td>');

   -- Spalte fr das Enddatum
   htp.p (v_td_string ||v_link   ||to_char(ca1.enddatum,dateformat)||'<br>'
     ||'</a></td>');

   -- Spalte "Aktueller_Status"
   htp.p (v_td_string
     ||v_link
     ||ca1.aktueller_Status
     ||'</a></td>');


   -- Spalte "Letzte Bearbeitung"
   htp.p (v_td_string
     ||v_link
     ||to_char(ca1.letzte_bearbeitung,'DD.MM.YYYY Hh24:MI') ||' / '|| ca1.bearbeitung_durch
     ||'</a></td>');


   htp.p( v_td_string
   ||v_link
   ||'<img src="/i/projekt/'||dbfun$default_gui||'/img/details.png" BORDER=NO></A></TD>');
   htp.p('   </tr>');
 end if;
 --  Ende der Listendarstellung,
 -- ab hier wirds interessanter!

 -- Netzplan grafisch darstellen
 if  ca1.startdatum is not null and v_netzplan = 'j' then
     v_top   := v_top +18;
     v_start := DBFUN$DAYS_BETWEEN ( v_erster_monat, nvl(ca1.startdatum,ca1.letzte_Bearbeitung) );
     v_days  := DBFUN$DAYS_BETWEEN  ( nvl(ca1.startdatum,ca1.letzte_Bearbeitung) , nvl(ca1.enddatum, ca1.startdatum)) +1;
     htp.p('   <tr>');
     htp.p('    <td colspan="7">');
    -- IE-Workaround, erstmal das Hintergrund-DIV malen  class="tdv"
--     htp.p('    <div id="iediv'|| ca1.id ||'"  style="position:relative;left:'||(v_start*v_faktor)
     htp.p('    <div id="iediv'|| ca1.id ||'"  style="position:relative;left:'||(v_start*v_faktor)
     ||'px;width:'|| ((v_days*v_faktor)) ||'px;height:16px;' -- keine Ahnung, warum 5 abgezogen werden mssen??
     ||'background-color:'||ca1.farbe||'; layer-background-color:'||ca1.farbe||'; visibility: visible;">'
     );

     htp.p ('<script type="text/javascript"> ');
     htp.p ('<!--');
     -- In der Farbe der Phase (Leistung)
     htp.p ('  jg.setColor("'||ca1.farbe||'");'); -- rot
 --    htp.p ('  var od   = new getObj(''iediv'|| ca1.id||''');');
     htp.p ('  var y_offset = 64 ;'); -- die 20 habe ich einfach ausprobiert!!
     htp.p ('  var y        = '||v_top||' + y_offset ;'); -- den Offset habe ich einfach ausprobiert!!
--     htp.p ('  var y    = parseInt(od.offsetHeight) + y_offset ;'); -- den Offset habe ich einfach ausprobiert!!
--     htp.p ('      y    = parseInt(od.style.top) + y_offset ;'); -- den Offset habe ich einfach ausprobiert!!

--     htp.p ('  alert(y + " TEST");');--    = parseInt(od.offsetHeight) + y_offset ;'); -- den Offset habe ich einfach ausprobiert!!
     htp.p ('  jg.drawLine('||(v_start*v_faktor)||', y , '||(v_start*v_faktor)||', y_offset );'); -- Koordinaten auf Zeichenflche bezogen
--     htp.p ('  jg.setColor("'||ca1.farbe||'");'); -- rot
     htp.p ('  jg.drawLine('||((v_start+v_days)*v_faktor)||', y, '||((v_start+v_days)*v_faktor)||', y_offset);'); -- Koordinaten auf Zeichenflche bezogen
--     htp.p ('jg.setColor("#0000ff");'); -- blau
--     htp.p ('jg.fillRect(110, 120, 30, 60);');
     htp.p ('  jg.paint();');
     htp.p ('//-->');
     htp.p ('</script>');

     --  Nun das DIV mit der Beschriftung einbinden
     -- Fr reine Firefox-Umgebungen kann man hier ein DIV weg lassen
     htp.p('    <div id="mozdiv'||ca1.id||'" class="tdx" style="position:absolute;left:0px;top:0px;"');

    -------------------------------------------
       htp.p ('    onMouseOut=''hidePopup()''    ');
      v_popup := '<table class="popuptable">';
      v_popup := v_popup || '<td class=\"popup_header\" colspan="2">'||ca1.phasen_name||'</td></tr>';
     --  Startdatum
      v_popup := v_popup || '<td class=\"popup_label\">Start:</td><td class=\"popup_val\">'
       ||to_char(ca1.startdatum,'Dy '||dateformat)||'</td></tr>';
     --  Enddatum
     v_popup := v_popup || '<td class=\"popup_label\">Enddatum:</td><td class=\"popup_val\">'
       ||to_char(ca1.enddatum,'Dy '||dateformat)||'</td></tr>';
     -- Spalte "Aktueller_Status"
     if ca1.aktueller_Status is not null then
      v_popup := v_popup || '<td class=\"popup_label\">Aktuell:</td><td class=\"popup_val\">'
       ||ca1.aktueller_Status||'</td></tr>';
     end if;


    -- Bereinigung der Daten, so dass alle Sonderzeichen rausfallen
    v_popup := replace(replace(v_popup,'(',''),')','');
    v_popup := replace(replace(v_popup,'"',''),'''','');
    htp.p ('    onMouseOver=''showPopup("'||v_popup||'",event)''    ></a>');
    -------------------------------------------

     -- Phasen_Name
     htp.p ( v_link||'<span style="white-space:nowrap; "> '||ca1.phasen_name||'</span>');
     htp.p('</a>');
  /* -- GUI ist beim IE nicht praktikabel

     if v_faktor > 2 then
      --  Startdatum
      htp.p(' '||to_char(ca1.startdatum,dateformat)||' ');
     end if;

     if v_faktor > 3 then
      --  Enddatum
      htp.p (to_char(ca1.enddatum,dateformat));
     end if;

      -- Spalte "Aktueller_Status"
     if ca1.aktueller_Status is not null and v_faktor > 1 then
       htp.p (' ('||ca1.aktueller_Status||')');
     end if;
  */
     htp.p('      </div>');
     htp.p('     </div>');
 --    htp.p('    </td>');
--     htp.p('   </tr>');
 end if;



   else -- v_dummy <150
    htp.p('   <tr>');
    htp.p('     <td colspan="9"> Zu viele Datenstze!!! Abgeschnitten ab Nr.'||v_dummy||'! </td>');
    htp.p('   </tr>');
   end if; -- v_dummy <150

   end loop;
    CLOSE r_cur1;

   htp.p('   </table>');

 else -- v-modus =0
    htp.p ('  <html><body><h1> no Accesss with Your Account ! </h1><br>');
 end if;


 htp.p('  </body>' );
 htp.p(' </html>' );

end;
 exception when others
 then
    htp.p ('SQL-Error '||sqlerrm ||' / '|| sqlcode );

  --  if v_modus != null and v_modus > 2 then
      htp.p ('<br>'||chr(10)||sql_string1);
  --  end if;

end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PO_PROJEKTPHASEN_LIST          TO PROJ_RO;

GRANT EXECUTE      ON PO_PROJEKTPHASEN_LIST          TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PROJ_FIRMA_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE PROJ_FIRMA_DETAILS
(
     p_id            in   Number default NULL
  ,  p_firmenname    in   Varchar2 default NULL
  ,  p_zusatz        in   Varchar2 default NULL
  ,  p_strasse1      in   Varchar2 default NULL
  ,  p_strasse2      in   Varchar2 default NULL
  ,  p_strasse3      in   Varchar2 default NULL
  ,  p_plz           in   Varchar2 default NULL
  ,  p_stadt         in   Varchar2 default NULL
  ,  p_land          in   Varchar default NULL
  ,  p_bemerkung     in   Varchar2 default NULL
  ,  p_webpage       in   Varchar2 default NULL
  ,  p_tel           in   Varchar2 default NULL
  ,  p_email         in   Varchar2 default NULL
--  ,  p_letzte_bearbeitung   in va default NULL
--  ,  p_bearbeitung_durch    in Varchar2 default NULL
  ,  p_do_update     in varchar2  default ''
  ,  p_do_delete     in Varchar2  default ''
  ,  p_do_insert     in Varchar2  default ''
) as

-- lokale Variablen:
   v_id                 proj_firma.id%type;
   v_firmenname         proj_firma.firmenname%type;
   v_zusatz             proj_firma.zusatz%type;
   v_strasse1           proj_firma.strasse1%type;
   v_strasse2           proj_firma.strasse2%type;
   v_strasse3           proj_firma.strasse3%type;
   v_plz                proj_firma.plz%type;
   v_stadt              proj_firma.stadt%type;
   v_land               proj_firma.land%type;
   v_bemerkung          proj_firma.bemerkung%type;
   v_webpage            proj_firma.webpage%type;
   v_tel                proj_firma.tel%type;
   v_email              proj_firma.email%type;
   v_letzte_bearbeitung         proj_firma.letzte_bearbeitung%type;
   v_bearbeitung_durch          proj_firma.bearbeitung_durch%type;

   v_modus        Number(1);
   v_module_name  Varchar2(30) := 'PROJ_FIRMA_DETAILS';

   defaultgui     Varchar2(400) := dbfun$default_gui;
   defaultlang    Varchar2(400) := dbfun$default_lang;
   dateformat     Varchar2(40)  := ('DD.MM.YYYY HH24:MI');

 BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed(
                v_module_name
                 );

  if v_modus > 0 then
   -- Delete
 if p_id is not null
   and p_do_delete is not NULL
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen
        v_firmenname := p_firmenname;
     delete PROJ_FIRMA
   where id = v_id;
    commit;
  end if; -- delete

 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
if (p_id is not null)
 or  (p_do_insert is not null and p_id is null)
 or  (p_do_update is not null )
  then
 -- Datensatz einfgen bzw. bernehmen
   v_id   :=  p_id ;
   v_firmenname   :=  p_firmenname ;
   v_zusatz       :=  p_zusatz ;
   v_strasse1     :=  p_strasse1 ;
   v_strasse2     :=  p_strasse2 ;
   v_strasse3     :=  p_strasse3 ;
   v_plz          :=  p_plz ;
   v_stadt        :=  p_stadt ;
   v_land         :=  p_land ;
   v_bemerkung    :=  p_bemerkung ;
   v_webpage      :=  p_webpage ;
   v_tel          :=  p_tel ;
   v_email        :=  p_email ;
 --  v_letzte_bearbeitung   :=  p_letzte_bearbeitung ;
 --  v_bearbeitung_durch    :=  p_bearbeitung_durch ;
end if;

if p_do_insert is not null
  and v_modus > 1 -- min 2!
    then

  --SEQUENCE !!!!!!
  select seq_firma.nextval into v_id from dual;
  insert into proj_firma
   (
              id
        ,     firmenname
        ,     zusatz
        ,     strasse1
        ,     strasse2
        ,     strasse3
        ,     plz
        ,     stadt
        ,     land
        ,     bemerkung
        ,     webpage
        ,     tel
        ,     email
        ,     letzte_bearbeitung
        ,     bearbeitung_durch
          ) values (
            v_id
        ,   v_firmenname
        ,   v_zusatz
        ,   v_strasse1
        ,   v_strasse2
        ,   v_strasse3
        ,   v_plz
        ,   v_stadt
        ,   v_land
        ,   v_bemerkung
        ,   v_webpage
        ,   v_tel
        ,   v_email
        ,   sysdate --v_letzte_bearbeitung
        ,   user --v_bearbeitung_durch
        );
  commit;
  end if; -- Insert ??

-- UPDATE
  if p_do_update is not null
   and p_id is not null
   and v_modus > 1
    then
     v_id := p_id;
      update proj_firma
       set
      firmenname          =  v_firmenname
     , zusatz     =  v_zusatz
     , strasse1   =  v_strasse1
     , strasse2   =  v_strasse2
     , strasse3   =  v_strasse3
     , plz        =  v_plz
     , stadt      =  v_stadt
     , land       =  v_land
     , bemerkung  =  v_bemerkung
     , webpage    =  v_webpage
     , tel        =  v_tel
     , email      =  v_email
     , letzte_bearbeitung         =  sysdate --v_letzte_bearbeitung
     , bearbeitung_durch          =  user --v_bearbeitung_durch
    where id   = v_id;
    commit;
 end if; -- Update ??
  if     ( p_do_insert is NULL)
     and ( p_do_delete is NULL)
     and  p_id is not null
  then
    v_id   := p_id;
    select
   firmenname
  , zusatz
  , strasse1
  , strasse2
  , strasse3
  , plz
  , stadt
  , land
  , bemerkung
  , webpage
  , tel
  , email
  , letzte_bearbeitung
  , bearbeitung_durch
  into
   v_firmenname
  , v_zusatz
  , v_strasse1
  , v_strasse2
  , v_strasse3
  , v_plz
  , v_stadt
  , v_land
  , v_bemerkung
  , v_webpage
  , v_tel
  , v_email
  , v_letzte_bearbeitung
  , v_bearbeitung_durch
    from proj_firma
 where id = v_id;
 end if;

  htp.p('<html>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p(' <link rel="stylesheet" href="/i/projekt/'||defaultgui||'/css/default.css" type="text/css">');
  htp.p('  <script type="text/javascript">     ');
  htp.p('        var djConfig = { isDebug: false }; ');
  htp.p('  </script>                       ');
  htp.p('  <script type="text/javascript" src="/i/projekt/js/dojo_core/dojo.js"></script>     ');
  htp.p('  <script type="text/javascript">');
  htp.p('        dojo.require("dojo.widget.ComboBox");');
  htp.p('        dojo.require("dojo.widget.TabContainer");   ');
  htp.p('        dojo.require("dojo.widget.LinkPane");    ');
  htp.p('        dojo.require("dojo.widget.ContentPane");   ');
  htp.p('        dojo.require("dojo.widget.LayoutContainer");  ');
  htp.p('</script> ');

  htp.p(dbfun$projtoolbar2js);
  htp.p('<title>Projekt | Firmen-Details</title>');
  htp.p('</head>');
  htp.p('<body topmargin=5 leftmargin=5 marginwidth=5 marginheight=5>');
  htp.p (dbfun$projtoolbar(upper(v_module_name), v_modus
                 , null
                  )
            );
  htp.p('<div class="maintitle">'||dbfun$i18(defaultlang,'PROJ_FIRMA')||'</div>');

  -- Container fr TAB-Reiter
  htp.p(' <div id="projektTabContainer" dojoType="TabContainer" style="background-color:#FFFFFF; '
  ||' position:absolute; top:66px; left:0px; width: 100%; height: 500px" selectedTab="tab1"> ');

  -- Erster TAB-Reiter
  htp.p('  <div id="tab1" dojoType="ContentPane" style="background-color:#FFFFFF;" label="Details">');


  htp.p('<table class="formtable" style="width:98%;">');
-- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method=head>');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type="hidden"  name="p_id" value="'||v_id||'"/>');
 -- Neue Werte --
   htp.p ('<tr><td class="tdlr"> '||dbfun$i18(defaultlang,'ID')||'</td>');
   htp.p ('      <td  class="tdv"> '||p_id
  ||'</td></tr>');
 if  p_do_delete is not null then
   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Firmenname')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ( v_firmenname||'</td></tr>');
   htp.p ('<tr><td  class="tdv" colspan = "2"><b>'||dbfun$i18(defaultlang,'wurde gelscht')||' </b></td></tr>');


 else -- nicht gelscht
   htp.p (' <tr><td  class="tdlor">'||dbfun$i18(defaultlang,'Firmenname')||'</td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_firmenname" type="text" size=40 maxlength=400 value="'
     || v_firmenname||'"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Zusatz')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_zusatz" type="text" size=40 maxlength=400 value="'
     || v_zusatz||'"></td></tr>');

   htp.p (' <tr><td  class="tdlor">'||dbfun$i18(defaultlang,'Adresse')||'</td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_strasse1" type="text" size=40 maxlength=400 value="'
     || v_strasse1||'"></td></tr>');

   htp.p (' <tr><td  class="tdlor">'||nbsp); --'||dbfun$i18(defaultlang,'Strasse2')||'</td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_strasse2" type="text" size=40 maxlength=400 value="'
     || v_strasse2||'"></td></tr>');

   htp.p (' <tr><td  class="tdlor">'||nbsp); --dbfun$i18(defaultlang,'Strasse3')||'</td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_strasse3" type="text" size=40 maxlength=400 value="'
     || v_strasse3||'"></td></tr>');

   htp.p ('<tr><td  class="tdlr">PLZ, Ort:  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_plz" style="width:67px;" type="text" size=8 maxlength=6 value="'
     || v_plz||'">');
   htp.p ('   <input name="p_stadt" type="text" size=28 maxlength=200 value="'
     || v_stadt||'"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Land')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_land" type="text" size=40 maxlength=11 value="'
     || v_land||'"></td></tr>');

   htp.p ('<tr><td  class="tdlor"> Bemerkung  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_bemerkung" type="text" size=40 maxlength=400 value="'
       || v_bemerkung||'"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Webpage')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_webpage" type="text" size=40 maxlength=200 value="'
     || v_webpage||'"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Telefonzentrale')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_tel" type="text" size=40 maxlength=20 value="'
     || v_tel||'"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Email')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_email" type="text" size=40 maxlength=20 value="'
     || v_email||'"></td></tr>');


   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Letzte_Bearbeitung / durch')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p (   v_letzte_bearbeitung ||'/'|| v_bearbeitung_durch||'</td></tr>');

    htp.p ('<tr><td colspan=2>');
   if v_id is not Null then
     if v_modus > 1 then
       htp.p ('  <input type="submit" name ="p_do_update" value="'||dbfun$i18(defaultlang,'update')||'"/>');
      end if;
      if v_modus > 2 and user = 'XDBADM' then
       htp.p ('  <input type="submit" name ="p_do_delete" value=" '||dbfun$i18(defaultlang,'delete')||'"/>');
      end if;
    end if;
   if v_id is NULL
      and v_modus > 1 then
      htp.p ('  <input type="submit" name ="p_do_insert" value=" '||dbfun$i18(defaultlang,'insert')||'"/>');
   end if;
   htp.p (' </td></tr>');
  end if; -- do_delete
  htp.p (' </table>');
  htp.p (' </form>');

  htp.p('</div>');
  -- Ende des ersten TABS

-- TAB2 fr geplante Phasen
  htp.p(' <div id="tab2" dojoType="ContentPane" label="Projektbeteiligung">');
   -- Liste der projekt-Aktionen:
   if v_id is not null then
    htp.p('<iframe src="po_projektbeteiligung_list?p_fk_firma_id='||v_id||'" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
     NULL;
   end if;
  htp.p('</div>');

-- TAB3 mit den Mitarbeitern
  htp.p(' <div id="tab3" dojoType="ContentPane" label="Mitarbeiter">');
   -- Liste der Mitarbeiter
   if v_id is not null then
    htp.p('<iframe src="po_firma_ma_list?p_fk_firma_id='||v_id||'" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
     NULL;
   end if;
  htp.p('</div>');


-- TAB4 fr die Routenplanung
 if dbfun$get_werte('globalconfig','RP') = 'ja' then  -- RP= Routenplanung

  htp.p(' <div id="tab4" dojoType="ContentPane" label="Routenplanung">');

   if v_strasse1 is not null then

   --  %C3%9F
   --  %C3%B6
   --  %C3%A4
   --  %C3%BC

    htp.p ('<h2> Routenplanung (maps.google.de)</h2>');

     begin
      htp.p(dbfun$url_to_googlemaps ('','Waldbrl',lower(v_Strasse1),lower(v_stadt) ));  
      htp.p ('Routenplanung von Waldbrl');
      htp.p ('</a>');
      htp.p(' - ' ||dbfun$url_to_googlemaps (lower(v_strasse1),lower(v_Stadt),'','Waldbrl' ));   
      htp.p ('zurck');
      htp.p ('</a>');

      exception when others then
       null;
     end;

   htp.p ('<h2> Routenplanung (www.michelin.com)</h2>');

     begin
      htp.p(dbfun$url_to_michelin ('','Waldbrl','51545',lower(v_strasse1),lower(v_Stadt),v_plz ));  
      htp.p ('Routenplanung von Waldbrl');
      htp.p ('</a>');
      htp.p(' - ' ||dbfun$url_to_michelin (lower(v_strasse1),lower(v_stadt),v_plz,'','Waldbrl','51545' ));  
      htp.p ('zurck');
      htp.p ('</a>');

     exception when others then
       null;
     end;


   end if;
   htp.p('</td></tr>');


  htp.p('</div>');
  -- Ende des TAB-Pane
 end if; -- RP



  else -- v-modus =0
  htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;
 -- eigentlich msste mann vorher die Berechtigung prfen !!
-- htp.p ('  <a href="proj_firma_list">Back</a>');
 htp.p('</body>');
 htp.p('</html>');
EXCEPTION
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PROJ_FIRMA_DETAILS             TO PROJ_RO;

GRANT EXECUTE      ON PROJ_FIRMA_DETAILS             TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PROJ_FIRMEN_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE proj_firmen_list (  p_initial       in varchar2 default 'A'
                                              , p_search        in Varchar2 default null
                                              , p_fk_projekt_id in number default null
                                              )
as

--[VERS:2008-07-14]

-- Ziel:
-- Generiert Liste der Firmen aus der Ontaktdatenbank

-- Autor: Erich Heinemann

 -- Suche aller passenden Firmen
 cursor c1 (l_initial in varchar2
 , l_search in varchar2)
 is
  select
     id
   , firmenname
   , plz
   , stadt
   , tel
   , nvl(ct.ct,0) ct
  from proj_firma
  , (select count(p.id) ct, k.fk_firma from
           proj_projekt p
         , proj_kontakt k
     where fk_firma is not null
       and p.fk_bauherr = k.id
       and fk_projekt_status not in (4) -- 4 = abgeschlossen!!
    group by fk_firma) ct
  where    id = ct.fk_firma (+)
       and  (
             ( l_search is null and upper(substr(firmenname,1,1)) = l_initial )
            or
              (l_search is not null and upper(firmenname) like '%'||upper(l_search)||'%' )
            )
  order by ct.ct
         , firmenname
         , plz
         , strasse1;


  cursor c2 is
   select distinct(substr(upper(firmenname),1,1) ) my_initial
    from proj_firma
    order by 1;

  kund varchar2(2) := chr(38);

  -- Zugriffsverwaltung
  v_modus            Number(1);
  v_module_name      Varchar2(20) := 'PROJ_FIRMEN_LIST';
  v_td_string        Varchar2(2000);
  v_dummy            Number(10)     :=1;
  v_link             Varchar2(2000);

BEGIN
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name);

 if v_modus > 0 then

  -- HTTP-Session ffen
   htp.p('<HTML>');
   htp.p('<head>');
   htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
   -- Include fr HTML-Header
   htp.p(dbfun$projtoolbar2js);
   htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||dbfun$default_gui||'/css/default.css'' type=''text/css''>');
   htp.p('<title>Projekt | Firmen</title>');
   htp.p('</head>');
   htp.p('<BODY>');
   htp.p (dbfun$projtoolbar(upper(v_module_name)
                               , v_modus
                               , null
                               )
          );

   htp.p('<table class"=listtable" width="98%"><tr><td> ');

   if v_modus > 2 then
     htp.p ('<a class="abc" href="proj_firma_details"><img src="/i/projekt/'||dbfun$default_gui
      ||'/img/add_new_abc.png" title="Neue Firma erstellen" border="No">Neue erstellen</a>');
   end if;

   for ca2 in c2 loop
   htp.p('<a class="abc" href="'||lower(v_module_name)||'?p_initial='
       ||ca2.my_initial||'">'
       ||ca2.my_initial||'</a>');

   end loop;


   htp.p('</td></tr></table>');

   -- Hilfs-DIVs fr den Mouse-Over-Effekt
   htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">x</div>');
   htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">x</div>');

   htp.p('<div class="maintitle"> Firmen-Liste </div>');

   -- Header fr die Liste
   htp.p('<table class="listtable" style="width:98%;">');
   htp.p('<TR>');
   htp.p('    <td class="tdh" style="border-bottom-width:1px;text-align:left;width:30px;"> ID </td>');
   htp.p('    <td class="tdh" style="border-bottom-width:1px;text-align:left;width:30%;"> Projekte </td>');
   htp.p('    <td class="tdh" style="border-bottom-width:1px;text-align:left;width:20%;"> Kundenname</td>');
   htp.p('    <td class="tdh" style="border-bottom-width:1px;text-align:left;width:10%;"> PLZ</td>');
   htp.p('    <td class="tdh" style="border-bottom-width:1px;text-align:left;width:20%;"> Stadt</td>');
   htp.p('    <td class="tdh" style="border-bottom-width:1px;text-align:left;" colspan=2>Telefonzentrale</td>');
   htp.p('<TR>');

-- id, company_name1, zipcode, city, telephone_central

  v_dummy := 0;
  for ca1 in c1 ( upper(p_initial), upper (replace (p_search,'*','%') ) )  loop -- Suche auch mit * mglich
     v_dummy := v_dummy +1;
     v_link := '<a href="proj_firma_details?p_id=' ||ca1.id||'"> ';

     v_td_string :=  '    <td onmouseover="tr'||v_dummy||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'
                  ||v_dummy||'.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;" '
                 ;-- ||' >';
    htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" id="tr'||v_dummy||'">');-- class="tdlist'||mod(v_dummy,2)||'" onmouseover="this.style.backgroundColor=''#FFFF00'';" onmouseout="this.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;">');

    -- Spalte ID
    htp.p(v_td_string || ' style="text-align:left;">'|| v_link
      ||ca1.id
      ||'</a></td>');

    -- Spalte "Offene Projekte"
    if ca1.ct > 0 then
      htp.p(v_td_string || ' style="text-align:left;">'
        ||'<a class="abc" href="proj_projekt_list?p_firma_id='
        ||ca1.id||'">'
        ||ca1.ct||' Projekte'); --||' / '||ca1.ct2);
      htp.p('</a></td>');
    else
      htp.p(v_td_string || ' style="text-align:left;">');
      htp.p (nbsp||'</td>');
    end if;

    -- Spalte "Firmenname"
    htp.p(v_td_string || ' style="text-align:left;">'|| v_link
     ||ca1.firmenname
     ||'</a></td>');

    -- Spalte "PLZ"
    htp.p(v_td_string || ' style="text-align:left;">'|| v_link
     ||ca1.plz
     ||'</a></td>');

    -- Spalte "Stadt"
    htp.p (v_td_string || ' style="text-align:left;">'|| v_link
     ||ca1.stadt
     ||'</a></td>');

    -- Spalte Telefon
    htp.p (v_td_string || ' style="text-align:left;">'|| v_link
     ||ca1.tel
     ||'</a></td>');

   -- Button zu den Details
   htp.p(v_td_string || ' style="text-align:right;">'|| v_link );
   htp.p('  <img src="/i/projekt/'||dbfun$default_gui||'/img/details.png" border=no></a></td>');
   htp.p(' </tr>');

   end loop;
   htp.p('</table>');

 else -- v-modus =0
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1><BR>');
 end if;


 htp.p('</BODY>' );
 htp.p('</HTML>' );

 exception when others
 then
    htp.p ('SQL-Error '||sqlerrm ||' / '|| sqlcode );
end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PROJ_FIRMEN_LIST               TO PROJ_RO;

GRANT EXECUTE      ON PROJ_FIRMEN_LIST               TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PROJ_KONTAKT_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE PROJ_kONTAkT_DETAILS
(

     p_id                  in Number      default NULL
  ,  p_fk_firma            in Number      default NULL
  ,  p_anrede              in Varchar2    default NULL
  ,  p_vorname             in Varchar2    default NULL
  ,  p_nachname            in Varchar2    default NULL
  ,  p_zusatz              in Varchar2    default NULL
  ,  p_email               in Varchar2    default NULL
  ,  p_tel1                in Varchar2    default NULL -- immer erreichbar = geschftlich
  ,  p_tel2                in Varchar2    default NULL -- mobil
  ,  p_tel3                in Varchar2    default NULL -- fax
  ,  p_tel4                in Varchar2    default NULL -- dect -- in der Firma
  ,  p_tel5                in Varchar2    default NULL -- sonstiges Telefon
  ,  p_strasse             in Varchar2    default NULL
  ,  p_strasse2            in Varchar2    default NULL
  ,  p_strasse3            in Varchar2    default NULL
  ,  p_plz                 in Varchar2    default NULL
  ,  p_stadt               in Varchar2    default NULL
  ,  p_land                in Varchar2    default NULL
  ,  p_letzte_bearbeitung  in Varchar2    default NULL
  ,  p_bearbeitung_durch   in Varchar2    default NULL
  ,  p_bemerkung           in Varchar2    default NULL
  ,  p_sip_user            in Varchar2    default NULL
  ,  p_old_sip_user        in Varchar2    default NULL
  ,  p_do_update           in varchar2    default ''
  ,  p_do_delete           in Varchar2    default ''
  ,  p_do_insert           in Varchar2    default ''
) as

--[VERS:2007-01-30]
-- Updates:
-- 30.01.2007 Patch _selected fr neues Ticket
-- 29.07.2005 Schnelleres ffnen von Tickets ermglicht
-- 19.04.2005 Auswahlliste optimiert, denn  Mozilla hat Probleme mit der Auswahlliste
-- 04.03.2005 FAX und Cordless-Nummer eingefgt und getestet
-- 11.11.2004 Navigation zu allen Ansprechpartnern der gleichen Firma

-- lokale Variablen:
   v_id                   proj_kontakt.id%type;
   v_fk_firma             proj_kontakt.fk_firma%type;
   v_anrede               proj_kontakt.anrede%type;
   v_vorname              proj_kontakt.vorname%type;
   v_nachname             proj_kontakt.nachname%type;
   v_zusatz               proj_kontakt.zusatz%type;
   v_email                proj_kontakt.email%type;
   v_tel1                 proj_kontakt.tel1%type;
   v_tel2                 proj_kontakt.tel2%type;
   v_tel3                 proj_kontakt.tel3%type;
   v_tel4                 proj_kontakt.tel4%type;
   v_tel5                 proj_kontakt.tel5%type;
   v_strasse              proj_kontakt.strasse%type;
   v_strasse2             proj_kontakt.strasse2%type;
   v_strasse3             proj_kontakt.strasse3%type;
   v_plz                  proj_kontakt.plz%type;
   v_stadt                proj_kontakt.stadt%type;
   v_bemerkung            proj_kontakt.bemerkung%type;
   v_land                 proj_kontakt.land%type;
   v_letzte_bearbeitung   proj_kontakt.letzte_bearbeitung%type;
   v_bearbeitung_durch    proj_kontakt.bearbeitung_durch%type;

   v_vanity               proj_kontakt.vanity%type;
   v_sip_user             proj_kontakt.sip_user%type;


   v_modus                Number(1);
   v_module_name          Varchar2(30) := 'PROJ_KONTAKT_DETAILS';
   v_error_mod1           Varchar2(80);
   v_error_mod2           Varchar2(80);
   v_mod_ret              Number(2);
   defaultgui             Varchar2(400) := dbfun$default_gui;
   defaultlang            Varchar2(400) := dbfun$default_lang;
   dateformat             Varchar2(40)  := ('DD.MM.YYYY HH24:MI');

  cursor c1 (l_firma_id in Number) is
  select Firmenname||' '||Stadt firma
       , id
       from proj_firma
       where ( l_firma_id = id or l_firma_id is null )
   order by firmenname;


 BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed(v_module_name );


  if v_modus > 0 then

   -- Delete
   if p_id is not null
    and p_do_delete is not NULL
    and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen
        v_fk_firma := p_fk_firma;
       delete PROJ_KONTAKT
        where id = v_id;
       commit;
   end if;
   -- delete

  if p_id is null and  p_fk_firma is not null then
    v_fk_firma := p_fk_firma;
  end if;

 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
if (p_id is not null)
 or  (p_do_insert is not null and p_id is null)
 or  (p_do_update is not null and p_id is not null)
  then
 -- Datensatz einfgen bzw. bernehmen
 -- Datensatz einfgen bzw. bernehmen
   v_id   :=  p_id ;
   v_fk_firma     :=  p_fk_firma ;
   v_anrede       :=  p_anrede ;
   v_vorname      :=  p_vorname ;
   v_nachname     :=  p_nachname ;
   v_zusatz       :=  p_zusatz ;
   v_email        :=  p_email ;
   v_tel1         :=  p_tel1 ;
   v_tel2         :=  p_tel2 ;
   v_tel3         :=  p_tel3 ;
   v_tel4         :=  p_tel4 ;
   v_tel5         :=  p_tel5 ;
   v_strasse      :=  p_strasse ;
   v_strasse2     :=  p_strasse2 ;
   v_strasse3     :=  p_strasse3 ;
   v_plz          :=  p_plz ;
   v_stadt        :=  p_stadt ;
   v_land         :=  p_land ;
   v_bemerkung    :=  p_bemerkung ;
   v_letzte_bearbeitung   :=  p_letzte_bearbeitung ;
   v_bearbeitung_durch    :=  p_bearbeitung_durch ;
   v_sip_user             :=  p_sip_user;
end if;


if p_do_insert is not null
and v_modus > 1 -- min 2!
then


--SEQUENCE !!!!!!
  select seq_kontakt.nextval into v_id from dual;
  insert into proj_kontakt
   (
              id
        ,     fk_firma
        ,     anrede
        ,     vorname
        ,     nachname
        ,     zusatz
        ,     email
        ,     tel1
        ,     tel2
        ,     tel3
        ,     tel4
        ,     tel5
        ,     strasse
        ,     strasse2
        ,     strasse3
        ,     plz
        ,     stadt
        ,     land
        ,     bemerkung
        ,     letzte_bearbeitung
        ,     bearbeitung_durch
        ,     vanity
        ,     sip_user
          ) values (
            v_id
        ,   v_fk_firma
        ,   v_anrede
        ,   v_vorname
        ,   v_nachname
        ,   v_zusatz
        ,   v_email
        ,   dbfun$format_tel(v_tel1)
        ,   dbfun$format_tel(v_tel2)
        ,   dbfun$format_tel(v_tel3)
        ,   dbfun$format_tel(v_tel4)
        ,   dbfun$format_tel(v_tel5)
        ,   v_strasse
        ,   v_strasse2
        ,   v_strasse3
        ,   v_plz
        ,   v_stadt
        ,   v_land
        ,   v_bemerkung
        ,   sysdate
        ,   user --v_bearbeitung_durch
        ,   dbfun$string2Vanity ( v_nachname)
        ,   v_sip_user
        );
  commit;
  end if;
  -- Insert ??


-- UPDATE
  if p_do_update is not null
   and p_id is not null
   and v_modus > 1
    then
     v_id := p_id;

     update proj_kontakt
      set
       fk_firma   =  v_fk_firma
     , anrede     =  v_anrede
     , vorname    =  v_vorname
     , nachname   =  v_nachname
     , zusatz     =  v_zusatz
     , email      =  v_email
     , tel1       =  dbfun$format_tel(v_tel1)
     , tel2       =  dbfun$format_tel(v_tel2)
     , tel3       =  dbfun$format_tel(v_tel3)
     , tel4       =  dbfun$format_tel(v_tel4)
     , tel5       =  dbfun$format_tel(v_tel5)
     , strasse    =  v_strasse
     , strasse2   =  v_strasse2
     , strasse3   =  v_strasse3
     , plz        =  v_plz
     , stadt      =  v_stadt
     , land       =  v_land
     , bemerkung  =  v_bemerkung
     , letzte_bearbeitung         =  sysdate    --v_letzte_bearbeitung
     , bearbeitung_durch          =  user --v_bearbeitung_durch
     , vanity      = dbfun$string2Vanity ( nachname)
     , sip_user    = v_sip_user
    where id = v_id;
    commit;

    -- oh, es hat sich jemand eine neue SIP-User-Kennung eingetragen...
    if nvl(p_old_sip_user,'0') != v_sip_user then
     -- dann mssen wir ggf. sein telefon nachregisitrieren...
     -- man knnte in einer spteren Funktion noch prfen, ob der User auch bezglich Email-Adresse bereinstimmt...
     -- nchstes Release...
     begin
      update proj_aastra_register
       set proj_user = upper(user)
        where sip_user = v_sip_user
          and letzte_aktivitaet > sysdate -1;
       commit;
      exception when others then
        -- Telefon bzw. SIP_USER war noch nicht aktiv...
        null;
      end ;
    end if;
 end if; -- Update ??

  if     (p_do_insert <> 'insert' or p_do_insert is NULL)
     and (p_do_delete <> 'delete' or p_do_delete is NULL)
     and  p_id is not null
  then
    v_id               := p_id;
   select
    fk_firma
  , anrede
  , vorname
  , nachname
  , zusatz
  , email
  , tel1
  , tel2
  , tel3
  , tel4
  , tel5
  , strasse
  , strasse2
  , strasse3
  , plz
  , stadt
  , land
  , bemerkung
  , letzte_bearbeitung
  , bearbeitung_durch
  , vanity
  , sip_user
  into
   v_fk_firma
  , v_anrede
  , v_vorname
  , v_nachname
  , v_zusatz
  , v_email
  , v_tel1
  , v_tel2
  , v_tel3
  , v_tel4
  , v_tel5
  , v_strasse
  , v_strasse2
  , v_strasse3
  , v_plz
  , v_stadt
  , v_land
  , v_bemerkung
  , v_letzte_bearbeitung
  , v_bearbeitung_durch
  , v_vanity
  , v_sip_user
     from proj_kontakt
     where id = v_id;
 end if;


-- Ab hier wird die Webpage gerendert
  htp.p('<HTML>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

  -- HTML-Include fr das Men
  htp.p(dbfun$projtoolbar2js);

  htp.p(' <link rel=''stylesheet'' href=''/i/projekt/default/css/default.css'' type=''text/css''>');
  htp.p('<title>Projekt-DB | Kontakt-Details</title>');

  htp.p('</head>');
  htp.p('<BODY  BGCOLOR="#FFFFFF" LINK="#000000" VLINK="#000000" TEXT="#000000"');
  htp.p('    TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');

  htp.p (dbfun$projtoolbar(upper(v_module_name)
                               , v_modus
                               , null
                               )
          );

 -- if v_fk_Firma > 0 then
    htp.p('<div class="maintitle"> Kontakt </div>');
 -- else -- Ausleihgert
 --   htp.p('<div class="maintitle"> Gert </div>');
 -- end if;

  htp.p('<TABLE class="formtable" style="width:98%;">');
-- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method="get">');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type=hidden  name="p_id" value="'||v_id||'"/>');
 -- Neue Werte --


 if p_do_delete = 'delete' and p_do_delete is not null then
   htp.p ('<tr><td  class="tdlr"> ID:  </td>');
   htp.p ('      <td  class="tdv"> '||p_id ||'</td></tr>');
   htp.p ('<tr><td  class="tdlr"> Nachname:  </td>');
   htp.p ('      <td  class="tdv"> '||p_nachname ||'</td></tr>');


  htp.p ('<tr><td  class="tdv" colspan = 2><b> wurde gelscht </b></td></tr>');
 else


 -- if nvl(v_fk_Firma,1) > 0 then
   if nvl(v_fk_Firma, p_fk_Firma) is null then
      htp.p ('<tr><td  class="tdlor" align="right">Primre Firma  </td>');
     else
      htp.p ('<tr><td  class="tdlor" align="right">Primre Firma  '
             ||'<a href="proj_firma_details?p_id='||nvl(v_fk_Firma, p_fk_Firma)||'"><img src="/i/projekt/default/img/details.png" title="Firma-Details" alt="Firma-Details"border="no"> </td>');

   end if;

 -- else -- Baumaschine
 --   null;
  /*
   if nvl(v_fk_Firma, p_fk_Firma) is null then
      htp.p ('<tr><td  class="tdv" align="right">Primre Gruppe  </td>');
     else
      htp.p ('<tr><td  class="tdv" align="right">Primre Gruppe  '
             ||'<a href="xdb_Firma_details?p_id='||nvl(v_fk_Firma, p_fk_Firma)||'"><img src="../../tst/cust/but_edit_big.gif" title="Firma-Details" alt="Firma-Details" border="no"> </td>');
   end if;
  */
 -- end if;-- Ausleihgert
   htp.p ('<td  class="tdv"> <select name="p_fk_Firma" size=1 maxlength=80 width=40 style="width:220px">');
   if nvl(v_fk_firma,p_fk_firma) is null then
       htp.p (' <option value="" selected> keine Firma');
   end if;
   for ca1 in c1 (v_fk_Firma) loop
    htp.p (' <option value="'||ca1.id||'" '||dbfun$selected_opt(ca1.id,v_fk_Firma)||'>'||ca1.firma);
   end loop;
   htp.p (' <option value="" '||dbfun$selected_opt(null,v_fk_Firma)||'>');
   htp.p ('</select>');
   htp.p ('</td></tr>');


  if nvl(v_fk_Firma,1) > 0 then
   htp.p ('<tr><td  class="tdlor" align=right> Anrede  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_anrede" type="text" size=40 maxlength=200 value="'
     || v_anrede||'"></td></tr>');


   htp.p ('<tr><td  class="tdlor"> Vorname  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_vorname" type="text" size=40 maxlength=200 value="'
     || v_vorname||'"></td></tr>');


   htp.p ('<tr><td  class="tdlor" align=right> Nachname  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_nachname" type="text" size=40 maxlength=200 value="'
     || v_nachname||'"></td></tr>');


   htp.p ('<tr><td  class="tdlr" align=right> Zusatz (Dr., Prof.  etc.)   </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_zusatz" type="text" size=40 maxlength=200 value="'
     || v_zusatz||'"></td></tr>');

  -- SIP-User nur anbieten, wenn der User Mitarbeiter einer berechtigten Firma ist
  if v_fk_firma = 1 then -- nur zu dieser Firma
   htp.p ('<tr><td  class="tdlr" align=right> Aastra - SIP-User:</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_sip_user" type="text" size=40 maxlength=200 value="'
     || v_sip_user||'">(Wird als Login verwendet!)</td></tr>');
  end if;

  --

   htp.p ('<tr><td  class="tdlr" align=right><b> Email </b></td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_email" type="text" size=40 maxlength=200 value="'
     || v_email||'">');

   if v_email is not null then
     htp.p('<a href="mailto:'|| v_email||'"><img src="/i/projekt/default/img/mail_ico.gif" border="0" title="sende Email"></a>');
   end if;

   -- Wenn Rechte auf Projekte vorhanden sind, kann zu den Projekten, mit denen dieser Kontakt zu tun hat,
   -- hin navigiert werden
   if v_id is not null then
    if dbpck$main.fun$chk_module_allowed('PROJ_PROJEKT_DETAILS')> 1 then
       htp.p('<a href="proj_projekt_list?p_kontakt_id='||v_id||'">'
       ||' <img src="/i/projekt/default/img/search-16x16.gif" '
       ||' Title="[Projekte auflisten]" Alt="[Projekte auflisten]" border="no"></a> ');
    end if;
   end if;

   -- Formular weiter fr Telefonnummern aufbauen.
   -- Es sind 5 Felder fr Telefonnummern vorgesehen.
   -- ggf. erweitern... :-)

   htp.p('</td></tr>');
   htp.p ('<tr><td  class="tdlor"><b> Telefon  </b></td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_tel1" style="width:266px;"  type="text" size=40 maxlength=20 value="'
     || v_tel1
     ||'">'||dbfun$aastra_dial(v_id,v_tel1)
     ||'</td></tr>');

   htp.p ('<tr><td  class="tdlor"> Mobil  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_tel2" style="width:266px;" type="text" size=40 maxlength=20 value="'
     || v_tel2
     ||'">'||dbfun$aastra_dial(v_id,v_tel2)||'</td></tr>');

   htp.p ('<tr><td  class="tdlor"> FAX  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_tel3" style="width:266px;" type="text" size=40 maxlength=20 value="'
     || v_tel3
     ||'">'||dbfun$aastra_dial(v_id,v_tel3)||'</td></tr>');

   htp.p ('<tr><td  class="tdlor"> DECT (auf dem Bau oder Bro)  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_tel4" style="width:266px;" type="text" size=40 maxlength=20 value="'
     || v_tel4
     ||'">'||dbfun$aastra_dial(v_id,v_tel4)||'</td></tr>');

   htp.p ('<tr><td  class="tdlr"> sontiges Telefon </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_tel5" style="width:266px;" type="text" size=40 maxlength=20 value="'
     || v_tel5
     ||'">'||dbfun$aastra_dial(v_id,v_tel5)||'</td></tr>');


    -- Formular weiter fr die Adresse
   htp.p ('<tr><td  class="tdlor"><b> Addresse:</b>  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_strasse" style="width:266px;"  type="text" size=40 maxlength=400 value="'
     || v_strasse||'"></td></tr>');


   htp.p ('<tr><td  class="tdlor">  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_strasse2" style="width:266px;" type="text" size=40 maxlength=400 value="'
     || v_strasse2||'"></td></tr>');


   htp.p ('<tr><td  class="tdlor">  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_strasse3" style="width:266px;" type="text" size=40 maxlength=400 value="'
     || v_strasse3||'"></td></tr>');


   htp.p ('<tr><td  class="tdlr">PLZ, Ort:  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_plz" style="width:67px;" type="text" size=8 maxlength=6 value="'
     || v_plz||'">');
   htp.p ('   <input name="p_stadt" type="text" size=28 maxlength=200 value="'
     || v_stadt||'"></td></tr>');

   htp.p ('<tr><td  class="tdlor"> Bemerkung  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('   <input name="p_bemerkung" type="text" size=40 maxlength=400 value="'
       || v_bemerkung||'"></td></tr>');

--   htp.p ('<tr><td  class="tdlr"> Vanity-Kurzsuche (aus Nachname generiert!)  </td>');
--   htp.p ('      <td  class="tdv"> ');
--   htp.p ( v_vanity ||'</td></tr>');

   else
     -- Baumaschine (Angaben zu Baumaschinen, so das zu diesena auch Termine geplant werden knnen
     -- Terminplanung fr Baumaschinen
     -- noch offen
   null;
  end if; -- Ausleihgert







    htp.p ('<tr><td class="tdlr" colspan=2 align=right>');
    htp.p ('<span class="abc">fr Vanity-Suche:'|| v_vanity ||' eingeben </span> '||v_modus);

   if v_id is not Null then
     if v_modus > 1 then
       htp.p ('  <input type="submit" name ="p_do_update" value="'||dbfun$i18(defaultlang,'update')||'"/>');
      end if;
      if v_modus > 2 and user = 'XDBADM' then
       htp.p ('  <input type="submit" name ="p_do_delete" value="'||dbfun$i18(defaultlang,'delete')||'"/>');
      end if;
    end if;
   if v_id is NULL
      and v_modus > 1 then
      htp.p ('  <input type="submit" name ="p_do_insert" value="'||dbfun$i18(defaultlang,'insert')||'">');
   end if;
   htp.p (' </td></tr>');
 end if; -- do_delete
   htp.p (' </form>');

  -- Button zurck:
  htp.p ('</TD></TR>');
  htp.p('</TABLE>');
  else -- v-modus =0
  htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;



 htp.p('</BODY>');
 htp.p('</HTML>');
exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PROJ_KONTAKT_DETAILS           TO PROJ_RO;

GRANT EXECUTE      ON PROJ_KONTAKT_DETAILS           TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PROJ_KONTAKT_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE proj_kontakt_list (  p_fk_firma    in Number    default null
                                              , p_width         in Number    default 800
                                              , p_suche        in Varchar2  default null
                                              , p_suche_tel    in Varchar2  default null
                                              , p_suche_module in Varchar2  default null
                                              , p_format        in varchar2  default null
                                               )
as

--[VERS:2007-02-07]
-- Fr Liste der Kontakte

 -- Ansprechpartner aus allgemeiner Suchmaske  suchen
 cursor c1 (c_fk_firma in number, c_suche in varchar2, c_suche_tel in varchar2) is
   select
      c.id
    , decode(vorname,vorname, vorname||' '||nachname,nachname ) kontakt_name
    , nvl(nvl(c.email,tel1),tel2) contact
    , c.email
    , nvl(c.tel1,c.tel2) telephone
  --  , substr(x.firmenname,1,80)||'('||x.stadt||')' firma
    , x.id firma_id
   from proj_kontakt c
      , proj_firma   x
     where ((fk_firma = c_fk_firma and  c_fk_firma is not null )
            or  c_fk_firma is null  )
      and ((upper(nachname) like c_suche||'%' and c_suche is not null)
            or c_suche is null)
      and (  c_suche_tel is null or
            (
             ( tel1 like c_suche_tel and c_suche_tel is not null and tel1 is not null)
              or
             ( tel2 like c_suche_tel and c_suche_tel is not null and tel2 is not null)
              or
             ( tel3 like c_suche_tel and c_suche_tel is not null and tel3 is not null)
              or
             ( tel4 like c_suche_tel and c_suche_tel is not null and tel4 is not null)
              or
             ( tel5 like c_suche_tel and c_suche_tel is not null and tel5 is not null)
            )

                      )
      and c.fk_firma = x.id(+)
           --    telephone_private
           --    telephone_additional
           --    mobile_additional
    order by nachname;

/*
   -- Ansprechpartner aus meinen Projekten
  cursor c2 (l_worker_id in Number) is
   select distinct
      c.id
    , decode(vorname,nvl(vorname,'-'),substr(vorname,1,1)||'. ')||nachname kontakt_name
    , nvl(nvl(email_address_business,telephone_business),mobile_business) contact
    , email_address_business
    , nvl(telephone_business,mobile_business) telephone
    , substr(x.firmenname,1,80)||'('||x.stadt||')' firma
    , x.id firma_id
    , c.nachname
   from proj_kontakt c
      , proj_firma x
     where l_worker_id = t.fk_worker
      and  (t.fk_customer_contact = c.id
          or t.fk_opener  = c.id)
      and c.fk_firma = x.id(+)
      and fk_ticket_state not in (4)
   order by nachname;
*/

  -- Zugriffsverwaltung
  v_modus         Number(1);
  v_module_name   Varchar2(20) := 'PROJ_KONTAKT_LIST';

  -- Formatierung
  v_firmenname           Varchar2(400); -- da wird der name der Firma reingebaut

  -- Suchfunktion
  v_suche         Varchar2(200) := upper(substr(p_suche    ,1,200));
  v_suche_tel     Varchar2(20)  := upper(substr(p_suche_tel ,1,20));
  v_counter        Number(10)    := 0; -- anch 100 Datenstzen wird abgebrochen !!

  v_user_id        Number(10);

  kund             Varchar2(2) := chr(38);
  nbsp             Varchar2(10) := kund||'nbsp;';
  v_dummy          Number(10) :=0;

  v_link           Varchar2(500);

  --fr Files:
  v_blob_content     xdb_tst_files.blob_content%TYPE;
 -- v_filename       Varchar2(255);
 -- myblob           Blob;
 -- v_mime_type      xdb_tst_files.mime_type%TYPE;
  v_bfile            UTL_FILE.file_type;
  l_text             VARCHAR2(32767);

BEGIN
 v_modus := dbpck$main.fun$chk_module_allowed(v_module_name);

   if p_fk_firma is not null then
    null;
    begin
     select  ' der Firma '||firmenname||' '||'('||stadt||')' into v_firmenname
         from proj_firma
         where id = p_fk_firma;
     exception when others then null;
    end;
   end if;


 if v_modus > 0 then

 if p_format is not null and p_format in ('word','excel','powerpoint') then
   owa_util.mime_header('application/vnd.ms-'||p_format,FALSE);

   if p_format = 'word' then
     htp.p('Content-disposition: attachment;filename=Kontakte_'||p_fk_firma||'.doc');
   end if;

   if p_format = 'xls' then
     htp.p('Content-disposition: attachment;filename=Kontakte_'||p_fk_firma||'.xls');
   end if;

   if p_format = 'powerpoint' then
     htp.p('Content-disposition: attachment;filename=Kontakte_'||p_fk_firma||'.ppt');
   end if;

   owa_util.http_header_close;
 end if;
  -- HTTP-Session ffen
   htp.p ('<HTML>');
   htp.p ('<head>');
   htp.p ('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p ('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  -- HTML-Include fr das Men
 if p_format is null then
   htp.p(dbfun$tickettoolbar2js);
 end if;

   if p_format is null then
     htp.p (' <link rel="stylesheet" href="../../cmdb/cust/default.css" type="text/css">');
   else
     null;
     -- read the CSS-File
   begin
   -- v_bfile := BFILENAME('XDBFUTIL', 'default.css');
    htp.p('<style type="text/css">');
    v_bfile := UTL_FILE.fopen('XDBFUTIL', 'default.css', 'r', 32767);

    -- Read and output first line.
    UTL_FILE.get_line(v_bfile, l_text, 32767);
    htp.p( l_text );

    -- Read through the file until we reach the last line.
    BEGIN
     LOOP
       UTL_FILE.get_line(v_bfile, l_text, 32767);
       htp.p (l_text);
     END LOOP;
    EXCEPTION
     WHEN NO_DATA_FOUND THEN
       NULL;
    END;
    -- Close the file.
   UTL_FILE.fclose(v_bfile);

   exception when others then
    htp.p('Error on WPG_DOCLOAD');
    htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);

   end;
    htp.p('</style>');
   end if;


   htp.p ('<title>Kontakte</title>');

   htp.p ('</head>');
   htp.p ('<BODY>');

 if p_format is null then
   htp.p (dbfun$tickettoolbar(upper(v_module_name)
                                , v_modus
                                , dbpck$main.fun$get_akt_benutzer
                                )
           );
 end if;

   htp.p ('<div class="maintitle"> Ansprechpartner-Liste '
       ||v_firmenname||'</div>');




  if p_fk_firma is not null and p_format is null then

  htp.p ('<div style="text-align:right;">');


  htp.p (' <a  href="proj_kontakt_list?p_fk_firma='||p_fk_firma||kund||'p_format=excel"> [XLS-Export] </a>');
  htp.p (' |<a href="proj_kontakt_list?p_fk_firma='||p_fk_firma||kund||'p_format=word"> [DOC-Export] </a>');
  htp.p('</div>');

 end if;

  IF     p_fk_firma    is null
      and p_suche        is null
      and p_suche_tel    is null
      and p_suche_module is null
      then
        -- CURSOR C2 ffnen
        v_user_id := DBFUN$USER_CONTACT_ID;
        htp.p ('<br><h1>Ansprechpartner zu aktuellen Tickets</h1>');
      --  htp.p('<tr><td>');
        htp.p(' <table class="listtable" style="width:100%;">');
        htp.p('  <tr>');
        htp.p('    <td width="80"  class="tdh">              Name    </span></td>');
        htp.p('    <td width="40"  class="tdh" align="center"><span class="ft">              -      </span></td>');
        htp.p('    <td width="120" class="tdh"><img src="../../cmdb/img/tool/webcall.png" style="height:14px;width:14px;" title="webcall"> Telefon </TD>');
        htp.p('    <td width="120" class="tdh"> Email </span></td>');
        htp.p('    <td width="80"  class="tdh"> Firma </span></td>');
        htp.p('    <td width="20"  colspan="3" class="tdh" align="center"><span class="ft"> Edit </span></td>');
        htp.p('  </tr>');
        for ca2 in c2(v_user_id)
         loop
         v_link  := '<A href="proj_kontakt_details?p_id=' ||ca2.id||'">';
         v_dummy := v_counter;

        if v_counter < 50 then
         htp.p('  <tr>');
         htp.p('    <td class="tdlist'||mod(v_dummy,2)||'" >'
         || v_link
         ||ca2.kontakt_name
         ||'</a></TD>');
         htp.p('    <td class="tdlist'||mod(v_dummy,2)||'" >'
         ||'<A HREF="xdb_ticket_list?p_contact_id='
         ||ca2.id||'">'
         ||'<img src="/tst/cust/ticketlist.gif" Border="NO" Alt="Ticket-List">'
         ||'</A></span></TD>');

         htp.p('    <td class="tdlist'||mod(v_dummy,2)||'">'
         || dbfun$get_contact_tel (ca2.id));
         htp.p('     </td>');

         htp.p('     <td class="tdlist'||mod(v_dummy,2)||'" >'
         ||'<A HREF="mailto:'
         ||ca2.email_address_business||'" title="Send Email" alt="Details">'
         ||ca2.email_address_business --contact
         ||'</A></TD>');

         htp.p('     <td class="tdlist'||mod(v_dummy,2)||'" >');
          if  ca2.firma_id is not null then
           htp.p(' <a href="proj_firma_details?p_id='||ca2.firma_id||'">'
           ||'<span class="ft">'
           ||ca2.firma
           ||'</span></a>');
          end if;
         htp.p('     </td>');

         htp.p('     <td class="tdlist'||mod(v_dummy,2)||'" ><A HREF="proj_kontakt_DETAILS?p_id='
         ||ca2.ID||'"><img src="../../tst/cust/but_edit_big.gif" BORDER="NO" title="Edit Details" Alt="Details"></A>');
         htp.p('     </td>');

         htp.p('     <td class="tdlist'||mod(v_dummy,2)||'" >');
         if v_modus_ticket_details> 1 then
           htp.p('      <a href="xdb_ticket_details?p_do_insert=insert'||kund||'p_fk_customer_contact='||ca2.id||'"><img src="../../tst/cust/but_new_ticket.gif" ALT="[Neues Ticket ffnen]" TITLE="Neues Ticket zum Ansprechpartner ffnen" Border="No"> </a>');
         else
           null;
         end if;

         if v_modus_av_details> 1 then
           htp.p('      <a href="xdb_av_details?p_do_insert=insert'||kund||'p_fk_customer_contact='||ca2.id||'"><img src="../../tst/cust/but_new_av.gif" ALT="[Neue AV ffnen]" TITLE="Neue AV zum Ansprechpartner ffnen" Border="No"> </a>');
         else
           null;
         end if;
         htp.p('    </td>');

         htp.p('</tr>');
         v_counter := v_counter +1;
       end if; -- v_counter < 100
    end loop;
    htp.p('</table>');
 else -- wie alte Version


    if p_fk_firma is not null then
     if v_modus > 1  and p_format is null then

     htp.p(dbfun$html_button('Neuen Ansprechpartner ' --zu '||v_firma_name
        ||' erfassen','proj_kontakt_details?p_fk_firma='
        ||p_fk_firma,230));
  /*
     htp.p ('<div style="text-align:right;"><a href="proj_kontakt_details?p_fk_firma='
        ||p_fk_firma||'">[Neuen Ansprechpartner zu '||v_firma_name
        ||' erfassen]</a>');
   */
     end if;
   -- else
  --   htp.p ('<TR><TD><a href="proj_kontakt_details">Neuen Ansprechpartner erfassen</a></TD></TR>');
    end if;



   htp.p('<table class="listtable" style="width:98%;background-color:#FFFFFF;">');

   htp.p('    <TD width="80"  class="tdh"> Name </TD>');
  if p_format is null then
     htp.p('    <TD width="40"  class="tdh">'||nbsp ||'</TD>');
   end if;
  htp.p('     <td width="120" class="tdh">');

        if p_format is null then
        htp.p('<img src="../../cmdb/img/tool/webcall.png" style="height:14px;width:14px;" title="webcall"> ');
        end if;

        htp.p(' Telefon </TD>');



   htp.p('    <TD width="120" class="tdh"> Email </TD>');
   htp.p('    <TD width="80"  class="tdh"> Firma </TD>');
   if p_format is null then
     htp.p('    <TD width="20"  class="tdh" colspan="3">'||nbsp ||'</TD>');
   end if;
   htp.p('<tr>');
  v_counter :=1;


  for ca1 in c1(p_fk_firma, v_suche, dbfun$replace_tel_char(v_suche_tel))  loop
   v_dummy := v_counter;
   v_link  := '<a href="proj_kontakt_details?p_id=' ||ca1.ID||'">';

   if  (
         ((v_suche is not null  or v_suche_tel is not null) and p_fk_firma is null)
         or (v_suche is  null  and v_suche_tel is null and p_fk_firma is null)
         )
    then
     v_counter := v_counter +1;
  end if;
  if v_counter < 50 then
   htp.p('  <tr class="tdlist'||mod(v_dummy,2)||'">');


   if ca1.firma_id = 1 then
    htp.p(' <td class="tdlist'||mod(v_dummy,2)||'" style="background-image: url(../../cmdb/img/tool/bg_gn.gif);"> ');
   else
    htp.p(' <td class="tdlist'||mod(v_dummy,2)||'" > ');
    null;
   end if;

   htp.p(v_link||ca1.kontakt_name
      ||'</a>'
      ||'</td>');

 if p_format is null then
   if ca1.count_tickets  > 0 then
    htp.p('    <td  class="tdlist'||mod(v_dummy,2)||'">'
      ||'<a href="xdb_ticket_list?p_contact_id='
      ||ca1.id||'">'
      ||'<img src="/tst/cust/ticketlist.gif" Border="NO" Alt="aktuelle Tickets">'
      ||'</a></td>');
   else
       htp.p(' <td  class="tdlist'||mod(v_dummy,2)||'">'
      ||nbsp||'</td>');
   end if;
 end if; -- p_format

   htp.p('    <td class="tdlist'||mod(v_dummy,2)||'">');
   if p_format is null then
      htp.p ( dbfun$get_contact_tel (ca1.id));
   else
      htp.p ('call:'|| dbfun$get_callto_tel (ca1.id));
   end if;

   htp.p('     </td>');



   htp.p('     <td  class="tdlist'||mod(v_dummy,2)||'">'
      ||'<a href="mailto:'
      ||ca1.email||'" title="Sende Email" alt="Email an">'
      ||ca1.email --contact
      ||'</a>');
   htp.p('     </td>');

   htp.p('     <td  class="tdlist'||mod(v_dummy,2)||'">');
       if  ca1.firma_id is not null then
          htp.p(' <a href="proj_firma_details?p_id='||ca1.firma_id||'">'
           ||ca1.firma
           ||'</a>');
     end if;
   htp.p('     </td>');
  if p_format is null then
    htp.p('     <td colspan="2" class="tdlist'||mod(v_dummy,2)||'"><A href="proj_kontakt_details?p_id='
       ||ca1.ID||'"><img src="/cmdb/default/img/tool/details.png" BORDER="NO" title="Edit Details" Alt="Details"></A>');
  --  htp.p('     </td>');

--    htp.p('    <td class="tdlist'||mod(v_dummy,2)||'">');
     if v_modus_ticket_details> 1 then
       htp.p('<br> <a href="xdb_ticket_details?p_do_insert=insert'||kund||'p_fk_customer_contact_selected='||ca1.id||'">[Neues Ticket erffnen]</a>');
       htp.p('<br> <a href="proj_kontakt_details?p_id='||ca1.id||kund||'p_format=vcard">[Outlook-Export]</a>');

     else
      null;
     end if;

   htp.p('     </td>');
  end if; -- p_format
   htp.p('   </tr>');

   end if; -- v_counter < 100
   end loop;

   end if; -- Suchvorgaben waren vorhanden
  end if; -- Suchvorgabe fr Modul AV
  htp.p('  </table>');

  if v_counter > 99 then
   htp.p('     <br><H1>Zu viele Daten !!, die Liste wurde abgeschnitten !</h1>');
  end if;


 else -- v-modus =0
    htp.p (' <html><body><H1> no Accesss with Your Account ! </H1><BR>');
 end if;


 htp.p('</BODY>' );
 htp.p('</HTML>' );
end;
/


----------------------------------------------------------------
-- PROCEDURE PROJ_PROJEKT_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE proj_projekt_details
(
     p_id                   in Number     default NULL
   , p_fk_bauherr_selected  in Number     default NULL
   , p_fk_bauherr_select_1  in Number     default Null
   , p_fk_bauherr           in Varchar2   default Null
   , p_fk_bauherr_old       in Number     default NULL  -- Zur Speicherung der alten ID
   , p_fk_projekt_status    in Number     default NULL
   , p_fk_projekt_group     in Number     default NULL
   , p_projekt_name         in Varchar2   default NULL
   , p_aktueller_status     in Varchar2   default NULL --('new')
   , p_alt_aktueller_status     in Varchar2   default NULL --('new')

   , p_do_update            in varchar2   default ''
   , p_do_delete            in Varchar2   default ''
   , p_do_insert            in Varchar2   default ''
) as

--[VERS:2008-07-02]
  -- Historie:

-- lokale Variablen:
   v_id                     proj_projekt.id%type;
   v_fk_bauherr             proj_projekt.fk_bauherr%type;
   v_fk_projekt_status      proj_projekt.fk_projekt_status%type;
   v_startdatum             proj_projekt.startdatum%type;
   v_projekt_name           proj_projekt.projekt_name%type;
   v_aktueller_status       proj_projekt.aktueller_status%type;
   v_projekt_id             proj_projekt.projekt_id%type;

--   v_getcompcontact         varchar2(455):= substr(p_getcompcontact,1,255);
--
   v_letzte_bearbeitung     proj_projekt.letzte_bearbeitung%type;
   v_bearbeitung_durch      proj_projekt.bearbeitung_durch%type;

  -- Hilfsvariablen ????
   v_f_cust_contact         Varchar2(200) := substr(p_fk_bauherr,1,200);


   v_found_cust_contact     Number(10) :=0;
   v_found_cust_company     Number(10) :=0;

   v_modus                  Number(1);
   v_modul_name             Varchar2(30)  := 'PROJ_PROJEKT_DETAILS';

  -- Formatierung
   kund                     Varchar2(1)   := chr(38);
   nbsp                     Varchar2(5)   := chr(38)||'nbsp';
   v_field_width            Number(10)    := '440'; -- Pixel (px)

/*
   v_today_td               Varchar2(50)  := ' background-color:#6595FF" ';
   v_today_td4              Varchar2(50)  := ' background-color:#A0C0FF" ';
   v_today_td7              Varchar2(50)  := ' background-color:#D0E0FF" ';
   v_timed_format           Varchar2(50);
*/

/*  -- Fr Files
   v_file_url               Varchar2(600); -- name fr die URL
*/
   v_email            Varchar2(200);

   defaultgui         Varchar2(400) := dbfun$default_gui;
   defaultlang        Varchar2(400) := dbfun$default_lang;

   v_dateformat       Varchar2(40) := 'DD.MM.YYYY HH24:MI';
   v_dummy            Number(10):=0;


/* -- Fr Files:
  cursor c1 (l_id in number) is
  select
    f.name
  , f.mime_type
  , f.last_updated
  , f.doc_size
  , f.author
  , t.id
  , f.external_blob
    from  xdb_tst_files  f
        , proj_projekt_action_files  z
        , proj_projekt_action t
    where f.name             = z.filename
      and z.fk_projekt_action = t.id
      and t.fk_projekt        = l_id
    order by f.last_updated desc;

  v_filecounter     Number(10):=0;  -- Zhler fr die Files
*/

  v_real_name       varchar2(255);

  CURSOR c2 (l_filter in Varchar2, l_id in Number, l_co_id in Number) is
   select * from
  ( select c.id
   , substr(decode(vorname,nvl(vorname,'-'),substr(vorname,1,1)||'.')||nachname||' / ' ||co.firmenname,1,80)  Kontakt
   , nachname
   , co.firmenname
   , co.id firmen_id
   from proj_kontakt c
      , proj_firma co
   where ((l_filter is not null and upper(nachname) like l_filter||'%') or l_filter is null)
    and  ((l_id is not null and c.id=l_id) or l_id is null)
    and  c.fk_firma = co.id (+)
      union all
   select null id,  null contact,  '-'  main_name, null company_name1, null company_id from dual
  ) x order by nachname;

 -- Projekt-Status
 cursor c6 is
  select  to_number (w.kurztext) id
  , langtext
   from xdb_werte w, xdb_wertebereiche wb
  where w.wb_id = wb.id
    and wb.name = 'projekt_status'
  order by id;



BEGIN

 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed ( v_modul_name );

 if v_modus > 0 then

  -- Delete , es wird der aktuelle Datensatz gelscht!
  if p_id is not null
   and p_do_delete is not NULL
  -- and p_do_delete = 'delete'
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen
   --     v_fk_opener := p_fk_opener;
     delete proj_projekt
   where id = v_id;
    commit;
  end if; -- delete


 -- Allgemein
 -- wenn nicht gelscht wird, - oder ein Insert durchgefhrt werden soll dann:
if (p_id is not null)
 or  (p_do_insert IS NOT NULL and p_id is null)
 or  (p_do_update IS NOT NULL)
-- or  (p_getcontactcomp is not null)
  then
 -- Datensatz einfgen bzw. bernehmen
   v_id                      :=  p_id ;
   v_fk_bauherr              :=  nvl(p_fk_bauherr_selected,nvl(p_fk_bauherr_select_1,-99)) ;
   v_fk_projekt_status       :=  p_fk_projekt_status ;
   v_projekt_name            :=  nvl(p_projekt_name,'Bitte g'||kund||'uuml;ltige Projektbeschreibung angeben!!') ;
   v_aktueller_status        :=  nvl(p_aktueller_status,'neu');

end if;


if p_do_insert is not null --= 'insert'
 and v_modus > 1 -- min 2!
 then

 --SEQUENCE !!!!!!
  select seq_projekt.nextval into v_id from dual;
    v_letzte_bearbeitung := sysdate;
    v_startdatum         := sysdate;

  -- Projekt_ID bestimmen
  -- diese kann z.B. in Emails als Referenz verwendet werden
  -- da das Feld in der DAtenbank eindeutig ist, kann man darber einen
  -- eindeutigen Bezeichner zusammenbauen
  -- ... nchste Zeile kann an die jeweilige Kundenumgebung angepat werden
  v_projekt_id := nvl(v_projekt_id,'[PROJ-'||lpad(v_id,5,'0')||']');


  insert into proj_projekt
  (
      id
 ,    fk_bauherr
 ,    fk_projekt_status
 ,    startdatum
 ,    projekt_name
 ,    aktueller_status
 ,    letzte_bearbeitung
 ,    bearbeitung_durch
 ,    projekt_id
   ) values (
      v_id
 ,    v_fk_bauherr
 ,    v_fk_projekt_status
 ,    sysdate --v_date_opened
 ,    v_projekt_name
 ,    v_aktueller_status
 ,    sysdate -- letzte Bearbeitung
 ,    user    -- Bearbeitung durch
 ,    v_projekt_id      -- ggf. customizen
 );
  commit;

  v_startdatum := sysdate;

  end if; -- Insert ??


-- UPDATE
  if p_do_update is not  null
   and p_id is not null
   and v_modus > 1
    then
    v_id := p_id;
    v_letzte_bearbeitung := sysdate;

    -- ggf. anpassen an die jeweilige Kundenumgebung!!
    v_projekt_id         := nvl(v_projekt_id,'[PROJ-'||lpad(v_id,5,'0')||']');

   if p_alt_aktueller_status !=   v_aktueller_status then --('new')
    insert into proj_projekt_aktuelles_log
     ( id
     , letzte_bearbeitung
     , bearbeitung_durch
     , aktueller_status
     , fk_projekt_status )
     values
     ( v_id
     , sysdate
     , user
     , v_aktueller_status
     , v_fk_projekt_status
     );
   end if;

   update proj_projekt
    set
       fk_bauherr         =  v_fk_bauherr
     , fk_projekt_status  =  v_fk_projekt_status
     , projekt_name       =  v_projekt_name
     , aktueller_status   =  v_aktueller_status
     , letzte_Bearbeitung =  sysdate --v_letzte_Bearbeitung
     , Bearbeitung_durch  =  user
     , projekt_id         =  v_projekt_id
    where id   = v_id;
   commit;
 end if; -- Update ??


  if   p_id is not null
  then
    v_id               := p_id;
   select
      fk_bauherr --bauherr
    , fk_projekt_status
    , startdatum
    , projekt_name
    , aktueller_status
    , projekt_id
    , letzte_bearbeitung
    , bearbeitung_durch
  into
      v_fk_bauherr
    , v_fk_projekt_status
    , v_startdatum
    , v_projekt_name
    , v_aktueller_status
    , v_projekt_id
    , v_letzte_Bearbeitung
    , v_bearbeitung_durch
    from proj_projekt
 where id = v_id;
 end if;

  v_letzte_bearbeitung := nvl(v_letzte_bearbeitung,v_startdatum);

 -- htp.p(dbfun$ddt);

  htp.p('<html>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

  -- Include fr HTML-Header
  htp.p(dbfun$projtoolbar2js);
  htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||defaultgui||'/css/default.css'' type=''text/css''>');

  htp.p('  <script type="text/javascript">     ');
  htp.p('        var djConfig = { isDebug: false }; ');
  htp.p('  </script>                       ');
  htp.p('  <script type="text/javascript" src="/i/projekt/js/dojo_core/dojo.js"></script>     ');
  htp.p('  <script type="text/javascript">');
  htp.p('        dojo.require("dojo.widget.ComboBox");');
  htp.p('        dojo.require("dojo.widget.TabContainer");   ');
  htp.p('        dojo.require("dojo.widget.LinkPane");    ');
  htp.p('        dojo.require("dojo.widget.ContentPane");   ');
  htp.p('        dojo.require("dojo.widget.LayoutContainer");  ');
  htp.p('</script> ');


  htp.p('<title>Projekt | Projekt-Details</title>');


  htp.p(' <style type="text/css">');
  htp.p('  .dojoTabPaneWrapper { ');
  htp.p('    padding : 1px 1px 1px 1px; ');
  htp.p('  }');
  htp.p(' </style> ');

  htp.p('</head>');
  htp.p('<body>');

  -- Toolbar ber PLS-SQL Funktion einbinden
  htp.p (dbfun$projtoolbar(upper(v_modul_name)
                               , v_modus
                               , null --dbpck$main.fun$get_akt_benutzer
                               )
          );

  htp.p('<div class="maintitle">');
  if v_id is not null and p_do_delete is null then
    htp.p('Projekt-Details <i>'||dbfun$get_projekt_name(v_id)||'</i>');  --: '||v_id  ||' - '||to_char(v_startdatum,'MM/YYYY'));
  else
      htp.p('Projekt-Details');
  end if;
  htp.p('</div>');

  -- Container fr TAB-Reiter
  htp.p(' <div id="projektTabContainer" dojoType="TabContainer" style="background-color:#FFFFFF; '
  ||' position:absolute; top:66px; left:0px; width: 100%; height: 500px" selectedTab="tab1"> ');

  -- Erster TAB-Reiter
  htp.p('  <div id="tab1" dojoType="ContentPane" style="background-color:#FFFFFF;" label="Details">');


  htp.p (' <form id="form1" name="form1" action="'||lower(v_modul_name)||'" method="post">');

  htp.p('<table class="formtable" style="width:90%;margin:8px;">');

  -- Alte Werte
  htp.p ('  <!-- Alter Werte -->');
  htp.p ('  <input type=hidden  name="p_id" value="'||v_id||'"/>');
  -- Neue Werte --

   htp.p ('<tr>');
   htp.p ('    <td  class="tdlor" align="left">Projekt-Name  </td>');
   htp.p ('    <td  class="td"> ');
   htp.p ('      <input class="text" name="p_projekt_name" type="text" size="100" maxlength="400" value="'
     || v_projekt_name||'" style="width:'||v_field_width||'px;"></td></tr>');

  htp.p ('<tr><td class="tdlor">Projekt-ID.:</td>');
  htp.p ('    <td class="td"><b> '--||v_id
    ||v_projekt_id||'</b></td></tr>');


  if p_do_delete = 'delete' and p_do_delete is not null then
    htp.p ('<tr><td class="tdv" colspan="2"><b> wurde gelscht </b></td></tr>');
  else -- nicht gelscht


   -----------------------------------
   -- Bauherr
   -----------------------------------

    htp.p ('<tr><td class="tdlr">');
    if  v_fk_bauherr != -99 and v_fk_bauherr is not null then
      htp.p ('       <a href="proj_kontakt_details?p_id='||v_fk_bauherr||'">Bauherr</a>');
    else
      htp.p ('         Bauherr');
    end if;
    htp.p ('    <td class="tdv"> ');
    htp.p ('     <div id="div1_fk_bauherr"');

    if v_fk_bauherr is not null or v_fk_bauherr=-99 then
      htp.p('       style="visibility:visible; position:relative; top:0px;left:0px; height:25px;" ');
    else
      htp.p('       style="visibility:hidden; position:relative; top:0px;left:0px;" ');
    end if;
    htp.p ('    >');

    if v_fk_bauherr is not null and v_fk_bauherr !=-99 then

      htp.p ('      <select name="p_fk_bauherr_select_1" size="1" maxlength="200" '
      ||' style="width:'||v_field_width||'px;" '
      ||' onchange="if (this.selectedIndex==0){div1_fk_bauherr.style.visibility=''hidden'';div_fk_bauherr.style.visibility=''visible'';div_fk_bauherr.style.top=div1_fk_bauherr.style.top;}"'
      ||'>');

      for ca2 in c2(null,v_fk_bauherr,1) loop
        if ca2.id is null then
          htp.p ('         <option value=""> Zuordnung lschen');
        else
          htp.p ('         <option value="'||ca2.id||'" '||dbfun$selected_opt(v_fk_bauherr ,nvl(ca2.id,-199))||'> '||ca2.kontakt);
        end if;
      end loop;
      htp.p ('      </select>');

    end if;

   -- bernahmefeld soll angeboten werden
     if v_id is not NULL
      and v_fk_bauherr is not null
      and v_fk_bauherr != -99
      and v_modus > 1 then

        v_email := dbfun$get_kontakt_email (v_fk_bauherr);

        if v_email is not null then

          htp.p('       <a href="mailto:'|| v_email
            ||'?subject='||substr(v_projekt_name,1,180)||' '||v_projekt_id
            ||kund||'bcc=projekt@telonic.de'
            ||'">'
            ||'<img src="/i/projekt/'||defaultgui||'/img/mail_ico.gif" width="20" height="17" border="0" title="sende Email mit Betreff"></a>');
        end if;

/*        -- Kurznotiz bzw. Telefonnotiz einfgen
        htp.p('        <a href="proj_kurznotiz_details'
            ||'?p_fk_projekt_id='||v_id
            ||kund||'p_do_insert=insert'
            ||kund||'p_fk_bauherr='||v_fk_bauherr
            ||'">'
            ||'<img src="/i/projekt/'||defaultgui||'/img/telnotiz.gif" width="40" height="17" border="0" title="Kurznotiz einfgen"></a>');
*/
        htp.p('<table><tr><td>'||dbfun$get_kontakt_tel (v_fk_bauherr)||'</td></tr></table>');
      end if;
    htp.p ('    </div>');

    htp.p ('   <div id="div_fk_bauherr"');
    if v_fk_bauherr is null or v_fk_bauherr = -99 then
      htp.p('       style="visibility:visible; position:relativ;  position:relative; top:0px;left:0px;" ');
    else
      htp.p('       style="visibility:hidden;  position:relative; left:0px;" ');
    end if;
    htp.p('     > ');

    htp.p ('         <select name="p_fk_bauherr" DojoType="ComboBox" value="2kjsdhfgsdkfjg" '
    ||' autoComplete="false"  dataUrl="ajax_such_kontakt?p_search=%{searchString}" '
    ||' maxListLength="15" mode="remote"  style="width:'||v_field_width||'px;">');
    htp.p ('      </select>');
    htp.p ('   </div>');
    htp.p ('  </td></tr>');

   htp.p ('<tr><td class="tdlor" align="left"> Status </td>');
   htp.p ('      <td class="td">');
   htp.p ('<select name="p_fk_projekt_status" size="1" maxlength="22" width="50" '
   ||' style="width:'||v_field_width||'px;">');
   for ca6 in c6 loop

   htp.p (' <option style="border-bottom: 1px solid #E0E0E0; background-image: url( ''/i/projekt/default/img/'
   ||dbfun$get_werte ('projekt_status_img', ca6.id )
   ||''' );height: 22px; background-repeat: no-repeat; background-position: 1px 1px;" value="'
   ||ca6.id||'" '||dbfun$selected_opt(v_fk_projekt_status ,ca6.id)
     ||'> '||nbsp||' '||nbsp||' '||nbsp||' '||nbsp||' '||ca6.langtext);

   end loop;

   htp.p ('</select></td></tr>');


   htp.p ('<tr><td  class="tdlor" align="left"> Geffnet / Zuletzt bearbeitet am  </td>');
   htp.p ('      <td  class="td"> ');
   htp.p ('         '||to_char(v_startdatum,'DD.MM.YYYY HH24:MI')
                     ||' / '||to_char(v_letzte_Bearbeitung,'DD.MM.YYYY HH24:MI'));
   htp.p('</td></tr>');


   htp.p ('<tr>');
   htp.p ('  <td  class="tdlor" align="left"> Aktuelles </td>');
   htp.p ('  <td  class="td"> ');
   -- einmal zwischenspeichern!
   htp.p ('    <input  class="hidden" name="p_alt_aktueller_status" type="hidden" value="'
     || v_aktueller_status||'">');

   htp.p ('    <input  class="text" name="p_aktueller_status" type="text" size="40" maxlength="100" value="'
     || v_aktueller_status||'" style="width:'||v_field_width||'px"></td></tr>');

   htp.p ('<tr><td colspan="2" align="right">');
   if v_id is not Null then
   -------------------

     if v_modus > 1 then
       htp.p ('  <input type="submit" name ="p_do_update" value="'||dbfun$i18(defaultlang,'update')||'"/>');
      end if;
      -- neu ab 15.12.2004
      if v_modus > 2
       and user = 'XDBADM'
        and v_fk_projekt_status in (4) -- geschlossen , neu ab 15.12.2004
        then
       htp.p ('  <input type="submit" name ="p_do_delete" value="'||dbfun$i18(defaultlang, 'delete')||'"/>');
      end if;
    end if;
   if v_id is NULL
      and v_modus > 1 then
      htp.p ('  <input type="submit" name ="p_do_insert" value="insert">');
   end if;
   htp.p('  </td></tr>');
 end if; -- do_delete
--   htp.p('  <tr><td width="'||(v_width-20)||' valign="top" colspan="2"> <hr> </td></tr>');
   htp.p(' </table>');
   htp.p(' </form>');

  --- iframe mit der Liste der letzten nderungen (Felder Aktuelles , Status,  User + Datum)
   htp.p('  nderungshistorie (Aktuelles)');

  htp.p('<iframe src="po_projekt_aktuelles?p_fk_projekt_id='||v_id||'" style="width:98%;border=no;" class="tdlr"></iframe>');

   htp.p('</div>');

-- Neues DIV anfangen

   htp.p(' <div id="tab2" dojoType="ContentPane" label="Projektphasen">');
  -- Liste der projekt-Aktionen:
  if v_id is not null then
   htp.p('<iframe src="po_projektphasen_list?p_fk_projekt_id='||v_id||'" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
   NULL;
  end if;


 htp.p('</div>');

 htp.p(' <div id="tab3" dojoType="ContentPane" label="Fragen" style="height:100%;"> ');
  if v_id is not null then
   htp.p('<iframe src="po_projekt_fragen_list?p_id='||v_id||'" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
   NULL;
  end if;
 htp.p('</div>');


 htp.p(' <div id="tab4" dojoType="ContentPane" label="Adress und Kontaktliste fr Bauherr" style="height:100%;"> ');
  if v_id is not null then
   htp.p('<iframe src="po_projekt_subs_list?p_fk_projekt_id='||v_id||'" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
   NULL;
  end if;
 htp.p('</div>');


 htp.p(' </div>'); -- Panel
---------------------

 else -- v-modus =0
  htp.p (' <HTML><BODY><H1> No Access </H1>');
 end if;


 htp.p(' </BODY>');
 htp.p('</HTML>');
exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PROJ_PROJEKT_DETAILS           TO PROJ_RO;

GRANT EXECUTE      ON PROJ_PROJEKT_DETAILS           TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PROJ_PROJEKT_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE proj_projekt_list

 (  p_firma_id                   in Number    default null -- Filter auf die Firma
  , p_such_projekt               in Varchar2  default null -- Lst eine Volltextsuche nach Projekten aus
  , p_kontakt_id                 in Number    default null -- Filter auf diesen Kontakt
  , p_such_projekt_id            in varchar2  default null -- fr Suche ber die Projektnummer
  , p_such_projekt_name          in Varchar2  default null -- Filter auf dieses Projekt
  , p_such_bauherr               in Varchar2  default null
  , p_such_startdatum            in Varchar2  default null
  , p_such_letzte_Bearbeitung    in Varchar2  default null
  , p_order1                     in Varchar2  default null
  , p_order2                     in Varchar2  default null
  , p_debug                      in Varchar2  default null
  -- neu
  , p_such_status                in varchar2  default null
  , p_such_status_info           in varchar2  default null
  , x                            in Number    default null -- Dummy
  , y                            in Number    default null -- Dummy
  , p_nur_offen                  in Number    default 1

  )

as
--[VERS:2008-07-03]

-- Ziel:
-- Generiert Liste der Projekte

-- Autor: Erich Heinemann
-- Kln

 -- Suche aller passenden Projekte
 -- dynamisches SQL
  sql_string1       Varchar2(4000);
  TYPE r_cur_t1     IS REF Cursor;
  r_cur1            r_cur_t1;


 -- DBMS_SQL
 -- cursor1        INTEGER;
 -- handle1        INTEGER;



  cursor c1 is
  select
    p.id
  , fk_bauherr
  , k.Vorname ||' '||k.nachname||decode(k.stadt,null,'',k.stadt,' ('||k.stadt||')','') Bauherr
  , p.aktueller_status
  , p.projekt_name
  , p.letzte_bearbeitung
  , fk_projekt_status
  , dbfun$get_werte     ('projekt_status',p.fk_projekt_status) projekt_status
  , p.projekt_id
  , dbfun$get_werte     ('projekt_status_farbe',p.fk_projekt_status) status_farbe
  , dbfun$get_werte_memo('projekt_status_farbe',p.fk_projekt_status) status_farbe_text
  , p.startdatum
  from proj_projekt p, proj_kontakt k
  where p.fk_bauherr = k.id (+)
    and fk_projekt_status != 4
  ;
  -- dynamic-SQL

  ca1                c1%rowtype;

 -- Vorladen der verschiedenen Farben fr die HTML-DIVs
 cursor c2 is
 select w.kurztext, w.langtext
   from xdb_werte  w
      , xdb_wertebereiche wb
  where wb.id   =  w.wb_id
    and wb.name =  'projekt_status_farbe'
  ;


  -- Zugriffsverwaltung
  v_modus            Number(1);
  v_module_name      Varchar2(30) := 'PROJ_PROJEKT_LIST';

  -- Formatierung
  kund               varchar2(2)  := chr(38);
  v_severity_str     Varchar2(255);

  -- Fr die Suchfunktionen
  v_such_projekt_id  Varchar2(255); -- :=  '%'||substr(p_such_projekt_nr,1,20)||'%';
  v_dummy            Number(10)     :=1;

  v_order_form       Varchar2(4000);
  v_order1           Varchar2(200);
  v_order2           Varchar2(200);
  v_link             Varchar2(400);
  v_td_string        Varchar2(2000);

BEGIN

 begin


  v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

  if v_modus > 0 then

   v_order_form := '<form  action="'||lower(v_module_name)||'" method="post" style="white-space:nowrap">';
   if p_kontakt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_kontakt_id" value="'||p_kontakt_id||'"/>';
   end if;


   if p_such_projekt_name is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_projekt" value="'||p_such_projekt_name||'"/>';
   end if;

   if p_such_projekt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_projekt_id" value="'||p_such_projekt_id||'"/>';
   end if;

    if p_such_status is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_status" value="'||p_such_status||'"/>';
   end if;


 -- Alte Sortierung nach hinten schieben !!
 -- Dieser Parameter hilft, dass die vorletzte Sortierung nicht ganz verloren geht.
 -- Erst die dritte Auswahl einer Sortierreihenfolge lscht die vorletzte!
   if p_order1 is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_order2" value="'||p_order1||'"/>';
   end if;

-- Suche auch nach abgeschlossenen Bauprojekten
   if p_nur_offen <> 1 then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_only_open" value="0"/>';
   end if;

  sql_string1 := 'select * from ( '
 ||' select    p.id   '||chr(10)
 ||' , fk_bauherr '
 ||' , k.Vorname ||'' ''||k.nachname||decode(k.stadt,null,'''',k.stadt,'' (''||k.stadt||'')'','''') Bauherr '||chr(10)
 ||' , p.aktueller_status  '||chr(10)
 ||' , p.projekt_name    '||chr(10)
 ||' , p.letzte_bearbeitung  '||chr(10)
 ||' , fk_projekt_status  '||chr(10)
 ||' , dbfun$get_werte     (''projekt_status'',p.fk_projekt_status) projekt_status  '||chr(10)
 ||' , p.projekt_id    '||chr(10)
 ||' , dbfun$get_werte     (''projekt_status_farbe'',p.fk_projekt_status) status_farbe  '||chr(10)
 ||' , dbfun$get_werte_memo(''projekt_status_farbe'',p.fk_projekt_status) status_farbe_text '||chr(10)
 ||' , p.startdatum          '||chr(10)
 ||' from proj_projekt p, proj_kontakt k '||chr(10)
 ||' where p.fk_bauherr = k.id (+)'||chr(10) ;

-- ||'   and fk_projekt_status != 4'||chr(10);


 if p_kontakt_id is not null then
   sql_string1 := sql_string1 ||' and ' || p_kontakt_id||'  = p.fk_bauherr ';
 end if;
 -- ??? muss erweitert werden, da in einem Projekt und Phasen zustzliche Personen involviert werden knnen


 if p_such_projekt_id is not null then
   sql_string1 := sql_string1 ||' and (p.projekt_id like ''%'||p_such_projekt_id ||'%''';
   sql_string1 := sql_string1 ||' or p.id||'''' like ''%'||p_such_projekt_id ||'%'')';
  else
   if p_nur_offen = 1  then  -- Wenn nicht abgeschlossene (4) Projekte gesucht werden!
     sql_string1 := sql_string1 ||' and p.fk_projekt_status not in (4)'||chr(10);
   end if;
 end if;

  if p_such_status is not null then
   sql_string1 := sql_string1 ||' and upper(dbfun$get_werte(''projekt_status'',p.fk_projekt_status)) like ''%'||upper(p_such_status)||'%'' ';
  end if;

  if p_such_bauherr is not null then
   sql_string1 := sql_string1 ||' and (upper(nachname) like ''%'||upper(p_such_bauherr)||'%'' or  ';
   sql_string1 := sql_string1 ||'      upper(stadt) like ''%'||upper(p_such_bauherr)||'%'' )  ';

  end if;


  if p_such_projekt_id is not null then
   sql_string1 := sql_string1 ||' and ( p.projekt_id      like ''%'||p_such_projekt_id ||'%'' ';
   sql_string1 := sql_string1 ||'   or  upper(nachname) like ''%'||upper(p_such_projekt_id )||'%'' ) ';
  end if;

  -- Suchfeld fr das Status-Bemerkungsfeld
  if p_such_status_info is not null then
   sql_string1 := sql_string1 ||' and upper(p.aktueller_status) like ''%'||upper(p_such_status_info)||'%'' ';
  end if;

  if p_such_projekt_name is not null then
   sql_string1 := sql_string1 ||' and ( upper(p.projekt_name) like ''%'||upper(p_such_projekt_name) ||'%'')' ||chr(10);
  end if;

 -- hier noch ein Block, womit eine Volltextsuche ber alle Felder gestartet wird
  if p_such_projekt is not null then
   sql_string1 := sql_string1 ||' and ( upper(p.projekt_name) like ''%'||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(p.aktueller_status) like ''%'  ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(k.plz) like ''%'        ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(k.stadt) like ''%'      ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'     )' ||chr(10);
 end if;
 -- Ende des Subselect einfgen
 sql_string1 := sql_string1 ||') x ';
-- .. sicher, so ein dynamisches SQL bietet nicht die beste Performance, ist aber irgendwie im Sourcecode nachvollziehbar.
-- Besser wre es, dieses Statement ber Bind-Variablen zu bauen. ... beim nchsten mal. :-)


 -- ORDER-BY einfgen
 if p_order1 is not null then
  sql_string1 := sql_string1 ||' order by '||dbfun$get_werte('projekt_list_order',p_order1);
  if p_order2 is not null then
  sql_string1 := sql_string1 ||' , '||dbfun$get_werte('projekt_list_order',p_order2);
  end if;
  else -- Sortierung nach letzter nderung desc
  sql_string1 := sql_string1 ||' order by letzte_bearbeitung desc';

 end if;

   -- HTTP-Session ffen
    htp.p('<HTML>');
    htp.p('<head>');
    htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
    htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

   -- Include fr HTML-Header
    htp.p(dbfun$projtoolbar2js);

    htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||dbfun$default_gui||'/css/default.css'' type=''text/css''>');
    htp.p('<title>Projekte | Projekt-Liste</title>');
    htp.p('</head>');
    htp.p('<BODY>');

    htp.p (dbfun$projtoolbar(upper(v_module_name)
                                , v_modus
                                , null --dbfun$get_akt_benutzer (dbfun$get_akt_benutzer_id)
                                )
           );

    if p_such_projekt_id is null and  p_such_projekt is null then
      htp.p('<div class="maintitle">bersicht laufende Projekte</div>');
    else
      htp.p('<div class="maintitle"> Projekte, <i>Filter, Projekte entsprechend '
          ||nvl(p_such_projekt_id,p_such_projekt)||'</i></div>');
    end if;

 -- die 2 anchfolgenden DIVS werden versteckt um die Styles fr das Highlighting beim Hover-Effekt zu steuern
   htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">x</div>');
   htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">x</div>');

 -- DIVs fr die unterschiedlichen Severities
 -- Die Farben fr die Severities werden in einer WErteliste ausgelesen und dann verstekct vorgehalten
  for ca2 in c2 loop
   htp.p('<div id="tdlistSeverities'||ca2.kurztext||'_0" style="visibility:hidden;top:0px;height:0px;background-color:'
   ||ca2.langtext||';">x</div>');
   htp.p('<div id="tdlistSeverities'||ca2.kurztext||'_1" style="visibility:hidden;top:0px;height:0px;background-color:'
   ||dbfun$mod_color(ca2.langtext,15)||';">x</div>');
  end loop;


    -- neue Tabelle fr die Liste des HTML-Mens
    htp.p(' <table class="listtable" style="width:98%;">');
    htp.p('  <tr>');

    htp.p('    <TD width="330" class="tdh"  style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="1"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/sort_down.gif" ');
    htp.p('      alt="Sort by projekt-Description" title="Nach dieser Spalte sortieren" Border="NO">');
    htp.p('      Projekt-Name</form>');
    htp.p('    </TD>');

    htp.p('  <td width="30" class="tdh" style="border-bottom-width:1px;">');
    htp.p('      '||v_order_form ||'<input type="hidden"  name="p_order1" value="2"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/sort_down.gif" ');
    htp.p('      alt="Nach dieser Spalte sortieren" title="Nach dieser Spalte sortieren" Border="NO">');
    htp.p('      Status</form>');
    htp.p('  </td>');

    -- es knnte auf Projekte zu einem bestimmten Kontakt gefiltert werden
    -- dann wird dieser Bauherr fest dargestellt:
    if p_kontakt_id is not null then
    -- Hier sollte noch eine Grafik fr Filter einfgen
      htp.p('    <td width="150" class="tdh" style="border-bottom-width:1px;">Bauherr</td>');
    else



     -- sonst wird einfach ein Sortierbutton angeboten
       htp.p('  <td width="150" class="tdh"  style="border-bottom-width:1px;" >');
       htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="3"/>');
       htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/sort_down.gif" ');
       htp.p('     alt="Nach dieser Spalte sortieren" title="Nach dieser Spalte sortieren" Border="NO">');
       htp.p('     Bauherr</form>');
       htp.p('</td>');
    end if;

    htp.p('    <td width="120" class="tdh" style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="4"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/sort_down.gif" ');
    htp.p('      alt="Nach dieser Spalte sortieren" title="Nach dieser Spalte sortieren" Border="NO">');
    htp.p('      Projekt-ID</form>');

    htp.p(' </TD>');

    htp.p('    <TD width="60" class="tdh"  style="border-bottom-width:1px;">');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="5"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/sort_down.gif" ');
    htp.p('      alt="Nach dieser Spalte sortieren" title="Nach dieser Spalte sortieren" Border="NO">');
    htp.p('      Startdatum</form>');
    htp.p('    </TD>');

    htp.p('    <TD width="60" class="tdh"  style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="6"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/sort_down.gif" ');
    htp.p('      alt="Nach dieser Spalte sortieren" title="Nach dieser Spalte sortieren" Border="NO">');
    htp.p('      letzte<br>nderung</form>');
    htp.p('    </TD>');


    htp.p('    <TD class="tdh" colspan="2" style="width:80px;border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="7"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/sort_down.gif" ');
    htp.p('      alt="Nach dieser Spalte sortieren" title="Nach dieser Spalte sortieren" Border="NO">');
    htp.p('      Aktuelles</form>');
    htp.p('    </td>');
    htp.p('</tr>');



   htp.p('<tr>');
   -- Filter-Zeile fr neue Suche einfgen!!
   -- Suchfelder zusammenbauen
   htp.p(' <form  action="'||lower(v_module_name)||'" method="get" style="white-space:nowrap">');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_name" type="text" size=38 maxlength=400 value="'
     || p_such_projekt_name ||'"></td>');


   htp.p('   <TD class="tdheader">');
   htp.p(     ' <input name="p_such_status" type="text" size=5 maxlength=400 value="'
     || p_such_status ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_bauherr" type="text" size=16 maxlength=400 value="'
     || p_such_bauherr ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_id" type="text" size=16 maxlength=20 value="'
     || p_such_projekt_id ||'"></td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_startdatum" type="text" size=19 maxlength=10 value="'
     || p_such_startdatum  ||'"></td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_letzte_Bearbeitung" type="text" size=10 maxlength=10 value="'
     || p_such_letzte_Bearbeitung ||'"></td>');



   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_status_info" type="text" size=18 maxlength=400 value="'
     || p_such_status_info ||'"></td>');

   htp.p('    <td class="tdheader" >'
         ||'<input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/such.png" ');
   htp.p('     alt="Suchen" title="Suchen" Border="NO">');
   htp.p('   </td>');

   htp.p('   </form>');
   htp.p('   </tr>');

   -------------------------------------

   if  p_such_projekt_id is not null then
      v_such_projekt_id :=  '%'||substr(p_such_projekt_id,1,20)||'%';
   end if;

  v_dummy := 1;

  -- SQL-Statement ausfhren
  open r_cur1 for sql_string1;
  loop
  fetch r_cur1 into ca1;
   exit when r_cur1%notfound;

   -- Der Style wird in der Liste zwischen den Datenstzen und dem Status des Projektes jeweils umgeschaltet
   -- Daher wird der Link vorher definiert und der Rohbau einer Tabellenzelle (<TD>) vorab je Zeile definiert
   v_link  :=   '<a href="proj_projekt_details?p_id='||ca1.id||'">';
   v_dummy :=  v_dummy +1;

   if v_dummy < 3050 then


    if instr(ca1.status_farbe,'#',1) > 0 then
        v_td_string :=  '    <td style="text-valign: middle;" onmouseover="tr'||v_dummy
        ||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy||'.style.backgroundColor=tdlistSeverities'
        ||ca1.projekt_status||'_'||mod(v_dummy,2)||'.style.backgroundColor;" '
        ||' >';
      htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" style="text-valign: bottom;background-color: '
      ||dbfun$mod_color(ca1.status_farbe,mod(v_dummy,2)*15)||';" id="tr'||v_dummy||'">');-- class="tdlist'||mod(v_dummy,2)||'" onmouseover="this.style.backgroundColor=''#FFFF00'';" onmouseout="this.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;">');
    else
       v_td_string :=  '    <td onmouseover="tr'||v_dummy||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'
       ||v_dummy||'.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;" '
                 ||' >';
    htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" id="tr'||v_dummy||'" style="text-valign: center;">');
    end if;

   -- Spalte "Projekt-Name"
   htp.p ( v_td_string
     || v_link
     ||ca1.projekt_name
     ||'</a></td>');


   -- Spalte fr den Status als Text oder Icon
   htp.p ( v_td_string
      ||v_link||
      '<img src="/i/projekt/default/img/'||dbfun$get_werte ('projekt_status_img', ca1.fk_projekt_status )||'" border="no">'
      ||dbfun$get_werte ('projekt_status', ca1.fk_projekt_status )
      --dbfun$projekt_status_img(ca1.fk_projekt_status)
      ||'</a></td>');

   -- Spalte fr den Bauherrn
   htp.p ( v_td_string ||v_link||ca1.bauherr
     ||'</a>'
     -- Telefonnummern auflisten
     ||DBFUN$GET_KONTAKT_TEL(ca1.fk_bauherr,'<br>')||'</td>');

   -- reset der Einstellung
   v_severity_str := '';

   -- Spalte "Projekt-ID"
   htp.p( v_td_string ||v_link||'<b>'||nvl(ca1.projekt_id,'[PROJ-'||lpad(ca1.id,5,'0')||']')
     ||'</b>'
     ||'</a></td>');

   -- Spalte "Startdatum"
   htp.p (v_td_string ||v_link
     ||to_char(ca1.Startdatum,'DD.MM.YY')||'<br>'
     ||to_char(ca1.Startdatum,'Hh24:MI')
     ||'</a></td>');

   -- Spalte "Letzte Bearbeitung"
   htp.p (v_td_string --    <td class="tdlist'||mod(v_dummy,2)||'"   '||v_severity_str||'>'
     ||v_link
     ||to_char(ca1.letzte_bearbeitung,'DD.MM.YY')||'<br>'
     ||to_char(ca1.letzte_bearbeitung,'Hh24:MI')
     ||'</a></td>');

   -- Spalte "Aktueller Status"
   htp.p ( v_td_string
     || v_link
     ||ca1.aktueller_status
     ||'</a></td>');


   htp.p( v_td_string --'     <td class="tdlist'||mod(v_dummy,2)||'" align="right" >'
   ||v_link
   ||'<img src="/i/projekt/'||dbfun$default_gui||'/img/details.png" BORDER=NO></A></TD>');
   htp.p('   </tr>');

   else -- v_dummy <150
    htp.p('   <tr>');
    htp.p('     <td colspan="9"> Zu viele Datenstze!!! Abgeschnitten ab Nr.'||v_dummy||'! </td>');
    htp.p('   </tr>');
   end if; -- v_dummy <150

   end loop;
    CLOSE r_cur1;

   htp.p('   </table>');

 else -- v-modus =0
    htp.p ('  <html><body><h1> no Accesss with Your Account ! </h1><br>');
 end if;


 htp.p('  </body>' );
 htp.p(' </html>' );

end;
 exception when others
 then
    htp.p ('SQL-Error '||sqlerrm ||' / '|| sqlcode );

    if v_modus != null and v_modus > 2 then
      htp.p ('<br>'||chr(10)||sql_string1);
    end if;

end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PROJ_PROJEKT_LIST              TO PROJ_RO;

GRANT EXECUTE      ON PROJ_PROJEKT_LIST              TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PROJ_PROJEKTBETEILIGUNG_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE proj_projektbeteiligung_list -- p_fk_projekt_id

 (  p_fk_firma_id                in Number    default null -- Filter auf die Firma
  , p_order1                     in Varchar2  default null
  , p_order2                     in Varchar2  default null
  , p_debug                      in Varchar2  default null
  , x                            in Number    default null -- Dummy
  , y                            in Number    default null -- Dummy
  )

as
--[VERS:2008-07-24]

-- Ziel:
-- Generiert Liste der Projektphasen die von einer Firma ausgefhrt werden sollen

-- noch offen:
-- Autor: Erich Heinemann

 -- Suche aller passenden Projekte
 -- dynamisches SQL
  sql_string1       Varchar2(4000);
  TYPE r_cur_t1     IS REF Cursor;
  r_cur1            r_cur_t1;


 -- DBMS_SQL
  cursor c1
   is
  select
    id
  , phasen_name
  , projekt_abschnitt
  , startdatum
  , enddatum
  , aktueller_status
  , letzte_bearbeitung
  , bearbeitung_durch
  , fk_projekt_id
  from proj_projektphase
    where fk_projekt_id = 1 -- damit es schnell geht!
   order by nvl(startdatum,letzte_bearbeitung)

  ;
  -- dynamic-SQL

  ca1                c1%rowtype;

/* -- Vorladen der verschiedenen Farben fr die HTML-DIVs
 cursor c2 is
 select w.kurztext, w.langtext
   from xdb_werte  w
      , xdb_wertebereiche wb
  where wb.id   =  w.wb_id
    and wb.name =  'projekt_status_farbe'
  ;
*/

  -- Zugriffsverwaltung
  v_modus            Number(1);
  v_module_name      Varchar2(30) := 'PROJ_PROJEKTBETEILIGUNG_LIST';

  -- Formatierung
  kund               varchar2(2)  := chr(38);
--  v_severity_str     Varchar2(255);

  -- Fr die Suchfunktionen
  v_such_projekt_id  Varchar2(255);
  v_dummy            Number(10)     :=1;

  v_order_form       Varchar2(4000);
  v_order1           Varchar2(200);
  v_order2           Varchar2(200);
  v_link             Varchar2(400);
  v_td_string        Varchar2(2000);



  v_error            Varchar2(800);
  defaultgui         Varchar2(400) := dbfun$default_gui;
  defaultlang        Varchar2(400) := dbfun$default_lang;
  dateformat         Varchar2(40)  := ('DD.MM.YYYY'); -- hier nur Tagesdatum


BEGIN

 begin


  v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

  if v_modus > 0 then

   v_order_form := '<form  action="'||lower(v_module_name)||'" method="post" style="white-space:nowrap">';


 -- Alte Sortierung nach hinten schieben !!
 -- Dieser Parameter hilft, dass die vorletzte Sortierung nicht ganz verloren geht.
 -- Erst die dritte Auswahl einer Sortierreihenfolge lscht die vorletzte!
   if p_order1 is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_order2" value="'||p_order1||'"/>';
   end if;

-- Suche auch nach abgeschlossenen Bauprojekten

  sql_string1 := 'select * from ( '||chr(10)
 ||' select   id            '||chr(10)
 ||' , phasen_name          '||chr(10)
 ||' , projekt_abschnitt    '||chr(10)
 ||' , startdatum           '||chr(10)
 ||' , enddatum             '||chr(10)
 ||' , aktueller_status     '||chr(10)
 ||' , letzte_bearbeitung   '||chr(10)
 ||' , bearbeitung_durch    '||chr(10)
 ||' , p_fk_projekt_id      '||chr(10)
 ||' from proj_projektphase '||chr(10)
 ||'  where fk_firma =      '|| p_fk_firma_id ||chr(10);


 -- Ende des Subselect einfgen
 sql_string1 := sql_string1 ||') x ';
-- .. sicher, so ein dynamisches SQL bietet nicht die beste Performance, ist aber irgendwie im Sourcecode nachvollziehbar.
-- Besser wre es, dieses Statement ber Bind-Variablen zu bauen. ... beim nchsten mal. :-)


 -- ORDER-BY einfgen
 if p_order1 is not null then
  sql_string1 := sql_string1 ||' order by '||dbfun$get_werte('PROJEKTPHASEN_LIST_ORDER',p_order1);
  if p_order2 is not null then
  sql_string1 := sql_string1 ||' , '||dbfun$get_werte('PROJEKTPHASEN_LIST_ORDER',p_order2);
  end if;
  else -- Sortierung nach letzter nderung desc
  --sql_string1 := sql_string1 ||' order by nvl(startdatum,letzte_bearbeitung) desc';
  null;
 end if;

   -- HTTP-Session ffen
    htp.p('<HTML>');
    htp.p('<head>');
    htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
    htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

   -- Include fr HTML-Header
    htp.p(dbfun$projtoolbar2js);

    htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||dbfun$default_gui||'/css/default.css'' type=''text/css''>');
    htp.p('<title>Projekte | Projektphasen</title>');
    htp.p('</head>');
    htp.p('<BODY>');

    htp.p (dbfun$projtoolbar(upper(v_module_name)
                                , v_modus
                                , dbpck$main.fun$get_akt_benutzer
                                )
           );

 --   if p_such_projekt_id is null and  p_such_projekt is null then
      htp.p('<div class="maintitle">Projektbeteiligungen der Firma '||'<b>'
      || dbfun$get_firmen_name(p_fk_firma_id)
    --  ||'<a href="proj_projekt_details?p_id='||p_fk_projekt_id||'" border="NO">'
      ||'<img src="/i/projekt/'||dbfun$default_gui||'/img/tool/details.png" ALT="Details" BORDER=NO>' --</a>'
      ||'</b>');

    --  if v_modus > 2 then
    --  --  htp.p ('<a href="proj_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id||'" target="_blank"> Neue Phase einfgen </a>');
    --    htp.p(dbfun$html_button ('proj_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id,'Neue Phase einfgen'));

    --  end if;

      htp.p('</div>');
 --   else
 --     htp.p('<div class="maintitle"> Projektphasen, <i>Filter, Projekte entsprechend '
 --         ||nvl(p_such_projekt_id,p_such_projekt)||'</i></div>');
 --   end if;

 -- die 2 anchfolgenden DIVS werden versteckt um die Styles fr das Highlighting beim Hover-Effekt zu steuern
   htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">x</div>');
   htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">x</div>');

/*
 -- DIVs fr die unterschiedlichen Severities
 -- Die Farben fr die Severities werden in einer WErteliste ausgelesen und dann verstekct vorgehalten
  for ca2 in c2 loop
   htp.p('<div id="tdlistSeverities'||ca2.kurztext||'_0" style="visibility:hidden;top:0px;height:0px;background-color:'
   ||ca2.langtext||';">x</div>');
   htp.p('<div id="tdlistSeverities'||ca2.kurztext||'_1" style="visibility:hidden;top:0px;height:0px;background-color:'
   ||dbfun$mod_color(ca2.langtext,15)||';">x</div>');
  end loop;
*/


    htp.p(' <table class="listtable" style="width:98%;">');

    -- Header-Zeile aufbauen
    htp.p('  <tr>');

    htp.p('  <td width="30" class="tdh" style="border-bottom-width:1px;">');
    htp.p('      '||v_order_form ||'<input type="hidden"  name="p_order1" value="1"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Phase" title="Sortierung nach Phase" Border="NO">');
    htp.p('      Name</form>');
    htp.p('  </td>');

    htp.p('  <td width="150" class="tdh"  style="border-bottom-width:1px;" >');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="2"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sortierung nach Projektabschnitt" title="Sortierung nach Projektabschnitt" Border="NO">');
    htp.p('     Projektabschnitt</form>');
    htp.p('  </td>');

    htp.p('  <td width="120" class="tdh" style="border-bottom-width:1px;" >');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="3"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sortierung nach Startdatum" title="Sortierung nach Startdatum" Border="NO">');
    htp.p('     Startdatum</form>');
    htp.p('  </td>');

    htp.p('  <td width="60" class="tdh"  style="border-bottom-width:1px;">');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="4"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sorierung nach Enddatum" title="Sorierung nach Enddatum" Border="NO">');
    htp.p('     Enddatum</form>');
    htp.p('  </td>');

    htp.p('  <td width="60" class="tdh"  style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="5"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Status" title="Sortierung nach Status" Border="NO">');
    htp.p('      Status</form>');
    htp.p('    </td>');

    htp.p('  <td width="60" class="tdh" colspan="2" style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="6"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Bearbeitung" title="Sortierung nach Bearbeitung" Border="NO">');
    htp.p('      Bearbeitung</form>');
    htp.p('    </td>');


    htp.p('</tr>');



  /*
   htp.p('<tr>');
   -- Filter-Zeile fr neue Suche einfgen!!
   -- Suchfelder zusammenbauen

   htp.p(' <form  action="'||lower(v_module_name)||'" method="get" style="white-space:nowrap">');
   htp.p('   <TD class="tdheader">');
   htp.p(     ' <input name="p_such_status" type="text" size=5 maxlength=400 value="'
     || p_such_status ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_bauherr" type="text" size=16 maxlength=400 value="'
     || p_such_bauherr ||'">Bauherr</td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_id" type="text" size=16 maxlength=20 value="'
     || p_such_projekt_id ||'">Projekt-ID</td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_startdatum" type="text" size=19 maxlength=10 value="'
     || p_such_startdatum  ||'">startdatum</td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_letzte_Bearbeitung" type="text" size=10 maxlength=10 value="'
     || p_such_letzte_Bearbeitung ||'"></td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_name" type="text" size=38 maxlength=400 value="'
     || p_such_projekt_name ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_status_info" type="text" size=18 maxlength=400 value="'
     || p_such_status_info ||'"></td>');

   htp.p('    <td class="tdheader" >'
         ||'<input type="image" src="../../projekt/'||dbfun$default_gui||'/img/tool/such.png" ');
   htp.p('     alt="Suchen" title="Suchen" Border="NO">');
   htp.p('   </td>');

   htp.p('   </form>');
   htp.p('   </tr>');

   -------------------------------------

   if  p_such_projekt_id is not null then
      v_such_projekt_id :=  '%'||substr(p_such_projekt_id,1,20)||'%';
   end if;
  */


  v_dummy := 1;

  -- SQL-Statement ausfhren
  open r_cur1 for sql_string1;
  loop
  fetch r_cur1 into ca1;
   exit when r_cur1%notfound;

   -- Der Style wird in der Liste zwischen den Datenstzen und dem Status des Projektes jeweils umgeschaltet
   -- Daher wird der Link vorher definiert und der Rohbau einer Tabellenzelle (<TD>) vorab je Zeile definiert
   v_link :=   '<a href="proj_projektphase_details?p_id='||ca1.id||'">';
    v_dummy :=  v_dummy +1;

   if v_dummy < 3050 then
 --   if instr(ca1.status_farbe,'#',1) > 0 then
 --       v_td_string :=  '    <td style="text-valign: middle;" onmouseover="tr'||v_dummy
 --       ||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy||'.style.backgroundColor=tdlistSeverities'
 --       ||ca1.projekt_status||'_'||mod(v_dummy,2)||'.style.backgroundColor;" '
  --      ||' >';
  --    htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" style="text-valign: bottom;background-color: '
  --    ||dbfun$mod_color(ca1.status_farbe,mod(v_dummy,2)*15)||';" id="tr'||v_dummy||'">');-- class="tdlist'||mod(v_dummy,2)||'" onmouseover="this.style.backgroundColor=''#FFFF00'';" onmouseout="this.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;">');
  --  else
       v_td_string :=  '    <td onmouseover="tr'||v_dummy||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'
       ||v_dummy||'.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;" '
                 ||' >';
    htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" id="tr'||v_dummy||'" style="text-valign: center;">');
  --  end if;

   -- Spalte fr den Status
 --  htp.p ( v_td_string
 --     ||v_link||dbfun$projekt_status_img(ca1.fk_projekt_status)||'</a></td>');

   -- Spalte fr Phasen_Name
   if ca1.phasen_name != 'PHASE' then
       htp.p ( v_td_string ||'<b>' || v_link||ca1.phasen_name   ||'</b></a>'||'</td>');
   else
       -- Beteiligte Personen aufzhlen und als Phasen-Name anzeigen z.B. "Tiefbau Mller GmbH"
       htp.p ( v_td_string ||'<i>' || v_link||ca1.phasen_name   ||'</i></a>'||'</td>');
   end if;

   -- Spalte fr Phasen_Name
   htp.p ( v_td_string ||v_link||ca1.Projekt_Abschnitt   ||'</a>'||'</td>');


   -- Spalte fr Startdatum
   htp.p( v_td_string ||v_link||'<b>'||to_char(ca1.startdatum,dateformat)||'</b>'
     ||'</a></td>');

   -- Spalte fr das Enddatum
   htp.p (v_td_string ||v_link   ||to_char(ca1.enddatum,dateformat)||'<br>'
     ||'</a></td>');

   -- Spalte "Aktueller_Status"
   htp.p (v_td_string --    <td class="tdlist'||mod(v_dummy,2)||'"   '||v_severity_str||'>'
     ||v_link
     ||ca1.aktueller_Status
     ||'</a></td>');


   -- Spalte "Letzte Bearbeitung"
   htp.p (v_td_string --    <td class="tdlist'||mod(v_dummy,2)||'"   '||v_severity_str||'>'
     ||v_link
     ||to_char(ca1.letzte_bearbeitung,'DD.MM.YYYY Hh24:MI') ||' / '|| ca1.bearbeitung_durch
     ||'</a></td>');


   htp.p( v_td_string --'     <td class="tdlist'||mod(v_dummy,2)||'" align="right" >'
   ||v_link
   ||'<img src="/i/projekt/'||dbfun$default_gui||'/img/tool/details.png" BORDER=NO></A></TD>');
   htp.p('   </tr>');

   else -- v_dummy <150
    htp.p('   <tr>');
    htp.p('     <td colspan="9"> Zu viele Datenstze!!! Abgeschnitten ab Nr.'||v_dummy||'! </td>');
    htp.p('   </tr>');
   end if; -- v_dummy <150

   end loop;
    CLOSE r_cur1;

   htp.p('   </table>');

 else -- v-modus =0
    htp.p ('  <html><body><h1> no Accesss with Your Account ! </h1><br>');
 end if;


 htp.p('  </body>' );
 htp.p(' </html>' );

end;
 exception when others
 then
    htp.p ('SQL-Error '||sqlerrm ||' / '|| sqlcode );

  --  if v_modus != null and v_modus > 2 then
      htp.p ('<br>'||chr(10)||sql_string1);
  --  end if;

end;
/


----------------------------------------------------------------
-- PROCEDURE PROJ_PROJEKTPHASE_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE PROJ_PROJEKTPHASE_DETAILS
(
     p_id                 in Number   default NULL
  ,  p_startdatum         in Varchar2 default NULL
  ,  p_enddatum           in Varchar2 default NULL
  ,  p_phasen_name        in Varchar2 default 'Phase'
  ,  p_projekt_abschnitt  in Varchar2 default NULL
  ,  p_aktueller_status   in Varchar2 default NULL
  ,  p_fk_projekt_id      in Number   default NULL -- muss immer durch eine Aufrufende Maske mitgeschickt werden !!!!
--  ,  p_letzte_bearbeitung in Date     default NULL
--  ,  p_bearbeitung_durch  in Varchar2 default NULL
  ,  p_beschreibung       in Varchar2 default NULL
  ,  p_do_update          in varchar2 default ''
  ,  p_do_delete          in Varchar2 default ''
  ,  p_do_insert          in Varchar2 default ''
) as

-- lokale Variablen:
   v_id                   proj_projektphase.id%type;
   v_startdatum           proj_projektphase.startdatum%type;
   v_enddatum             proj_projektphase.enddatum%type;
   v_phasen_name          proj_projektphase.phasen_name%type;
   v_projekt_abschnitt    proj_projektphase.projekt_abschnitt%type;
   v_aktueller_status     proj_projektphase.aktueller_status%type;
   v_fk_projekt_id        proj_projektphase.fk_projekt_id%type;
   v_letzte_bearbeitung   proj_projektphase.letzte_bearbeitung%type;
   v_bearbeitung_durch    proj_projektphase.bearbeitung_durch%type;
   v_beschreibung         proj_projektphase.beschreibung%type;

   v_modus                Number(1);
   v_module_name          Varchar2(30) := 'PROJ_PROJEKTPHASE_DETAILS';

   v_error                Varchar2(800);
   defaultgui             Varchar2(400) := dbfun$default_gui;
   defaultlang            Varchar2(400) := dbfun$default_lang;
   dateformat             Varchar2(40)  := ('DD.MM.YYYY'); -- hier nur Tagesdatum


 BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

  if v_modus > 0 then
   -- Delete
 if p_id is not null
   and p_do_delete is not NULL
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen um ihn spter nochmal anzuzeigen
        v_phasen_name := v_phasen_name;
     delete PROJ_PROJEKTPHASE
   where id = v_id;
    commit;
  end if; -- delete

 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
 if (p_id is not null)
  or  (p_do_insert is not null and p_id is null)
  or  (p_do_update is not null )
   then
  -- Datensatz einfgen bzw. bernehmen
    v_id                  :=  p_id ;

    begin
     v_startdatum          :=  to_date(p_startdatum,dateformat ) ;
    exception when others then
     v_error := 'Falsches Datumsformat fr Startdatum';
    end;

    begin
     v_enddatum            :=  to_date(p_enddatum,dateformat ) ;
    exception when others then
     v_error := 'Falsches Datumsformat fr Startdatum';
    end;

    v_phasen_name         :=  nvl(trim(p_phasen_name),'PHASE') ;
    v_projekt_abschnitt   :=  p_projekt_abschnitt ;
    v_aktueller_status    :=  p_aktueller_status ;
    v_fk_projekt_id       :=  p_fk_projekt_id ;
    v_letzte_bearbeitung  :=  sysdate; --p_letzte_bearbeitung ;
    v_bearbeitung_durch   :=  user; --p_bearbeitung_durch ;
    v_beschreibung        :=  p_beschreibung ;
 end if;


if p_do_insert is not null
  and v_modus > 1 -- mindestens muss Modus = 2 sein um etwas speichern zu drfen
    then

  --SEQUENCE !!!!!!
  select seq_projektphase.nextval into v_id from dual;
  -- Datensatz einfgen
  insert into proj_projektphase
   (          id
        ,     startdatum
        ,     enddatum
        ,     phasen_name
        ,     projekt_abschnitt
        ,     aktueller_status
        ,     fk_projekt_id
        ,     letzte_bearbeitung
        ,     bearbeitung_durch
        ,     beschreibung
          ) values (
              v_id
        ,     v_startdatum
        ,     v_enddatum
        ,     v_phasen_name
        ,     v_projekt_abschnitt
        ,     v_aktueller_status
        ,     v_fk_projekt_id
        ,     v_letzte_bearbeitung
        ,     v_bearbeitung_durch
        ,     v_beschreibung
        );
  commit;
  end if; -- Insert ??

-- UPDATE
  if p_do_update is not null
   and p_id is not null
   and v_modus > 0
    then
     v_id := p_id;
      update proj_projektphase
       set
       startdatum          =  v_startdatum
     , enddatum            =  v_enddatum
     , phasen_name         =  v_phasen_name
     , projekt_abschnitt   =  v_projekt_abschnitt
     , aktueller_status    =  v_aktueller_status
     , fk_projekt_id       =  v_fk_projekt_id
     , letzte_bearbeitung  =  v_letzte_bearbeitung
     , bearbeitung_durch   =  v_bearbeitung_durch
     , beschreibung        =  v_beschreibung
    where id   = v_id;
    commit;
 end if; -- Update ??

  if     ( p_do_insert is NULL)
     and ( p_do_delete is NULL)
     and  p_id is not NULL
  then
    v_id   := p_id;
    select
     startdatum
   , enddatum
   , phasen_name
   , projekt_abschnitt
   , aktueller_status
   , fk_projekt_id
   , letzte_bearbeitung
   , bearbeitung_durch
   , beschreibung
   into
     v_startdatum
   , v_enddatum
   , v_phasen_name
   , v_projekt_abschnitt
   , v_aktueller_status
   , v_fk_projekt_id
   , v_letzte_bearbeitung
   , v_bearbeitung_durch
   , v_beschreibung
     from proj_projektphase
   where id = v_id;
 end if;

 -- der nachfolgende Parameter muss immer gesetzt werden, egal was vorher gelaufen sit!!
 if p_fk_projekt_id is not null and v_fk_projekt_id is null then
     v_fk_projekt_id       :=  p_fk_projekt_id ;
 end if;

  htp.p('<html>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p(' <link rel=''stylesheet'' href=''/projekt/'||defaultgui||'/css/default.css'' type=''text/css''>');
  -- Toolbar einbinden
  htp.p(dbfun$projtoolbar2js);
  htp.p('<title>PROJEKT | Projektphasen </title>');
  htp.p('</head>');

  htp.p('<body topmargin=5 leftmargin=5 marginwidth=5 marginheight=5>');
  htp.p (dbfun$projtoolbar(upper(v_module_name)
                               , v_modus
                               , dbpck$main.fun$get_akt_benutzer
                             )
            );

  htp.p('<div class="maintitle"> '||dbfun$i18(defaultlang,'PROJ_PROJEKTPHASE zum Projekt')||'<b>'|| dbfun$get_projekt_name(p_fk_projekt_id)||'</b></div>');

  htp.p('<table class="formtable" style="width:98%;">');
  -- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method=head>');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type="hidden"  name="p_id" value="'||v_id||'"/>');
  -- Neue Werte --
  htp.p ('<tr><td class="tdlr"> '||dbfun$i18(defaultlang,'ID')||'</td>');
  htp.p ('      <td  class="tdv"> '||p_id
          ||'</td></tr>');

 if  p_do_delete is not null then
  htp.p ('<tr><td  class="tdv" colspan = "2"><b>'||dbfun$i18(defaultlang,'wurde_gelscht')||' </b></td></tr>');
 else -- nicht gelscht
   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Startdatum')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_startdatum" type="text" size=40 maxlength=10 value="'
     || to_char(v_startdatum,dateformat)||'"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Enddatum')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_enddatum" type="text" size=40 maxlength=10 value="'
     || to_char( v_enddatum,dateformat)||'"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Phasen_Name')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_phasen_name" type="text" size=40 maxlength=100 value="'
     || v_phasen_name||'"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Projekt_Abschnitt')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_projekt_abschnitt" type="text" size=40 maxlength=100 value="'
     || v_projekt_abschnitt||'"></td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Aktueller_Status')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_aktueller_status" type="text" size=40 maxlength=100 value="'
     || v_aktueller_status||'"></td></tr>');

--   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Fk_Projekt_Id')||'</td>');
--   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_fk_projekt_id" type="hidden" value="' || v_fk_projekt_id||'">'); --</td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Letzte_Bearbeitung')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ( to_char( v_letzte_bearbeitung,dateformat||' HH24:MI') ||' / ');
   htp.p ( v_bearbeitung_durch||'</td></tr>');

   htp.p (' <tr><td  class="tdlr">'||dbfun$i18(defaultlang,'Beschreibung')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_beschreibung" type="text" size=40 maxlength=2000 value="'
     || v_beschreibung||'"></td></tr>');

    htp.p ('<tr><td colspan=2>');
   if v_id is not Null then
     if v_modus > 0 then
       htp.p ('  <input type="submit" name ="p_do_update" value="'||dbfun$i18(defaultlang,'update')||'"/>');
      end if;
      if v_modus > 2 then
       htp.p ('  <input type="submit" name ="p_do_delete" value=" '||dbfun$i18(defaultlang,'delete')||'"/>');
      end if;
    end if;
   if v_id is NULL
      and v_modus > 1 then
      htp.p ('  <input type="submit" name ="p_do_insert" value=" '||dbfun$i18(defaultlang,'insert')||'"/>');
   end if;
   htp.p (' </td></tr>');
  end if; -- do_delete
  htp.p (' </table>');

  htp.p (' </form>');

  else -- v-modus =0 -> keine Berechtigung
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;

 htp.p('</body>');
 htp.p('</html>');
EXCEPTION
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- PROCEDURE PROJ_PROJEKTPHASEN_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE proj_projektphasen_list -- p_fk_projekt_id

 (  p_fk_projekt_id                in Number    default null -- Filter auf die Firma
--  , p_such_projekt               in Varchar2  default null -- Lst eine Volltextsuche nach Projekten aus
--  , p_kontakt_id                 in Number    default null -- Filter auf diesen Kontakt
--  , p_such_projekt_id            in varchar2  default null -- fr Suche ber die Projektnummer
--  , p_such_projekt_name          in Varchar2  default null -- Filter auf dieses Projekt
--  , p_such_bauherr               in Varchar2  default null
--  , p_such_startdatum            in Varchar2  default null
--  , p_such_letzte_Bearbeitung    in Varchar2  default null
  , p_order1                     in Varchar2  default null
  , p_order2                     in Varchar2  default null
  , p_debug                      in Varchar2  default null
  -- neu
--  , p_such_status                in varchar2  default null
--  , p_such_status_info           in varchar2  default null
  , x                            in Number    default null -- Dummy
  , y                            in Number    default null -- Dummy
--  , p_nur_offen                  in Number    default 1

  )

as
--[VERS:2008-07-13]

-- Ziel:
-- Generiert Liste der Projektphasen

-- noch offen:
-- - kritische Projektphasen hervorheben  (Status, oder aus dem Rahmen gelaufen)
-- - grafische Darstellung als Netzplan (Interaktiv ber DHTML ...)
-- - Links zu den Ansprechpartnern


-- Autor: Erich Heinemann
-- Kln

 -- Suche aller passenden Projekte
 -- dynamisches SQL
  sql_string1       Varchar2(4000);
  TYPE r_cur_t1     IS REF Cursor;
  r_cur1            r_cur_t1;


 -- DBMS_SQL
  cursor c1
   is
  select
    id
  , phasen_name
  , projekt_abschnitt
  , startdatum
  , enddatum
  , aktueller_status
  , letzte_bearbeitung
  , bearbeitung_durch
  from proj_projektphase
--   where fk_projekt_id = l_fk_projekt_id
   order by nvl(startdatum,letzte_bearbeitung)

  ;
  -- dynamic-SQL

  ca1                c1%rowtype;

/* -- Vorladen der verschiedenen Farben fr die HTML-DIVs
 cursor c2 is
 select w.kurztext, w.langtext
   from xdb_werte  w
      , xdb_wertebereiche wb
  where wb.id   =  w.wb_id
    and wb.name =  'projekt_status_farbe'
  ;
*/

  -- Zugriffsverwaltung
  v_modus            Number(1);
  v_module_name      Varchar2(30) := 'PROJ_PROJEKTPHASEN_LIST';

  -- Formatierung
  kund               varchar2(2)  := chr(38);
--  v_severity_str     Varchar2(255);

  -- Fr die Suchfunktionen
  v_such_projekt_id  Varchar2(255); -- :=  '%'||substr(p_such_projekt_nr,1,20)||'%';
  v_dummy            Number(10)     :=1;

  v_order_form       Varchar2(4000);
  v_order1           Varchar2(200);
  v_order2           Varchar2(200);
  v_link             Varchar2(400);
  v_td_string        Varchar2(2000);



  v_error            Varchar2(800);
  defaultgui         Varchar2(400) := dbfun$default_gui;
  defaultlang        Varchar2(400) := dbfun$default_lang;
  dateformat         Varchar2(40)  := ('DD.MM.YYYY'); -- hier nur Tagesdatum


BEGIN

 begin


  v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

  if v_modus > 0 then

   v_order_form := '<form  action="'||lower(v_module_name)||'" method="post" style="white-space:nowrap">';

   if p_fk_projekt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_fk_projekt_id" value="'||p_fk_projekt_id||'"/>';
   end if;



/*
   if p_kontakt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_kontakt_id" value="'||p_kontakt_id||'"/>';
   end if;


   if p_such_projekt_name is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_projekt" value="'||p_such_projekt_name||'"/>';
   end if;

   if p_such_projekt_id is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_projekt_id" value="'||p_such_projekt_id||'"/>';
   end if;

    if p_such_status is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_such_status" value="'||p_such_status||'"/>';
   end if;
*/

 -- Alte Sortierung nach hinten schieben !!
 -- Dieser Parameter hilft, dass die vorletzte Sortierung nicht ganz verloren geht.
 -- Erst die dritte Auswahl einer Sortierreihenfolge lscht die vorletzte!
   if p_order1 is not null then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_order2" value="'||p_order1||'"/>';
   end if;

-- Suche auch nach abgeschlossenen Bauprojekten
/*   if p_nur_offen <> 1 then
     v_order_form := v_order_form ||'<input type="hidden"  name="p_only_open" value="0"/>';
   end if;
*/

  sql_string1 := 'select * from ( '||chr(10)
 ||' select   id          '||chr(10)
 ||' ,  phasen_name       '||chr(10)
 ||' , projekt_abschnitt  '||chr(10)
 ||' , startdatum         '||chr(10)
 ||' , enddatum           '||chr(10)
 ||' , aktueller_status   '||chr(10)
 ||' , letzte_bearbeitung '||chr(10)
 ||' , bearbeitung_durch  '||
 ' from proj_projektphase '||chr(10) ;

/* if p_kontakt_id is not null then
   sql_string1 := sql_string1 ||' and ' || p_kontakt_id||'  = p.fk_bauherr ';
 end if;
*/
 -- ??? muss erweitert werden, da in einem Projekt und Phasen zustzliche Personen involviert werden knnen

/*
 if p_such_projekt_id is not null then
   sql_string1 := sql_string1 ||' and (p.projekt_id like ''%'||p_such_projekt_id ||'%''';
   sql_string1 := sql_string1 ||' or p.id||'''' like ''%'||p_such_projekt_id ||'%'')';
  else
   if p_nur_offen = 1  then  -- Wenn nicht abgeschlossene (4) Projekte gesucht werden!
     sql_string1 := sql_string1 ||' and p.fk_projekt_status not in (4)'||chr(10);
   end if;
 end if;

  if p_such_status is not null then
   sql_string1 := sql_string1 ||' and upper(dbfun$get_werte(''projekt_status'',p.fk_projekt_status)) like ''%'||upper(p_such_status)||'%'' ';
  end if;

  if p_such_bauherr is not null then
   sql_string1 := sql_string1 ||' and (upper(nachname) like ''%'||upper(p_such_bauherr)||'%'' or  ';
   sql_string1 := sql_string1 ||'      upper(stadt) like ''%'||upper(p_such_bauherr)||'%'' )  ';

  end if;


  if p_such_projekt_id is not null then
   sql_string1 := sql_string1 ||' and ( p.projekt_id      like ''%'||p_such_projekt_id ||'%'' ';
   sql_string1 := sql_string1 ||'   or  upper(nachname) like ''%'||upper(p_such_projekt_id )||'%'' ) ';
  end if;

  -- Suchfeld fr das Status-Bemerkungsfeld
  if p_such_status_info is not null then
   sql_string1 := sql_string1 ||' and upper(p.aktueller_status) like ''%'||upper(p_such_status_info)||'%'' ';
  end if;

  if p_such_projekt_name is not null then
   sql_string1 := sql_string1 ||' and ( upper(p.projekt_name) like ''%'||upper(p_such_projekt_name) ||'%'')' ||chr(10);
  end if;

 -- hier noch ein Block, womit eine Volltextsuche ber alle Felder gestartet wird
  if p_such_projekt is not null then
   sql_string1 := sql_string1 ||' and ( upper(p.projekt_name) like ''%'||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(p.aktueller_status) like ''%'  ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(k.plz) like ''%'        ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'       or upper(k.stadt) like ''%'      ||upper(p_such_projekt) ||'%''' ||chr(10);
   sql_string1 := sql_string1 ||'     )' ||chr(10);
 end if;

*/

 -- Ende des Subselect einfgen
 sql_string1 := sql_string1 ||') x ';
-- .. sicher, so ein dynamisches SQL bietet nicht die beste Performance, ist aber irgendwie im Sourcecode nachvollziehbar.
-- Besser wre es, dieses Statement ber Bind-Variablen zu bauen. ... beim nchsten mal. :-)


 -- ORDER-BY einfgen
 if p_order1 is not null then
  sql_string1 := sql_string1 ||' order by '||dbfun$get_werte('PROJEKTPHASEN_LIST_ORDER',p_order1);
  if p_order2 is not null then
  sql_string1 := sql_string1 ||' , '||dbfun$get_werte('PROJEKTPHASEN_LIST_ORDER',p_order2);
  end if;
  else -- Sortierung nach letzter nderung desc
  --sql_string1 := sql_string1 ||' order by nvl(startdatum,letzte_bearbeitung) desc';
  null;
 end if;

   -- HTTP-Session ffen
    htp.p('<HTML>');
    htp.p('<head>');
    htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
    htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

   -- Include fr HTML-Header
    htp.p(dbfun$projtoolbar2js);

    htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||dbfun$default_gui||'/css/default.css'' type=''text/css''>');
    htp.p('<title>Projekte | Projektphasen</title>');
    htp.p('</head>');
    htp.p('<BODY>');

    htp.p (dbfun$projtoolbar(upper(v_module_name)
                                , v_modus
                                , dbpck$main.fun$get_akt_benutzer
                                )
           );

 --   if p_such_projekt_id is null and  p_such_projekt is null then
      htp.p('<div class="maintitle">Projektphasen zum Projekt '||'<b>'
      || dbfun$get_projekt_name(p_fk_projekt_id)
      ||'<a href="proj_projekt_details?p_id='||p_fk_projekt_id||'" border="NO">'
      ||'<img src="/i/projekt/'||dbfun$default_gui||'/img/tool/details.png" ALT="Details" BORDER=NO></a>'
      ||'</b>');

      if v_modus > 2 then
      --  htp.p ('<a href="proj_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id||'" target="_blank"> Neue Phase einfgen </a>');
        htp.p(dbfun$html_button ('proj_projektphase_details?p_fk_projekt_id='||p_fk_projekt_id,'Neue Phase einfgen'));

      end if;

      htp.p('</div>');
 --   else
 --     htp.p('<div class="maintitle"> Projektphasen, <i>Filter, Projekte entsprechend '
 --         ||nvl(p_such_projekt_id,p_such_projekt)||'</i></div>');
 --   end if;

 -- die 2 anchfolgenden DIVS werden versteckt um die Styles fr das Highlighting beim Hover-Effekt zu steuern
   htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">x</div>');
   htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">x</div>');

/*
 -- DIVs fr die unterschiedlichen Severities
 -- Die Farben fr die Severities werden in einer WErteliste ausgelesen und dann verstekct vorgehalten
  for ca2 in c2 loop
   htp.p('<div id="tdlistSeverities'||ca2.kurztext||'_0" style="visibility:hidden;top:0px;height:0px;background-color:'
   ||ca2.langtext||';">x</div>');
   htp.p('<div id="tdlistSeverities'||ca2.kurztext||'_1" style="visibility:hidden;top:0px;height:0px;background-color:'
   ||dbfun$mod_color(ca2.langtext,15)||';">x</div>');
  end loop;
*/


    htp.p(' <table class="listtable" style="width:98%;">');

    -- Header-Zeile aufbauen
    htp.p('  <tr>');

    htp.p('  <td width="30" class="tdh" style="border-bottom-width:1px;">');
    htp.p('      '||v_order_form ||'<input type="hidden"  name="p_order1" value="1"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Phase" title="Sortierung nach Phase" Border="NO">');
    htp.p('      Name</form>');
    htp.p('  </td>');

    htp.p('  <td width="150" class="tdh"  style="border-bottom-width:1px;" >');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="2"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sortierung nach Projektabschnitt" title="Sortierung nach Projektabschnitt" Border="NO">');
    htp.p('     Projektabschnitt</form>');
    htp.p('  </td>');

    htp.p('  <td width="120" class="tdh" style="border-bottom-width:1px;" >');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="3"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sortierung nach Startdatum" title="Sortierung nach Startdatum" Border="NO">');
    htp.p('     Startdatum</form>');
    htp.p('  </td>');

    htp.p('  <td width="60" class="tdh"  style="border-bottom-width:1px;">');
    htp.p('     '|| v_order_form ||'<input type="hidden"  name="p_order1" value="4"/>');
    htp.p('     <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('     alt="Sorierung nach Enddatum" title="Sorierung nach Enddatum" Border="NO">');
    htp.p('     Enddatum</form>');
    htp.p('  </td>');

    htp.p('  <td width="60" class="tdh"  style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="5"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Status" title="Sortierung nach Status" Border="NO">');
    htp.p('      Status</form>');
    htp.p('    </td>');

    htp.p('  <td width="60" class="tdh" colspan="2" style="border-bottom-width:1px;" >');
    htp.p('      '|| v_order_form ||'<input type="hidden"  name="p_order1" value="6"/>');
    htp.p('      <input type="image" src="/i/projekt/'||dbfun$default_gui||'/img/tool/sort_down.gif" ');
    htp.p('      alt="Sortierung nach Bearbeitung" title="Sortierung nach Bearbeitung" Border="NO">');
    htp.p('      Bearbeitung</form>');
    htp.p('    </td>');


    htp.p('</tr>');



  /*
   htp.p('<tr>');
   -- Filter-Zeile fr neue Suche einfgen!!
   -- Suchfelder zusammenbauen

   htp.p(' <form  action="'||lower(v_module_name)||'" method="get" style="white-space:nowrap">');
   htp.p('   <TD class="tdheader">');
   htp.p(     ' <input name="p_such_status" type="text" size=5 maxlength=400 value="'
     || p_such_status ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_bauherr" type="text" size=16 maxlength=400 value="'
     || p_such_bauherr ||'">Bauherr</td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_id" type="text" size=16 maxlength=20 value="'
     || p_such_projekt_id ||'">Projekt-ID</td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_startdatum" type="text" size=19 maxlength=10 value="'
     || p_such_startdatum  ||'">startdatum</td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_letzte_Bearbeitung" type="text" size=10 maxlength=10 value="'
     || p_such_letzte_Bearbeitung ||'"></td>');

   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_projekt_name" type="text" size=38 maxlength=400 value="'
     || p_such_projekt_name ||'"></td>');


   htp.p('    <td class="tdheader">'
     || ' <input name="p_such_status_info" type="text" size=18 maxlength=400 value="'
     || p_such_status_info ||'"></td>');

   htp.p('    <td class="tdheader" >'
         ||'<input type="image" src="../../projekt/'||dbfun$default_gui||'/img/tool/such.png" ');
   htp.p('     alt="Suchen" title="Suchen" Border="NO">');
   htp.p('   </td>');

   htp.p('   </form>');
   htp.p('   </tr>');

   -------------------------------------

   if  p_such_projekt_id is not null then
      v_such_projekt_id :=  '%'||substr(p_such_projekt_id,1,20)||'%';
   end if;
  */


  v_dummy := 1;

  -- SQL-Statement ausfhren
  open r_cur1 for sql_string1;
  loop
  fetch r_cur1 into ca1;
   exit when r_cur1%notfound;

   -- Der Style wird in der Liste zwischen den Datenstzen und dem Status des Projektes jeweils umgeschaltet
   -- Daher wird der Link vorher definiert und der Rohbau einer Tabellenzelle (<TD>) vorab je Zeile definiert
   v_link :=   '<a href="proj_projektphase_details?p_id='||ca1.id||'">';
    v_dummy :=  v_dummy +1;

   if v_dummy < 3050 then
 --   if instr(ca1.status_farbe,'#',1) > 0 then
 --       v_td_string :=  '    <td style="text-valign: middle;" onmouseover="tr'||v_dummy
 --       ||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy||'.style.backgroundColor=tdlistSeverities'
 --       ||ca1.projekt_status||'_'||mod(v_dummy,2)||'.style.backgroundColor;" '
  --      ||' >';
  --    htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" style="text-valign: bottom;background-color: '
  --    ||dbfun$mod_color(ca1.status_farbe,mod(v_dummy,2)*15)||';" id="tr'||v_dummy||'">');-- class="tdlist'||mod(v_dummy,2)||'" onmouseover="this.style.backgroundColor=''#FFFF00'';" onmouseout="this.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;">');
  --  else
       v_td_string :=  '    <td onmouseover="tr'||v_dummy||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'
       ||v_dummy||'.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;" '
                 ||' >';
    htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" id="tr'||v_dummy||'" style="text-valign: center;">');
  --  end if;

   -- Spalte fr den Status
 --  htp.p ( v_td_string
 --     ||v_link||dbfun$projekt_status_img(ca1.fk_projekt_status)||'</a></td>');

   -- Spalte fr Phasen_Name
   if ca1.phasen_name != 'PHASE' then
       htp.p ( v_td_string ||'<b>' || v_link||ca1.phasen_name   ||'</b></a>'||'</td>');
   else
       -- Beteiligte Personen aufzhlen und als Phasen-Name anzeigen z.B. "Tiefbau Mller GmbH"
       htp.p ( v_td_string ||'<i>' || v_link||ca1.phasen_name   ||'</i></a>'||'</td>');
   end if;

   -- Spalte fr Phasen_Name
   htp.p ( v_td_string ||v_link||ca1.Projekt_Abschnitt   ||'</a>'||'</td>');


   -- Spalte fr Startdatum
   htp.p( v_td_string ||v_link||'<b>'||to_char(ca1.startdatum,dateformat)||'</b>'
     ||'</a></td>');

   -- Spalte fr das Enddatum
   htp.p (v_td_string ||v_link   ||to_char(ca1.enddatum,dateformat)||'<br>'
     ||'</a></td>');

   -- Spalte "Aktueller_Status"
   htp.p (v_td_string --    <td class="tdlist'||mod(v_dummy,2)||'"   '||v_severity_str||'>'
     ||v_link
     ||ca1.aktueller_Status
     ||'</a></td>');


   -- Spalte "Letzte Bearbeitung"
   htp.p (v_td_string --    <td class="tdlist'||mod(v_dummy,2)||'"   '||v_severity_str||'>'
     ||v_link
     ||to_char(ca1.letzte_bearbeitung,'DD.MM.YYYY Hh24:MI') ||' / '|| ca1.bearbeitung_durch
     ||'</a></td>');


   htp.p( v_td_string --'     <td class="tdlist'||mod(v_dummy,2)||'" align="right" >'
   ||v_link
   ||'<img src="/i/projekt/'||dbfun$default_gui||'/img/tool/details.png" BORDER=NO></A></TD>');
   htp.p('   </tr>');

   else -- v_dummy <150
    htp.p('   <tr>');
    htp.p('     <td colspan="9"> Zu viele Datenstze!!! Abgeschnitten ab Nr.'||v_dummy||'! </td>');
    htp.p('   </tr>');
   end if; -- v_dummy <150

   end loop;
    CLOSE r_cur1;

   htp.p('   </table>');

 else -- v-modus =0
    htp.p ('  <html><body><h1> no Accesss with Your Account ! </h1><br>');
 end if;


 htp.p('  </body>' );
 htp.p(' </html>' );

end;
 exception when others
 then
    htp.p ('SQL-Error '||sqlerrm ||' / '|| sqlcode );

  --  if v_modus != null and v_modus > 2 then
      htp.p ('<br>'||chr(10)||sql_string1);
  --  end if;

end;
/


----------------------------------------------------------------
-- PROCEDURE PROJ_SUCHE
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE proj_suche (  p_contact_search     in Varchar2  default null
                                        , p_telnumber          in varchar2  default null
                                        , p_kontext            in varchar2  default 'kund'
                                        )
as

--[VERS:2007-02-20]
-- Procedure zur Suche im nach Projekten oder Kunden
  -- Zugriffsverwaltung
  v_modus         Number(1);
  v_module_name   Varchar2(20) := 'PROJ_SUCHE';

  -- Formatierung
  v_company_name   Varchar2(400); -- da wird der name der Firma reingebaut

  -- Suchfunktion
  v_contact_search Varchar2(200) := upper(substr(p_contact_search ,1,200));


BEGIN
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name);


 if v_modus > 0 then
  -- HTTP-Session ffen
   htp.p('<HTML>');
   htp.p('<head>');
   htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

   -- Include fr HTML-Header
   htp.p(dbfun$projtoolbar2js);

   htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||dbfun$default_gui||'/css/default.css'' type=''text/css''>');
   htp.p('<title>Projekt | Suche</title>');
   htp.p('</head>');
   htp.p('<BODY>');

    htp.p (dbfun$projtoolbar(upper(v_module_name)
                                , v_modus
                                , NUll -- dbpck$main.fun$get_akt_benutzer
                                )
           );

   htp.p('<div class="maintitle"> Suche </div>');

   htp.p('<table class="formtable" style="width:98%;margin:3px;">');

 -- Suche nach Kundendaten ermglichen
    if dbpck$main.fun$chk_module_allowed('PROJ_KONTAKT_DETAILS')> 0
    and  p_kontext='kund'
    then
    -- Suche ber Nachname des Ansprechpartners
     -- Firma
        htp.p('   <tr>'); --<td  class="tdv"> ');
        htp.p (' <form  action="proj_firmen_list" method=head>');
        htp.p ('      <td  class="tdlr" ><b> Firma </b></td>');
        htp.p ('      <td  class="tdv"> ');
        htp.p ('         <input name="p_search" type="text" size="40" maxlength="20" value="'
                       || '' ||'" style="width:250px">');
        htp.p ('  <input type="submit" value="Suche" />');
        htp.p('  </td>');
        htp.p(' </form></tr>');
        htp.p('<tr><td class="tdlor" style="height:2px;"></td><td class="td"></td></tr>');

        htp.p('   <tr>');
        htp.p (' <form  action="po_firma_ma_list" method="get">');
        htp.p ('      <td  class="tdlor" ><b> Ansprechpartner  </b></td>');
        htp.p ('      <td  class="td"> ');
        htp.p ('         <input name="p_is_portlet" type="hidden" value="nein"">');
        htp.p ('         <input name="p_such" type="text" size="40" maxlength="20" value="'
                       || '' ||'" style="width:250px;">');

        htp.p ('  <input type="submit" value="Suche" />');
        htp.p('  </td>');
        htp.p(' </form></tr>');


    -- Suche ber Rufnummer
        htp.p('   <tr>');

        htp.p (' <form  action="proj_suche_tel" method="get">');
        htp.p ('      <td  class="tdlr" > Telefonnummer  </td>');
        htp.p ('      <td  class="tdv"> ');
        htp.p ('         <input name="p_num" type="text" size="40" maxlength="20" value="'
                       || '' ||'" style="width:250px">');
        htp.p ('  <input type="submit" value="Suche" />');
        htp.p(' <br><span style="font-size: 9px;">Bitte nur die Endrufnummer eingeben! Die Vorwahl kann entfallen.</td></tr>');
        htp.p(' </form>');

        htp.p('<tr><td class="tdlor" style="height:2px;"></td><td class="td"></td></tr>');

    end if;

  -- Suche nach projnummer ermglichen
    if dbpck$main.fun$chk_module_allowed('PROJ_PROJEKT_DETAILS')> 0
     and p_kontext='proj' then
    -- Suche ber die projnummer
        htp.p('   <tr>');
        htp.p (' <form  action="proj_projekt_list" method=head>');
        htp.p ('      <td  class="tdlor"><b> Projekt-ID  </b></td>');
        htp.p ('      <td  class="td"> ');
        htp.p ('         <input name="p_such_projekt_id" type="text" size="40" maxlength="20" value="'
                       || '' ||'" style="width:250px">');
        htp.p ('  <input type="submit" value="Suche" />'); --name ="p_do_update" value="Se"/>');
        htp.p('  </td>');
        htp.p(' </form>');
        htp.p('</tr>'  );


        htp.p('   <tr>');
        htp.p (' <form  action="proj_projekt_list" method=head>');
        htp.p ('      <td  class="tdlr"> Projekt-Beschreibung  </td>');
        htp.p ('      <td  class="tdv"> ');
        htp.p ('         <input name="p_such_projekt" type="text" size="40" maxlength="20" value="'
                       || '' ||'" style="width:250px">');
        htp.p ('   auch in "abgeschlossenen Projekten" suchen  <input type="radio" name="p_only_open" value="0"  '
                       || '' ||'" style="width:20px"> ');

        htp.p ('  <input type="submit" value="Suche" />');
        htp.p('  </td>');
        htp.p(' </form>');
        htp.p('</tr>'  );
    end if;



   htp.p('</TABLE>');

 else -- v-modus =0
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1><BR>');
 end if;


 htp.p('</BODY>' );
 htp.p('</HTML>' );
end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PROJ_SUCHE                     TO PROJ_RO;

GRANT EXECUTE      ON PROJ_SUCHE                     TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PROJ_SUCHE_TEL
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE proj_suche_tel   ( p_num in Varchar2 default null
                                                , p_dir in Varchar2 default 'out'
                                                , p_pbx in Varchar2 default null
                                                )

as


-- So muss die Ergebnisliste fr ein Aastra aussehen
/*
<AastraIPPhoneTextMenu destroyOnExit = yes>
<Title>Dial and Select</Title>
<MenuItem>
<Prompt>First Selection</Prompt>
<URIURI>
>200</<Selection>200</Selection>
</MenuItem>
<MenuItem>
<Prompt>Second Selection</Prompt>
<URI>201</URI>
<Selection>201</Selection>
</MenuItem>
<SoftKey index = 1>
<Label>Dial</Label>
<URI>SoftKey:Dial</URI>
</SoftKey>
<SoftKey index = 2>
<Label>Select</Label>
<URI>http://myserver.com/script.php</URI>
</SoftKey>
</AastraIPPhoneTextMenu>
*/

 v_num Varchar2(200) := substr(p_num,1,200);


 v_modus                  Number(1);
 v_module_name            Varchar2(30)  := 'PROJ_SUCHE_TEL';
 v_error_mod1             Varchar2(80);
 v_error_mod2             Varchar2(80);
 v_mod_ret                Number(2);

  -- Formatierung
-- v_width                Number(10)    := p_width;
 kund                     Varchar2(1)   := chr(38);
 nbsp                     Varchar2(6)   := chr(38)||'nbsp ';
 v_field_width            Number(10);

 v_counter                Number(10);
 v_link                   Varchar2(255);

 -- Liste der Ansprechpartner
 cursor c1 (cnumber in Varchar2) is
 select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       , co.id
       , co.tel1 tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(tel1,'/',''),' ') like '%'||cnumber
     and  co.tel1    is not null
     and  co.fk_firma = c.id (+)

  union all
  -- 2
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       ,  co.id
       ,  co.tel2 tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(co.tel2,'/',''),' ') like '%'||cnumber
       and co.tel2 is not null
       and  co.fk_firma = c.id (+)
  --3
  union all
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       , co.id
         , co.tel3  tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(co.tel3 ,'/',''),' ') like '%'||cnumber
       and co.tel3 is not null
       and  co.fk_firma = c.id (+)
 --4
  union all
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
       ,  co.id
   ,  co.tel4  tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
       ,  proj_firma c
    where replace(replace(co.tel4 ,'/',''),' ') like '%'||cnumber
       and co.tel4 is not null
       and co.fk_firma = c.id (+)
 --5
  union all
   select decode(vorname,vorname, vorname||' '||nachname,nachname ) full_name
   ,  co.id
   ,  co.tel5  tel
   , c.firmenname
   , c.zusatz
   , nvl(co.strasse,c.strasse1)   strasse1
   , nvl(co.strasse2,c.strasse2)  strasse2
   , nvl(co.strasse3,c.strasse3)  strasse3
   , nvl(co.stadt,c.stadt)        stadt
   , nvl(co.plz  , c.plz)         plz
   , co.email
   from proj_kontakt co
     ,  proj_firma c
    where replace(replace(co.tel5 ,'/',''),' ') like '%'||cnumber
       and co.tel5 is not null
       and  co.fk_firma = c.id (+)
 ;

 -- Liste der laufenden Projekte, wo diese Person als Bauherr eingetragen ist
 cursor c2 (l_contact in Number)
  is
 select
   p.id
 , p.projekt_id
 , p.projekt_name
 , decode(vorname, vorname,vorname||' '||nachname, nachname) bauherr
 , aktueller_status
 , fk_projekt_status
 , startdatum
 , p.letzte_bearbeitung
  from proj_projekt p
     , proj_kontakt k
   where fk_projekt_status  != 4 -- abgeschlossene werden nicht aufgelistet... - suctomizing!   ;
    and k.id = l_contact
    and ( -- entweder ist es der Bauherr
         ( fk_bauherr = l_contact and fk_bauherr is not null)
    --  or
    --     ( -- oder ein Mitarbeiter eines Subunternehmers
    --      1=0
    --      )
         );


begin

  -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

 if v_modus > 0 then


  if v_num like ('00%') then
   v_num := substr(v_num,2);
  end if;

  if v_num not like ('0%') and length(v_num) <= 4  then
   v_num := p_pbx || v_num  ;
  end if;

 htp.p('<html>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  -- deutscher zeichensatz <meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

  -- Include fr HTML-Header
  htp.p(dbfun$projtoolbar2js);
--  htp.p(' <link rel=''stylesheet'' href=''/cmdb/cust/default.css'' type=''text/css''>');

  htp.p(' <link rel=''stylesheet'' href=''/i/projekt/default/css/default.css'' type=''text/css''>');

  htp.p('  <script type="text/javascript">     ');
  htp.p('        var djConfig = { isDebug: false }; ');
  htp.p('  </script>                       ');
  htp.p('  <script type="text/javascript" src="../../cmdb/js/dojo_core/dojo.js"></script>     ');
  htp.p('  <script type="text/javascript">');
  htp.p('        dojo.require("dojo.widget.ComboBox");');
  htp.p('        dojo.require("dojo.widget.TabContainer");   ');
  htp.p('        dojo.require("dojo.widget.LinkPane");    ');
  htp.p('        dojo.require("dojo.widget.ContentPane");   ');
  htp.p('        dojo.require("dojo.widget.LayoutContainer");  ');
--  htp.p('        dojo.require("dojo.widget.Checkbox");    ');
  htp.p('</script> ');


  htp.p('<title>Projekt | Telefon-Suche</title>');

/*
 htp.p(' <style type="text/css">');
 htp.p('  .dojoTabPaneWrapper { ');
 htp.p('    padding : 1px 1px 1px 1px; ');
 htp.p('  }');
 htp.p(' </style> ');
 */
  htp.p('</head>');
  htp.p('<BODY style="font-size : 0.8em;" style="background-color:#FFFFFF;" LINK="#000000" VLINK="#000000" TEXT="#000000"');
  htp.p('    TOPMARGIN="0" LEFTMARGIN="0" MARGINWIDTH="0" MARGINHEIGHT="0">');

  htp.p (dbfun$projtoolbar(upper(v_module_name)
                               , v_modus
                               , null --dbpck$main.fun$get_akt_benutzer
                               )
          );

--  htp.p('<span class="maintitle">Telefonlog ');
--  htp.p('des Users: '||dbfun$get_username(user)) ;
--  htp.p('</span>');
--  htp.p('<a href="docs/001784112889.dial" target="new">dial</a>');
  v_num := nvl(v_num,'xxxx');

   v_num  := replace(v_num ,'/','');
   v_num  := replace(v_num ,' ','');
   v_num  := replace(v_num ,'-','');
   v_num  := replace(v_num ,'.','');
   v_num  := replace(v_num ,'\','');
   v_num  := replace(v_num ,':','');


  htp.p('<table style="width:99%">');
  for ca1 in c1 (v_num) loop
   htp.p('<tr>');
   htp.p(' <td class="tdh" colspan="4"><b>Ansprechpartner</b></td>');
   htp.p('</tr>');

   htp.p('<tr>');

   v_link := '<a href="proj_kontakt_details?p_id='||ca1.id||'" target="_blank">';
   htp.p(' <td class="tdv" style="width:30%;">'||v_link||'<b>'||ca1.full_name||'</b>');
   if ca1.strasse1 is not null then htp.p(' <br>'||ca1.strasse1 );  end if;
   if ca1.strasse2 is not null then htp.p(' <br>'||ca1.strasse2 );  end if;
   if ca1.strasse3 is not null then htp.p(' <br>'||ca1.strasse3 );  end if;
   if ca1.plz  is not null then htp.p(' <br>'||ca1.plz); else htp.p(' <br>'); end if;

   if ca1.stadt is not null then htp.p(ca1.stadt);  end if;

   if ca1.firmenname is not null then htp.p('<br><b>'||ca1.firmenname||'</b>');  end if;


   htp.p('  </a></td>');


   htp.p('  </a></b></td>');
   htp.p(' <td class="tdv" colspan="3">'||v_link||'Tel.:<b>'||ca1.tel||'</a></b>');
   --if user = 'XDBADM' then
     htp.p('<br><img src="/i/projekt/default/img/telefon.png">'||dbfun$get_kontakt_tel(ca1.id));
   --end if;

   if ca1.email is not null then
     htp.p('<br><a href="mailto:'|| ca1.email
     ||'"><img src="/i/projekt/default/img/mail_ico.gif" border="0" title="sende Email">'
     ||'<span style="font-size:0.7em;"> ('||ca1.email||')</span></a>');
   end if;

   htp.p('  </td>');


   -- Diese Funktion fehlt leider noch
   htp.p('  <td class="tdv">');
 /*   if dbpck$main.fun$chk_module_allowed('PROJ_KONTAKT_NOTIZ')> 1 then
           htp.p('     <a href="PROJ_KONTAKT_NOTIZ?p_do_insert=insert'||kund||'p_fk_kontakt='||ca1.id
           ||'"><img src="/i/prokjekt/default/img/neue_notiz.png" ALT="[Neue Notiz]" TITLE="Neue Notiz einfgen" Border="No"> </a>');
           htp.p('     <br>');

    else
           null;
    end if;
 */

   htp.p('  </td>');
   htp.p(' </tr>');



   if dbpck$main.fun$chk_module_allowed('PROJ_PROJEKT_DETAILS')> 0 then
    v_counter :=0;
    for ca2 in c2 (ca1.id) loop
     if v_counter =0 then -- header wird nur eingebaut, wenn wirklich Datenstze vorliegen
      htp.p('<tr>');
      htp.p(' <td class="tdh" style="width:25%;">Projekt-Name<br>'
      ||'</td>');
      htp.p(' <td class="tdh" style="width:10%;">Status</td>');
      htp.p(' <td class="tdh"><b>Bauherr</b></td>');
      htp.p(' <td class="tdh"><b>Aktuelles</b></td>');
      htp.p('</tr>');
        v_counter :=1;
     end if;
     htp.p('<tr>');
     v_link := '<a href="proj_projekt_details?p_id='||ca2.id||'" target="_blank">';
     htp.p('    <td class="tdv" style="font-size:0.6em;">');
     htp.p('     '||nbsp||v_link||ca2.projekt_name);
     htp.p('      <br><span>'
      ||nbsp||'Start:'|| to_char(ca2.startdatum,'DD.MM.YYYY')
      ||' '||nbsp||' letzte Bearbeitung:'|| to_char(ca2.letzte_bearbeitung,'DD.MM.YYYY')
      ||'</span>');
     htp.p('  </a>');
     htp.p(' </td>');
     htp.p(' <td class="tdv">'||v_link||dbfun$get_werte('projekt_status',ca2.fk_projekt_status)||'</a></td>');
     htp.p(' <td class="tdv">'||v_link||ca2.Bauherr              ||'</a></td>');
     htp.p(' <td class="tdv">'||v_link||ca2.aktueller_status||'</a></td>');
     htp.p('</tr>');
    end loop;
  end if;

    htp.p('<tr>');
    htp.p(' <td colspan="4"><hr></td>');
    htp.p('</tr>');
  end loop;

  htp.p('</table>');
 else -- v-modus =0


  htp.p (' <HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;


 htp.p(' </BODY>');
 htp.p('</HTML>');
exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON PROJ_SUCHE_TEL                 TO PROJ_RO;

GRANT EXECUTE      ON PROJ_SUCHE_TEL                 TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE PROJ_WERTEBEREICHE_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE PROJ_WERTEBEREICHE_DETAILS
(
     p_id                   in Number    default NULL
   , p_name                 in Varchar2  default NULL
   , p_bemerkung            in Varchar2  default NULL
  ,  p_do_update            in varchar2  default ''
  ,  p_do_delete            in Varchar2  default ''
  ,  p_do_insert            in Varchar2  default ''
) as

--[VERS:2008-07-29]
-- 2008-07-29 Aktualisierung des GUI-Designs

-- Details eines Wertebereichs darstellen und einzelne Werte auslisten!!!

-- lokale CURSOR
 cursor c1 (p_wb_id in Number)
 is
 select id
      , kurztext
   , substr(langtext,1,40)  langtext
   , substr(bemerkung,1,40) bemerkung
  from xdb_werte
 where wb_id = p_wb_id
  order by id;


-- lokale Variablen:
   v_id         xdb_wertebereiche.id%type;
   v_name       xdb_wertebereiche.name%type;
   v_bemerkung  xdb_wertebereiche.bemerkung%type;
   v_dateformat   Varchar2(40) := ('DD.MM.YYYY HH24:MI');
   defaultgui     Varchar2(200) := dbfun$default_gui;
   defaultlang    Varchar2(4)   := dbfun$default_lang;

   v_counter      Number(10):=0;
   v_dummy        Number(10):=0;
   v_td_string    Varchar2(1200);
   v_link         Varchar2(400);



   v_modus  number(1);
   v_module_name Varchar2(30) := 'PROJ_WERTEBEREICHE_DETAILS';
   v_error_mod1 Varchar2(80);
   v_error_mod2 Varchar2(80);
   v_mod_ret Number(2);

 -- Local-Function
    function selected_opt ( val1 in varchar2, value in varchar2)
   return varchar2 -- selected
   as
  begin
 if val1 = value then
  return 'selected';
 else
  if (val1 is NULL and value = '')
   or (val1 ='' and value is NULL)
    then
    return 'selected';
  end if;
  return NULL;
 end if;
   end;


 BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name);


  if v_modus > 0 then
   -- Delete
 if p_id is not null
   and p_do_delete is not NULL
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen
        v_name := p_name;
     begin
      delete xdb_Werte
       where wb_id = v_id;
     exception when others then
      null;
     end;
    delete xdb_wertebereiche
     where id = v_id;
    commit;
  end if; -- delete


 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
if (p_id is not null)
 or  (p_do_insert is not null and p_id is null)
 or  (p_do_update is not null)
  then
 -- Datensatz einfgen bzw. bernehmen
   v_id   :=  p_id ;
   v_name   :=  p_name ;
   v_bemerkung   :=  p_bemerkung ;
end if;


if p_do_insert is not null
 and v_modus > 1 -- min 2!
  then


--SEQUENCE !!!!!!
 select seq_wertebereiche.nextval into v_id from dual;
  insert into xdb_wertebereiche
 (
     id
 ,    name
 ,    bemerkung
   ) values (
      v_id
   ,  v_name
   ,  v_bemerkung
   );
  commit;
  end if; -- Insert ??


-- UPDATE
  if p_do_update is not null
   and p_id is not null
   and v_modus > 0
    then
     v_id := p_id;
   update xdb_wertebereiche
    set
      name   =  v_name
     , bemerkung   =  v_bemerkung
  where id   = v_id;
  commit;
 end if; -- Update ??

  if     ( p_do_insert is NULL)
     and ( p_do_delete is NULL)
     and  p_id is not null
  then
    v_id  := p_id;
   select
    name
  , bemerkung
  into
    v_name
  , v_bemerkung
    from xdb_wertebereiche
 where id = v_id;
 end if;

  htp.p('<HTML>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||defaultgui||'/css/default.css'' type=''text/css''>');
  htp.p(dbfun$projtoolbar2js);

  htp.p('<title>Meta-Values</title>');
  htp.p('</head>');
  htp.p('<body topmargin=5 leftmargin=5 marginwidth=5 marginheight=5>');
     htp.p (dbfun$projtoolbar(upper(v_module_name)
                               , v_modus
                               , null
                               )
          );

  htp.p('<div class="maintitle">META-Values</div>');

  htp.p('<div class="formtable">');
  htp.p('<TABLE class="formtable">');
-- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method=head>');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type=hidden  name="p_id" value="'||v_id||'"/>');
 -- Neue Werte --
   htp.p ('<tr><td  class="tdlr"> ID:  </td>');
   htp.p ('      <td  class="tdv"> '||p_id
  ||'</td></tr>');
 if p_do_delete is not null then
  htp.p ('<tr><td  class="tdv" colspan = 2><b> is deleted </b></td></tr>');
 else -- nicht gelscht
   htp.p ('<tr><td  class="tdlr"> '||dbfun$i18(defaultlang,'Name')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_name" type="text" size=40 maxlength=30 value="'
     || v_name||'"></td></tr>');


   htp.p ('<tr><td  class="tdlr"> '||dbfun$i18(defaultlang,'memo')||'</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('      <input name="p_bemerkung" type="text" size=40 maxlength=100 value="'
     || v_bemerkung||'"></td></tr>');


   htp.p (' <tr><td class="tdlr"></td><td class="tdv">');
   if v_id is not Null then
     if v_modus > 0 then
       htp.p ('  <input type="submit" name ="p_do_update" value="'||dbfun$i18(defaultlang,'update')||'"/>');
      end if;
      if v_modus > 2 then
       htp.p ('  <input type="submit" name ="p_do_delete" value="'||dbfun$i18(defaultlang,'delete')||'"/>');
      end if;
    end if;
   if v_id is NULL
      and v_modus > 1 then
      htp.p ('  <input type="submit" name ="p_do_insert" value="'||dbfun$i18(defaultlang,'insert')||'">');
   end if;
   htp.p ('  </td></tr>');
 end if; -- do_delete
   htp.p ('  </table>');
   htp.p (' </form>');
   htp.p ('</div>');

 -- Liste der Details
 htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">bbbd</div>');
 htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">asd</div>');

 -- Ueberschriften zusammenbauen
 htp.p('<div class="listtable">');
 htp.p('<TABLE class="listtable">');
 htp.p('<TR>');
 htp.p(' <TD colspan="5" style="width:120px;" class="tdh">'||dbfun$i18(defaultlang,'Werte')||'</td>');
 htp.p('</TR>');
 htp.p('<TR>');
 htp.p('<TD style="width:120px;" class="tdh">ID</td>');
 htp.p('<TD style="width:120px;" class="tdh">Shorttext</td>');
 htp.p('<TD style="width:120px;" class="tdh">Longtext</td>');
 htp.p('<TD colspan="2" class="tdh">Memo</td></tr>');

 for ca1 in c1 (v_id) loop
  v_dummy     := v_dummy +1;     --
  v_td_string := '<td onmouseover="tr'||v_dummy||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy||'.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;" onmouseclick="self.document.location.href=''f_ci_definitions_details?p_id='||ca1.id||'''">';
  v_link      := '<a href="proj_werte_details?p_id='||ca1.id||'" title="Details"> ';

  htp.p ('    <tr class="tdlist'|| mod(v_dummy,2)||'" id="tr'||v_dummy||'">');-- class="tdlist'||mod(v_dummy,2)||'" onmouseover="this.style.backgroundColor=''#FFFF00'';" onmouseout="this.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;">');

 -- htp.p('<tr>');
  htp.p( v_td_string || v_link ||ca1.id||'</a></td>');
  htp.p( v_td_string || v_link ||ca1.kurztext  ||'</a></td>');
  htp.p( v_td_string || v_link ||ca1.langtext  ||'</a></td>');
  htp.p( v_td_string || v_link ||ca1.bemerkung ||'</a></td>');
   htp.p (v_td_string || v_link||'<img src="../../projekt/'||defaultgui
   ||'/img/tool/details.png" title="Details" alt="Details" Border="no"></a></td>');

  htp.p ( '</tr>');
 end loop;

  if v_modus > 1 then
     htp.p (' <TR><td colspan=5  class="tdvr">');

     htp.p( dbfun$html_button ('proj_werte_details?p_wb_id='||v_id,'<img src="/i/projekt/'||defaultgui||'/img/add_new_abc.png">'||dbfun$i18(defaultlang, 'add_record')));
     htp.p('  </TD></TR>');
   end if;
  htp.p('</table>');
   htp.p('</div>');


  else -- v-modus =0
  htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;
 -- eigentlich msste mann vorher die Berechtigung prfen !!
 htp.p('<p>');
-- htp.p ('  <a href="xdb_wertebereiche_list" class="abc">Back</a>');

 htp.p(dbfun$html_button ('proj_wertebereiche_list',dbfun$i18(defaultlang,'Back')) );


 htp.p('</BODY>');
 htp.p('</HTML>');
exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- PROCEDURE PROJ_WERTEBEREICHE_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE PROJ_WERTEBEREICHE_LIST
         (  vals in Number default 1      -- Erstes Element der Liste
          , vale in Number default 24    -- Letztes Element der Liste
          )
 as
--[VERS:2004-07-12]
 -- Dient der Darstellung der liste der Wertebereiche
 -- E.Heinemann 11.11.2003
 cursor c1 (v_s in number, v_e in number)
  is
 select x.* from
 ( select tt.*, rownum xx  from
   ( select
       id
   ,   name
   ,   bemerkung
   from xdb_wertebereiche t
    order by t.name
    ) tt
     ) x
     where x.xx >= v_s and x.xx <= v_e order
  by x.xx;

 --lokale Variablen
   a              Number;
   v_c_max        Number;
 -- *******************
   v_d_c          Number:=24; -- Anzahl der Records, die angezeigt werden, dieser Parameter kann gendert werden !
 -- *******************
   v_s            Number :=  nvl(vals,1);
   v_e            Number :=  nvl(vale,v_d_c);
   -- v_v         Varchar2(255) := valv; -- Vendor
   v_link         Varchar2(255) := '' ; -- Variable fr Link auf Details
   v_dateformat   Varchar2(30) := DBFUN$GET_WERTE('lang_dateformat',DBFUN$GET_WERTE('language','gui'));
   defaultgui     Varchar2(200) := dbfun$default_gui;

   v_dummy        Number(10):=0;
   v_td_string    Varchar2(1200);

   -- Zugriffsverwaltung
   v_modus        Number(1);
   v_module_name  Varchar2(40) := 'PROJ_WERTEBEREICHE_LIST';


BEGIN
 begin
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name);
 if v_modus > 0 then

 htp.p('<HTML>');
 htp.p('<head>');
 htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
 htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
 htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||defaultgui||'/css/default.css'' type=''text/css''>');

  htp.p(dbfun$Projtoolbar2js);

 htp.p('<title></title>');
 htp.p('</head>');
 htp.p('<BODY TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');

 htp.p (dbfun$projtoolbar(upper(v_module_name)
                               , v_modus
                               , null
                               )
          );


 htp.p('<div class="maintitle"> Systemparameter und Listen </div>');


 htp.p('<div id="tdlist0" class="tdlist0" style="visibility:hidden;top:0px;height:0px;">bbbd</div>');
 htp.p('<div id="tdlist1" class="tdlist1" style="visibility:hidden;top:0px;height:0px;">asd</div>');


-- Ueberschriften zusammenbauen
 htp.p('<div class="listtable">');
 htp.p('<table class="listtable" style="width:98%">');
 htp.p(' <tr>');
 htp.p('  <TD width=30  class="tdh">ID</td>');
 htp.p('  <TD width=200 class="tdh">Werteliste</td>');
 htp.p('  <TD width=200 class="tdh" colspan=2>Bemerkung</td>');
 htp.p(' </tr>');


 for ca1 in c1 (v_s, v_e) loop
 v_dummy := v_dummy +1;
  v_td_string :=  '    <td onmouseover="tr'||v_dummy
   ||'.style.backgroundColor=''#FFFF50'';" onmouseout="tr'||v_dummy||'.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;">';

  htp.p ('    <tr class="tdlist'||mod(v_dummy,2)||'" id="tr'||v_dummy||'">');-- class="tdlist'||mod(v_dummy,2)||'" onmouseover="this.style.backgroundColor=''#FFFF00'';" onmouseout="this.style.backgroundColor=tdlist'||mod(v_dummy,2)||'.style.backgroundColor;">');
  v_link := '<a href="proj_wertebereiche_details?p_id='||ca1.id||'">';
  htp.p(v_td_string||v_link||ca1.id||'</a></td>');
  htp.p(v_td_string||v_link||ca1.name||'</a></td>');
  htp.p(v_td_string||v_link||ca1.bemerkung||'</a></td>');

  htp.p(v_td_string||v_link
  ||'<img src="/i/projekt/'||defaultgui||'/img/tool/details.png" BORDER="NO" alt="[Details]" title="Details"></a></td>');

  htp.p('</tr>');

 end loop;


 htp.p('</table>');
 htp.p('</div>');

 -- Navigationsleiste um die weiteren Devices auflisten zu knnen
-- htp.p('</TD></TR><TR><TD>');

 -- Muss noch angepat werden an die neuen Eingangsparameter !!!
 select count(id)
 into v_c_max from
  xdb_wertebereiche
  ;

 if v_c_max > 16 then -- sonst kann man sich das sparen !!
   for a in 0..20 loop
    if a=11 then
  htp.p ('<br>');
 end if;
 if a*v_d_c +1 < v_c_max then
     if a*v_d_c +1 <> v_s then
      -- v_link zusammensetzen !
    v_link := '<A class="abc" HREF="';
    v_link := v_link
       || lower(v_module_name)||'?vals='
         ||to_char(a*v_d_c+1)||chr(38)||'vale='
       ||to_char(a*v_d_c +v_d_c) ;

   v_link := v_link ||'"> '
      || to_char(a*v_d_c +1)
    ||' - '
     || to_char( a*v_d_c +v_d_c )
    ||'</A>|';

     htp.p (v_link);
     -- htp.p ('<A HREF="xdb_scanned_dev_list?ps='||a*20||chr(38)||'pe='||(a+1)*20-1||'"> '||a*20||'-'||(a+1)*20-1||'</A>';
    else
     htp.p ('<span  class="abc"><b>'|| to_char(a*v_d_c +1)||' - '|| to_char(a*v_d_c +v_d_c )||'</b></span>|' );
    end if;
   end if;
  end loop;
 end if;


-- htp.p('</TD></TR></TABLE>');
 htp.p('</BODY></HTML>');
else -- NO Access
 htp.p('<HTML><BODY><H1> no Accesss with Your Account ! </H1></body></html>');
end if;

  exception when others
  then
     htp.p ('SQL-Error '||sqlerrm ||' / '|| sqlcode );
  end;
end;
/


----------------------------------------------------------------
-- PROCEDURE PROJ_ZUG_USER_ADMIN
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE proj_zug_user_admin
as
 --[VERS:2008-07-28]
 -- Ziel:
 -- Generiert Admin-Page mit Buttons zu den anderen Pages

 -- Autor: Erich Heinemann
 -- Bonn 15.07.2008

  -- Zugriffsverwaltung
   v_modus        Number(1);
   v_module_name  Varchar2(30)  := 'PROJ_ZUG_USER_ADMIN';

   defaultgui     Varchar2(400) := dbfun$default_gui;
   defaultlang    Varchar2(400) := dbfun$default_lang;
   dateformat     Varchar2(40)  := ('DD.MM.YYYY HH24:MI');


BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed(
                v_module_name
                 );

  if v_modus > 0 then

  htp.p('<html>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p(' <link rel=''stylesheet'' href=''/i/projekt/'||defaultgui||'/css/default.css'' type=''text/css''>');
  htp.p('  <script type="text/javascript">     ');
  htp.p('        var djConfig = { isDebug: false }; ');
  htp.p('  </script>                       ');
  htp.p('  <script type="text/javascript" src="/i/projekt/js/dojo_core/dojo.js"></script>     ');
  htp.p('  <script type="text/javascript">');
  htp.p('        dojo.require("dojo.widget.ComboBox");');
  htp.p('        dojo.require("dojo.widget.TabContainer");   ');
  htp.p('        dojo.require("dojo.widget.LinkPane");    ');
  htp.p('        dojo.require("dojo.widget.ContentPane");   ');
  htp.p('        dojo.require("dojo.widget.LayoutContainer");  ');
  htp.p('</script> ');

  htp.p(dbfun$projtoolbar2js);
  htp.p('<title>Projekt | User-Administration</title>');
  htp.p('</head>');
  htp.p('<body topmargin=5 leftmargin=5 marginwidth=5 marginheight=5>');
  htp.p (dbfun$projtoolbar(upper(v_module_name), v_modus
                 , null
                  )
            );
  htp.p('<div class="maintitle">User-Administration</div>');

  -- Container fr TAB-Reiter
  htp.p(' <div id="projektTabContainer" dojoType="TabContainer" style="background-color:#FFFFFF; '
  ||' position:absolute; top:66px; left:0px; width: 100%; height: 500px" selectedTab="tab1"> ');

  -- Erster TAB-Reiter
-- TAB1: User
  htp.p(' <div id="tab1" dojoType="ContentPane" label="User (Logins)">');
  htp.p('   <iframe src="xdb_zug_user_list" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
  htp.p(' </div>');

-- TAB2: Rollenzuordnung zu User
  htp.p(' <div id="tab2" dojoType="ContentPane" label="User - Rollenzuordnung">');
  htp.p('   <iframe src="xdb_zug_zuo_user_menu_list" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
  htp.p(' </div>');

-- TAB3: Rollen
  htp.p(' <div id="tab3" dojoType="ContentPane" label="Rollen">');
  htp.p('   <iframe src="xdb_zug_roles_list" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
  htp.p(' </div>');

-- TAB4: Rollen  zu Masken - Zuordnung
  htp.p(' <div id="tab4" dojoType="ContentPane" label="Rollen zu Masken-Zuordnung">');
  htp.p('   <iframe src="xdb_zug_menuroles_mode_list" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
  htp.p(' </div>');

-- TAB5: Rollen
  htp.p(' <div id="tab5" dojoType="ContentPane" label="Rollen zu Masken-Zuordnung">');
  htp.p('   <iframe src="xdb_zug_menuroles_mode_list" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
  htp.p(' </div>');

-- TAB6: Rollen
  htp.p(' <div id="tab6" dojoType="ContentPane" label="Masken (Prozeduren)">');
  htp.p('   <iframe src="xdb_zug_module_list" style="width:99%;height:99%;" frameborder="0" marginheight="0" marginwidth="0" scrolling="yes" /></iframe>');
  htp.p(' </div>');

  -- TAB-Pane auch zu Ende
  htp.p(' </div>');

 else -- v-modus =0
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1><BR>');
 end if;


   htp.p('<p><hr><p><input type="button" value="< Back to the Start-Page" onClick="self.document.location.href=''/pls/proj/''" style="width:200px">');

 htp.p('</BODY>' );
 htp.p('</HTML>' );
 exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);

end;
/


----------------------------------------------------------------
-- PROCEDURE XDB_CREATE_USER
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE XDB_CREATE_USER
(     p_un            in Varchar2 default null -- User_Name
  ,   p_pw            in Varchar2 default null
  ,   p_role          in Varchar2 default 'PROJ_RO'
  ,   p_user_name     in Varchar2 default null
  ,   p_email_address in varchar2 default null
)
authid current_user
as
--[VERS:2008-07-15]
 -- Maske ganz neu aufgebaut

-- lokale Variablen:
  v_un            Varchar2(2000)  := p_un; -- user
  v_pw            Varchar2(2000)  := p_pw; -- pw
  v_role          Varchar2(2000)  := upper(p_role) ; -- defaultrolle
  v_user_name     Varchar2(2000)  := nvl(p_user_name,initcap(p_un));

  v_statement     Varchar2(2000);
  v_id            Number(10);
  v_role_id       Number(10);
  v_error         Number(1) :=0;

  -- Zugriffsverwaltung
   v_modus        Number(1);
   v_module_name  Varchar2(30)  := 'XDB_CREATE_USER';

  -- Defaults
   defaultgui     Varchar2(400) := dbfun$default_gui;
   defaultlang    Varchar2(400) := dbfun$default_lang;
   dateformat     Varchar2(40)  := ('DD.MM.YYYY HH24:MI');

 -- lokale Cursor
  cursor c1 is
   select  db_role
         , rolename
         from xdb_zug_roles
    order by rolename;



BEGIN
 begin
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name);
 if v_modus > 0 then

 -- Prfung, ob dieser User nicht schon existiert!!!
 -- noch offen
 if p_pw is not null
  and p_un is not null
  then
   begin
    if upper(v_role) not in ('PROJ_RO','PROJ_RW')
         or v_role is null then
         v_role :=  'PROJ_RO';
    end if;

   htp.p('<HTML>');
   htp.p('<head>');
   htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
   htp.p(' <link rel="stylesheet" href="/i/projekt/'||defaultgui||'/css/default.css" type="text/css">');
   htp.p('<title> PROJEKT | Create User </title>');
   htp.p('</head>');
   htp.p('<BODY  BGCOLOR="#FFFFFF" LINK="#000000" VLINK="#000000" TEXT="#000000"');
   htp.p('    TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');

   htp.p('<div class="maintitle"> Create User </div>');

    htp.p('<table class="formtable">');
    htp.p('<tr><td  class="tdv" align=left><b>User '||upper (v_un)||' wird angelegt</b></td></tr>');

     v_statement := 'create user '||upper(v_un)||' identified by '||v_pw;
     execute immediate ( v_statement);

     v_statement := 'grant connect to '||upper(v_un);
     execute immediate v_statement;
     htp.p ('<tr><td  class="tdv" align=left>Rolle "Connect" zugewiesen</td></tr>');
       v_statement := 'grant '||v_role||' to '||upper(v_un);
     htp.p ('<tr><td  class="tdv" align=left>Rolle "'||v_role||'" zugewiesen</td></tr>');

    execute immediate v_statement;
        begin
        select nvl(max(id),0)+1 into v_id from xdb_zug_user;
        exception when others
         then
         v_id := 1;
        end;

        begin
        select id into v_role_id
          from xdb_zug_roles
         where upper(rolename) = upper(v_role);
                 exception when others
         then
         v_role_id := -2;
        end;

        insert into xdb_zug_user
         (id, login, user_name, email, memo)
         values
         ( v_id, v_un, v_user_name, p_email_address, 'created '||to_char(sysdate,'DD.MM.YYYY'));
      htp.p ('<tr><td  class="tdv" align=left> Tabelle "zug_zuo_user" bearbeitet</td></tr>');
        insert into xdb_zug_zuo_user_menu
         (user_id, menurole_id,id )
         values
          (v_id, v_role_id, seq_zug_zuo_user_menu.nextval);
      htp.p ('<tr><td  class="tdv" align=left> Tabelle "xdb_zug_zuo_user_menu" bearbeitet</td></tr>');
        commit;

  exception
   when others then
   htp.p  ('<H1>BAD DATA: SQL-Error '||sqlerrm ||' / '|| sqlcode||' </H1>');
   v_error := 1;
  end;

  if v_error = 0 then
   htp.p('<tr><td  class="tdv" align=left><span class="maintitle"> User '||initcap (v_un)||' erstellt. </td></tr>');
  end if;
  htp.p ('</tr></table>');
  htp.p('</body>');
  htp.p('</html>');

 else

   htp.p('<HTML>');
   htp.p('<head>');
   htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
   htp.p(' <link rel="stylesheet" href="/i/projekt/'||defaultgui||'/css/default.css" type="text/css">');
   htp.p('<title> PROJEKT | Create User </title>');
   htp.p('</head>');
   htp.p('<BODY  BGCOLOR="#FFFFFF" LINK="#000000" VLINK="#000000" TEXT="#000000"');
   htp.p('    TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');

   htp.p('<div class="maintitle"> Create User </div>');

  htp.p('<TABLE class="formtable">');

-- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method="HEAD">');
 -- Neue Werte --

   htp.p ('<tr><td  class="tdv" align=right> Username  (z.B. Hans Mustermann)</td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_user_name" type="text" size=40 maxlength=40 value="'
     ||'"></td></tr>');

     htp.p ('<tr><td  class="tdv" align=right> Login  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_un" type="text" size=40 maxlength=40 value="'
     ||'"></td></tr>');


   htp.p ('<tr><td  class="tdv" align=right> First Password  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_pw" type="password" size=40 maxlength=40 value="'
     ||'"></td></tr>');

    htp.p ('<tr><td  class="tdv" align=right> Default-Role</td>');
    htp.p ('<td  class="tdv"> <select name="p_role" size="1" maxlength="40" width="40" style="width:220px">');
    for ca1 in c1  loop
      htp.p (' <option value="'||upper(ca1.db_role)||'" '||dbfun$selected_opt(upper(ca1.db_role),p_role)||'>'||substr(ca1.rolename,1,30));
    end loop;
    htp.p ('</select></td></tr>');

   htp.p ('<tr><td  class="tdv" align=right> Contact (Email-Address)');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_email_address" type="text" size=40 maxlength=40 value="'
     ||'"></td></tr>');


   htp.p ('<tr><td  class="tdv" align=right></td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('  <input type="submit" value=" Create "></td></tr>');
   htp.p('</tr></table>');

   htp.p(dbfun$html_button('xdb_zug_user_list','Listenansicht'));
   htp.p('</BODY>');
   htp.p('</HTML>');
   end if; -- pw NULL
  else -- NO Access
   htp.p('<HTML><BODY><H1> no Accesss with Your Account ! </H1></body></html>');
 end if; -- v_modus
 end;
exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- PROCEDURE XDB_LOGOUTADM
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE xdb_logoutadm (p_width in Number default(800)  )
as
--[VERS:2004-07-12]
-- Ziel:
-- Logout und Verzweigung zu Navigation

-- Autor: Erich Heinemann
-- Kln 12.11.2004



  -- Formatierung
  v_width          Number       := p_width;
  kund             Varchar2(2)  := chr(38);
  v_modus          Number(2);
  v_module_name    varchar2(50) := 'xdb_logoutadm';

BEGIN

 begin



  v_modus := 1;

  if v_modus > 0 then
   -- HTTP-Session ffen
    htp.p('<HTML>');
    htp.p('<head>');
    htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
    htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');

  -- HTML-Include fr das Men
    htp.p(dbfun$projtoolbar2js);

    htp.p(' <link rel=''stylesheet'' href=''/xdb/cust/default.css'' type=''text/css''>');
    htp.p('<title></title>');

    htp.p('</head>');
    htp.p('<BODY  BGCOLOR="#FFFFFF" LINK="#000000" VLINK="#000000" TEXT="#000000"');
    htp.p('    TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');

    htp.p (dbfun$projtoolbar(upper(v_module_name)
                                , v_modus
                                , null
                                )
           );

     htp.p('<div class="maintitle"> Logout </div>');
    -- neue Tabelle fr die Liste des HTML-Mens
    htp.p('<table width='||v_width||'>');

  -- if dbpck$main.fun$chk_module_allowed('XDB_ZUG_USER_ADMIN') > 2 and user = 'XDBADM' then
    htp.p('<TR>');
  --  htp.p('  <TD width="200" class="tdh" align="center"><span class="ftb">User-Admin</span></TD>');
    htp.p('  <td align="center">');
    htp.p('    <input type="button" value="Abmelden" onClick="self.document.location.href=''logmeoff''" style="width:200px"></td>');
    htp.p('</TR>');

 /*   htp.p('<TR>');
  --  htp.p('  <TD width="200" class="tdh" align="center"><span class="ftb">User-Admin</span></TD>');
    htp.p('  <td align="center">');
    htp.p('    <input type="button" value="Einstellungen" onClick="self.document.location.href=''xdb_tst_user_prevs_details''" style="width:200px"></td>');
    htp.p('</TR>');

    htp.p('<TR>');
  --  htp.p('  <TD width="200" class="tdh" align="center"><span class="ftb">User-Admin</span></TD>');
    htp.p('  <td align="center">');
    htp.p('    <hr>'); --<input type="button" value="Abmelden" onClick="self.document.location.href=''logmeoff''" style="width:200px"></td>');
    htp.p('  </td>');
    htp.p('</TR>');

   if dbpck$main.fun$chk_module_allowed('XDB_TST_STATS3') > 1 then
    htp.p('<TR>');
    htp.p('  <td align="center">');
    htp.p('    <input type="button" value="Allg. Jahres-Statistik fr Tickets" onClick="self.document.location.href=''xdb_tst_stats3''" style="width:200px"></td>');
    htp.p('  </td>');
    htp.p('</TR>');

   end if;

   if dbpck$main.fun$chk_module_allowed('XDB_TST_STATS4') > 1 then
    htp.p('<TR>');
    htp.p('  <td align="center">');
    htp.p('    <input type="button" value="Meine Jahres-Statistik fr Tickets" onClick="self.document.location.href=''xdb_tst_stats4''" style="width:200px"></td>');
    htp.p('  </td>');
    htp.p('</TR>');
   end if;

--xdb_contact_list
   if dbpck$main.fun$chk_module_allowed('XDB_TICKET_DETAILS') > 0 then
    htp.p('<TR>');
    htp.p('  <td align="center">');
    htp.p('    <input type="button" value="Ansprechpartner aus meinen Tickets" onClick="self.document.location.href=''xdb_contact_list''" style="width:200px"></td>');
    htp.p('  </td>');
    htp.p('</TR>');
   end if;

 --  end if;
    htp.p('<TR>');
  --  htp.p('  <TD width="200" class="tdh" align="center"><span class="ftb">User-Admin</span></TD>');
    htp.p('  <td align="center">');
    htp.p('    <hr>'); --<input type="button" value="Abmelden" onClick="self.document.location.href=''logmeoff''" style="width:200px"></td>');
    htp.p('  </td>');
    htp.p('</TR>');

   if dbpck$main.fun$chk_module_allowed('XDB_ZUG_USER_ADMIN') > 2 and user = 'XDBADM' then
    htp.p('<TR>');
    htp.p('  <td align="center">');
    htp.p('    <input type="button" value="Useradministration" onClick="self.document.location.href=''xdb_zug_user_admin''" style="width:200px"></td>');
    htp.p('</TR>');
    htp.p('<TR>');
    htp.p('  <td align="center">');
    htp.p('    <input type="button" value="Ticket-Groups" onClick="self.document.location.href=''xdb_ticket_group_list''" style="width:200px"></td>');
    htp.p('  </td>');
    htp.p('</TR>');
  end if;

  if dbpck$main.fun$chk_module_allowed('XDB_PW_CHANGE')> 0 and user <> 'XDBADM' then
    htp.p('<TR>');
  --  htp.p('  <TD width="200" class="tdh" align="center"><span class="ftb">Change-Password</span></TD>');
    htp.p('  <td align="center">');
    htp.p('    <input type="button" value="Passwort ndern" onClick="self.document.location.href=''xdb_pw_change''" style="width:200px"></td>');
    htp.p('  </td>');
    htp.p('</TR>');
   end if;
   if dbpck$main.fun$chk_module_allowed('XDB_WERTEBEREICHE_LIST')> 2 then
    htp.p('<TR>');
  --  htp.p('<TD width="200" class="tdh" align="center"><span class="ftb">TSTTicket-Config</span></TD>');
    htp.p('  <td align="center">');
    htp.p('    <input type="button" value="Wertelisten" onClick="self.document.location.href=''xdb_wertebereiche_list''" style="width:200px"></td>');
    htp.p('  </td>');
    htp.p('</TR>');
   end if;

   htp.p('</TABLE>');
   htp.p('</TD></TR>');
   htp.p('</TABLE>');
*/
 else -- v-modus =0
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1><BR>');
 end if;


 htp.p('</BODY>' );
 htp.p('</HTML>' );

end;
 exception when others
 then
    htp.p ('SQL-Error '||sqlerrm ||' / '|| sqlcode );
end;
/


----------------------------------------------------------------
-- Grants
----------------------------------------------------------------


GRANT EXECUTE      ON XDB_LOGOUTADM                  TO PROJ_RO;

GRANT EXECUTE      ON XDB_LOGOUTADM                  TO PROJ_RW;

----------------------------------------------------------------
-- PROCEDURE XDB_ZUG_MENUROLES_MODE_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE xdb_zug_menuroles_mode_details
(    p_id           in Number    default null
   , p_menuroles_id in Number    default NULL
   , p_module_id    in Number    default NULL
   , p_modus        in Number    default NULL
   , p_memo         in Varchar2  default NULL
  ,  p_do_update    in varchar2  default ''
  ,  p_do_delete    in Varchar2  default ''
  ,  p_do_insert    in Varchar2  default ''
) as
--[VERS:2004-07-12]

 -- zur Verwaltung der Module und Rollen
 -- Zur Zeit noch kein Update der DB-Rollen-grants vorhanden !
 -- E.Heinemann 08.07.2004

-- lokale Variablen:
   v_menuroles_id    xdb_zug_menuroles_mode.menuroles_id%type;
   v_module_id       xdb_zug_menuroles_mode.module_id%type;
   v_modus2          xdb_zug_menuroles_mode.modus%type;
   v_memo            xdb_zug_menuroles_mode.memo%type;
   v_id              xdb_zug_menuroles_mode.id%type;

   v_module_name     Varchar2(30) := 'XDB_ZUG_MENUROLES_MODE_DETAILS';
   v_error_mod1      Varchar2(80);
   v_error_mod2      Varchar2(80);
   v_mod_ret         Number(2);
   v_modus           Number(2);

 cursor c1 (l_role_id in Number) is
  select id, name from XDB_zug_module
 --  where id not in (select module_id from xdb_zug_menuroles_mode where menuroles_id = l_role_id )
 --  or l_role_id is null
  order by name;

 cursor c2 (l_module_id in Number) is
  select id, rolename name from xdb_zug_roles
  order by rolename;



 BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed(v_module_name);

  if v_modus > 0 then
   -- Delete
 if p_id is not null
   and p_do_delete is not NULL
   and p_do_delete = 'delete'
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen
        v_module_id := p_module_id;
     delete xdb_zug_menuroles_mode
   where id = v_id;
    commit;
  end if; -- delete

 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
if (p_id is not null)
 or  (p_do_insert = 'insert' and p_id is null)
 or  (p_do_update = 'update')
  then
 -- Datensatz einfgen bzw. bernehmen
   v_menuroles_id         :=  p_menuroles_id ;
   v_module_id            :=  p_module_id ;
   v_modus2               :=  p_modus ;
   v_memo                 :=  nvl(p_memo,user) ;
   v_id                   :=  p_id ;
end if;

if p_do_insert = 'insert'
 and v_modus > 1 -- min 2!
 then

--SEQUENCE !!!!!!
 select seq_zug_menuroles_mode.nextval into v_id from dual;
  insert into xdb_zug_menuroles_mode
  (
             menuroles_id
        ,    module_id
        ,    modus
        ,    memo
        ,    id
          ) values (
            v_menuroles_id
        ,   v_module_id
        ,   v_modus2
        ,   v_memo
        ,   v_id
        );
  commit;
        --p_id := v_id;
  end if; -- Insert ??

-- UPDATE
  if p_do_update = 'update'
   and p_id is not null
   and v_modus > 0
    then
     v_id := p_id;
   update xdb_zug_menuroles_mode
    set
       module_id   =  v_module_id
     , modus       =  v_modus2
     , memo        =  v_memo
     , id          =  v_id
  where id         = v_id;
  commit;
 end if; -- Update ??

 if     (p_do_insert <> 'insert' or p_do_insert is NULL)
     and (p_do_delete <> 'delete' or p_do_delete is NULL)
     and  p_id is not null
  then
    v_id  := p_id;
   select
    module_id
  , modus
  , memo
  , id
  into
   v_module_id
  , v_modus2
  , v_memo
  , v_id
    from xdb_zug_menuroles_mode
 where id = v_id;
 end if;

  htp.p('<HTML>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p(' <link rel=''stylesheet'' href=''/xdb/cust/default.css'' type=''text/css''>');
  htp.p('<title></title>');
  htp.p('</head>');
  htp.p('<BODY  TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');
  htp.p('<div class="maintitle"> Rollen- zu Masken-Zuordnung </div>');

  htp.p('<TABLE class="formtable">');
-- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method=head>');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type=hidden  name="p_id" value="'||v_id||'"/>');
 -- Neue Werte --
   htp.p ('<tr><td  class="tdv" > ID:  </td>');
   htp.p ('      <td  class="tdv"> '||v_id
  ||'</td></tr>');
 if p_do_delete = 'delete' and p_do_delete is not null then
  htp.p ('<tr><td  class="tdv" colspan = 2><b> is deleted </b></td></tr>');
 else -- nicht gelscht
   htp.p ('<tr><td  class="tdv" > Module:  </td>');
  -- htp.p ('      <td  class="tdv"> ');
  -- htp.p ('   <input name="p_module_id" type="text" size=40 maxlength=22 value="'
  --     || v_module_id||'"></td></tr>');

      htp.p ('<td  class="tdv"> <select name="p_module_id" size="1" maxlength="40" width="40" style="width:280px">');
   for ca1 in c1(v_menuroles_id) loop
    htp.p (' <option value="'||ca1.id||'" '||dbfun$selected_opt(ca1.id,v_module_id)||'>'||substr(ca1.name,1,30));
   end loop;
   htp.p ('</select></td></tr>');




   htp.p ('<tr><td  class="tdv" > Menurole:  </td>');
 --  htp.p ('      <td  class="tdv"> ');
 --  htp.p ('   <input name="p_menuroles_id" type="text" size=40 maxlength=22 value="'
 --    || v_menuroles_id||'"></td></tr>');
   htp.p ('<td  class="tdv"> <select name="p_menuroles_id" size="1" maxlength="40" width="40" style="width:280px">');
   for ca2 in c2(v_module_id) loop
    htp.p (' <option value="'||ca2.id||'" '||dbfun$selected_opt(ca2.id,v_menuroles_id)||'>'||substr(ca2.name,1,30));
   end loop;
   htp.p ('</select></td></tr>');

     htp.p ('<tr><td  class="tdv" > Modus:  </td>');
 --  htp.p ('      <td  class="tdv"> ');
--  htp.p ('   <input name="p_modus" type="text" size=40 maxlength=22 value="'
  --   || v_modus||'"></td></tr>');
   htp.p ('<td class="tdv"><select name="p_modus" size="1" maxlength="40" width="40" style="width:280px">');
    htp.p (' <option value="1" '||dbfun$selected_opt(1,v_modus2)||'>Read-Only');
    htp.p (' <option value="2" '||dbfun$selected_opt(2,v_modus2)||'>Read and Update');
    htp.p (' <option value="3" '||dbfun$selected_opt(3,v_modus2)||'>Read, Update and Delete');
   htp.p ('</select></td></tr>');



   htp.p ('<tr> <td  class="tdv" > Memo:  </td>');
   htp.p ('     <td  class="tdv"> ');
   htp.p ('      <input name="p_memo" type="text" size=40 maxlength=255 value="'|| v_memo||'"></td></tr>');


    htp.p ('<tr><td colspan="2" align="right">');
   -- htp.p('V_ID:'||nvl(v_id,p_id)||v_modus||user);
   if v_id is not Null then
     if v_modus > 0 then
       htp.p ('  <input type="submit" name ="p_do_update" value="update"/>');
      end if;
      if v_modus > 2 then
       htp.p ('  <input type="submit" name ="p_do_delete" value="delete"/>');
      end if;
    end if;
   if v_id is NULL
      and v_modus > 1 then
      htp.p ('  <input type="submit" name ="p_do_insert" value="insert">');
   end if;
    htp.p (' </td></tr>');
   end if; -- do_delete
    htp.p (' </form>');
    htp.p('<TR>');
 --   htp.p('  <td width=600 valign=top colspan=2><hr></td>');
    htp.p('</TABLE>');

  else -- v-modus =0
  htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;
 -- eigentlich msste mann vorher die Berechtigung prfen !!
 htp.p (dbfun$html_button('xdb_zug_menuroles_mode_list','Listenansicht'));
 htp.p('</BODY>');
 htp.p('</HTML>');
exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- PROCEDURE XDB_ZUG_MENUROLES_MODE_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE xdb_zug_menuroles_mode_list
as
--[VERS:2005-01-28]
-- Ziel:
-- Generiert Liste mit zugelassen Modulen

-- Autor: Erich Heinemann
-- Kln 02.10.2003

 -- Suche aller passenden Subnetzeintrge
 cursor c1 is
 select a.id
   , replace(m.usage,m.name,'') usage
   , initcap(m.name) name
   , r.rolename
   , decode (modus, 0, 'no access',1,'read only',2,'update,read',3,'insert,read,update', modus) modus
  from xdb_zug_menuroles_mode a
  , xdb_zug_module m
  , xdb_zug_roles r
 where a.module_id = m.id
   and a.menuroles_id = r.id
   order by m.name, modus;

  -- Zugriffsverwaltung
  v_modus       Number(1);
  v_module_name Varchar2(30) := 'XDB_ZUG_MENUROLES_MODE_LIST';
  v_error_mod1  Varchar2(80);
  v_error_mod2  Varchar2(80);
  v_mod_ret     Number(2);


BEGIN
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name);

 if v_modus > 0 then
  -- HTTP-Session ffen
   htp.p('<HTML>'||chr(10));
   htp.p('<head>'||chr(10));
   htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
   htp.p(' <link rel="stylesheet" href="/i/projekt/default/css/default.css" type="text/css">');
   htp.p('<title>Projekt | Rollen - zu Masken-Zuordnung</title>');
   htp.p('</head>');
   htp.p(' <BODY  TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');
   htp.p('  <div class="maintitle"> Rollen - zu Masken-ZUordnung </div>');
  if v_modus > 2 then
   htp.p(dbfun$html_button('xdb_zug_menuroles_mode_details','<img src="/i/projekt/default/img/add_new_abc.png" border="no">Neue Zuordnung einfgen') );
  end if;
    -- neue Tabelle fr die Liste des HTML-Mens
   htp.p('<table class="listtable" style="width:98%;">');
   htp.p('<tr>');
   htp.p('    <td class="tdh">ID             </TD>');
   htp.p('    <td class="tdh">Prozedur-Name    </TD>');
   htp.p('    <td class="tdh">Nutzung   </TD>');
   htp.p('    <td class="tdh">PROJ-Rolle      </TD>');
   htp.p('    <td class="tdh" colspan=2>Modus </TD>');
   htp.p('<tr>');

  for ca1 in c1  loop
    htp.p('<tr>');
    htp.p('<td class="tdf">'||ca1.id      ||'</td>');
    htp.p('<td class="tdv">'||ca1.name    ||'</td>');
    htp.p('<td class="tdv">'||ca1.usage   ||'</td>');
    htp.p('<td class="tdv">'||ca1.rolename||'</td>');
    htp.p('<td class="tdv">'||ca1.modus   ||'</td>');
    htp.p('<td class="tdv"><a href="xdb_zug_menuroles_mode_details?p_id='||ca1.id||'">');
    htp.p('<img src="/i/projekt/default/img/details.png" border=no></a></td></tr>');
   end loop;
   htp.p('</table>');
   htp.p('</td></tr>');
 --  htp.p('<tr><td><a href="javascript:history.back()">Back</a></TD></TR>');
   htp.p('</table>');

 else -- v-modus =0
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1><BR>');
 end if;

 htp.p('</body>');
 htp.p('</html>');

 exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);

end;
/


----------------------------------------------------------------
-- PROCEDURE XDB_ZUG_MODULE_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE XDB_ZUG_MODULE_DETAILS
(
     p_id           in Number    default NULL
   , p_name         in Varchar2  default NULL
   , p_usage        in Varchar2  default NULL
   , p_typ          in Varchar2  default NULL
  ,  p_do_update    in Varchar2  default ''
  ,  p_do_delete    in Varchar2  default ''
  ,  p_do_insert    in Varchar2  default ''
) as
--[VERS:2004-07-12]
-- lokale Variablen:
   v_id           xdb_zug_module.id%type;
   v_name         xdb_zug_module.name%type;
   v_usage        xdb_zug_module.usage%type;
   v_typ          xdb_zug_module.typ%type;

   v_modus        Number(1);
   v_module_name  Varchar2(30) := 'XDB_ZUG_MODULE_DETAILS';
   v_error_mod1   Varchar2(80);
   v_error_mod2   Varchar2(80);
   v_mod_ret      Number(2);


 -- Local-Function
    function selected_opt ( val1 in varchar2, value in varchar2)
   return varchar2 -- selected
   as
  begin
 if val1 = value then
  return 'selected';
 else
  if (val1 is NULL and value = '')
   or (val1 ='' and value is NULL)
    then
    return 'selected';
  end if;
  return NULL;
 end if;
   end;

 BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

 if v_modus > 0 then
   -- Delete
  if p_id is not null
   and p_do_delete is not NULL
   and p_do_delete = 'delete'
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen
        v_name := p_name;
     delete XDB_ZUG_MODULE
   where id = v_id;
    commit;
  end if; -- delete

 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
 if (p_id is not null)
  or  (p_do_insert = 'insert' and p_id is null)
  or  (p_do_update = 'update')
   then
  -- Datensatz einfgen bzw. bernehmen
   v_id   :=  p_id ;
   v_name         :=  upper(p_name) ;
   v_usage        :=  p_usage ;
   v_typ          :=  nvl(p_typ,'Procedure') ;
 end if;

 if p_do_insert = 'insert'
  and v_modus > 1 -- min 2!
  then

 --SEQUENCE !!!!!!
  select seq_zug_module.nextval into v_id from dual;
   insert into xdb_zug_module
    (
           ID
        ,  NAME
        ,  USAGE
        ,  TYP
     ) values (
         v_id
      ,  upper(v_name)
      ,  v_usage
      ,  v_typ
     );
  commit;
 end if; -- Insert ??

-- UPDATE
 if p_do_update = 'update'
   and p_id is not null
   and v_modus > 0
    then
     v_id := p_id;
     update xdb_zug_module
     set
       name        =  upper(v_name)

     , usage      =  v_usage
     , typ        =  nvl(v_typ,'Procedure')
  where id   = v_id;
  commit;
 end if; -- Update ??

  if     (p_do_insert <> 'insert' or p_do_insert is NULL)
     and (p_do_delete <> 'delete' or p_do_delete is NULL)
     and  p_id is not null
  then
    v_id               := p_id;
   select
   name
  , usage
  , typ
  into
   v_name
  , v_usage
  , v_typ
    from xdb_zug_module
 where id = v_id;
 end if;

  htp.p('<HTML>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p(' <link rel="stylesheet" href="/i/projekt/default/css/default.css" type="text/css">');
  htp.p('<title>Projekt | Masken (Module) </title>');
  htp.p('</head>');
  htp.p('<BODY TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');

   htp.p('<div class="maintitle">Masken-Details</div>');

  htp.p('<TABLE class="formtable">');
-- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method=head>');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type=hidden  name="p_id" value="'||v_id||'"/>');
 -- Neue Werte --
   htp.p ('<tr><td  class="tdh" > ID:  </td>');
   htp.p ('      <td  class="tdv"> '||p_id
  ||'</td></tr>');
 if p_do_delete = 'delete' and p_do_delete is not null then
  htp.p ('<tr><td  class="tdv" colspan = 2><b> is deleted </b></td></tr>');
 else -- nicht gelscht
   htp.p ('<tr><td  class="tdh" > Name:  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_name" type="text" size=40 maxlength=100 value="'
     || v_name||'"></td></tr>');

   htp.p ('<tr><td  class="tdh" > Nutzung:  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_usage" type="text" size=40 maxlength=70 value="'
     || v_usage||'"></td></tr>');

   htp.p ('<tr><td  class="tdh" > Typ:  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_typ" type="text" size=40 maxlength=10 value="'
     || v_typ||'"></td></tr>');

    htp.p ('<tr><td class="tdh" colspan="2">');
   if v_id is not Null then
     if v_modus > 2 then
       htp.p ('  <input type="submit" name ="p_do_update" value="update"/>');
      end if;
      if v_modus > 2 then
       htp.p ('  <input type="submit" name ="p_do_delete" value="delete"/>');
      end if;
    end if;
   if v_id is NULL
      and v_modus > 2 then
      htp.p ('  <input type="submit" name ="p_do_insert" value="insert">');
   end if;
   htp.p (' </td></tr>');
 end if; -- do_delete
   htp.p (' </form>');
   htp.p('<TR><TD width=600 valign=top colspan=2>');
   htp.p(' <HR> </TD>');
   htp.p('</TR></TABLE>');
  else -- v-modus =0
  htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;
 -- eigentlich msste mann vorher die Berechtigung prfen !!
 htp.p (dbfun$html_button('xdb_zug_module_list','Listenansicht'));
 htp.p('</BODY>');
 htp.p('</HTML>');
exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- PROCEDURE XDB_ZUG_MODULE_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE xdb_zug_module_list
as
--[VERS:2005-02-01]
-- Ziel:
-- Generiert Liste mit zugelassen Modulen

-- Autor: Erich Heinemann
-- Kln 02.10.2003

 -- Suche aller passenden Subnetzeintrge
 cursor c1 is
  select id
    , name
    , usage
 , typ
   from XDB_zug_module
  order by name;

  -- Zugriffsverwaltung
  v_modus  number(1);
  v_module_name Varchar2(20) := 'XDB_ZUG_MODULE_LIST';
  v_error_mod1 Varchar2(80);
  v_error_mod2 Varchar2(80);
  v_mod_ret Number(2);


BEGIN
 v_modus := dbpck$main.fun$chk_module_allowed(v_module_name);

 if v_modus > 0 then
  -- HTTP-Session ffen
   htp.p('<HTML>');
   htp.p('<head>');
   htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
   htp.p(' <link rel="stylesheet" href="/i/projekt/default/css/default.css" type="text/css">');
   htp.p('<title> PROJEKT | Masken</title>');
   htp.p('</head>');
   htp.p('<BODY  TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');
   htp.p('<div class="maintitle"> Masken </div>');

   if v_modus > 2 then
     htp.p( dbfun$html_button('xdb_zug_module_details','<img src="/i/projekt/default/img/add_new_abc.png" border="no">Neue Maske hinzufgen'));
   end if;

   -- Header zusammenbauen
   htp.p('<TABLE class="formtable">');
   htp.p(' <TR><TD width=30 class="tdh">ID</TD>');
   htp.p('    <TD width=120 class="tdh">Name</TD>');
   htp.p('    <TD width=250 class="tdh">Nutzung</TD>');
   htp.p('    <TD width=130 class="tdh" colspan=2>Typ</TD>');
   htp.p(' <TR>');

  for ca1 in c1  loop
    htp.p ('<TR>');
    htp.p (' <TD class="tdv">'||ca1.ID||'</TD>');
    htp.p (' <TD class="tdv"><A HREF="xdb_zug_module_details?p_id='||ca1.ID||'">' ||ca1.name||'</A></TD>');
    htp.p (' <TD class="tdv">'||ca1.usage||'</TD>');
    htp.p (' <TD class="tdv">'||ca1.typ  ||'</TD>');
    htp.p ('<TD class="tdv"><A HREF="XDB_ZUG_MODULE_DETAILS?p_id='||ca1.ID||'"><img src="/i/projekt/default/img/details.png" border="no"></A></TD></TR>');
   end loop;
   htp.p('</table>');

 else -- v-modus =0
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1><BR>');
 end if;


 htp.p('</BODY>' );
 htp.p('</HTML>' );
end;
/


----------------------------------------------------------------
-- PROCEDURE XDB_ZUG_ROLES_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE XDB_ZUG_ROLES_DETAILS
(
     p_id                   in Number    default NULL
   , p_rolename             in Varchar2  default NULL
   , p_db_role              in Varchar2  default NULL
   , p_memo                 in Varchar2  default NULL
  ,  p_do_update            in varchar2  default ''
  ,  p_do_delete            in Varchar2  default ''
  ,  p_do_insert            in Varchar2  default ''
) as

-- lokale Variablen:
   v_id          xdb_zug_roles.id%type;
   v_rolename    xdb_zug_roles.rolename%type;
   v_db_role     xdb_zug_roles.db_role%type;
   v_memo        xdb_zug_roles.memo%type;

  v_modus        Number(1);
  v_module_name  Varchar2(30) := 'XDB_ZUG_ROLES_DETAILS';
  v_error_mod1   Varchar2(80);
  v_error_mod2   Varchar2(80);
  v_mod_ret      Number(2);

 -- Local-Function
    function selected_opt ( val1 in varchar2, value in varchar2)
   return varchar2 -- selected
   as
  begin
 if val1 = value then
  return 'selected';
 else
  if (val1 is NULL and value = '')
   or (val1 ='' and value is NULL)
    then
    return 'selected';
  end if;
  return NULL;
 end if;
   end;

 BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed(
               v_module_name);

  if v_modus > 0 then
   -- Delete
 if p_id is not null
   and p_do_delete is not NULL
   and p_do_delete = 'delete'
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen
        v_rolename := p_rolename;
     delete XDB_ZUG_ROLES
   where id = v_id;
    commit;
  end if; -- delete

 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
if (p_id is not null)
 or  (p_do_insert = 'insert' and p_id is null)
 or  (p_do_update = 'update')
  then
 -- Datensatz einfgen bzw. bernehmen
   v_id   :=  p_id ;
   v_rolename     :=  p_rolename ;
   v_db_role      :=  p_db_role ;
   v_memo         :=  p_memo ;
end if;

if p_do_insert = 'insert'
and v_modus > 1 -- min 2!
then

--SEQUENCE !!!!!!
select seq_zug_roles.nextval into v_id from dual;
insert into xdb_zug_roles
(
 ID
        ,    ROLENAME
        ,    DB_ROLE
        ,    MEMO
          ) values (
            v_id
        ,  v_rolename
        ,  v_db_role
        ,  v_memo
        );
  commit;
  end if; -- Insert ??

-- UPDATE
  if p_do_update = 'update'
   and p_id is not null
   and v_modus > 0
    then
 v_id := p_id;
   update xdb_zug_roles
    set
      rolename    =  v_rolename
     , db_role    =  v_db_role
     , memo       =  v_memo
  where id   = v_id;
  commit;
 end if; -- Update ??
  if     (p_do_insert <> 'insert' or p_do_insert is NULL)
     and (p_do_delete <> 'delete' or p_do_delete is NULL)
     and  p_id is not null
  then
    v_id               := p_id;
   select
   rolename
  , db_role
  , memo
  into
   v_rolename
  , v_db_role
  , v_memo
    from xdb_zug_roles
 where id = v_id;
 end if;

  htp.p('<html>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p(' <link rel=''stylesheet'' href=''/i/projekt/default/css/default.css'' type=''text/css''>');
  htp.p('<title>Projekt-DB | Rollen-Details</title>');
  htp.p('</head>');
  htp.p('<body topmargin=5 leftmargin=5 marginwidth=5 marginheight=5>');

  htp.p('<div class="maintitle"> Rollen -Details</div>');

 htp.p('<table class="formtable">');
-- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method=head>');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type="hidden"  name="p_id" value="'||v_id||'"/>');
 -- Neue Werte --
   htp.p ('<tr><td  class="tdh"> ID:  </td>');
   htp.p ('      <td  class="tdv"> '||p_id
  ||'</td></tr>');
 if p_do_delete = 'delete' and p_do_delete is not null then
  htp.p ('<tr><td  class="tdv" colspan = "2"><b> is deleted </b></td></tr>');
 else -- nicht gelscht
   htp.p (' <tr><td  class="tdh"> Rolename:  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_rolename" type="text" size=40 maxlength=30 value="'
     || v_rolename||'"></td></tr>');

   htp.p (' <tr><td  class="tdh"> Db_Role:  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_db_role" type="text" size=40 maxlength=30 value="'
     || v_db_role||'"></td></tr>');

   htp.p (' <tr><td  class="tdh"> Memo:  </td>');
   htp.p ('      <td  class="tdv"> ');
   htp.p ('   <input name="p_memo" type="text" size=40 maxlength=255 value="'
     || v_memo||'"></td></tr>');

    htp.p ('<tr><td colspan=2>');
   if v_id is not Null then
     if v_modus > 0 then
       htp.p ('  <input type="submit" name ="p_do_update" value="update"/>');
      end if;
      if v_modus > 2 then
       htp.p ('  <input type="submit" name ="p_do_delete" value="delete"/>');
      end if;
    end if;
   if v_id is NULL
      and v_modus > 1 then
      htp.p ('  <input type="submit" name ="p_do_insert" value="insert">');
   end if;
   htp.p (' </td></tr>');
 end if; -- do_delete
   htp.p (' </form>');
   htp.p('<tr><td width="600" valign="top" colspan="2">');
   htp.p(' <hr> </td>');
   htp.p('</tr></table>');


  else -- v-modus =0
  htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;
 -- eigentlich msste mann vorher die Berechtigung prfen !!
 htp.p (dbfun$html_button('xdb_zug_roles_list','Listenansicht') );
 htp.p('</BODY>');
 htp.p('</HTML>');
EXCEPTION
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- PROCEDURE XDB_ZUG_ROLES_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE xdb_zug_roles_list
as
--[VERS:2008-07-20]
-- Liste der Rollen
-- Autor: Erich Heinemann


 -- Suche aller passenden Subnetzeintrge
 cursor c1 is
  select  r.id,
    r.rolename, r.db_role
  from  xdb_zug_roles r
   order by r.rolename;

  -- Zugriffsverwaltung
  v_modus       Number(1);
  v_module_name Varchar2(30) := 'XDB_ZUG_ROLES_LIST';
  v_error_mod1  Varchar2(80);
  v_error_mod2  Varchar2(80);
  v_mod_ret     Number(2);


BEGIN
 v_modus:= dbpck$main.fun$chk_module_allowed(v_module_name);

 if v_modus > 0 then
  -- HTTP-Session ffen
   htp.p('<HTML>'||chr(10));
   htp.p('<head>'||chr(10));
   htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
    htp.p(' <link rel="stylesheet" href="/i/projekt/default/css/default.css" type="text/css">');
   htp.p('<title>'||v_modus||' PROJEKT | USER-Liste </title>');
   htp.p('</head>');
   htp.p('<BODY  BGCOLOR="#FFFFFF" LINK="#000000" VLINK="#000000" TEXT="#000000"');
   htp.p('    TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');

   htp.p('<div class="maintitle"> Rollen </div>');

   if v_modus > 2 then
    htp.p (   dbfun$html_button('xdb_zug_roles_details','<img src="/i/projekt/default/img/add_new_abc.png" border="no"/> Neue Rolle anlegen') );
  end if;

    -- neue Tabelle fr die Liste des HTML-Mens
   htp.p('<table class="listtable">');
   htp.p('<tr>');
   htp.p('  <td width="80" class="tdh">ID          </TD>');
   htp.p('  <td width="80" class="tdh">Projekt-Rolle   </TD>');
   htp.p('  <td width="80" class="tdh" colspan="2">Datenbank-Rolle </TD>');
   htp.p('<tr>');

  for ca1 in c1  loop
    htp.p('<tr>');
    if v_modus > 2 then
      htp.p('<td class="tdf"><a href="xdb_zug_roles_details?p_id='||ca1.id||'">'||ca1.id||'</a></td>');
    else
      htp.p('<td class="tdf">'||ca1.id       ||'</td>');
    end if;
    htp.p('<td class="tdv"> '||ca1.rolename ||'</td>');
    htp.p('<td class="tdv"> '||ca1.db_role  ||'</td>');
    htp.p('<td class="tdv">');
    htp.p (  '<a href="xdb_zug_roles_details?p_id='||ca1.id||'"><img src="/i/projekt/default/img/details.png" border="no"/></a>' );
    htp.p('</td>');
   end loop;
   htp.p('</table>');


 else -- v-modus =0
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1><BR>');
 end if;

 htp.p('</body>');
 htp.p('</html>');

 exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);

end;
/


----------------------------------------------------------------
-- PROCEDURE XDB_ZUG_USER_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE xdb_zug_user_list
as
--[VERS:2004-11-10]
-- Ziel:
-- Generiert Liste mit usern

-- Autor: Erich Heinemann
-- Kln 02.10.2003

 cursor c1 is
 select id
 , login
 , user_name
 , email contact from
  xdb_zug_user
  order by user_name;


  -- Zugriffsverwaltung
   v_modus        Number(1);
   v_module_name  Varchar2(30)  := 'XDB_ZUG_USER_LIST';

   defaultgui     Varchar2(400) := dbfun$default_gui;
   defaultlang    Varchar2(400) := dbfun$default_lang;
   dateformat     Varchar2(40)  := ('DD.MM.YYYY HH24:MI');



BEGIN
 v_modus := dbpck$main.fun$chk_module_allowed( v_module_name );

 if v_modus > 0 then
  -- HTTP-Session ffen
   htp.p('<HTML>');
   htp.p('<head>');
   htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
   htp.p(' <link rel="stylesheet" href="/i/projekt/'||defaultgui||'/css/default.css" type="text/css">');
   htp.p('<title> PROJEKT | USER-Liste </title>');
   htp.p('</head>');
   htp.p('<BODY TOPMARGIN=5 LEFTMARGIN=5 MARGINWIDTH=5 MARGINHEIGHT=5>');

   htp.p('<div class="maintitle"> User </div>');

   if v_modus > 2 then
    htp.p (   dbfun$html_button('xdb_create_user','<img src="/i/projekt/default/img/add_new_abc.png" border="no"/> Neuen User anlegen') );
   end if;
   htp.p (   dbfun$html_button('xdb_drop_user','User lschen') );
--   htp.p ('<TR><td align="center"><input type="button" value="Drop a User" onClick="self.document.location.href=''xdb_drop_user''" style="width:200px"></td></TR>');
--   htp.p ('<TR><td align="center"><input type="button" value="< Back to Account-Administration" onClick="self.document.location.href=''xdb_zug_user_admin''" style="width:200px"></td></TR>');

--   htp.p('</TABLE>' );
--   htp.p(' </TD></TR><TR><TD VALIGN=TOP>' );

 --  htp.p(' </TD></TR><TR><TD VALIGN=TOP>' );

    -- neue Tabelle fr die Liste des HTML-Mens
   htp.p('<TABLE class="listtable">');
   htp.p('<TR><TD width=30 class="tdh">ID</TD>');
   htp.p('    <TD width=120 class="tdh">Username</TD>');
   htp.p('    <TD width=250 class="tdh">Login</TD>');
   htp.p('    <TD width=250 class="tdh">Contact</TD>');
   htp.p('<tr>');

  for ca1 in c1  loop
    htp.p('<TR><TD class="tdf">'
      ||ca1.ID
      ||'</TD><TD class="tdv">'
      ||ca1.user_name
      ||'</A></TD><TD class="tdv">'
      ||ca1.login
      ||'</TD>');
      htp.p ('<TD class="tdv">'
      ||ca1.contact
      ||'</TD>');
     htp.p('</tr>');
   end loop;
   htp.p('</table>');
 else -- v-modus =0
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1><BR>');
 end if;


 htp.p('</BODY>' );
 htp.p('</HTML>' );
end;
/


----------------------------------------------------------------
-- PROCEDURE XDB_ZUG_ZUO_USER_MENU_DETAILS
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE XDB_ZUG_ZUO_USER_MENU_DETAILS
(     p_id                in Number    default NULL
   ,  p_user_id           in Number    default NULL
   ,  p_menurole_id       in Number    default NULL
   ,  p_do_update         in varchar2  default ''
   ,  p_do_delete         in Varchar2  default ''
   ,  p_do_insert         in Varchar2  default ''
) as

-- lokale Variablen:
   v_user_id      xdb_zug_zuo_user_menu.user_id%type;
   v_menurole_id  xdb_zug_zuo_user_menu.menurole_id%type;
   v_id           xdb_zug_zuo_user_menu.id%type;

   v_user_name   xdb_zug_user.user_name%type;
   v_login       xdb_zug_user.login%type;
   v_rolename    xdb_zug_roles.rolename%type;
   v_db_role     xdb_zug_roles.db_role%type;


  v_modus         Number(1);
  v_module_name   Varchar2(30) := 'XDB_ZUG_ZUO_USER_MENU_DETAILS';
  v_error_mod1    Varchar2(80);
  v_error_mod2    Varchar2(80);
  v_mod_ret       Number(2);

  -- Cursor User
  Cursor c_user
  is
   select id, user_name from xdb_zug_user order by user_name;

  -- Cursor Roles
  Cursor c_roles
  is
   select id, rolename from xdb_zug_roles order by rolename;



 -- Local-Function
    function selected_opt ( val1 in varchar2, value in varchar2)
   return varchar2 -- selected
   as
  begin
 if val1 = value then
  return 'selected';
 else
  if (val1 is NULL and value = '')
   or (val1 ='' and value is NULL)
    then
    return 'selected';
  end if;
  return NULL;
 end if;
   end;

 BEGIN
 -- Modus ermitteln
 v_modus := dbpck$main.fun$chk_module_allowed(
               v_module_name);

  if v_modus > 0 then
   -- Delete
 if p_id is not null
   and p_do_delete is not NULL
   and p_do_delete = 'delete'
   and v_modus > 2
     then
       v_id := p_id;
        --- Hier noch einen Parameter zuweisen
        v_menurole_id := p_menurole_id;
     delete XDB_ZUG_ZUO_USER_MENU
   where id = v_id;
    commit;
  end if; -- delete

 -- Allgemein
 -- wenn nicht gelscht wird order ein Insert durchgefhrt werden soll dann:
 if (p_id is not null)
  or  (p_do_insert = 'insert' and p_id is null)
  or  (p_do_update = 'update')
   then
  -- Datensatz einfgen bzw. bernehmen
    v_user_id     :=  p_user_id ;
    v_menurole_id :=  p_menurole_id ;
    v_id          :=  p_id ;
 end if;

 if p_do_insert = 'insert'
  and v_modus > 1 -- min 2!
  then

 --SEQUENCE !!!!!!
 select seq_zug_zuo_user_menu.nextval into v_id from dual;
  insert into xdb_zug_zuo_user_menu
  (     user_id
     ,  menurole_id
     ,  id
     ) values (
        v_user_id
     ,  v_menurole_id
     ,  v_id
     );

    commit;
  end if; -- Insert ??

 -- UPDATE
   if p_do_update = 'update'
    and p_id is not null
    and v_modus > 0
     then
  v_id := p_id;
    update xdb_zug_zuo_user_menu
     set
       menurole_id         =  v_menurole_id
      , id         =  v_id
   where id   = v_id;
   commit;
  end if; -- Update ??
   if     (p_do_insert <> 'insert' or p_do_insert is NULL)
      and (p_do_delete <> 'delete' or p_do_delete is NULL)
      and  p_id is not null
   then
     v_id               := p_id;

    select
       a.id,a.menurole_id, a.user_id, u.user_name, u.login, r.rolename, r.db_role
     into
        v_id
      , v_menurole_id
      , v_user_id
      , v_user_name
      , v_login
      , v_rolename
      , v_db_role
  from xdb_zug_zuo_user_menu a
    , xdb_zug_user  u
    , xdb_zug_roles r
    where a.user_id =  u.id  (+)
     and  a.menurole_id = r.id  (+)
     and  a.id = v_id
   order by u.user_name;

 /*



    select
    menurole_id
   , id
   into
    v_menurole_id
   , v_id
     from xdb_zug_zuo_user_menu
  where id = v_id;
  */

  end if;

  htp.p('<html>');
  htp.p('<head>');
  htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
  htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  htp.p(' <link rel="stylesheet" href="/i/projekt/default/css/default.css" type="text/css">');
  htp.p('<title>Projekt | User - Rollenzuordnung - Details</title>');
  htp.p('</head>');
  htp.p('<body topmargin=5 leftmargin=5 marginwidth=5 marginheight=5>');
  htp.p('<div class="maintitle"> User - Rollenzuordnung </div>');


  htp.p('<table class="formtable" width="500">');

 -- Alte Werte
  htp.p (' <form  action="'||lower(v_module_name)||'" method=head>');
  htp.p ('<!-- Alter Werte -->');
  htp.p ('<input type="hidden"  name="p_id" value="'||v_id||'"/>');

 -- Neue Werte --
   htp.p ('<tr><td  class="tdh" > ID:  </td>');
--   htp.p ('<td  class="tdv"> <select name="p_oid" size="1" maxlength="40" width="40" style="width:220px">');
   htp.p ('      <td  class="tdv"> '||p_id
          ||'</td></tr>');

  /*
  htp.p ('<tr><td  class="tdv" > Menu-Role </td>');
  htp.p ('      <td  class="tdv"> '||v_rolename
          ||'</td></tr>');
   */


   if p_do_delete = 'delete' and p_do_delete is not null then
    htp.p ('<tr><td  class="tdv" colspan = "2"><b> is deleted </b></td></tr>');
   else -- nicht gelscht


   htp.p (' <tr><td  class="tdh" >User  </td>');

   htp.p ('<td  class="tdv"> <select name="p_user_id" size="1" maxlength="40" width="40" style="width:220px">');
   for ca_user in c_user  loop
      htp.p (' <option value="'||ca_user.id||'" '||selected_opt(ca_user.id,v_user_id)||'>'||substr(ca_user.user_name,1,30));
   end loop;
   htp.p ('</select></td></tr>');

   if v_user_id is not null then
     htp.p ('<tr><td  class="tdh" > User-Name </td>');
     htp.p ('      <td  class="tdv"> '||v_user_name
            ||'</td></tr>');

     htp.p ('<tr><td  class="tdh" > User-Login </td>');
     htp.p ('      <td  class="tdv"> '||v_login
           ||'</td></tr>');
   end if;

   htp.p('<tr><td  class="tdh">'||nbsp||'</td><td class="tdv"><b>zugeordnet zu:</b></td></tr>');

   htp.p (' <tr><td  class="tdh" > Projekt-Rolle  </td>');

   htp.p ('<td  class="tdv"> <select name="p_menurole_id" size="1" maxlength="40" width="40" style="width:220px">');
   for ca_roles in c_roles  loop
     htp.p (' <option value="'||ca_roles.id||'" '||selected_opt(ca_roles.id,v_menurole_id)||'>'||substr(ca_roles.rolename,1,30));
   end loop;
   htp.p ('</select></td></tr>');

   htp.p ('<tr><td  class="tdh" > Datenbank-Rolle </td>');
   htp.p ('    <td  class="tdv"> '||v_db_role    ||'</td></tr>');


    htp.p ('<tr><td class="tdh" colspan=2 >');
    if v_id is not Null then
     if v_modus > 0 then
       htp.p ('  <input type="submit" name ="p_do_update" value="update"/>');
     end if;
     if v_modus > 2 then
       htp.p ('  <input type="submit" name ="p_do_delete" value="delete"/>');
     end if;
    end if;

   if v_id is NULL
      and v_modus > 1 then
      htp.p ('  <input type="submit" name ="p_do_insert" value="insert">');
   end if;
   htp.p (' </td></tr>');
 end if; -- do_delete

  htp.p (' </form>');
  htp.p('<tr><td width="600" valign="top" colspan="2">');
  htp.p(' <hr> </td>');
  htp.p('</tr></table>');
  else -- v-modus =0
  htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1>');
 end if;
 -- eigentlich msste mann vorher die Berechtigung prfen !!
 htp.p (dbfun$html_button('xdb_zug_zuo_user_menu_list','Listenansicht' ) );
 htp.p('</BODY>');
 htp.p('</HTML>');
EXCEPTION
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);
END;
/


----------------------------------------------------------------
-- PROCEDURE XDB_ZUG_ZUO_USER_MENU_LIST
----------------------------------------------------------------

CREATE OR REPLACE PROCEDURE xdb_zug_zuo_user_menu_list
as
--[VERS:2004-07-15]
-- Ziel:
-- Generiert Liste mit zugelassen user-men-berechtigungen
   -- grants von rollen ewrden noch nicht bercksichtigt !

-- Autor: Erich Heinemann
-- Kln 02.10.2003

 -- Suche aller passenden Subnetzeintrge
 cursor c1 is
  select
     a.id
   , u.user_name
   , u.email
   , u.login
   , r.rolename
  from xdb_zug_zuo_user_menu a
     , xdb_zug_user  u
     , xdb_zug_roles r
    where a.user_id = u.id
     and  r.id      = menurole_id
   order by u.user_name;

  -- Zugriffsverwaltung
  v_modus       Number(1);
  v_module_name Varchar2(30) := 'XDB_ZUG_ZUO_USER_MENU_LIST';
  v_error_mod1  Varchar2(80);
  v_error_mod2  Varchar2(80);
  v_mod_ret     Number(2);


BEGIN
 v_modus := dbpck$main.fun$chk_module_allowed(
                  v_module_name
                  );

 if v_modus > 0 then
  -- HTTP-Session ffen
   htp.p('<HTML>'||chr(10));
   htp.p('<head>'||chr(10));
   htp.p('<META HTTP-EQUIV="Pragma" CONTENT="No-cache">');
   htp.p('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
   htp.p(' <link rel="stylesheet" href="/i/projekt/default/css/default.css" type="text/css">');
   htp.p('<title></title>');
   htp.p('</head>');
   htp.p('<BODY   TOPMARGIN="5" LEFTMARGIN="5" MARGINWIDTH="5" MARGINHEIGHT="5">');
   htp.p('  <div class="maintitle"> User - Rollenzuordnung </div>');

    htp.p( dbfun$html_button('xdb_zug_zuo_user_menu_details','<img src="/i/projekt/default/img/add_new_abc.png"> Insert a new one') );


   htp.p('<table class="listtable">');
   htp.p('<tr>');
   htp.p('  <td width="80" class="tdh">ID          </TD>');
   htp.p('  <td width="80" class="tdh">User-Name   </TD>');
   htp.p('  <td width="80" class="tdh">Login       </TD>');
   htp.p('  <td width="80" class="tdh" colspan=2>Rolle </TD>');
   htp.p('<tr>');

  for ca1 in c1  loop
    htp.p(' <tr>');
    htp.p('  <td class="tdf">'||ca1.id      ||'</td>');
    htp.p('  <td class="tdv" > '||ca1.user_name    ||'</td>');
    htp.p('  <td class="tdv" > '||ca1.login  ||'</td>');
    htp.p('  <td class="tdv" > '||ca1.rolename   ||'</td>');
    htp.p('  <td class="tdv">');
    htp.p('    <a href="xdb_zug_zuo_user_menu_details?p_id='||ca1.id||'">');
    htp.p('       <img src="/i/projekt/default/img/details.png" border=no>');
    htp.p('    </a>');
    htp.p(' </td>');
    htp.p(' </tr>');
   end loop;
   htp.p(' </table>');

 else -- v-modus =0
    htp.p ('<HTML><BODY><H1> no Accesss with Your Account ! </H1><BR>');
 end if;

 htp.p('</body>');
 htp.p('</html>');

 exception
  when others then
   htp.p ('Error inside the Module: SQL-Error '||sqlerrm ||' / '|| sqlcode);

end;
/

