--
--  OraTool Pro  - (c) by Softwaredevelopment Jens Fudickar
--          TGS Telonic - 0000000004 (1)
--
--  Generator    : Create Object
--  Objecttype   : PACKAGE
--  Generated at : 30.07.2008
--  Generated by : PROJADM
--


----------------------------------------------------------------
-- PACKAGE AASTRA_UTIL
----------------------------------------------------------------

CREATE OR REPLACE PACKAGE aastra_util
    is
    procedure  push2phone (
          p_server  in varchar2
        , p_phone   in varchar2
        , p_data    in varchar2
    );
end;
/


----------------------------------------------------------------
-- PACKAGE BODY AASTRA_UTIL
----------------------------------------------------------------

CREATE OR REPLACE PACKAGE BODY aastra_util
is
    procedure push2phone (
          p_server   in  varchar2
        , p_phone    in  varchar2
        , p_data     in  varchar2
    ) is

        p_url_in                varchar2(400)   := substr(p_phone,1,400);
        p_data_in               varchar2(32000) := substr(p_data,1,320000);

        p_data_type             varchar2(200) default 'text/xml';
        p_proxy_in              varchar2(200) default null;
        p_no_proxy_domains_in   varchar2(200) default null;
        p_username_in           varchar2(200) default null;
        p_password_in           varchar2(200) default null;


        l_http_req              utl_http.req;
        l_http_resp             utl_http.resp;
        l_my_scheme             varchar2(256);
        l_my_realm              varchar2(256);
        l_my_proxy              boolean;

    begin
        -- When going through a firewall, pass requests through this host.
        -- Specify sites inside the firewall that don't need the proxy host.
        if (p_proxy_in is not null) and
            (p_no_proxy_domains_in is not null)
        then
            utl_http.set_proxy(p_proxy_in, p_no_proxy_domains_in);
        end if;

        -- Ask UTL_HTTP not to raise an exception for 4xx and 5xx status codes,
        -- rather than just returning the text of the error page.
        utl_http.set_response_error_check(false);

        -- Begin the post request
        l_http_req := utl_http.begin_request (p_url_in, 'POST');

     --     -   if p_post is not null then
     --         Utl_Http.Write_Text (l_http_req
     --   end if;

        -- Set the HTTP request headers
        utl_http.set_header(l_http_req, 'POST / HTTP/1.1.');
        utl_http.set_header(l_http_req, 'Host: '     ,p_phone);
        utl_http.set_header(l_http_req, 'Referer: '  ,p_server);

  --      utl_http.set_header(l_http_req, 'User-Agent', 'Mozilla/4.0');
  --      utl_http.set_header(l_http_req, 'User-Agent', 'Mozilla/4.0');
        utl_http.set_header(l_http_req, 'Connection'    , 'Keep-Alive');
        utl_http.set_header(l_http_req, 'Content-Type'  , p_data_type);
        utl_http.set_header(l_http_req, 'Content-Length', length(p_data_in));

        -- Specify a user ID and password for pages that require them.
        if p_username_in is not null then
            utl_http.set_authentication(
                l_http_req, p_username_in, p_password_in);
        end if;

        -- Write the data to the body of the HTTP request
        utl_http.write_text(l_http_req, p_data_in);

        -- Process the request and get the response.
        l_http_resp := utl_http.get_response (l_http_req);

        dbms_output.put_line ('status code: ' || l_http_resp.status_code);
        dbms_output.put_line ('reason phrase: ' || l_http_resp.reason_phrase);

        -- Look for client-side error and report it.
        if (l_http_resp.status_code >= 400) and
            (l_http_resp.status_code <= 499)
        then
            -- Detect whether the page is password protected,
            -- and we didn't supply the right authorization.
            -- Note the use of utl_http.HTTP_UNAUTHORIZED, a predefined
            -- utl_http package global variable
            if (l_http_resp.status_code = utl_http.HTTP_UNAUTHORIZED) then
                utl_http.get_authentication(
                    l_http_resp, l_my_scheme, l_my_realm, l_my_proxy);
                if (l_my_proxy) then
                    dbms_output.put_line('Web proxy server is protected.');
                    dbms_output.put(
                        'Please supply the required ' ||
                        l_my_scheme ||
                        ' authentication username/password for realm ' ||
                        l_my_realm ||
                        ' for the proxy server.');
                else
                    dbms_output.put_line(
                        'Web page ' || p_url_in || ' is protected.');
                    dbms_output.put(
                        'Please supplied the required ' ||
                        l_my_scheme ||
                        ' authentication username/password for realm ' ||
                        l_my_realm ||
                        ' for the Web page.');
                end if;
            else
                dbms_output.put_line('Check the URL.');
            end if;
            utl_http.end_response(l_http_resp);
            return;

        -- Look for server-side error and report it.
        elsif (l_http_resp.status_code >= 500) and
                (l_http_resp.status_code <= 599)
        then
            dbms_output.put_line('Check if the Phone '||p_phone||' is up.');
            utl_http.end_response(l_http_resp);
            return;
        end if;
        utl_http.end_response (l_http_resp);

    exception
        when others then
            dbms_output.put_line (sqlerrm);
            raise;
    end push2phone;

end;
/


----------------------------------------------------------------
-- PACKAGE DBPCK$MAIN
----------------------------------------------------------------

CREATE OR REPLACE PACKAGE dbpck$main IS
----------------------------------------------------------------------
-- Ermittelt max. Zugriffsmodus(akt. Benutzer)  auf ein vorgegeb. Modul
-- 0 - keine Berechtigung, warum auch immer
-- 1 - nur Lese Rechte
-- 2 - nur Update und Lese-Rechte
-- 3 - Admin bzw. Insert, Update, Read und Delete - Rechte auf das Objekt
--- weitere Rechtestufen knnen beliebig implementiert werden...

FUNCTION fun$chk_module_allowed(p_modul_name IN varchar2)
 RETURN NUMBER ;


FUNCTION fun$chk_module_allowed( p_modul_name IN Varchar2
                                ,  v_username   IN Varchar2
                                 )
 RETURN NUMBER;


END DBPCK$main;
/


----------------------------------------------------------------
-- PACKAGE BODY DBPCK$MAIN
----------------------------------------------------------------

CREATE OR REPLACE PACKAGE BODY dbpck$main IS

 --------------------------------------------------
  -- Ermittelt max. Zugriffsmodus(akt. Benutzer) zu einem Modul (Maske,Prozedur, Hilfsfunktion...)
  FUNCTION fun$chk_module_allowed(p_modul_name IN varchar2)
  RETURN NUMBER IS
  -- Return ist der Modus, bei Fehler oder keiner Berechtigung = 0

   --
  CURSOR C1 ( v_module_name in Varchar2, v_user_login in varchar2)
    is
     select  max (modus) v_modus
     from
             xdb_zug_roles r
           , xdb_zug_module m
           , xdb_zug_menuroles_mode mm
           , xdb_zug_zuo_user_menu z
           , xdb_zug_user u
           where mm.menuroles_id = r.id
            and mm.module_id     = m.id
                and z.menurole_id    = r.id
                and z.user_id = u.id
                and upper(u.login) = v_user_login
                and m.name = v_module_name;
 --
    v_found         BOOLEAN;
    v_modus         NUMBER(1);
    v_dummy         VARCHAR2(2);
  BEGIN
    -----------------------------------------
    --  Jeder Benutzername der mit ADMIN anfaengt
    --  passiert diese Pruefung unabhaengig
    -----------------------------------------
      if  upper(substr(user,1,7)) = 'PROJADM'
       or upper(substr(user,1,6)) ='XDBADM'
     then
        v_modus := 3;
        return 3;
    else
           open c1 (upper(p_modul_name), upper(user));
            fetch c1 into v_modus;
           close c1;
       if not v_found then
         return(0);
                 else
                 return(v_modus);
       end if;
      end if;
    --
           exception
      when others then
        if c1%isopen then
          close c1;
        --
        RAISE;
        --
    END IF;

  END;

--------------------------------------------------
  -- Ermittelt max. Zugriffsmodus(akt. Benutzer)  auf ein vorgegeb. Modul
  FUNCTION fun$chk_module_allowed( p_modul_name IN Varchar2
                                ,  v_username   IN Varchar2
                                 )
  RETURN NUMBER IS -- Return ist der Modus, bei Fehler 0

   --
  CURSOR C1 ( v_module_name in Varchar2, v_user_login in varchar2)
    is
     select  max (modus) v_modus
     -- mm.modus
     from
             xdb_zug_roles r
           , xdb_zug_module m
           , xdb_zug_menuroles_mode mm
           , xdb_zug_zuo_user_menu z
           , xdb_zug_user u
           where mm.menuroles_id = r.id
            and mm.module_id     = m.id
                and z.menurole_id    = r.id
                and z.user_id = u.id
                and upper(u.login) = v_user_login
                and m.name = v_module_name;
 --
    v_found         BOOLEAN;
    v_modus         NUMBER(1);

  BEGIN
    -----------------------------------------
    --  Jeder Benutzername der mit ADMIN anfaengt
    --  passiert diese Pruefung unabhaengig
    -----------------------------------------
    if  upper(substr(v_username,1,5)) = 'PROJADM'
       or upper(substr(v_username,1,6)) ='XDBADM'
     then
        v_modus := 3;
        return 3;
    else
    --  if v_username is not null then
           open c1 (upper(p_modul_name), upper(v_username));
            fetch c1 into v_modus;
           close c1;
       if not v_found then
         return(0);
       else
         return(nvl(v_modus,0));
       end if;
    end if;
    --
           exception
      when others then
        if c1%isopen then
          close c1;
          return (0);
        --
        RAISE;
        --
    END IF;

  END;

END dbpck$main;
/

