DECLARE
   l_dad           VARCHAR2(30) := 'PROJ';
   l_path          VARCHAR2(30) := '/pls/proj/*';
   l_dbUser        VARCHAR2(30) := 'projadm'; --<Username (of restricted user)>';
   l_docTable      VARCHAR2(30) := 'projadm.proj_docs';
   l_authMode      VARCHAR2(30) := 'Basic'; --'Basic';
   l_attrNames     DBMS_EPG.VARCHAR2_TABLE;
   l_attrValues    DBMS_EPG.VARCHAR2_TABLE;


   BEGIN
     l_dbUser := UPPER(l_dbUser);
     BEGIN
         DBMS_EPG.DROP_DAD(l_dad);
     EXCEPTION  WHEN OTHERS THEN
         NULL;
         DBMS_output.put_line ('DROP_DAD - Error');

     END;
     DBMS_EPG.CREATE_DAD  ( dad_name  => l_dad
                       ,    path      => l_path
                          );
/*     DBMS_EPG.SET_DAD_ATTRIBUTE  ( dad_name   => l_dad
                              ,    attr_name  => 'database-username'
                              ,    attr_value => l_dbUser
                              );
     DBMS_EPG.SET_DAD_ATTRIBUTE  ( dad_name   => l_dad
                              ,    attr_name  => 'authentication-mode'
                              ,    attr_value => l_authMode
                              );
*/
     DBMS_EPG.SET_DAD_ATTRIBUTE  ( dad_name   => l_dad
                              ,    attr_name  => 'default-page'
                              ,    attr_value => 'proj_projekt_list'
                              );

     DBMS_EPG.SET_DAD_ATTRIBUTE  ( dad_name   => l_dad
                              ,    attr_name  => 'document-table-name'
                              ,    attr_value => l_docTable
                               );

     DBMS_EPG.AUTHORIZE_DAD  ( dad_name   => l_dad
                          ,    user       => l_dbUser
                             );

   DBMS_EPG.GET_ALL_DAD_ATTRIBUTES(l_dad,l_attrNames,l_attrValues);
     FOR i IN 1..l_attrNames.COUNT LOOP
      DBMS_OUTPUT.PUT_LINE(LPAD(l_attrNames(i),20)||' : '||l_attrValues(i));
     END LOOP;
   END;
